/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.io.IOException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;

public class OipczSharedInventoryChecks {
    private OipczSharedInventoryChecks() {
    }

    public static OipcrIResult checkIfSharedInventory(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OixdInvalidDocumentException {
        OipcrIResult oRes;
        block17: {
            String localNode = null;
            String[] clusterNodes = null;
            String sInvLocation = null;
            oRes = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVar = null;
                    oVar = oContext.getVariable("INVENTORY_LOCATION");
                    if (oVar != null) {
                        sInvLocation = (String)oVar.getValue();
                    }
                    if (sInvLocation == null || sInvLocation.equalsIgnoreCase("")) {
                        String InvLoc = System.getProperty("oracle.installer.invPtrLoc");
                        OiipgPropertyLoader iPropLoad = new OiipgPropertyLoader();
                        try {
                            sInvLocation = OiipgPropertyLoader.getLocationFileLoc((String)InvLoc);
                        }
                        catch (IOException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                    if ((oVar = oContext.getVariable("LOCAL_NODE")) != null) {
                        localNode = (String)oVar.getValue();
                    }
                    if ((oVar = oContext.getVariable("CLUSTER_NODES")) != null) {
                        clusterNodes = (String[])oVar.getValue();
                    }
                    if (sInvLocation != null && !sInvLocation.equalsIgnoreCase("")) {
                        try {
                            if (Cluster.isSharedPath((String)sInvLocation, (String[])clusterNodes, (String)localNode)) {
                                oRes = OipcrResult.FAILED_RESULT;
                                break block17;
                            }
                            oRes = OipcrResult.PASSED_RESULT;
                        }
                        catch (SharedDeviceException e) {
                            OiiolTextLogger.appendException((Throwable)e);
                        }
                        catch (InvalidNodeListException e) {
                            OiiolTextLogger.appendException((Throwable)e);
                        }
                        break block17;
                    }
                    oRes = OipcrResult.getNotExecutedResult((OiixException)new OiixException());
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oRes = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oRes = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oRes = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oRes = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oRes;
    }
}

