/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.sysman.prov.prereqs.util.CygPackage;

public class CygwinCheckhelper {
    public static boolean isActualGTEQRequired(String actual, String base) throws NumberFormatException {
        String[] actualSplit = actual.split(Pattern.compile("[^0-9]").pattern());
        int i = 0;
        String[] baseSplit = base.split(Pattern.compile("[^0-9]").pattern());
        if (i < baseSplit.length) {
            int intActual;
            String strBase = baseSplit[i];
            String strActual = actualSplit[i];
            int intBase = Integer.parseInt(strBase);
            return intBase <= (intActual = Integer.parseInt(strActual));
        }
        return true;
    }

    public static String getCygwinVersion() {
        return CygwinCheckhelper.parseVersion(CygwinCheckhelper.getCygPackages());
    }

    private static String parseVersion(List op) {
        if (op == null || op.size() == 0) {
            return null;
        }
        for (String line : op) {
            int i = line.indexOf("cygwin ");
            if (i == -1) continue;
            StringTokenizer sTokens = new StringTokenizer(line, " ");
            String version = null;
            if (sTokens.hasMoreTokens()) {
                sTokens.nextToken();
            }
            if (!sTokens.hasMoreTokens()) continue;
            version = sTokens.nextToken();
            return version;
        }
        return null;
    }

    public static List getCygPackages() {
        final ArrayList output = new ArrayList();
        String cmd = "cygcheck.exe -c ";
        try {
            InputStream errStream;
            final Process proc = Runtime.getRuntime().exec(cmd);
            proc.getErrorStream();
            proc.getInputStream();
            OutputStream opStream = proc.getOutputStream();
            if (opStream != null) {
                opStream.close();
            }
            if ((errStream = proc.getErrorStream()) != null) {
                errStream.close();
            }
            Thread outputThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        output.addAll(CygwinCheckhelper.gatherOutput(proc));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            outputThread.start();
            try {
                outputThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return output;
    }

    private static List gatherOutput(Process proc) throws Exception {
        BufferedReader outRdr = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        List l = CygwinCheckhelper.readBufData(outRdr);
        outRdr.close();
        return l;
    }

    private static List readBufData(BufferedReader outRdr) throws Exception {
        String ln;
        ArrayList<String> output = new ArrayList<String>();
        while ((ln = outRdr.readLine()) != null) {
            output.add(ln);
        }
        return output;
    }

    public static List preparePackageList(String value) {
        ArrayList<CygPackage> l = new ArrayList<CygPackage>();
        if (value == null || value.length() == 0) {
            return l;
        }
        StringTokenizer sTokens = new StringTokenizer(value, " ");
        while (sTokens.hasMoreTokens()) {
            String token = sTokens.nextToken();
            String[] pkgInfo = token.split(":");
            String name = null;
            String ver = null;
            String status = null;
            if (pkgInfo == null || pkgInfo.length <= 0) continue;
            if (pkgInfo.length >= 1) {
                name = pkgInfo[0];
            }
            if (pkgInfo.length >= 2) {
                ver = pkgInfo[1];
            }
            if (pkgInfo.length >= 3) {
                status = pkgInfo[2];
            }
            CygPackage p = new CygPackage(name, ver, status);
            System.out.println(p);
            l.add(p);
        }
        return l;
    }

    public static List verifyPackages(List pkgList, String format) {
        ArrayList<CygPackage> retVal = new ArrayList<CygPackage>();
        if (pkgList == null || pkgList.size() == 0) {
            return retVal;
        }
        List installedPkgs = CygwinCheckhelper.getCygPackages();
        if (installedPkgs == null || installedPkgs.size() == 0) {
            return retVal;
        }
        for (CygPackage p : pkgList) {
            System.out.println("Step1: " + p);
            for (String line : installedPkgs) {
                StringTokenizer sTokens = new StringTokenizer(line, " ");
                if (!sTokens.hasMoreTokens()) continue;
                String name = sTokens.nextToken();
                String version = null;
                String status = null;
                if (name == null || name.trim().length() <= 0 || !Pattern.matches(p.getName(), name)) continue;
                System.out.println("it matches");
                CygPackage instP = new CygPackage(name, p.getRequiredVersion(), p.getRequiredStatus());
                if (sTokens.hasMoreTokens()) {
                    version = sTokens.nextToken().trim();
                }
                if (sTokens.hasMoreTokens()) {
                    status = sTokens.nextToken().trim();
                }
                System.out.println(" Actual version: " + version + " status: " + status);
                CygwinCheckhelper.verifyStatus(instP, status);
                CygwinCheckhelper.verifyVersion(instP, version, format);
                p.setInst(true);
                retVal.add(instP);
            }
        }
        for (CygPackage p : pkgList) {
            if (p.inst()) continue;
            p.setProper(false);
            retVal.add(p);
        }
        return retVal;
    }

    private static void verifyVersion(CygPackage p, String version, String format) {
        p.setActualVersion(version);
        String pkgVersion = p.getRequiredVersion();
        if (version == null || version.length() == 0) {
            return;
        }
        if (pkgVersion == null || pkgVersion.length() == 0) {
            return;
        }
        if (!CygwinCheckhelper.compare(format, pkgVersion, version)) {
            p.setProper(false);
        }
    }

    private static boolean compare(String pattern, String base, String actual) {
        boolean retVal = true;
        while (pattern.length() > 0) {
            String token = null;
            String delim = null;
            if (pattern.length() == 2) {
                token = pattern;
                pattern = "";
                delim = null;
            } else {
                token = pattern.substring(0, 2);
                pattern = pattern.substring(2);
                delim = pattern.substring(0, pattern.indexOf("%"));
                pattern = pattern.substring(delim.length());
            }
            if (!token.equals("%d")) {
                return false;
            }
            String base1 = null;
            String actual1 = null;
            if (delim != null) {
                try {
                    base1 = base.substring(0, base.indexOf(delim));
                    actual1 = actual.substring(0, actual.indexOf(delim));
                    base = base.substring(base1.length() + delim.length());
                    actual = actual.substring(actual1.length() + delim.length());
                    System.out.println("Remaining base: " + base + " actual: " + actual);
                }
                catch (IndexOutOfBoundsException aiob) {
                    System.out.println("Invalid Format : " + aiob.getMessage());
                    return false;
                }
            } else {
                base1 = base;
                actual1 = actual;
                System.out.println("Remaining base: " + base + " actual: " + actual);
            }
            System.out.println("To compare : " + base1 + " : " + actual1);
            try {
                int intBase1 = Integer.parseInt(base1);
                int intActual1 = Integer.parseInt(actual1);
                if (intBase1 > intActual1) {
                    return false;
                }
                if (intActual1 <= intBase1) continue;
                return true;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid Format : " + nfe.getMessage());
                return false;
            }
        }
        return retVal;
    }

    private static void verifyStatus(CygPackage p, String status) {
        p.setActualStatus(status);
        if (status == null || status.length() == 0) {
            return;
        }
        String pkgStatus = p.getRequiredStatus();
        if (pkgStatus == null || pkgStatus.length() == 0) {
            return;
        }
        if (!Pattern.matches(p.getRequiredStatus(), status)) {
            p.setProper(false);
        }
    }

    public static boolean allPkgsAreFine(List pkgList, StringBuffer actual) {
        if (pkgList == null || pkgList.size() == 0) {
            return false;
        }
        boolean retVal = true;
        for (CygPackage p : pkgList) {
            actual.append(p.getName() + ":" + p.getActualVersion() + ":" + p.getActualStatus() + " ");
            if (p.isProper() || !retVal) continue;
            System.out.println(p);
            retVal = false;
        }
        return retVal;
    }
}

