/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.message.Content;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;

public class DriverHelper {
    private static final Logger logger = Logger.getLogger(DriverHelper.class.getName());
    private static Vector<Callable<Void>> shutdownCleanupTasks = new Vector();
    private static final String DRIVER_PROPERTIES_FILE = "/oracle/install/driver/oui/resource/driver.properties";

    public static ArrayList<String> transformSecure(ArrayList<String> props, String ouiVarMappingFilePath) throws IOException {
        ArrayList<String> transformed = new ArrayList<String>();
        InputStream inpStrVarProp = DriverHelper.class.getResourceAsStream(ouiVarMappingFilePath);
        if (inpStrVarProp != null) {
            ArrayList propsClone = (ArrayList)props.clone();
            Properties propVarObj = new Properties();
            propVarObj.load(inpStrVarProp);
            for (String string : propVarObj.keySet()) {
                String propName = (String)propVarObj.get(string);
                if (!props.contains(propName)) continue;
                transformed.add(string);
                propsClone.remove(propName);
            }
            transformed.addAll(propsClone);
        }
        return transformed;
    }

    public static HashMap<String, Object> transform(HashMap<String, Object> source, String ouiVarMappingFilePath) throws IOException {
        HashMap<String, Object> target = null;
        InputStream inpStrVarProp = DriverHelper.class.getResourceAsStream(ouiVarMappingFilePath);
        if (inpStrVarProp != null) {
            HashMap sourceClone = (HashMap)source.clone();
            target = new HashMap<String, Object>();
            Properties propVarObj = new Properties();
            propVarObj.load(inpStrVarProp);
            Iterator<Object> itOuiVars = propVarObj.keySet().iterator();
            while (itOuiVars.hasNext()) {
                String currentOUIKey = itOuiVars.next().toString();
                String currentBridgeKey = propVarObj.getProperty(currentOUIKey);
                target.put(currentOUIKey, source.get(currentBridgeKey));
                sourceClone.remove(currentBridgeKey);
            }
            target.putAll(sourceClone);
        }
        return target;
    }

    public static void logSessionDetails(Map<String, Object> details, Set<String> securePropertySet) {
        try {
            Content content = BeanStoreUtils.createBeanGridContent(true, details, securePropertySet, (Object[])null);
            content.setTitle("Session Details");
            logger.log(Level.INFO, content.getContent());
        }
        catch (BeanStoreException e) {
            logger.log(Level.INFO, "Error while logging session details", e);
        }
    }

    public static void addCleanupTask(Callable<Void> callable) {
        shutdownCleanupTasks.add(callable);
    }

    public static synchronized void doCleanup() {
        try {
            for (Callable<Void> cleanupTask : shutdownCleanupTasks) {
                cleanupTask.call();
            }
        }
        catch (Exception e) {
            logger.info("occured " + e.getClass() + " while executing individual cleanup tasks");
            e.printStackTrace();
        }
        finally {
            OiicExitOps.getExitOps().doExitOperations();
        }
    }

    static synchronized void registerForDelete(String fileOrDir) {
        OiicExitOps.getExitOps().addDelDir(fileOrDir);
    }

    static synchronized void markForDelete(File logFile) throws OiilNativeException, IOException {
        if (PlatformInfo.getInstance().isWindows()) {
            OiipwWin32NativeCalls.registerFileToDelete((String)logFile.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReadmeFileContent(File oracleHome) {
        File readmeLoc = new File(oracleHome.getPath(), "install/readme.txt");
        StringBuffer sEndMsgs = new StringBuffer();
        BufferedReader br = null;
        if (readmeLoc == null || !readmeLoc.exists()) {
            logger.log(Level.WARNING, "readme.txt file doesn't exits");
        } else {
            try {
                br = new BufferedReader(new FileReader(readmeLoc));
                String sMsg = null;
                while ((sMsg = br.readLine()) != null) {
                    sEndMsgs.append(sMsg + "\n");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while reading file " + readmeLoc.getPath(), e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return sEndMsgs.toString();
    }

    public static void setCVUEnabled(boolean enabled) {
        System.setProperty("oracle.install.cvu", Boolean.toString(enabled));
    }

    public static boolean isCVUEnabled() {
        boolean enabled = Boolean.valueOf(System.getProperty("oracle.install.cvu", "true"));
        if (!enabled) {
            logger.log(Level.WARNING, "CVU is not enabled. No CVU based operation will be performed.");
        }
        return enabled;
    }

    public static boolean isCVUOperationEnabled(String controlKey) {
        boolean enabled = false;
        if (controlKey != null && DriverHelper.isCVUEnabled() && !(enabled = Boolean.valueOf(System.getProperty(controlKey, "true")).booleanValue())) {
            logger.log(Level.WARNING, "CVU operation {0} is not enabled.", controlKey);
        }
        return enabled;
    }

    public String getVersion() {
        URL mappingsURL = this.getClass().getResource(DRIVER_PROPERTIES_FILE);
        Properties props = null;
        if (mappingsURL != null) {
            props = new Properties();
            try {
                props.load(mappingsURL.openStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
        if (props != null) {
            return props.get("VERSION").toString();
        }
        return null;
    }

    public static String getLicenseFileLocation() {
        String lic = null;
        String dir = null;
        String paramFile = DriverHelper.getOraparamLocation();
        if (paramFile != null) {
            dir = new File(paramFile).getParent();
        }
        if (dir == null) {
            return lic;
        }
        lic = OiixOraparam.getOraparamProfileString((String)"LICENSE_LOCATION", null);
        if (lic != null && lic.length() != 0) {
            File l = new File(lic = OiixPathOps.concatPath((String)dir, (String)lic));
            if (!l.exists()) {
                logger.log(Level.WARNING, "License file not found");
                return null;
            }
        } else {
            return null;
        }
        return lic;
    }

    public static String getOraparamLocation() {
        String iniFile = System.getProperty("oracle.installer.paramFile");
        if (null != iniFile) {
            try {
                iniFile = OiixPathOps.getCanonicalPath((String)iniFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (iniFile == null || !new File(iniFile).exists()) {
            String dir = System.getProperty("oracle.installer.startup_location");
            if (dir != null) {
                iniFile = OiixPathOps.concatPath((String)dir, (String)"oraparam.ini");
                File f = new File(iniFile);
                if (!f.exists()) {
                    File fStartupDir = new File(dir);
                    String sParentDir = fStartupDir.getParent();
                    iniFile = sParentDir != null ? OiixPathOps.concatPath((String)sParentDir, (String)"oraparam.ini") : "oraparam.ini";
                }
            } else {
                iniFile = "oraparam.ini";
            }
        }
        return iniFile;
    }

    public static String getValue(String key) {
        Object setupDriver = SetupDriver.getInstance();
        Properties clArgs = ((SetupDriver)setupDriver).getCommandLineArgs();
        if (clArgs != null && clArgs.getProperty(key.toLowerCase()) != null) {
            return clArgs.getProperty(key.toLowerCase());
        }
        return null;
    }
}

