/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;

@BeanDef(value="oui-metadata", beanStore=true)
public class OUIMetadata {
    private static final Logger logger = Logger.getLogger(OUIMetadata.class.getName());
    public static final String ARCHITECTURE = "ARCHITECTURE";
    public static final String STARTUP_LOC = System.getProperty("oracle.installer.startup_location");
    public static final String METADATA_FILE_LOC = STARTUP_LOC + File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml";
    public static final String ORACLE_HOME_METADATA_FILE_LOC = "inventory" + File.separator + "ContentsXML" + File.separator + "oraclehomeproperties.xml";
    private Map<String, String> properties;
    private static final URL ext2raw = OUIMetadata.class.getResource("resource/ouimetadatafmt_ext2raw.xsl");

    @PropertyDef(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getArchitecture() {
        return this.getProperty(ARCHITECTURE);
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public static OUIMetadata newInstance(File metadataFile) throws Exception {
        logger.log(Level.INFO, "Reading shiphome metadata from {0}", metadataFile);
        XmlBeanStoreSource source = new XmlBeanStoreSource(metadataFile.toURL(), new XmlBeanStoreFormat(null, null, ext2raw, null));
        OUIMetadata metadata = BeanStoreUtils.restoreFromXML(source, OUIMetadata.class);
        return metadata;
    }

    public static boolean is32BitShiphome(String metadataFileLoc) {
        OUIMetadata metadata = null;
        File metadata_file = new File(metadataFileLoc);
        try {
            metadata = OUIMetadata.newInstance(metadata_file);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Error in retriving metadata from shiphomeproperties xml", e1);
        }
        return metadata != null && metadata.getArchitecture() != null && metadata.getArchitecture().equals("32");
    }
}

