/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationWarning;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;

public class DefaultRetryHandler
implements OiifbIRetry {
    private static Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
    private String title;
    private Component owner;

    public DefaultRetryHandler() {
        this(null, null);
    }

    public DefaultRetryHandler(Component owner) {
        this(owner, null);
    }

    public DefaultRetryHandler(Component owner, String title) {
        this.owner = owner;
        this.title = title;
    }

    public int doModal() {
        return this.doModal(null);
    }

    public int doModal(String msg, int flags, int type) {
        Option option;
        Level level = Level.SEVERE;
        ArrayList<RetryOption> options = new ArrayList<RetryOption>();
        options.add(RetryOption.ABORT);
        for (RetryOption option2 : RetryOption.values()) {
            if (option2.intValue != (flags & option2.intValue) || options.contains(option2)) continue;
            options.add(option2);
        }
        if (!Application.isCommandLineSwitchEnabled("-silent")) {
            DefaultStatusMessage message;
            RetryOption defaultOption = null;
            defaultOption = options.contains(RetryOption.CONTINUE) ? RetryOption.CONTINUE : (RetryOption)options.get(0);
            if (msg == null) {
                msg = resource.getString("DefaultHandler.defaultMessage", "Unknown problem during the installation.", new Object[0]);
            }
            if ((option = StandardDialog.showMessage(this.owner, this.title, message = new DefaultStatusMessage(level, msg), defaultOption, options.toArray(new RetryOption[0]))) == RetryOption.ABORT) {
                Application.getInstance().shutdown(OUIExitStatus.STOP_INSTALL);
            } else if (option == RetryOption.CONTINUE) {
                Application.addApplicationWarning(OUIWarning.INSTALLATION_WARNING_IGNORED_DURING_SETUP);
            }
        } else {
            option = RetryOption.CONTINUE;
            Application.addApplicationWarning(OUIWarning.INSTALLATION_WARNING_IGNORED_DURING_SETUP);
        }
        return option.toInt();
    }

    public int doModal(String msg) {
        return this.doModal(msg, 6, 0);
    }

    public void setEnableCancel(boolean flag) {
    }

    public static enum OUIWarning implements ApplicationWarning
    {
        INSTALLATION_WARNING_IGNORED_DURING_SETUP;


        @Override
        public String getMessage() {
            return resource.getString(this, new Object[0]);
        }
    }

    public static enum RetryOption implements Option
    {
        ABORT(16),
        RETRY(2),
        PROPAGATE(8),
        CONTINUE(4);

        private int intValue;

        private RetryOption(int intValue) {
            this.intValue = intValue;
        }

        @Override
        public int toInt() {
            return this.intValue;
        }

        @Override
        public String toString() {
            return resource.getString(this, new Object[0]);
        }
    }
}

