/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchHPOS;
import oracle.sysman.oip.oipc.oipch.OipchHPPatch;
import oracle.sysman.oip.oipc.oipch.OipchIHasKernel;
import oracle.sysman.oip.oipc.oipch.OipchIHasPackages;
import oracle.sysman.oip.oipc.oipch.OipchIHasPatches;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSReader;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchRefHostReader;
import oracle.sysman.oip.oipc.oipch.OipchRunCommand;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipchHPOSReader
extends OipchOSReader {
    private OipchHPOS m_oHPOS = null;

    protected OipchHPOSReader(Node oNode, int iPlatID) {
        super(oNode, iPlatID);
    }

    @Override
    protected OipchOS createOS() throws OixdInvalidDocumentException {
        this.m_oHPOS = new OipchHPOS();
        this.m_oHPOS.setPlatformID(this.m_iPlatID);
        NodeList oOSNodes = this.m_oNode.getChildNodes();
        if (oOSNodes != null) {
            int nOSNodes = oOSNodes.getLength();
            Node oAttrib = null;
            NamedNodeMap oOSNodeAttribs = null;
            for (int i = 0; i < nOSNodes; ++i) {
                Object[] args;
                Node oOSNode = oOSNodes.item(i);
                if (oOSNode.getNodeType() != 1) continue;
                if (oOSNode.getNodeName().equalsIgnoreCase("VERSION")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VERSION", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    String full_ver = oAttrib.getNodeValue();
                    if (full_ver.startsWith("B.")) {
                        full_ver = full_ver.substring(2);
                    }
                    OipchVersion ver = new OipchVersion(full_ver);
                    this.m_oHPOS.setOSVersion(ver);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("VENDOR")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"VENDOR", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    OipchVendor vendor = new OipchVendor(oAttrib.getNodeValue());
                    this.m_oHPOS.setOSVendor(vendor);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("NAME")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"NAME", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oHPOS.setOSName(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("ARCHITECTURE")) {
                    oOSNodeAttribs = oOSNode.getAttributes();
                    if (oOSNodeAttribs == null) continue;
                    oAttrib = oOSNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        args = new String[]{"ARCHITECTURE", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                    }
                    this.m_oHPOS.setOSArch(oAttrib.getNodeValue());
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("PACKAGES")) {
                    this.addPackageDetails(this.m_oHPOS, oOSNode);
                    continue;
                }
                if (oOSNode.getNodeName().equalsIgnoreCase("PATCHES")) {
                    this.addPatchDetails(this.m_oHPOS, oOSNode);
                    continue;
                }
                if (!oOSNode.getNodeName().equalsIgnoreCase("KERNEL") || Boolean.getBoolean(OipchRefHostReader.S_IF_REFHOST)) continue;
                NodeList oKernelProps = oOSNode.getChildNodes();
                this.addKernelDetails(this.m_oHPOS, oKernelProps);
            }
        }
        return this.m_oHPOS;
    }

    private void addPatchDetails(OipchIHasPatches oOS, Node oPatches) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oPatches.getAttributes();
        Node oAttrib = oNodeAttribs.getNamedItem("VALUE");
        if (oAttrib != null) {
            String sPatches = oAttrib.getNodeValue();
            String[] asPatches = OiixFunctionOps.explodeString((String)sPatches, (String)",");
            for (int i = 0; i < asPatches.length; ++i) {
                OipchHPPatch oPatch = new OipchHPPatch(asPatches[i]);
                oOS.addPatch(oPatch);
            }
        }
    }

    private void addPackageDetails(OipchIHasPackages oOS, Node oPackages) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oPackages.getAttributes();
        Node oAttrib = oNodeAttribs.getNamedItem("VALUE");
        if (oAttrib != null) {
            String sPkgs = oAttrib.getNodeValue();
            String[] asPkgs = OiixFunctionOps.explodeString((String)sPkgs, (String)",");
            for (int i = 0; i < asPkgs.length; ++i) {
                OipchPackage oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                try {
                    oPkg.setProperty("VALUE", asPkgs[i]);
                    oPkg.setProperty("VERSION", "0.0");
                }
                catch (OipchIncorrectPackageFormatException e) {
                    throw new OixdInvalidDocumentException((Throwable)((Object)e));
                }
                oOS.addPackage(oPkg);
            }
        } else {
            NodeList oPackagesNodeList = oPackages.getChildNodes();
            int nPackages = oPackagesNodeList.getLength();
            for (int j = 0; j < nPackages; ++j) {
                Node oPkgNode = oPackagesNodeList.item(j);
                oAttrib = null;
                if (oPkgNode.getNodeType() != 1 || !oPkgNode.getNodeName().equalsIgnoreCase("PACKAGE") || (oNodeAttribs = oPkgNode.getAttributes()) == null) continue;
                String pkgName = null;
                String pkgVers = null;
                for (int i = 0; i < oNodeAttribs.getLength(); ++i) {
                    oAttrib = oNodeAttribs.item(i);
                    if (oAttrib.getNodeName().equals("VALUE")) {
                        pkgName = oAttrib.getNodeValue();
                    }
                    if (oAttrib.getNodeName().equals("VAR")) {
                        if (oAttrib.getNodeValue().indexOf("%") != -1) {
                            String[] kernelVer = new String[1];
                            try {
                                kernelVer = OipchRunCommand.runLocalUnixCommand("uname -r");
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                kernelVer[0] = "";
                            }
                            String verToAppend = kernelVer[0];
                            String[] arg = new String[1];
                            String[] arg1 = new String[1];
                            arg[0] = new String("%KERNEL_RELEASE%");
                            verToAppend = verToAppend.trim();
                            arg1[0] = new String(verToAppend);
                            pkgName = OiixInstantiateString.processString((String)oAttrib.getNodeValue(), (String[])arg, (String[])arg1);
                        } else {
                            pkgName = oAttrib.getNodeValue();
                        }
                    }
                    if (!oAttrib.getNodeName().equals("VERSION")) continue;
                    pkgVers = oAttrib.getNodeValue();
                }
                if (pkgVers == null) {
                    pkgVers = "0.0";
                }
                if (pkgName == null) {
                    Object[] args = new String[]{"NAME", "VALUE"};
                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                }
                OipchPackage oPkg = OipchPackage.createNewInstance(this.m_iPlatID);
                try {
                    oPkg.setProperty("VALUE", pkgName);
                    oPkg.setProperty("VERSION", pkgVers);
                }
                catch (OipchIncorrectPackageFormatException e) {
                    throw new OixdInvalidDocumentException((Throwable)((Object)e));
                }
                oOS.addPackage(oPkg);
            }
        }
    }

    private void addKernelDetails(OipchIHasKernel oOS, NodeList oKernelProps) throws OixdInvalidDocumentException {
        OipchKernelInfo oKernelInfo = oOS.getKernel();
        int nKernelProps = oKernelProps.getLength();
        for (int i = 0; i < nKernelProps; ++i) {
            Object[] args;
            Node oKernelPropNode = oKernelProps.item(i);
            String sName = null;
            String sValue = null;
            if (oKernelPropNode.getNodeType() != 1 || !oKernelPropNode.getNodeName().equals("PROPERTY")) continue;
            NamedNodeMap oNodeAttribs = oKernelPropNode.getAttributes();
            OipchKernelProperty oKernelProp = null;
            int nNodeAttribs = oNodeAttribs.getLength();
            Node oAttrib = oNodeAttribs.getNamedItem("NAME");
            if (oAttrib == null) {
                args = new String[]{"PROPERTY", "NAME"};
                throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
            }
            sName = oAttrib.getNodeValue();
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            if (oAttrib == null) {
                args = new String[]{"PROPERTY", "VALUE"};
                throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
            }
            sValue = oAttrib.getNodeValue();
            try {
                Long lValue = new Long(sValue);
                oKernelProp = new OipchNumKernelProperty(sName, lValue);
            }
            catch (NumberFormatException e) {
                oKernelProp = new OipchStrKernelProperty(sName, sValue);
            }
            oKernelInfo.addProperty(oKernelProp);
        }
    }
}

