/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.CygwinCheckhelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CygwinPackagesChecks {
    private CygwinPackagesChecks() {
    }

    public static OipcrIResult checkCygwinPackages(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                Node oCygNode = oGenRefHost.getNode("CYGWIN_PACKAGES");
                if (oCygNode != null) {
                    NamedNodeMap oCygAttributes = null;
                    Node oAttrib = null;
                    String value = null;
                    StringBuffer actual = new StringBuffer();
                    String expected = null;
                    String format = null;
                    OipcrIResult oRes = null;
                    boolean isAvailable = false;
                    oCygAttributes = oCygNode.getAttributes();
                    for (int i = 0; i < oCygAttributes.getLength(); ++i) {
                        oAttrib = oCygAttributes.item(i);
                        if (!isAvailable && oAttrib != null && oAttrib.getNodeName() != null && oAttrib.getNodeName().equals("VALUE")) {
                            expected = value = oAttrib.getNodeValue();
                        }
                        if (oAttrib == null || oAttrib.getNodeName() == null || !oAttrib.getNodeName().equals("FORMAT")) continue;
                        format = oAttrib.getNodeValue();
                    }
                    List pkgList = CygwinCheckhelper.preparePackageList(value);
                    oRes = CygwinCheckhelper.allPkgsAreFine(pkgList = CygwinCheckhelper.verifyPackages(pkgList, format), actual) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    oResDetails.add(new OipcrResultDetails((Object)actual, (Object)expected, oRes));
                    oResult = new OipcrResult(oResDetails);
                } else {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
                }
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        }
        return oResult;
    }
}

