/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;

public class OracleInventory {
    private OiiiInstallAreaControl areaControl;
    private OiiiInstallInventory inventory;
    private static final OiiiVersion newVersion = new OiiiVersion("10.2.0.0.0");
    private static final OiiiVersion omsMinVersion = new OiiiVersion("10.1.0.2.0");
    private static final OiiiVersion agentMinVersion = new OiiiVersion("10.1.0.2.0");
    private static final String agentName = "oracle.sysman.top.agent";
    private static List agents = new Vector();
    private static final String omsName = "oracle.sysman.top.oms";
    private static final String oldOmsName = "oracle.sysman.console.oms";
    private static List omses = new Vector();
    private static List allHomes = new Vector();
    private static OracleInventory oracleInventory = new OracleInventory();

    public static OracleInventory getInstance() {
        return oracleInventory;
    }

    private OracleInventory() {
        block2: {
            try {
                this.init();
            }
            catch (Exception problem) {
                if (this.isClean()) break block2;
                problem.printStackTrace();
            }
        }
    }

    private void init() throws Exception {
        if (this.initInventorySession()) {
            Vector homesInfo = this.inventory.getHomes();
            for (OiiiOracleHomeInfo info : homesInfo) {
                allHomes.add(info.getLocation());
                this.processHomeLocation(info, omsName, omsMinVersion, omses);
                this.processHomeLocation(info, oldOmsName, omsMinVersion, omses);
                this.processHomeLocation(info, agentName, agentMinVersion, agents);
            }
        }
        OiiolTextLogger.setEnabled((boolean)true);
    }

    public static List getOmsHomes() {
        return omses;
    }

    public static List getAgentHomes() {
        return agents;
    }

    public static List getAllHomes() {
        return allHomes;
    }

    private boolean initInventorySession() throws IOException {
        try {
            OiiiInstallAreaControl.initAreaControl((int)1);
            this.areaControl = OiiiInstallAreaControl.getInstallAreaControl();
            if (this.areaControl == null) {
                throw new IOException("Failed to obtain access to Inventory areaControl");
            }
            this.inventory = this.areaControl.getInstallInventory();
        }
        catch (Exception e) {
            String error = e.getMessage();
            throw new IOException(error);
        }
        return true;
    }

    public boolean isClean() {
        return new OiipgBootstrap().isCleanMachine();
    }

    private void processHomeLocation(OiiiOracleHomeInfo info, String targetName, OiiiVersion minVersion, List output) {
        String componentHome = info.getLocation();
        int idx = info.getIndex();
        Vector comps = this.inventory.getTopLevelComps(idx);
        for (OiiiCompInstallID component : comps) {
            String componentName = component.getName();
            OiiiVersion version = component.getVersion();
            OiiiVersion replaceVersion = component.getReplaceVersion();
            if (!componentName.equalsIgnoreCase(targetName)) continue;
            output.add(componentHome);
        }
    }
}

