/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.config.common;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.config.common.NetCAInternalPlugIn;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.library.util.PlatformInfo;

public class NETCAHelperV2 {
    private static final Logger logger = Logger.getLogger(NETCAHelperV2.class.getName());
    private static final boolean isSilentInstall = Application.isCommandLineSwitchEnabled((String)"-silent");
    private static final String WIN_SERVICE_USER_PASSWORD_FLAG_NAME = "s_winServiceUserPasswordFlag";
    private static final String WIN_SERVICE_USER_PASSWORD_NAME = "S_WINSERVICEUSERPASSWORD";
    private static final String NETCA = "NETCA";
    private static final String NETCA_ARGS = "s_netCA_Args";
    private static final String SPACE = " ";
    public static final String NETCA_RSP_LOC_IN_OH = "network" + File.separator + "install";
    public static final String INSCOMP_SEPARATOR = ",";
    public static final String NO_VALUE = "NO_VALUE";
    private static final String ORACLE_HOME_FLAG = "/orahome";
    private static final String INSTYPE_FLAG = "/instype";
    private static final String INSCOMP_FLAG = "/inscomp";
    private static final String INSPRTCL_FLAG = "/insprtcl";
    private static final String CFG_FLAG = "/cfg";
    private static final String AUTHADP_FLAG = "/authadp";
    private static final String RESPONSE_FILE_FLAG = "/responseFile";
    private static final String SILENT_FLAG = "/silent";
    private static final String CRS_UPGRADE_FLAG = "/crsupgrade";
    public static final String INSPRTCL_TCP = "tcp";
    public static final String CFG_LOCAL = "local";
    public static final String INSTYPE_TYPICAL = "typical";
    public static final String INSTYPE_CUSTOM = "custom";
    public static final String RSPTYPE_TYP = "netca_typ.rsp";
    public static final String RSPTYPE_CLT = "netca_clt.rsp";
    private static String ORACLE_HOME_VALUE;
    private static String INSTYPE_VALUE;
    private static String INSCOMP_VALUE;
    private static String INSPRTCL_VALUE;
    private static String CFG_VALUE;
    private static String AUTHADP_VALUE;
    private static String RESPONSE_FILE_VALUE;

    private static ConfigAssistantParams constructCommonConfigParams(Configurable configJob, String component, WindowsSecureOptionSettings winSecureSettings) {
        ConfigAssistantParams params = new ConfigAssistantParams(NETCA);
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        HashMap<String, String> secretArguments = new HashMap<String, String>();
        configJob.setTransientParameter(component, WIN_SERVICE_USER_PASSWORD_FLAG_NAME, "");
        configJob.setTransientParameter(component, WIN_SERVICE_USER_PASSWORD_NAME, "");
        if (platformInfo.isWindows() && null != winSecureSettings && !winSecureSettings.isDeclineOption()) {
            secretArguments.put("-winServiceUserPassword", winSecureSettings.getPassword());
            Map<String, String> passwordParams = NETCAHelperV2.getPasswordParams(winSecureSettings, false);
            for (String key : passwordParams.keySet()) {
                configJob.setTransientParameter(component, key, passwordParams.get(key));
            }
        }
        params.setSecretArguments(secretArguments);
        params.setSecretParamRegexMap(NetCAInternalPlugIn.secretParamRegexMap);
        return params;
    }

    public static Map<String, String> getPasswordParams(WindowsSecureOptionSettings winSecureSettings, boolean beanValue) {
        HashMap<String, String> passParams = new HashMap<String, String>();
        if (winSecureSettings != null) {
            String winuserPassword = "";
            if (beanValue) {
                winuserPassword = winSecureSettings.getPassword();
            } else {
                winuserPassword = "${S_WINSERVICEUSERPASSWORD}";
                passParams.put(WIN_SERVICE_USER_PASSWORD_FLAG_NAME, "-winServiceUserPassword");
            }
            passParams.put(WIN_SERVICE_USER_PASSWORD_NAME, winuserPassword);
        }
        return passParams;
    }

    public static ConfigAssistantParams constructDBConfigParams(Configurable configJob, String oracleHomeValue, WindowsSecureOptionSettings winSecureSettings) {
        String component = "oracle.server";
        ConfigAssistantParams params = NETCAHelperV2.constructCommonConfigParams(configJob, component, winSecureSettings);
        ORACLE_HOME_VALUE = oracleHomeValue;
        INSTYPE_VALUE = INSTYPE_TYPICAL;
        INSCOMP_VALUE = "client,oraclenet,javavm,server,ano";
        INSPRTCL_VALUE = INSPRTCL_TCP;
        CFG_VALUE = CFG_LOCAL;
        AUTHADP_VALUE = NO_VALUE;
        RESPONSE_FILE_VALUE = oracleHomeValue + File.separator + NETCA_RSP_LOC_IN_OH + File.separator + RSPTYPE_TYP;
        StringBuilder netcaArgs = NETCAHelperV2.constructCommonNETCAArgs();
        netcaArgs.append("/silent ");
        logger.info("s_netCA_Args: " + netcaArgs.toString());
        configJob.setTransientParameter(component, NETCA_ARGS, netcaArgs.toString());
        return params;
    }

    public static ConfigAssistantParams constructCRSConfigParams(Configurable configJob, String oracleHomeValue, WindowsSecureOptionSettings winSecureSettings, Boolean isUpgrade) {
        String component = "oracle.crs";
        ConfigAssistantParams params = NETCAHelperV2.constructCommonConfigParams(configJob, component, winSecureSettings);
        ORACLE_HOME_VALUE = oracleHomeValue;
        INSTYPE_VALUE = INSTYPE_TYPICAL;
        INSCOMP_VALUE = "client,oraclenet,javavm,server,ano";
        INSPRTCL_VALUE = INSPRTCL_TCP;
        CFG_VALUE = CFG_LOCAL;
        AUTHADP_VALUE = NO_VALUE;
        RESPONSE_FILE_VALUE = oracleHomeValue + File.separator + NETCA_RSP_LOC_IN_OH + File.separator + RSPTYPE_TYP;
        StringBuilder netcaArgs = NETCAHelperV2.constructCommonNETCAArgs();
        netcaArgs.append("/silent ");
        if (isUpgrade.booleanValue()) {
            netcaArgs.append("/crsupgrade ");
        }
        logger.info("s_netCA_Args: " + netcaArgs.toString());
        configJob.setTransientParameter(component, NETCA_ARGS, netcaArgs.toString());
        return params;
    }

    public static ConfigAssistantParams constructClientConfigParams(Configurable configJob, String oracleHomeValue, WindowsSecureOptionSettings winSecureSettings, String insCompValue, String insTypeValue, String responseFileValue, boolean silentFlag) {
        String component = "oracle.client";
        ConfigAssistantParams params = NETCAHelperV2.constructCommonConfigParams(configJob, component, winSecureSettings);
        ORACLE_HOME_VALUE = oracleHomeValue;
        INSTYPE_VALUE = INSTYPE_TYPICAL;
        INSCOMP_VALUE = "client,oraclenet";
        INSPRTCL_VALUE = INSPRTCL_TCP;
        CFG_VALUE = CFG_LOCAL;
        AUTHADP_VALUE = NO_VALUE;
        RESPONSE_FILE_VALUE = oracleHomeValue + File.separator + NETCA_RSP_LOC_IN_OH + File.separator + RSPTYPE_CLT;
        if (insCompValue != null) {
            INSCOMP_VALUE = insCompValue;
        }
        if (insTypeValue != null) {
            INSTYPE_VALUE = insTypeValue;
        }
        if (responseFileValue != null) {
            RESPONSE_FILE_VALUE = responseFileValue;
        }
        StringBuilder netcaArgs = NETCAHelperV2.constructCommonNETCAArgs();
        if (silentFlag || isSilentInstall) {
            netcaArgs.append("/silent ");
        }
        logger.info("s_netCA_Args: " + netcaArgs.toString());
        configJob.setTransientParameter(component, NETCA_ARGS, netcaArgs.toString());
        return params;
    }

    public static ConfigAssistantParams constructGSMConfigParams(Configurable configJob, String oracleHomeValue, WindowsSecureOptionSettings winSecureSettings) {
        String component = "oracle.dslm";
        ConfigAssistantParams params = NETCAHelperV2.constructCommonConfigParams(configJob, component, winSecureSettings);
        ORACLE_HOME_VALUE = oracleHomeValue;
        INSTYPE_VALUE = INSTYPE_TYPICAL;
        INSCOMP_VALUE = "client,oraclenet";
        INSPRTCL_VALUE = INSPRTCL_TCP;
        CFG_VALUE = CFG_LOCAL;
        AUTHADP_VALUE = NO_VALUE;
        RESPONSE_FILE_VALUE = oracleHomeValue + File.separator + NETCA_RSP_LOC_IN_OH + File.separator + RSPTYPE_TYP;
        StringBuilder netcaArgs = NETCAHelperV2.constructCommonNETCAArgs();
        netcaArgs.append("/silent ");
        logger.info("s_netCA_Args: " + netcaArgs.toString());
        configJob.setTransientParameter(component, NETCA_ARGS, netcaArgs.toString());
        return params;
    }

    public static ConfigAssistantParams constructTGConfigParams(Configurable configJob, String oracleHomeValue, WindowsSecureOptionSettings winSecureSettings) {
        String component = "oracle.tg";
        ConfigAssistantParams params = NETCAHelperV2.constructCommonConfigParams(configJob, component, winSecureSettings);
        ORACLE_HOME_VALUE = oracleHomeValue;
        INSTYPE_VALUE = INSTYPE_CUSTOM;
        INSCOMP_VALUE = "client,oraclenet,server";
        INSPRTCL_VALUE = INSPRTCL_TCP;
        CFG_VALUE = CFG_LOCAL;
        AUTHADP_VALUE = NO_VALUE;
        RESPONSE_FILE_VALUE = oracleHomeValue + File.separator + NETCA_RSP_LOC_IN_OH + File.separator + RSPTYPE_TYP;
        StringBuilder netcaArgs = NETCAHelperV2.constructCommonNETCAArgs();
        if (isSilentInstall) {
            netcaArgs.append("/silent ");
        }
        logger.info("s_netCA_Args: " + netcaArgs.toString());
        configJob.setTransientParameter(component, NETCA_ARGS, netcaArgs.toString());
        return params;
    }

    private static StringBuilder constructCommonNETCAArgs() {
        StringBuilder netcaArgs = new StringBuilder();
        netcaArgs.append("/orahome ");
        netcaArgs.append(ORACLE_HOME_VALUE + SPACE);
        netcaArgs.append("/instype ");
        netcaArgs.append(INSTYPE_VALUE + SPACE);
        netcaArgs.append("/inscomp ");
        netcaArgs.append(INSCOMP_VALUE + SPACE);
        netcaArgs.append("/insprtcl ");
        netcaArgs.append(INSPRTCL_VALUE + SPACE);
        netcaArgs.append("/cfg ");
        netcaArgs.append(CFG_VALUE + SPACE);
        netcaArgs.append("/authadp ");
        netcaArgs.append(AUTHADP_VALUE + SPACE);
        netcaArgs.append("/responseFile ");
        netcaArgs.append(RESPONSE_FILE_VALUE + SPACE);
        return netcaArgs;
    }

    public static final class InsComp {
        public static final String CLIENT = "client";
        public static final String ORACLENET = "oraclenet";
        public static final String JAVAVM = "javavm";
        public static final String SERVER = "server";
        public static final String ANO = "ano";
    }
}

