/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.List;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.AbstractActionableStatusMessage;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.util.RemoteOperationHelper;
import oracle.install.ivw.common.validator.ActionableValidationHelper;
import oracle.install.ivw.crs.bean.CRSInstallSettings;

public class ClusterActionableValidationStatusMessage
extends AbstractActionableStatusMessage<RemoteOperationHelper.RemoteOperationResult, CRSInstallSettings> {
    private static Logger logger = Logger.getLogger(ClusterActionableValidationStatusMessage.class.getName());

    public ClusterActionableValidationStatusMessage(ErrorCode errorCode, RemoteOperationHelper.RemoteOperationResult result, Object ... messageArgs) {
        super(errorCode, (Object)result, messageArgs);
        this.updateExtraDetails();
    }

    public ClusterActionableValidationStatusMessage(ErrorCode errorCode, Severity severity, RemoteOperationHelper.RemoteOperationResult result, Object ... messageArgs) {
        super(errorCode, severity, (Object)result, messageArgs);
        this.updateExtraDetails();
    }

    public ClusterActionableValidationStatusMessage(String message, RemoteOperationHelper.RemoteOperationResult result) {
        super(message, (Object)result);
        this.updateExtraDetails();
    }

    public ClusterActionableValidationStatusMessage(String message, Severity severity, RemoteOperationHelper.RemoteOperationResult result) {
        super(message, severity, (Object)result);
        this.updateExtraDetails();
    }

    public ClusterActionableValidationStatusMessage(Throwable cause, RemoteOperationHelper.RemoteOperationResult result) {
        super(cause, (Object)result);
        this.updateExtraDetails();
    }

    public StatusMessages<ValidationStatusMessage> performAction(CRSInstallSettings bean) {
        RemoteOperationHelper.RemoteOperationResult clusterResult;
        logger.entering(ClusterActionableValidationStatusMessage.class.getName(), "performAction");
        if (bean != null && (clusterResult = (RemoteOperationHelper.RemoteOperationResult)this.getResult()) != null) {
            List badNodes = clusterResult.getFailedNodes();
            ActionableValidationHelper.removeBadNodes(badNodes, bean);
        }
        logger.exiting(ClusterActionableValidationStatusMessage.class.getName(), "performAction");
        return null;
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        RemoteOperationHelper helper = RemoteOperationHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }
}

