/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.util.Application;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.view.UpdatesListPane;

@ViewDef(id="UpdatesListUI")
public class UpdatesListUI
implements View {
    private UpdatesListPane updatesListPane;
    private Logger logger = Logger.getLogger(UpdatesListUI.class.getName());
    private String defaultHomeLoc = "";

    public UpdatesListUI() {
        this.updatesListPane = new UpdatesListPane();
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        AutoUpdatesInstallSettings bean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        bean.setApplyUpdates(this.updatesListPane.applyUpdatesSelected());
        this.logger.log(Level.INFO, "In processinput of UpdatesListUI. Apply Updates selected: " + this.updatesListPane.applyUpdatesSelected());
        if (bean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
            bean.setPatchDownloadLocation(this.updatesListPane.getPatchDownloadLocation());
        }
    }

    public Component getView() {
        return this.updatesListPane;
    }

    public void localize(FlowContext flowContext) {
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        this.logger.log(Level.INFO, "UpdatesListUI entering onEvent");
        this.defaultHomeLoc = PlatformInfo.getInstance().isWindows() ? "c:\\temp" : System.getProperty("user.home", "");
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        if (eventType == EventType.LOAD || eventType == EventType.INIT) {
            UpdateManager updateManager;
            if (autoBean.getDownloadType() != null) {
                if (autoBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
                    if (autoBean.getPatchDownloadLocation() == null || autoBean.getPatchDownloadLocation().length() == 0) {
                        this.updatesListPane.setPatchDownloadLocation(this.defaultHomeLoc);
                    } else {
                        this.updatesListPane.setPatchDownloadLocation(autoBean.getPatchDownloadLocation());
                    }
                    if (Application.getInstance() instanceof OracleInstaller) {
                        OracleInstaller installer = (OracleInstaller)Application.getInstance();
                        if (installer.getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
                            this.updatesListPane.setShowDownloadLocationPanel(true, true);
                        } else {
                            this.updatesListPane.setShowDownloadLocationPanel(true, false);
                        }
                    }
                } else if (autoBean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
                    this.updatesListPane.setShowDownloadLocationPanel(false, false);
                    this.updatesListPane.setStoredDownloadLocation(autoBean.getPatchDownloadLocation());
                }
                this.updatesListPane.setPatchDownloadType(autoBean.getDownloadType());
            }
            if ((updateManager = UpdateManager.getInstance()).getListOfUpdatesSelected() != null && updateManager.getListOfUpdatesSelected().size() > 0) {
                this.updatesListPane.setListOfPatches(updateManager.getListOfUpdatesSelected());
                if (autoBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
                    this.updatesListPane.setTotalDownloadSize(updateManager.getTotalDownloadSizeForAllPatches(autoBean.getMyoracleSupportDetails(), autoBean.getHttpProxySettings()));
                }
            }
        }
    }
}

