/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.partition.Partition;
import oracle.install.library.partition.PartitionInfoUnix;
import oracle.install.library.partition.PartitionInfoWin;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.ClusterPreinstClassW32;
import oracle.install.library.util.InstallException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixGeneralQueries;

public class DiskManager {
    public static final String ORAREMOTESERVICE_PATH = "oracle.install.library.partition.diskmanager.ORAREMOTESERVICE_PATH";
    private static DiskManager instance = null;
    public List<Partition> partitionDetails;
    List<String> driveLettersList;
    String[] nodesSelected;
    private static String errorHint = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)"INSTALL_COMMON_HINT_FILE_SYSTEM_ERROR"), new Object[0]);
    private Logger logger = Logger.getLogger(DiskManager.class.getName());

    protected DiskManager() {
    }

    public static DiskManager getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (DiskManager)(proxyFactory = ProxyFactory.getInstance()).createProxy(DiskManager.class)) == null) {
            instance = new DiskManager();
        }
        return instance;
    }

    public List<Partition> getPartitions() {
        return this.getPartitions(false);
    }

    public List<Partition> getPartitions(boolean reload) {
        if (this.partitionDetails == null || reload) {
            int i;
            ClusterPreinstClassW32 qc = new ClusterPreinstClassW32();
            int pCount = qc.getPartitionCount();
            PartitionInfoWin[] partitionInfoArray = new PartitionInfoWin[pCount];
            Partition[] partitionArray = new Partition[pCount];
            for (i = 0; i < pCount; ++i) {
                partitionInfoArray[i] = new PartitionInfoWin();
            }
            qc.fillPartitions(partitionInfoArray);
            for (i = 0; i < partitionInfoArray.length; ++i) {
                partitionArray[i] = new Partition();
                partitionArray[i].setDiskNumber(partitionInfoArray[i].getDiskNumber());
                partitionArray[i].setPartitionNumber(partitionInfoArray[i].getPartitionNumber());
                partitionArray[i].setPartitionSize(partitionInfoArray[i].getPartitionSize());
            }
            this.partitionDetails = Arrays.asList(partitionArray);
            return this.partitionDetails;
        }
        return this.partitionDetails;
    }

    public Partition getPartition(String diskNumber, String partitionNumber) {
        Partition p = null;
        if (this.getPartitions() != null) {
            for (Partition p1 : this.getPartitions()) {
                if (!p1.getDiskNumber().equals(diskNumber) || !p1.getPartitionNumber().equals(partitionNumber)) continue;
                p = p1;
            }
        }
        return p;
    }

    public long getSize(String diskNumber, String partNumber) {
        long size = 0L;
        for (Partition p1 : this.partitionDetails) {
            if (!diskNumber.equals(p1.getDiskNumber()) || !partNumber.equals(p1.getPartitionNumber())) continue;
            size = Long.parseLong(p1.getPartitionSize());
        }
        return size;
    }

    private boolean areNodesSelectedSame(String[] nodesSelected, String[] nodes) {
        if (nodesSelected != null && nodes != null) {
            Arrays.sort(nodesSelected);
            Arrays.sort(nodes);
            return Arrays.equals(nodesSelected, nodes);
        }
        return false;
    }

    public List<String> getAvailableDriveLetters(String ... nodes) {
        return this.getAvailableDriveLetters(false, nodes);
    }

    public List<String> getAvailableDriveLetters(boolean reload, String ... nodes) {
        boolean flag = false;
        if (this.driveLettersList == null || reload || !this.areNodesSelectedSame(this.nodesSelected, nodes)) {
            this.driveLettersList = new ArrayList<String>();
            List<String> tmpDriveLetterList = null;
            if (nodes == null || nodes.length == 0) {
                tmpDriveLetterList = Arrays.asList(OiixFileOps.getAllVolumeNames());
                this.nodesSelected = null;
                flag = true;
            } else {
                String oraremservicePath = System.getProperty(ORAREMOTESERVICE_PATH, "");
                this.nodesSelected = nodes;
                try {
                    ClusterWindows win = new ClusterWindows();
                    tmpDriveLetterList = Arrays.asList(win.getAvailableDriveLetters(nodes, oraremservicePath));
                }
                catch (Exception e) {
                    this.logger.log(Level.INFO, "EXCEPTION OCCURRED WHILE GETTING DRIVE LETTERS");
                }
            }
            if (tmpDriveLetterList != null && tmpDriveLetterList.size() > 0) {
                String[] driveLettersPresent = new String[tmpDriveLetterList.size()];
                for (int k = 0; k < tmpDriveLetterList.size(); ++k) {
                    driveLettersPresent[k] = tmpDriveLetterList.get(k);
                    driveLettersPresent[k] = driveLettersPresent[k].replace(':', ' ');
                    driveLettersPresent[k] = driveLettersPresent[k].replace('\\', ' ');
                    driveLettersPresent[k] = driveLettersPresent[k].trim();
                }
                if (flag) {
                    List<String> test = Arrays.asList(driveLettersPresent);
                    for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
                        if (test.contains(Character.toString(i))) continue;
                        this.driveLettersList.add(Character.toString(i));
                    }
                } else {
                    this.driveLettersList = Arrays.asList(driveLettersPresent);
                }
            }
        }
        return this.driveLettersList;
    }

    public long getFreeSpace(String partitionName) throws InstallException {
        partitionName = PartitionInfoUnix.getLastExistingParent(partitionName);
        try {
            return OiixGeneralQueries.getFreeSpaceux((String)partitionName, (Boolean)true).longValue();
        }
        catch (Exception ioex) {
            throw new InstallException((Throwable)ioex, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_GET_FS_PARTITION_FREE_SIZE, new Object[0]);
        }
    }

    public String getSizeWithUnits(String diskNumber, String partNumber) {
        long size = this.getSize(diskNumber, partNumber);
        String s = Long.toString(size) + " MB";
        if (size > 1024L && size < 0x100000L) {
            s = (size /= 1024L) + " GB";
        } else if (size >= 0x100000L) {
            s = (size /= 0x100000L) + " TB";
        }
        return s;
    }

    public boolean isPartitionRaw(String partitionName) throws InstallException {
        try {
            return Cluster.validateDevice((String)partitionName);
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_CHECK_WHETHER_PARTITION_ISRAW, new Object[0]);
        }
    }
}

