/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.range.compiler.NodeGeneratorFactory;
import oracle.install.library.util.cluster.range.compiler.NodeToken;
import oracle.install.library.util.cluster.range.enums.NodeTokenType;
import oracle.install.library.util.cluster.range.generator.NodeGenerator;

public class NodeRangeCompiler {
    private static final Logger logger = Logger.getLogger(NodeRangeCompiler.class.getName());
    private List<NodeToken> expressionTokens;
    private List<NodeGenerator> nodeGenerators;

    public void compile(String nodeExpression, boolean createNodeGenerators) {
        logger.log(Level.INFO, "Node range expression to be compiled: " + nodeExpression + ", create node generators: " + String.valueOf(createNodeGenerators));
        if (nodeExpression == null || nodeExpression.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.expressionTokens = this.parseNodeTokens(nodeExpression);
        if (createNodeGenerators) {
            this.nodeGenerators = this.createNodeGenerators(this.expressionTokens);
        }
    }

    public void compile(String nodeExpression) {
        this.compile(nodeExpression, true);
    }

    private List<NodeToken> parseNodeTokens(String rawExpression) {
        ArrayList<NodeToken> parsedTokens = new ArrayList<NodeToken>();
        char[] rawExpressionContent = rawExpression.toCharArray();
        NodeToken currentToken = new NodeToken();
        StringBuilder tokenContentBuilder = new StringBuilder();
        for (char currentChar : rawExpressionContent) {
            if (currentChar == '[') {
                if (currentToken.getTokenType() != NodeTokenType.NOT_DETERMINED) continue;
                if (tokenContentBuilder.length() != 0) {
                    currentToken.setTokenType(NodeTokenType.CONSTANT);
                    String tokenContent = tokenContentBuilder.toString();
                    currentToken.setTokenContent(tokenContent);
                    logger.log(Level.INFO, "CONSTANT token detected: " + tokenContent);
                    parsedTokens.add(currentToken);
                    tokenContentBuilder.setLength(0);
                    currentToken = new NodeToken();
                }
                tokenContentBuilder.append(currentChar);
                continue;
            }
            if (currentChar == ']') {
                if (tokenContentBuilder.length() == 0 || !tokenContentBuilder.toString().contains("[")) {
                    currentToken.setTokenType(NodeTokenType.INVALID);
                } else if (currentToken.getTokenType() == NodeTokenType.RANGE || currentToken.getTokenType() == NodeTokenType.SEQUENCE) {
                    int firstRangeOperandIndex;
                    char firstRangeOperand;
                    int validRangeCharacterLength = 4;
                    String currentTokenContent = tokenContentBuilder.toString();
                    char lastCapturedToken = currentTokenContent.charAt(tokenContentBuilder.length() - 1);
                    if (!Character.isLetterOrDigit(lastCapturedToken)) {
                        currentToken.setTokenType(NodeTokenType.INVALID);
                    } else if (currentToken.getTokenType() == NodeTokenType.RANGE && tokenContentBuilder.length() != validRangeCharacterLength) {
                        currentToken.setTokenType(NodeTokenType.INVALID);
                    }
                    if (currentToken.getTokenType() == NodeTokenType.RANGE && (firstRangeOperand = currentTokenContent.charAt(firstRangeOperandIndex = 1)) > lastCapturedToken) {
                        currentToken.setTokenType(NodeTokenType.INVALID);
                    }
                }
                tokenContentBuilder.append(currentChar);
                String tokenContent = tokenContentBuilder.toString();
                currentToken.setTokenContent(tokenContent);
                logger.log(Level.INFO, currentToken.getTokenType().toString() + " token detected: " + tokenContent);
                parsedTokens.add(currentToken);
                currentToken = new NodeToken();
                tokenContentBuilder.setLength(0);
                continue;
            }
            if (currentChar == '-') {
                if (tokenContentBuilder.toString().contains("[")) {
                    char lastCapturedToken = tokenContentBuilder.toString().charAt(tokenContentBuilder.length() - 1);
                    if (Character.isLetterOrDigit(lastCapturedToken) && !tokenContentBuilder.toString().contains("-")) {
                        currentToken.setTokenType(NodeTokenType.RANGE);
                    } else {
                        currentToken.setTokenType(NodeTokenType.INVALID);
                    }
                    tokenContentBuilder.append(currentChar);
                    continue;
                }
                tokenContentBuilder.append(currentChar);
                continue;
            }
            if (currentChar == '|') {
                if (tokenContentBuilder.toString().contains("[")) {
                    char lastCapturedToken = tokenContentBuilder.toString().charAt(tokenContentBuilder.length() - 1);
                    if (Character.isLetterOrDigit(lastCapturedToken)) {
                        currentToken.setTokenType(NodeTokenType.SEQUENCE);
                    } else {
                        currentToken.setTokenType(NodeTokenType.INVALID);
                    }
                    tokenContentBuilder.append(currentChar);
                    continue;
                }
                currentToken.setTokenType(NodeTokenType.INVALID);
                continue;
            }
            tokenContentBuilder.append(currentChar);
        }
        if (tokenContentBuilder.length() != 0) {
            NodeTokenType lastTokenType = currentToken.getTokenType();
            if (lastTokenType == NodeTokenType.NOT_DETERMINED) {
                if (tokenContentBuilder.toString().contains("[")) {
                    currentToken.setTokenType(NodeTokenType.INVALID);
                } else {
                    currentToken.setTokenType(NodeTokenType.CONSTANT);
                }
            }
            if (!(lastTokenType != NodeTokenType.SEQUENCE && lastTokenType != NodeTokenType.RANGE || tokenContentBuilder.toString().contains("]"))) {
                currentToken.setTokenType(NodeTokenType.INVALID);
            }
            String tokenContent = tokenContentBuilder.toString();
            currentToken.setTokenContent(tokenContent);
            logger.log(Level.INFO, currentToken.getTokenType().toString() + " token detected: " + tokenContent);
            parsedTokens.add(currentToken);
        }
        return parsedTokens;
    }

    public List<NodeToken> getParsedTokens() {
        return this.expressionTokens;
    }

    public List<NodeGenerator> createNodeGenerators(List<NodeToken> parsedTokens) {
        ArrayList<NodeGenerator> generatorList = new ArrayList<NodeGenerator>();
        for (NodeToken nodeToken : parsedTokens) {
            generatorList.add(NodeGeneratorFactory.createNodeGenerator(nodeToken));
        }
        return generatorList;
    }

    public List<NodeGenerator> getNodeGenerators() {
        return this.nodeGenerators;
    }
}

