/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.view.InstallLocationPane;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;

@ViewDef(id="InstallLocationUI")
public class InstallLocationGUI
implements View {
    private InstallLocationPane installLocationPane;
    private String oraHome = new String();

    public InstallLocationGUI() {
        this.installLocationPane = new InstallLocationPane();
        this.installLocationPane.setOracleBaseActiveHelpId("InstallLocationUI.cbxOracleBases");
        this.installLocationPane.setOracleHomeActiveHelpId("InstallLocationUI.cbxSoftwareLoc");
    }

    private void initialize(FlowContext flowContext) {
        ClientInstallSettings clientBean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        WindowsSecureOptionSettings winSecurebean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
        String oraBase = new String();
        String oraBaseWin = new String();
        this.oraHome = clientBean.getOracleHome();
        oraBase = clientBean.getOracleBase();
        oraBaseWin = clientBean.getOracleBase();
        if (GenericValidation.isEmpty((String)oraBase)) {
            if (PlatformInfo.getInstance().isWindows() && clientBean.getInstallType() != ClientInstallSettings.InstallType.InstantClient) {
                WindowsSecureOptionSettings secureBean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
                if (!secureBean.isDeclineOption()) {
                    String[] temp;
                    String userName;
                    String userNameWithoutDomain = userName = secureBean.getUserName();
                    userNameWithoutDomain = userName.contains("\\") ? ((temp = userName.split("\\\\")).length > 1 ? temp[1] : userName) : userName;
                    if (!GenericValidation.isEmpty((String)userNameWithoutDomain)) {
                        oraBaseWin = oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation(userNameWithoutDomain);
                    } else {
                        String instuserName = "client" + File.separator + System.getProperty("user.name", "");
                        oraBaseWin = oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation(instuserName);
                    }
                } else {
                    String instuserName = "client" + File.separator + System.getProperty("user.name", "");
                    oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation(instuserName);
                    oraBaseWin = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
                }
            } else {
                oraBaseWin = oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
            }
        }
        if (GenericValidation.isEmpty((String)this.oraHome)) {
            this.oraHome = OFAWrapper.getInstance().getOracleHomeFromEnv();
            if (GenericValidation.isEmpty((String)this.oraHome)) {
                if (!clientBean.isUpgrading()) {
                    this.installLocationPane.setComputeOracleHomeLoc(true);
                    this.oraHome = OFAWrapper.getInstance().getDBHomeLoc(oraBase);
                    this.installLocationPane.setDefOracleHomeLocation(this.oraHome);
                } else {
                    String[] homes = clientBean.getUpgradableHomes();
                    if (homes.length > 0) {
                        this.oraHome = homes[0];
                    }
                    this.installLocationPane.fillOracleHomeLocations(homes);
                    this.installLocationPane.setDefOracleHomeLocation(this.oraHome);
                }
            }
        }
        this.installLocationPane.setOracleHomeLocation(this.oraHome);
        if (!GenericValidation.isEmpty((String)OFAWrapper.getInstance().getBaseForLocation(this.oraHome))) {
            oraBase = OFAWrapper.getInstance().getBaseForLocation(this.oraHome);
            this.installLocationPane.dissableOracleBase();
        }
        this.installLocationPane.setOracleBase(oraBase);
    }

    public Component getView() {
        return this.installLocationPane;
    }

    public void localize(FlowContext flowContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.client.resource.ClientDialogLabelResID");
        String oraBaseDesc = resource.getString("INSTALL_CLIENT_LOCATION_DLG_LABEL_ORABASE_DESC", "Specify an Oracle base path to place all Oracle software and configuration-related files.  This location is the Oracle base directory.", new Object[0]);
        String oraHomeDesc = resource.getString("INSTALL_CLIENT_LOCATION_DLG_LABEL_ORAHOME_DESC", "Specify a location for storing Oracle software files.  This location is the Oracle home directory.", new Object[0]);
        this.installLocationPane.setOracleBaseDesc(oraBaseDesc);
        this.installLocationPane.setOracleHomeDesc(oraHomeDesc);
        this.installLocationPane.localize();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        final ClientInstallSettings clientBean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        switch (eventType) {
            case INIT: {
                this.initialize(flowContext);
                clientBean.addPropertyChangeListener("oracle_install_client_upgrading", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (clientBean.isUpgrading()) {
                            InstallLocationGUI.this.installLocationPane.fillOracleHomeLocations(clientBean.getUpgradableHomes());
                        } else {
                            InstallLocationGUI.this.installLocationPane.fillOracleHomeLocations(new String[0]);
                        }
                    }
                });
                break;
            }
            case LOAD: {
                if (clientBean.getInstallType() == ClientInstallSettings.InstallType.InstantClient || clientBean.isUpgrading()) {
                    this.installLocationPane.hideOracleBasePanel(true);
                    break;
                }
                this.installLocationPane.hideOracleBasePanel(false);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        String oracleBase = this.installLocationPane.getOracleBase();
        if (installSettings.getInstallType() != ClientInstallSettings.InstallType.InstantClient) {
            installSettings.setOracleBase(oracleBase);
        }
        cenInv.setInventoryLocation(InventoryInfo.computeInventoryLocation((String)oracleBase));
        installSettings.setOracleHome(this.installLocationPane.getOracleHomeLocation());
    }
}

