/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMInstanceType;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.ExadataDisk;
import oracle.install.asm.util.kfod.ASMTypeOutputParser;
import oracle.install.asm.util.kfod.ClientsOpOutputParser;
import oracle.install.asm.util.kfod.DFLTDSTROpOutputParser;
import oracle.install.asm.util.kfod.DiskOpOutputParser;
import oracle.install.asm.util.kfod.ExadataDiskOpOutputParser;
import oracle.install.asm.util.kfod.GroupDetailsOpOutputParser;
import oracle.install.asm.util.kfod.GroupOpOutputParser;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.InstsOpOutputParser;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.asm.util.kfod.VersionOpOutputParser;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;

public class KFOD
extends ASMUtility {
    public static final String PATH = "oracle.install.asm.util.kfod.PATH";
    public static final String ORACLE_HOME = "oracle.install.asm.util.kfod.KFOD_ORACLE_HOME";
    private static final Logger logger = Logger.getLogger(KFOD.class.getName());
    public static final String UNIX_SIDPATTERN = "\\+.+";
    public static final String WIN_SIDPATTERN = ".+\\+.+";
    private ProcessBuilder processBuilder;
    private Pattern pattern;
    public static final String TEMP_OB = "temp_ob";
    private OutputProcessor stderrProcessor = new AbstractLineProcessor(){

        public void processLine(String line, int lineNumber) {
            logger.warning(line);
        }
    };
    private static Map<List<String>, List<Disk>> discoveredDisks;

    public KFOD() {
        if (discoveredDisks == null) {
            discoveredDisks = new HashMap<List<String>, List<Disk>>();
        }
    }

    private ProcessBuilder findKFOD(File path) throws ASMUtilityException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File kfod = null;
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        if (!windows) {
            kfod = new File(path, "kfod.bin");
            if (!kfod.exists()) {
                logger.info("kfod.bin not found at " + path + " , falling back to kfod");
                kfod = new File(path, "kfod");
            }
        } else {
            kfod = new File(path, "kfod.exe");
        }
        if (kfod == null || !kfod.exists()) {
            logger.warning("KFOD not found at " + path);
            return null;
        }
        if (!windows) {
            processBuilder.command(kfod.getPath());
            Map<String, String> env = processBuilder.environment();
            File libPath = new File(path, "../lib/");
            env.put("LD_LIBRARY_PATH", libPath.getPath());
            env.put("LD_LIBRARY_PATH_64", libPath.getPath());
            env.put("LIBPATH", libPath.getPath());
            env.put("SHLIB_PATH", libPath.getPath());
        } else {
            processBuilder.command("\"" + kfod.getPath() + "\"");
        }
        List<String> command = processBuilder.command();
        command.add("nohdr=true");
        command.add("verbose=true");
        processBuilder.directory(path);
        return processBuilder;
    }

    @Override
    public void init() throws ASMUtilityException {
        File kfodDir = new File(System.getProperty(PATH, ""));
        this.processBuilder = this.findKFOD(kfodDir);
        this.pattern = Pattern.compile(KFOD.getSIDPattern(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultDiscoveryString() throws ASMUtilityException {
        String discoveryString = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("op=dfltdstr");
        if (this.processBuilder != null) {
            try {
                this.processBuilder.environment().put("ORACLE_HOME", System.getProperty(ORACLE_HOME, ""));
                this.processBuilder.command().addAll(command);
                DFLTDSTROpOutputParser outputParser = new DFLTDSTROpOutputParser();
                this.execute(this.processBuilder, outputParser);
                discoveryString = outputParser.getDefaultDiscoveryString();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return discoveryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int shallowFindDisks(String ... discoveryString) throws ASMUtilityException {
        int disks = -1;
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("op=disks");
        command.add("shallow=true");
        if (discoveryString != null) {
            StringBuffer asm_diskstring = new StringBuffer();
            for (String item : discoveryString) {
                if (item == null) continue;
                asm_diskstring.append(",").append("'").append(item).append("'");
            }
            if (asm_diskstring.length() > 0) {
                asm_diskstring.deleteCharAt(0);
                command.add("asm_diskstring=" + asm_diskstring.toString());
            }
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.environment().put("ORACLE_HOME", System.getProperty(ORACLE_HOME, ""));
                this.processBuilder.command().addAll(command);
                class ShallowFindOutputParser
                extends KFODOpOutputParser {
                    String shallowLine = null;

                    ShallowFindOutputParser() {
                    }

                    public int getDisks() {
                        int disks = -1;
                        if (this.shallowLine != null) {
                            String[] token = this.shallowLine.split(" ");
                            if (token.length == 5) {
                                try {
                                    disks = Integer.parseInt(token[3]);
                                }
                                catch (Exception e) {
                                    logger.warning("Could not parse the disks number from: " + token[3] + " , from line: " + this.shallowLine);
                                }
                            } else {
                                logger.warning("The kfod shallow line did not contain 5 columns: " + this.shallowLine);
                            }
                        } else {
                            logger.warning("The kfod shallow line was null");
                        }
                        return disks;
                    }

                    @Override
                    public void parseLine(String line) {
                        if (line != null && line.trim().toLowerCase().startsWith("shallow")) {
                            this.shallowLine = line.trim();
                        }
                    }
                }
                ShallowFindOutputParser outputParser = new ShallowFindOutputParser();
                this.execute(this.processBuilder, outputParser);
                disks = outputParser.getDisks();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return disks;
    }

    @Override
    public List<Disk> findDisks(String ... discoveryString) throws ASMUtilityException {
        return this.findDisks(false, discoveryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Disk> findDisks(boolean reload, String ... discoveryString) throws ASMUtilityException {
        if (!reload) {
            ArrayList<String> discoveryStringList = new ArrayList<String>();
            if (discoveryString != null) {
                for (String str : discoveryString) {
                    discoveryStringList.add(str);
                }
                if (discoveredDisks.containsKey(discoveryStringList)) {
                    return discoveredDisks.get(discoveryStringList);
                }
            }
        } else {
            discoveredDisks = new HashMap<List<String>, List<Disk>>();
        }
        List<Disk> disks = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("status=true");
        command.add("op=disks");
        if (discoveryString == null) {
            discoveryString = new String[]{this.getDefaultDiscoveryString()};
        }
        StringBuffer asm_diskstring = new StringBuffer();
        for (String item : discoveryString) {
            asm_diskstring.append(",").append("'").append(item).append("'");
        }
        if (asm_diskstring.length() > 0) {
            asm_diskstring.deleteCharAt(0);
            command.add("asm_diskstring=" + asm_diskstring.toString());
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.environment().put("ORACLE_HOME", System.getProperty(ORACLE_HOME, ""));
                this.processBuilder.command().addAll(command);
                DiskOpOutputParser outputParser = new DiskOpOutputParser();
                this.execute(this.processBuilder, outputParser);
                disks = outputParser.getDisks();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
            if (discoveryString.length > 0 && disks.size() > 0) {
                ArrayList<String> discoveryStringList = new ArrayList<String>();
                for (String str : discoveryString) {
                    discoveryStringList.add(str);
                }
                discoveredDisks.put(discoveryStringList, disks);
            }
        }
        return disks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findDiskgroupsFromHeader(String discoveryString) throws ASMUtilityException {
        final ArrayList<String> diskgroups = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("op=disks");
        command.add("dscvgroup=TRUE");
        if (discoveryString != null && discoveryString.length() > 0) {
            command.add("asm_diskstring='AFD:*," + discoveryString + "'");
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.environment().put("ORACLE_HOME", System.getProperty(ORACLE_HOME, ""));
                this.processBuilder.command().addAll(command);
                DiskOpOutputParser outputParser = new DiskOpOutputParser(){

                    @Override
                    public void parseLine(String line) {
                        String[] tokens;
                        if (!(line == null || line.length() <= 0 || line.startsWith("ORA-") || line.startsWith("KFOD-") || line.startsWith("LEM-") || !Pattern.matches("^\\d.*", line) || (tokens = Helper.tokenize(line)).length != 3 && tokens.length != 5)) {
                            try {
                                String diskGroupName = tokens[2].replaceAll("#", "").trim();
                                if (diskGroupName.length() > 0 && !diskgroups.contains(tokens[2].trim())) {
                                    diskgroups.add(tokens[2].trim());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                this.execute(this.processBuilder, outputParser);
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return diskgroups.size() == 0 ? null : diskgroups;
    }

    @Override
    public ASMInstance getASMInstance() throws ASMUtilityException {
        List<ASMInstance> asmList;
        ASMInstance instance = null;
        OracleServiceRegistry serviceRegistry = OracleServiceRegistry.getInstance();
        OracleService asm = serviceRegistry.findServiceById(this.pattern);
        if (asm != null) {
            instance = new ASMInstance(asm.getSid(), asm.getOracleHome());
        }
        if (instance == null && (asmList = this.getASMInstances(new String[0])) != null && asmList.size() > 0) {
            instance = asmList.get(0);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ASMInstance> getASMInstances(String ... nodes) throws ASMUtilityException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("op=insts");
        if (nodes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            for (String node : nodes) {
                buffer.append(',' + node);
            }
            buffer.deleteCharAt(0);
            command.add("hostlist=" + buffer.toString());
        }
        List<ASMInstance> instances = new ArrayList<ASMInstance>();
        if (this.processBuilder != null) {
            try {
                this.processBuilder.command().addAll(command);
                InstsOpOutputParser outputParser = new InstsOpOutputParser();
                this.execute(this.processBuilder, outputParser);
                instances = outputParser.getInstances();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return instances;
    }

    @Override
    public List<DiskGroup> getDiskGroups(ASMInstance asmInstance) throws ASMUtilityException {
        if (asmInstance != null) {
            Version asmVersion = this.getVersion(asmInstance);
            File oracleHome = asmInstance.getOracleHome();
            String sid = asmInstance.getSid();
            if (oracleHome.exists() && oracleHome.list() != null && oracleHome.list().length > 0) {
                ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
                processBuilder.command().add("op=groups");
                processBuilder.command().add("cluster=true");
                if (asmVersion != null && asmVersion.compareTo(InstallConstants.VERSION_12_1, 4) >= 0) {
                    processBuilder.command().add("asmcompatibility=true");
                }
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("ORACLE_HOME", oracleHome.getPath());
                env.put("ORACLE_SID", sid);
                processBuilder.environment().putAll(env);
                GroupOpOutputParser outputParser = new GroupOpOutputParser();
                this.execute(processBuilder, outputParser);
                return outputParser.getDiskGroups();
            }
            return new ArrayList<DiskGroup>();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskGroup> getDiskGroups(String sASMClientDataFileLoc) throws ASMUtilityException {
        ArrayList<String> command = new ArrayList<String>();
        String kfodDir = System.getProperty(PATH, "");
        String oracleHome = System.getProperty(ORACLE_HOME, "");
        ProcessBuilder processBuilder = this.findKFOD(new File(kfodDir));
        command.add("op=groups");
        command.add("wrap=\"" + sASMClientDataFileLoc + "\"");
        command.add("_boot=true");
        if (processBuilder != null) {
            try {
                processBuilder.command().addAll(command);
                processBuilder.environment().put("ORACLE_HOME", oracleHome);
                GroupOpOutputParser outputParser = new GroupOpOutputParser();
                this.execute(processBuilder, outputParser);
                List<DiskGroup> list = outputParser.getDiskGroups();
                return list;
            }
            finally {
                processBuilder.command().removeAll(command);
            }
        }
        return new ArrayList<DiskGroup>();
    }

    @Override
    public List<Disk> getDisks(ASMInstance asmInstance, DiskGroup diskGroup) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=groups");
        processBuilder.command().add(String.format("group=%s", diskGroup.getName()));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        GroupDetailsOpOutputParser outputParser = new GroupDetailsOpOutputParser();
        this.execute(processBuilder, outputParser);
        return outputParser.getDisks();
    }

    @Override
    public boolean isAccessible(ASMInstance asmInstance) throws ASMUtilityException {
        boolean accessible = true;
        try {
            this.getDiskGroups(asmInstance);
        }
        catch (ASMUtilityException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == ASMUtilityErrorCode.ASM_ACCESS_DENIED) {
                accessible = false;
            }
            throw e;
        }
        return accessible;
    }

    @Override
    public boolean isAlive(ASMInstance asmInstance) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=insts");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        InstsOpOutputParser outputParser = new InstsOpOutputParser();
        this.execute(processBuilder, outputParser);
        List<ASMInstance> instances = outputParser.getInstances();
        return instances != null && instances.contains((Object)asmInstance);
    }

    @Override
    public List<OracleService> getClientServices(ASMInstance asmInstance) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=clients");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        ClientsOpOutputParser outputParser = new ClientsOpOutputParser();
        this.execute(processBuilder, outputParser);
        return outputParser.getClients();
    }

    @Override
    public List<String> getActiveASMClients(ASMInstance asmInstance) throws ASMUtilityException {
        ArrayList<String> activeDBsOnASM = new ArrayList<String>();
        String sid = "";
        for (OracleService oraService : this.getClientServices(asmInstance)) {
            sid = oraService.getSid();
            if (sid.startsWith("+ASM")) continue;
            activeDBsOnASM.add(sid);
        }
        return activeDBsOnASM;
    }

    @Override
    public ASMInstance getDetails(ASMInstance instance) throws ASMUtilityException {
        if (instance != null) {
            Version version = this.getVersion(instance);
            instance.setVersion(version);
        }
        return instance;
    }

    private Version getVersion(ASMInstance instance) throws ASMUtilityException {
        Version version = null;
        if (instance != null) {
            File oracleHome = instance.getOracleHome();
            String sid = instance.getSid();
            if (oracleHome.exists()) {
                ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("ORACLE_HOME", oracleHome.getPath());
                env.put("ORACLE_SID", sid);
                processBuilder.environment().putAll(env);
                processBuilder.command().add("op=version");
                VersionOpOutputParser outputParser = new VersionOpOutputParser(instance);
                this.execute(processBuilder, outputParser);
                instance = outputParser.getInstance();
                if (instance == null) {
                    throw new ASMUtilityException(ASMUtilityErrorCode.ASM_INSTANCE_DOWN, new Object[0]);
                }
                version = instance.getVersion();
            } else {
                throw new ASMUtilityException(ASMUtilityErrorCode.CORRUPT_ASM_HOME, new Object[0]);
            }
        }
        return version;
    }

    private void execute(ProcessBuilder processBuilder, KFODOpOutputParser outputParser) throws ASMUtilityException {
        this.execute(processBuilder, outputParser, this.stderrProcessor);
    }

    private void execute(ProcessBuilder processBuilder, KFODOpOutputParser outputParser, OutputProcessor stderrProcessor) throws ASMUtilityException {
        try {
            if (Boolean.getBoolean("oracle.installer.setupWizard")) {
                String tempOB = OFAWrapper.getInstance().getTempOracleBaseLocation();
                File tempOBFile = new File(tempOB);
                if (tempOBFile.exists() || tempOBFile.mkdirs()) {
                    processBuilder.environment().put("ORACLE_BASE", tempOB);
                } else {
                    logger.warning("Could not create temp oracle base: " + tempOB);
                }
            }
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)outputParser, stderrProcessor);
            ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            ASMUtilityErrorCode errorCode = outputParser.getErrorCode();
            if (errorCode != null) {
                throw new ASMUtilityException(errorCode, new Object[0]);
            }
        }
        catch (ASMUtilityException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ASMUtilityException(e);
        }
    }

    public static String getSIDPattern() {
        return PlatformInfo.getInstance().isWindows() ? WIN_SIDPATTERN : UNIX_SIDPATTERN;
    }

    @Override
    public List<String> getAllowedASMVersionsForRollingUpgrade() throws ASMUtilityException {
        ProcessBuilder processBuilder = this.findKFOD(new File(InstallHelper.getInstallBinariesPath()));
        processBuilder.command().add("op=rmvers");
        class LineOutputParser
        extends KFODOpOutputParser {
            List<String> verList = new ArrayList<String>();

            LineOutputParser() {
            }

            public List<String> getVersionList() {
                return this.verList;
            }

            @Override
            public void parseLine(String line) {
                if (line != null && !line.trim().contains("KFOD-")) {
                    this.verList.add(line.trim());
                }
            }
        }
        LineOutputParser outputParser = new LineOutputParser();
        this.execute(processBuilder, outputParser);
        return outputParser.getVersionList();
    }

    @Override
    public ASMInstanceType getASMInstanceType(ASMInstance instance) throws ASMUtilityException {
        if (instance != null) {
            File oracleHome = instance.getOracleHome();
            String sid = instance.getSid();
            if (oracleHome.exists()) {
                ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("ORACLE_HOME", oracleHome.getPath());
                env.put("ORACLE_SID", sid);
                processBuilder.environment().putAll(env);
                processBuilder.command().add("op=version");
                ASMTypeOutputParser outputParser = new ASMTypeOutputParser();
                this.execute(processBuilder, outputParser);
                return outputParser.getASMType();
            }
            throw new ASMUtilityException(ASMUtilityErrorCode.CORRUPT_ASM_HOME, new Object[0]);
        }
        return ASMInstanceType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExadataDisk> findExadataDisks(String ... discoveryString) throws ASMUtilityException {
        List<ExadataDisk> disks = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("status=true");
        command.add("op=disks");
        command.add("cell=true");
        StringBuffer asm_diskstring = new StringBuffer();
        for (String item : discoveryString) {
            asm_diskstring.append(",").append("'").append(item).append("'");
        }
        if (asm_diskstring.length() > 0) {
            asm_diskstring.deleteCharAt(0);
            command.add("asm_diskstring=" + asm_diskstring.toString());
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.environment().put("ORACLE_HOME", System.getProperty(ORACLE_HOME, ""));
                this.processBuilder.command().addAll(command);
                ExadataDiskOpOutputParser outputParser = new ExadataDiskOpOutputParser();
                this.execute(this.processBuilder, outputParser);
                disks = outputParser.getDisks();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return disks;
    }
}

