/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.DownloadUpdateJob;
import oracle.install.ivw.common.util.autoupdates.DownloadUpdateJobEvent;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesRestartManager;

public class UpdatesListAction
extends DefaultAction {
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
    private Logger logger = Logger.getLogger(UpdatesListAction.class.getName());

    public Route transition(FlowContext flowContext) {
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        String shiphomeUpdatesDir = "Shiphome";
        String updatesDir = "LatestUpdates";
        String metadataDir = "metadata";
        UpdateManager updateManager = UpdateManager.getInstance();
        Application application = Application.getInstance();
        String downloadLocation = autoBean.getPatchDownloadLocation();
        boolean standAloneUtility = false;
        this.logger.log(Level.FINEST, "From UpdatesListAction.. download location: " + downloadLocation);
        if (application.getUIType() == UIType.NONE && autoBean.getDownloadType() != PatchDownloadType.SKIP_UPDATES) {
            autoBean.setApplyUpdates(true);
        }
        boolean applyUpdatesSelected = autoBean.isApplyUpdates();
        DownloadUpdateJob updatesDownloadJob = new DownloadUpdateJob(downloadLocation, updateManager.getListOfUpdatesSelected());
        if (autoBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
            OracleInstaller installer;
            block19: {
                File updatesLoc = new File(downloadLocation, updatesDir);
                if (updatesLoc.exists()) {
                    FileSystem.delete((File)updatesLoc);
                }
                if (applyUpdatesSelected) {
                    if (!downloadLocation.equalsIgnoreCase(this.scratchPathLoc)) {
                        updateManager.copyMetadataToDownloadLoc(downloadLocation);
                    }
                    updatesDownloadJob.setDownloadLoc(downloadLocation);
                    updatesDownloadJob.prepareJob(updateManager.getListOfUpdatesSelected());
                    updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.JOB_STARTED, downloadLocation, updateManager.getListOfUpdatesSelected()));
                    try {
                        JobHelper.executeJobs((Job[])new Job[]{updatesDownloadJob});
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Download of updates failed", e);
                        updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.JOB_INTERRUPTED, downloadLocation, updateManager.getListOfUpdatesSelected()));
                        ExceptionManager.handle((Throwable)e);
                        if (flowContext == null || flowContext.getFlowControl() == null) break block19;
                        flowContext.getFlowControl().stop();
                    }
                }
            }
            if (application instanceof OracleInstaller && (installer = (OracleInstaller)Application.getInstance()).getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
                standAloneUtility = true;
                if (updatesDownloadJob.getStatus() == Status.SUCCEEDED) {
                    this.logger.log(Level.INFO, "The download of the updates succeeded.");
                    return new Route("DOWNLOAD_UPDATES_FINISHED");
                }
                updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.STANDALONE_DOWNLOAD_FAILED, downloadLocation, updateManager.getListOfUpdatesSelected()));
                this.logger.log(Level.INFO, "The download of the updates failed.");
                if (flowContext != null && flowContext.getFlowControl() != null) {
                    flowContext.getFlowControl().stop();
                }
                return new Route("DOWNLOAD_UPDATES_FINISHED");
            }
            if (updatesDownloadJob.getStatus() == Status.FAILED && !standAloneUtility) {
                this.logger.log(Level.SEVERE, "The download of the updates failed");
                autoBean.setApplyUpdates(false);
                updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.JOB_INTERRUPTED, downloadLocation, updateManager.getListOfUpdatesSelected()));
                ExceptionManager.handle((Throwable)((Object)new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.UPDATES_DOWNLOAD_FAILED, Severity.WARNING, new Object[0])));
                if (flowContext != null && flowContext.getFlowControl() != null) {
                    flowContext.getFlowControl().stop();
                }
            }
            if (updatesDownloadJob.getStatus() == Status.SUCCEEDED) {
                this.logger.log(Level.INFO, "The download of the updates succeeded.");
                updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.JOB_FINISHED, downloadLocation, updateManager.getListOfUpdatesSelected()));
            }
        }
        if (applyUpdatesSelected && autoBean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES || applyUpdatesSelected && autoBean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD && updatesDownloadJob.getStatus() == Status.SUCCEEDED) {
            updateManager.fireDownloadUpdateJobEvent(new DownloadUpdateJobEvent(updatesDownloadJob, DownloadUpdateJobEvent.Type.RESTART_INSTALL, downloadLocation, updateManager.getListOfUpdatesSelected()));
            if (application.getUIType() == UIType.NONE) {
                boolean shiphomeUpdateRestart;
                int ouiBug = -1;
                int opatchBug = -1;
                boolean requiresRestart = false;
                if (updateManager.getOUIUpdate() != null && updateManager.getOUIUpdate().getPatchBugNumber() != 0) {
                    ouiBug = updateManager.getOUIUpdate().getPatchBugNumber();
                }
                if (updateManager.getOPatchUpdate() != null && updateManager.getOPatchUpdate().getPatchBugNumber() != 0) {
                    opatchBug = updateManager.getOPatchUpdate().getPatchBugNumber();
                }
                if (!(shiphomeUpdateRestart = updateManager.getRestartInstall()) && !requiresRestart) {
                    this.logger.log(Level.FINEST, "No shiphome updates which require restart are found.");
                }
                if (applyUpdatesSelected && (requiresRestart || shiphomeUpdateRestart)) {
                    application.pause(true);
                    this.logger.log(Level.FINEST, "Updates requiring restart of the installer found and its a silent install, so restarting the install");
                    UpdatesRestartManager restartManager = UpdatesRestartManager.getInstance();
                    autoBean.setPatchDownloadLocation(autoBean.getPatchDownloadLocation());
                    restartManager.prepareForRestart(autoBean);
                    restartManager.restartInstaller(autoBean.getPatchDownloadLocation(), ouiBug, opatchBug);
                }
            }
        }
        return Route.SUCCESS;
    }
}

