/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.install.commons.base.logging.BasicLogHandler;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.PrintStreamRedirector;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUITimeLogHandler;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InventoryInfo;
import oracle.ops.mgmt.trace.Trace;

public class CommonConfigLogHandler
extends BasicLogHandler {
    public static String invLogLocation = null;
    public static final String timeStamp = FunctionsUtil.getTimeStamp();
    protected static String logFileNamePrefix = null;

    public CommonConfigLogHandler(String logFileName) throws IOException, SecurityException {
        super(logFileName, (Formatter)new CommonConfigLogFormater());
        this.constructorInit(logFileName);
    }

    public CommonConfigLogHandler(String logDirPrefix, String logPrefix) throws IOException, SecurityException {
        super(CommonConfigLogHandler.getLogFileName(logDirPrefix, logPrefix), (Formatter)new CommonConfigLogFormater());
        this.constructorInit(CommonConfigLogHandler.getLogFileName(logDirPrefix, logPrefix));
    }

    private void constructorInit(String logFileName) throws IOException, SecurityException {
        this.setLevel(Level.FINEST);
        PrintStreamRedirector.setErrFile((String)CommonConfigLogHandler.getErrFileName());
        PrintStreamRedirector.setOutFile((String)CommonConfigLogHandler.getOutFileName(), (boolean)true);
        LogManager.getInstance().setDefaultLogFile(new File(logFileName));
        if (Application.isCommandLineSwitchEnabled((String)"-printtime")) {
            OUITimeLogHandler.getInstanse().setLogLocation(invLogLocation);
        }
        if (!Application.isCommandLineSwitchEnabled((String)"-debug")) {
            Trace.enableTracing();
            Trace.configure((boolean)false, (boolean)false, (boolean)true, (boolean)true, (String)CommonConfigLogHandler.getOutFileName(), (boolean)true, (boolean)true);
            DriverHelper.addCleanupTask((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Trace.close();
                    return null;
                }
            });
        }
    }

    private static String getLogFileName(String logDirPrefix, String logPrefix) {
        CommonConfigLogHandler.init(logDirPrefix, logPrefix);
        return logFileNamePrefix + ".log";
    }

    public static String getLogFileName() {
        return logFileNamePrefix + ".log";
    }

    protected static void init(String logDirPrefix, String logPrefix) {
        if (invLogLocation == null) {
            InventoryInfo invInfo = InventoryInfo.getInstance();
            if (invInfo.isInventoryExist()) {
                boolean isNonWindowsAndUserNonMemberOfInvGroup = false;
                if (!PlatformInfo.getInstance().isWindows()) {
                    String invGroup = invInfo.getUnixGroupName();
                    if (!Arrays.asList(invInfo.getOSGroups()).contains(invGroup)) {
                        isNonWindowsAndUserNonMemberOfInvGroup = true;
                        invLogLocation = System.getProperty("oracle.installer.tempLogDir");
                    }
                }
                if (!isNonWindowsAndUserNonMemberOfInvGroup) {
                    invLogLocation = invInfo.getDefaultInventoryLoc() + File.separator + "logs" + File.separator + logDirPrefix + timeStamp;
                }
            } else {
                invLogLocation = System.getProperty("oracle.installer.tempLogDir");
            }
            new File(invLogLocation).mkdirs();
            logFileNamePrefix = invLogLocation + File.separator + logPrefix + timeStamp;
            OUILogHandler.setLogLocation((String)invLogLocation);
        }
    }

    public static String getErrFileName() {
        return logFileNamePrefix + ".err";
    }

    public static String getOutFileName() {
        return logFileNamePrefix + ".out";
    }

    public static String getLogLocation() {
        return invLogLocation;
    }

    static class CommonConfigLogFormater
    extends Formatter {
        private boolean PRINT_TIME = Boolean.getBoolean("oracle.installer.printtime") || Boolean.getBoolean("oracle.installer.printtimeverbose") || Application.isCommandLineSwitchEnabled((String)"-printtime");
        MessageFormat formater = new MessageFormat("{0,date} {0,time}");
        Date dat = new Date();

        CommonConfigLogFormater() {
        }

        @Override
        public String format(LogRecord logRecord) {
            Appendable buffer;
            Level level = logRecord.getLevel();
            String message = this.formatMessage(logRecord);
            Throwable throwable = logRecord.getThrown();
            if (throwable != null && !(throwable instanceof ValidationException) && !(throwable instanceof UncheckedValidationException)) {
                try {
                    buffer = new StringWriter();
                    PrintWriter out = new PrintWriter((Writer)buffer);
                    throwable.printStackTrace(out);
                    out.close();
                    String stacktraceId = String.format("%s:%s", logRecord.getLoggerName(), logRecord.getSequenceNumber());
                    System.err.printf("---# Begin Stacktrace #---------------------------\nID: %s\n%s\n---# End Stacktrace #-----------------------------\n", stacktraceId, ((StringWriter)buffer).toString());
                    message = String.format("%s.\nRefer associated stacktrace #%s", message, stacktraceId);
                }
                catch (Exception buffer2) {
                    // empty catch block
                }
            }
            buffer = new StringBuffer();
            this.dat.setTime(logRecord.getMillis());
            if (message != null) {
                ((StringBuffer)buffer).append(message);
                if (level.getName().startsWith(Level.FINE.getName())) {
                    ((StringBuffer)buffer).insert(0, ':');
                    ((StringBuffer)buffer).insert(0, logRecord.getLoggerName());
                }
            }
            if (this.PRINT_TIME) {
                StringBuffer text = new StringBuffer();
                this.formater.format(new Object[]{this.dat}, text, (FieldPosition)null);
                ((StringBuffer)buffer).insert(0, " [" + text + "] ");
            }
            return String.format("%s: %s\n", level.getName(), ((StringBuffer)buffer).toString());
        }
    }
}

