/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.PlatformInfo;

public class RoohCtlToolJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(RoohCtlToolJob.class.getName());
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final String roohCtl = "roohctl";
    private static final String roohCtl_win = "roohctl.bat";
    private OutputProcessor stdOutProcessor;
    private OutputProcessor stdErrProcessor;
    ErrorMessage message;
    String oracleHome;
    List<String> clusterNodes;

    public RoohCtlToolJob(String oracleHome, List<String> clusterNodes) {
        super((Object)roohCtl, null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"roohInitToolJob.description"), "Setup Read-Only Oracle Home", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.oracleHome = oracleHome;
        this.clusterNodes = clusterNodes;
        this.stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.info(line);
            }
        };
        this.stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.warning(line);
            }
        };
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add((Job)this);
            }
        }
        return retriableJobs;
    }

    public Callable<?> getWork() {
        return this;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        boolean succeeded = true;
        String ohBinDir = new File(this.oracleHome, "bin").getAbsolutePath();
        ArrayList<String> args = new ArrayList<String>();
        String cmd = PlatformInfo.getInstance().isWindows() ? ohBinDir + File.separator + roohCtl_win : ohBinDir + File.separator + roohCtl;
        File roohCtlFile = new File(cmd);
        if (roohCtlFile != null && roohCtlFile.exists()) {
            args.add(cmd);
            args.add("-enable");
            if (this.clusterNodes != null && this.clusterNodes.size() > 0) {
                args.add("-nodeList " + this.getCSVForList(this.clusterNodes));
            }
            args.add("-force");
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            ((AbstractLineProcessor)this.stdOutProcessor).getLines().clear();
            ((AbstractLineProcessor)this.stdErrProcessor).getLines().clear();
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, this.stdOutProcessor, this.stdErrProcessor);
            int exitCode = 0;
            try {
                exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (Exception e) {
                succeeded = false;
                logger.log(Level.INFO, "Initialize Read-Only Oracle Home failed", e);
                logger.log(Level.INFO, e.getMessage());
            }
            if (exitCode != 0) {
                succeeded = false;
            }
            if (succeeded) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                Advice advice;
                this.message = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ROOHCTL_TOOL_FAILED, new Object[0]);
                this.message.getErrorInfo().setExtraDetails((Content)this.getExtraDetails(succeeded));
                if (args != null) {
                    PlainContent extraDetails = new PlainContent();
                    StringBuilder s = new StringBuilder("Command:\n");
                    for (String arg : args) {
                        s.append(arg);
                        s.append(" ");
                    }
                    extraDetails.setContent(s.toString());
                    logger.log(Level.INFO, s.toString());
                }
                if ((advice = ExceptionManager.advise((ErrorMessage)this.message)) == Advice.CONTINUE) {
                    this.setStatus(Status.SUCCEEDED);
                } else {
                    this.setStatus(Status.FAILED);
                }
            }
        } else {
            logger.info(cmd + " utility does not exist");
        }
    }

    private String getCSVForList(List<String> list) {
        StringBuilder retStr = new StringBuilder();
        if (list != null) {
            for (String item : list) {
                retStr.append(item);
                retStr.append(",");
            }
            if (retStr.length() > 0) {
                retStr.deleteCharAt(retStr.lastIndexOf(","));
            }
        }
        return retStr.toString();
    }

    public PlainContent getExtraDetails(boolean succeeded) {
        PlainContent content = null;
        if (!succeeded) {
            content = new PlainContent("");
            content.setContentType(ContentType.HTML);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            StringBuffer extraDetails = new StringBuffer();
            ArrayList totalLines = new ArrayList();
            totalLines.addAll(((AbstractLineProcessor)this.stdOutProcessor).getLines());
            totalLines.addAll(((AbstractLineProcessor)this.stdErrProcessor).getLines());
            for (String line : totalLines) {
                if (line == null) continue;
                extraDetails.append("&nbsp;-&nbsp;");
                extraDetails.append(StringUtils.textToHtml((String)line) + "<br>");
            }
            StringBuffer details = new StringBuffer(content.getContent());
            details.append(extraDetails.toString());
            content.setContent(details.toString());
        }
        return content;
    }
}

