/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.ivw.common.driver.job.RemoveTemporaryHome;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.GoldImageUtil;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.imageinfo.ImageInfoUtil;

public class CreateGoldImageJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(CreateGoldImageJob.class.getName());
    private static final boolean isWindows = PlatformInfo.getInstance().isWindows();
    private static final String oPatchesDirectory = "OPatch";
    private String sourceHome;
    private String destinationLocation;
    protected static final String sep = File.separator;
    protected static final String comma = ",";
    protected static final String fileslst = "install" + sep + "files.lst";
    protected List<String> excludedFiles;
    private static final String timestamp = FunctionsUtil.getTimeStamp();
    protected String goldImageName = "home_" + timestamp + ".zip";
    protected String cmdLineExclFiles;
    private ProgressUI<Void> progressUI;
    private Set<File> createdGoldImageContents;
    private List<String> removedSymlinksToDereference;
    private boolean recreateImageInfo;
    private String[] symlinksToDereference = new String[]{"lib" + sep + "libskgxnr.so" + "," + "clone" + sep + "rootpre" + sep + "ORCLcluster" + sep + "libskgxnr.so", "lib" + sep + "libskgxn2.so" + "," + "lib" + sep + "libskgxns.so"};

    public CreateGoldImageJob(String sourceHome, String destinationLocation, String cmdLineExclFiles, ProgressUI<Void> progressUI) {
        super((Object)"creategoldimage", null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"createGoldImageJob.description"), "Create Gold Image", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.sourceHome = sourceHome;
        this.destinationLocation = destinationLocation;
        this.cmdLineExclFiles = cmdLineExclFiles;
        this.progressUI = progressUI;
        this.recreateImageInfo = System.getProperty("image_info_location") != null;
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        Application.removeExitStatus((ExitStatus)Application.CommonExitStatus.FAILURE);
        Resource stringResource = Application.getInstance().getResource(StringResourceBundle.class.getName());
        this.log(Level.INFO, stringResource.getString("CreateGoldImageJob.progress.createGoldImage", "Creating the Gold Image", new Object[0]), new Object[0]);
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        boolean recreateFilesListAction = this.isRecreateFilesList();
        boolean isTarFormat = cmdLineArgumentHandler.isArgumentPassed("format") ? cmdLineArgumentHandler.getArgumentValue("format").equalsIgnoreCase("tar") : false;
        boolean noTarCompression = cmdLineArgumentHandler.isArgumentPassed("noTarCompression");
        boolean succeeded = false;
        Set<File> filesSet = this.getAllFilesRecursively(new File(this.sourceHome));
        this.createdGoldImageContents = new HashSet<File>();
        this.createdGoldImageContents.addAll(filesSet);
        Set<File> filesSetCopy = null;
        if (recreateFilesListAction) {
            filesSetCopy = new HashSet<File>();
            filesSetCopy.addAll(filesSet);
        }
        this.setProgress(0.0012f);
        HashMap<String, String> symlinkPhysicalMap = this.getSymlinkPhysicalMap();
        filesSet = this.removeSymlinksToDereference(symlinkPhysicalMap, filesSet);
        this.setProgress(0.00123f);
        if (filesSet != null) {
            boolean isDestDirCreated;
            filesSet = this.removeExcludedFiles(filesSet);
            this.createdGoldImageContents = this.removeExcludedFiles(this.createdGoldImageContents);
            if (recreateFilesListAction) {
                filesSetCopy = this.removeExcludedFiles(filesSetCopy);
            }
            this.setProgress(0.00125f);
            List<File> sortedFiles = this.sortFilesByPathLength(filesSet);
            this.setProgress(0.00136f);
            File destinationDir = new File(this.destinationLocation);
            if (!destinationDir.exists() && !(isDestDirCreated = destinationDir.mkdirs())) {
                logger.log(Level.SEVERE, "Failed to create destination location:" + this.destinationLocation);
            }
            if (destinationDir.exists()) {
                succeeded = this.createGoldImage(sortedFiles, 0.98f);
                this.setProgress(0.99f);
                if (succeeded) {
                    succeeded = this.addPhysicalFilesOfDereferencedSymlinks(symlinkPhysicalMap);
                }
                this.addImageInfoToGoldImage();
                if (succeeded && recreateFilesListAction) {
                    List<File> sortedFilesSetCopy = this.sortFilesByPathName(filesSetCopy);
                    this.addNewFilesListToGoldImage(sortedFilesSetCopy);
                }
            } else {
                logger.log(Level.SEVERE, "The destination location directory does not exist.");
            }
        }
        if (succeeded) {
            succeeded = isTarFormat && !noTarCompression ? this.compressTar() : this.verifyGoldImageContents();
        }
        this.setProgress(1.0f);
        if (succeeded) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            String logLocation;
            Advice advice;
            File goldImageFile = new File(this.destinationLocation + sep + this.goldImageName);
            if (goldImageFile.exists()) {
                logger.log(Level.INFO, "Removing the goldimage file, as there was a failure.");
                boolean removed = goldImageFile.delete();
                if (!removed) {
                    logger.log(Level.INFO, "Could not directly remove the goldimage, attempt with nio API.");
                    try {
                        Files.delete(goldImageFile.toPath());
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Could not directly remove the goldimage, will delete on exit.");
                        goldImageFile.deleteOnExit();
                    }
                }
            }
            if ((advice = ExceptionManager.advise((ErrorMessage)new DefaultErrorMessage((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_CREATOR_JOB_FAILED, new Object[]{logLocation = OUILogHandler.getLogLocation()}))) == Advice.CONTINUE) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.setStatus(Status.FAILED);
                Application.addExitStatus((ExitStatus)Application.CommonExitStatus.FAILURE);
            }
        }
    }

    private boolean compressTar() {
        boolean succeed = false;
        File goldImageFile = new File(this.destinationLocation + sep + this.goldImageName);
        if (goldImageFile.exists()) {
            ArrayList<String> args = new ArrayList<String>();
            String gzipLocation = null;
            CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
            if (cmdLineArgumentHandler.isArgumentPassed("gzipLocation")) {
                gzipLocation = cmdLineArgumentHandler.getArgumentValue("gzipLocation");
            } else if (!isWindows) {
                gzipLocation = "/bin/gzip";
            }
            args.add(gzipLocation);
            args.add(goldImageFile.getAbsolutePath());
            String workingDir = goldImageFile.getParent();
            succeed = this.runCmd(args.toArray(new String[0]), workingDir, false, 0.0f);
            if (!succeed) {
                new File(this.destinationLocation + sep + this.goldImageName).delete();
            }
        }
        return succeed;
    }

    private boolean addImageInfoToGoldImage() {
        String tempLoc = System.getProperty("oracle.installer.tempLogDir");
        String tempHome = tempLoc + sep + "tempHome_" + System.currentTimeMillis();
        File tempHomeDir = new File(tempHome);
        boolean succeeded = false;
        String originalImageInfo = null;
        File imageInfo = new File(this.sourceHome + File.separator + "install" + File.separator + ".img.bin");
        if (imageInfo.exists() && !this.recreateImageInfo) {
            ImageInfoUtil decoder = new ImageInfoUtil(this.sourceHome);
            try {
                originalImageInfo = decoder.decode();
            }
            catch (CheckedException e) {
                logger.log(Level.WARNING, "Unable to decode the original image information.", e.getMessage());
            }
        }
        tempHomeDir.mkdir();
        succeeded = this.createImageInfo(tempHome, originalImageInfo);
        if (succeeded) {
            this.addAtomicDirToGoldImage(tempHomeDir, false, false, 0.0f);
        }
        FileSystem.delete((File)tempHomeDir);
        return succeeded;
    }

    private boolean createImageInfo(String tempLoc, String originalImageInfoToAppend) {
        boolean succeeded;
        File imageInfoFile;
        StringBuilder content;
        block25: {
            content = new StringBuilder();
            String additionalInfoLoc = System.getProperty("image_info_location");
            imageInfoFile = new File(tempLoc + sep + "install");
            succeeded = false;
            content.append("Image information generated on " + new Timestamp(new Date().getTime()).toString() + "\n");
            content.append("Release version " + InstallConstants.VERSION.toString() + "\n");
            if (this.recreateImageInfo) {
                if (!additionalInfoLoc.isEmpty()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(additionalInfoLoc));){
                        if (!reader.ready()) break block25;
                        content.append("Additional information:\n");
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            content.append(line + "\n");
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.WARNING, "Could not find the additional information file " + additionalInfoLoc, e);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not read the additional information file from " + additionalInfoLoc, e);
                    }
                }
            } else {
                List<String> LSPatches = this.getLSPatches();
                if (LSPatches != null) {
                    content.append("Patch information:\n");
                    if (LSPatches != null && !LSPatches.isEmpty()) {
                        for (String patch : LSPatches) {
                            if (patch == null || patch.isEmpty()) continue;
                            content.append(patch + "\n");
                        }
                    }
                }
            }
        }
        if (originalImageInfoToAppend != null) {
            content.append("\n--------------------\n\n");
            content.append(originalImageInfoToAppend);
        }
        try {
            imageInfoFile.mkdirs();
            ImageInfoUtil encoder = new ImageInfoUtil(tempLoc);
            succeeded = encoder.encode(content.toString());
        }
        catch (CheckedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        return succeeded;
    }

    private List<String> getLSPatches() {
        String opatchCmd = isWindows ? "opatch.bat" : "opatch";
        String oracleHome = System.getProperty("ORACLE_HOME");
        String oPatchCmdLocation = oracleHome + sep + oPatchesDirectory + sep + opatchCmd;
        int exitCode = -1;
        ArrayList<String> args = new ArrayList<String>();
        args.add(oPatchCmdLocation);
        args.add("lspatches");
        ProcessBuilder process = new ProcessBuilder(args);
        AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.info(line);
            }
        };
        AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.warning(line);
            }
        };
        ((AbstractLineProcessor)stdOutProcessor).getLines().clear();
        ((AbstractLineProcessor)stdErrProcessor).getLines().clear();
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(process, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
        try {
            exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to get the LS Patches", e.getMessage());
        }
        if (exitCode == 0) {
            List output = ((AbstractLineProcessor)stdOutProcessor).getLines();
            return output;
        }
        return null;
    }

    private boolean verifyGoldImageContents() {
        File goldImageFile = new File(this.destinationLocation + sep + this.goldImageName);
        if (goldImageFile.exists()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(goldImageFile);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not create zip file object from: " + goldImageFile.getAbsolutePath(), e);
            }
            if (zipFile != null) {
                HashSet<String> zipEntries = new HashSet<String>();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                if (entries != null) {
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (isWindows) {
                            name = name.replace('/', File.separatorChar);
                        }
                        if (entry.isDirectory()) {
                            zipEntries.add(name.substring(0, name.length() - 1));
                            continue;
                        }
                        zipEntries.add(name);
                    }
                } else {
                    logger.log(Level.WARNING, "Could not get the entries of zip file: " + goldImageFile.getAbsolutePath());
                }
                if (zipEntries != null && !zipEntries.isEmpty()) {
                    if (this.createdGoldImageContents != null && !this.createdGoldImageContents.isEmpty()) {
                        HashSet<String> filesNotAdded = new HashSet<String>();
                        for (File file : this.createdGoldImageContents) {
                            if (file == null) continue;
                            String pathStr = file.getAbsolutePath();
                            String relPathStr = pathStr.substring(this.sourceHome.length() + 1);
                            filesNotAdded.add(relPathStr);
                        }
                        filesNotAdded.removeAll(zipEntries);
                        if (!filesNotAdded.isEmpty()) {
                            logger.log(Level.WARNING, "Following files were not added to the goldimage:");
                            for (String fileNotAdded : filesNotAdded) {
                                logger.log(Level.WARNING, fileNotAdded);
                            }
                            return false;
                        }
                        logger.log(Level.INFO, "Successfully verified the contents of the created goldimage " + goldImageFile.getAbsolutePath());
                    } else {
                        logger.log(Level.INFO, "No content added to the goldimage.");
                    }
                } else {
                    logger.log(Level.INFO, "No content inside the created goldimage.");
                }
            }
        }
        return true;
    }

    private boolean addNewFilesListToGoldImage(List<File> files) {
        boolean succeeded = true;
        String tempLoc = System.getProperty("oracle.installer.tempLogDir");
        String tempHome = tempLoc + sep + "tempHome_" + System.currentTimeMillis();
        File tempHomeDir = new File(tempHome);
        tempHomeDir.mkdir();
        succeeded = this.createFilesLst(tempHomeDir, files);
        if (succeeded) {
            this.addAtomicDirToGoldImage(tempHomeDir, false, false, 0.0f);
        }
        FileSystem.delete((File)tempHomeDir);
        return succeeded;
    }

    private List<File> getSymlinksFromFilesList(List<File> filesList) {
        ArrayList<File> symlinks = new ArrayList<File>();
        if (filesList != null && !filesList.isEmpty()) {
            for (File file : filesList) {
                boolean isSymlink;
                if (file == null || !(isSymlink = Files.isSymbolicLink(file.toPath()))) continue;
                logger.log(Level.INFO, "Identified symlink: " + file.getAbsolutePath());
                symlinks.add(file);
            }
        }
        return symlinks;
    }

    private File createTemporaryHome(List<File> files, List<String> allExcludedFiles) {
        String tempLoc = System.getProperty("oracle.installer.tempLogDir");
        String tempHome = tempLoc + sep + "tempHome_" + System.currentTimeMillis();
        File tempHomeDir = new File(tempHome);
        tempHomeDir.mkdir();
        DriverHelper.addCleanupTask((Callable)new RemoveTemporaryHome(tempHomeDir));
        ArrayList<String> copyCompleteDirs = new ArrayList<String>();
        for (File file : files) {
            String relPath = file.getAbsolutePath().substring(this.sourceHome.length() + 1);
            String pathInTempDir = tempHome + sep + relPath;
            File fileInTempDir = new File(pathInTempDir);
            boolean isSubfileOfCopyCompleteDir = false;
            if (!copyCompleteDirs.isEmpty()) {
                for (String string : copyCompleteDirs) {
                    if (!relPath.startsWith(string + File.separator)) continue;
                    isSubfileOfCopyCompleteDir = true;
                    break;
                }
            }
            if (!PlatformInfo.getInstance().isWindows() && isSubfileOfCopyCompleteDir) continue;
            if (file.isDirectory()) {
                boolean isCopyCompleteDir = true;
                if (!PlatformInfo.getInstance().isWindows()) {
                    for (String excludedFile : allExcludedFiles) {
                        if (!excludedFile.startsWith(relPath + File.separator)) continue;
                        isCopyCompleteDir = false;
                        break;
                    }
                    if (isCopyCompleteDir) {
                        copyCompleteDirs.add(relPath);
                    }
                }
                if (!PlatformInfo.getInstance().isWindows() && isCopyCompleteDir) {
                    try {
                        Files.createSymbolicLink(fileInTempDir.toPath(), file.toPath(), new FileAttribute[0]);
                        continue;
                    }
                    catch (IOException iOException) {
                        logger.log(Level.WARNING, "Could not create symlink: " + fileInTempDir.getAbsolutePath(), iOException);
                        return null;
                    }
                }
                try {
                    Files.copy(file.toPath(), fileInTempDir.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Could not create directory: " + fileInTempDir.getAbsolutePath(), exception);
                    return null;
                }
            }
            if (PlatformInfo.getInstance().isWindows()) {
                try {
                    Files.copy(file.toPath(), fileInTempDir.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not create copy file: " + fileInTempDir.getAbsolutePath(), e);
                    return null;
                }
            }
            try {
                Files.createSymbolicLink(fileInTempDir.toPath(), file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not create symlink: " + fileInTempDir.getAbsolutePath(), e);
                return null;
            }
        }
        return tempHomeDir;
    }

    private boolean addAtomicDirToGoldImage(File file, boolean honorSymlinks, boolean processProgress, float progressPerFile) {
        boolean isTarFormat;
        boolean succeed = false;
        ArrayList<String> args = new ArrayList<String>();
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        boolean bl = isTarFormat = cmdLineArgumentHandler.isArgumentPassed("format") ? cmdLineArgumentHandler.getArgumentValue("format").equalsIgnoreCase("tar") : false;
        if (isTarFormat) {
            String tarLocation = null;
            if (cmdLineArgumentHandler.isArgumentPassed("tarLocation")) {
                tarLocation = cmdLineArgumentHandler.getArgumentValue("tarLocation");
            } else if (!isWindows) {
                tarLocation = "/bin/tar";
            }
            args.add(tarLocation);
            String tarArgs = "f";
            if (!honorSymlinks) {
                tarArgs = tarArgs + "h";
            }
            if (processProgress) {
                tarArgs = tarArgs + "v";
            }
            tarArgs = new File(this.destinationLocation + sep + this.goldImageName).exists() ? tarArgs + "r" : tarArgs + "c";
            args.add(tarArgs);
            args.add(this.destinationLocation + sep + this.goldImageName);
            if (file.isDirectory()) {
                String[] subFiles;
                for (String subFile : subFiles = file.list()) {
                    args.add(subFile);
                }
            } else {
                args.add(file.getName());
            }
        } else {
            args.add(System.getProperty("ORACLE_HOME") + sep + "bin" + sep + "zip");
            if (!processProgress) {
                args.add("-q");
            }
            args.add("-r");
            if (honorSymlinks && !PlatformInfo.getInstance().isWindows()) {
                args.add("-y");
            }
            if (new File(this.destinationLocation + sep + this.goldImageName).exists()) {
                args.add("-g");
            }
            args.add(this.destinationLocation + sep + this.goldImageName);
            if (file.isDirectory()) {
                args.add(".");
            } else {
                args.add(file.getName());
            }
        }
        String workingDir = null;
        workingDir = file.isDirectory() ? file.getAbsolutePath() : file.getParent();
        succeed = this.runCmd(args.toArray(new String[0]), workingDir, processProgress, progressPerFile);
        if (!succeed) {
            new File(this.destinationLocation + sep + this.goldImageName).delete();
        }
        return succeed;
    }

    private boolean createGoldImage(List<File> allFiles, float weight) {
        float weightRatio = 0.98f;
        float realFilesZipWeight = weight * weightRatio;
        float symlinksZipWeight = weight - realFilesZipWeight;
        List<File> symlinks = this.getSymlinksFromFilesList(allFiles);
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(allFiles);
        files.removeAll(symlinks);
        ArrayList<String> allExcludedFiles = new ArrayList<String>();
        allExcludedFiles.addAll(this.excludedFiles);
        if (this.removedSymlinksToDereference != null) {
            allExcludedFiles.addAll(this.removedSymlinksToDereference);
        }
        for (File symlink : symlinks) {
            allExcludedFiles.add(symlink.getAbsolutePath().substring(this.sourceHome.length() + 1));
        }
        File tempHome = this.createTemporaryHome(files, allExcludedFiles);
        if (tempHome == null) {
            return false;
        }
        float progressPerFile = realFilesZipWeight / (float)files.size();
        boolean processProgress = !Application.isCommandLineSwitchEnabled((String)"-silent");
        boolean succeed = this.addAtomicDirToGoldImage(tempHome, false, processProgress, progressPerFile);
        if (succeed) {
            CreateGoldImageJob.removeRecursively(tempHome);
            succeed = this.addToGoldImage(symlinks, this.sourceHome, -1.0f, 0.0f, true);
        }
        if (succeed) {
            this.setProgress(this.getProgress() + symlinksZipWeight);
        }
        return succeed;
    }

    protected static void removeRecursively(File file) {
        if (file != null) {
            File[] subFiles;
            if (file.isDirectory() && !Files.isSymbolicLink(file.toPath()) && (subFiles = file.listFiles()) != null && subFiles.length > 0) {
                for (File subFile : subFiles) {
                    CreateGoldImageJob.removeRecursively(subFile);
                }
            }
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not delete file: " + file.getAbsolutePath(), e);
            }
        }
    }

    private boolean createFilesLst(File tempHome, List<File> files) {
        boolean succeeded = true;
        File filesLst = new File(tempHome, fileslst);
        try {
            filesLst.getParentFile().mkdirs();
            filesLst.createNewFile();
            if (files != null && !files.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (File file : files) {
                    sb.append(file.getAbsolutePath().substring(this.sourceHome.length() + 1) + "\n");
                }
                if (!FileInfo.appendTextToFile(filesLst.getAbsolutePath(), sb.toString())) {
                    logger.warning("Could not write into the files list file.");
                    succeeded = false;
                }
                if (succeeded) {
                    boolean cmdLineExclFilesSpecified;
                    CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
                    boolean recreateFilesList = cmdLineArgumentHandler.isArgumentPassed("recreateFilesList");
                    boolean bl = cmdLineExclFilesSpecified = this.cmdLineExclFiles != null && !this.cmdLineExclFiles.isEmpty();
                    if (recreateFilesList || cmdLineExclFilesSpecified) {
                        succeeded = GoldImageUtil.markAsRecreated(filesLst.getAbsolutePath());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not create the files.lst file", e);
            succeeded = false;
        }
        return succeeded;
    }

    private HashMap<String, String> getSymlinkPhysicalMap() {
        HashMap<String, String> symlinkPhysicalMap = new HashMap<String, String>();
        if (this.symlinksToDereference != null && this.symlinksToDereference.length > 0) {
            for (String symlinkPair : this.symlinksToDereference) {
                String[] tokens;
                if (symlinkPair == null || (tokens = symlinkPair.split(comma)) == null || tokens.length != 2) continue;
                symlinkPhysicalMap.put(tokens[0], tokens[1]);
            }
        }
        return symlinkPhysicalMap;
    }

    private boolean addPhysicalFilesOfDereferencedSymlinks(HashMap<String, String> symlinkPhysicalMap) {
        boolean succeeded = true;
        if (symlinkPhysicalMap != null && symlinkPhysicalMap.size() > 0) {
            String tempLoc = System.getProperty("oracle.installer.tempLogDir");
            String tempHome = tempLoc + sep + "tempHome_" + System.currentTimeMillis();
            File tempHomeDir = new File(tempHome);
            tempHomeDir.mkdir();
            for (String symlink : symlinkPhysicalMap.keySet()) {
                String physical;
                File symlinkFile = new File(this.sourceHome, symlink);
                if (!symlinkFile.exists() || !Files.isSymbolicLink(symlinkFile.toPath()) || (physical = symlinkPhysicalMap.get(symlink)) == null) continue;
                File physicalFile = null;
                try {
                    physicalFile = new File(this.sourceHome, physical);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the physical file from: " + physical, e);
                }
                if (physicalFile == null || !physicalFile.exists()) continue;
                File symlinkParent = symlinkFile.getParentFile();
                String symlinkParentRelPath = symlinkParent.getAbsolutePath().substring(this.sourceHome.length() + 1);
                File relPathInTempHome = new File(tempHomeDir, symlinkParentRelPath);
                relPathInTempHome.mkdirs();
                File newSymlink = new File(relPathInTempHome, symlinkFile.getName());
                try {
                    Files.createSymbolicLink(newSymlink.toPath(), physicalFile.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not create symlink: " + newSymlink.getAbsolutePath(), e);
                    succeeded = false;
                    break;
                }
            }
            if (succeeded && tempHomeDir.listFiles() != null && tempHomeDir.listFiles().length > 0) {
                succeeded = this.addAtomicDirToGoldImage(tempHomeDir, false, false, 0.0f);
            }
            FileSystem.delete((File)tempHomeDir);
        }
        return succeeded;
    }

    private Set<File> removeSymlinksToDereference(HashMap<String, String> symlinkPhysicalMap, Set<File> allFiles) {
        HashSet<File> files = new HashSet<File>();
        files.addAll(allFiles);
        if (symlinkPhysicalMap != null && symlinkPhysicalMap.size() > 0) {
            for (String symlink : symlinkPhysicalMap.keySet()) {
                boolean isSymlink;
                if (symlink == null) continue;
                File file = null;
                try {
                    file = new File(this.sourceHome, symlink);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the symlink file from: " + symlink, e);
                }
                if (file == null || !file.exists() || !(isSymlink = Files.isSymbolicLink(file.toPath()))) continue;
                files.remove(file);
                if (this.removedSymlinksToDereference == null) {
                    this.removedSymlinksToDereference = new ArrayList<String>();
                }
                this.removedSymlinksToDereference.add(symlink);
            }
        }
        return files;
    }

    private List<File> sortFilesByPathName(Set<File> filesSet) {
        ArrayList<File> sortedFiles = new ArrayList<File>();
        sortedFiles.addAll(filesSet);
        Collections.sort(sortedFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String path1 = f1.getAbsolutePath();
                String path2 = f2.getAbsolutePath();
                int comparison = path1.compareToIgnoreCase(path2);
                return comparison;
            }
        });
        return sortedFiles;
    }

    private List<File> sortFilesByPathLength(Set<File> filesSet) {
        ArrayList<File> sortedFiles = new ArrayList<File>();
        sortedFiles.addAll(filesSet);
        Collections.sort(sortedFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int dist1 = f1.getAbsolutePath().length();
                int dist2 = f2.getAbsolutePath().length();
                return dist1 - dist2;
            }
        });
        return sortedFiles;
    }

    protected Set<File> getAllFilesRecursively(File file) {
        HashSet<File> files = new HashSet<File>();
        if (file != null) {
            files.add(file);
            if (file.isDirectory()) {
                File[] subFiles = null;
                try {
                    subFiles = file.listFiles();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get subfiles from: " + file.getPath(), e);
                }
                if (subFiles != null && subFiles.length > 0) {
                    for (File subFile : subFiles) {
                        files.addAll(this.getAllFilesRecursively(subFile));
                    }
                }
            }
        }
        return files;
    }

    private Set<File> removeExcludedFiles(Set<File> listOfFiles) {
        HashSet<File> files = new HashSet<File>();
        if (listOfFiles != null && !listOfFiles.isEmpty()) {
            files.addAll(listOfFiles);
            if (this.excludedFiles != null && !this.excludedFiles.isEmpty()) {
                for (String excludedFile : this.excludedFiles) {
                    File excluded = null;
                    try {
                        excluded = new File(this.sourceHome + sep + excludedFile);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Could not create file object from: " + excludedFile, e);
                    }
                    if (excluded == null || !excluded.exists()) continue;
                    files.remove(excluded);
                }
            }
        }
        files.remove(new File(this.sourceHome));
        return files;
    }

    private boolean addToGoldImage(List<File> sortedFiles, String workingDir, float currentProgress, float progressWeight, boolean honorSymlinks) {
        boolean succeed = true;
        if (workingDir.endsWith(File.separator)) {
            workingDir = workingDir.substring(0, workingDir.length() - 1);
        }
        if (sortedFiles != null && !sortedFiles.isEmpty()) {
            int buffer = 100;
            float progressIncrement = 0.0f;
            if (currentProgress != -1.0f) {
                progressIncrement = buffer >= sortedFiles.size() ? progressWeight : progressWeight / (float)(sortedFiles.size() / buffer);
            }
            for (int i = 0; i < sortedFiles.size(); i += buffer) {
                boolean isTarFormat;
                int batchSize = buffer;
                if (i + buffer > sortedFiles.size()) {
                    batchSize = sortedFiles.size() - i;
                }
                List<File> filesBatch = sortedFiles.subList(i, i + batchSize);
                ArrayList<String> args = new ArrayList<String>();
                CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
                boolean bl = isTarFormat = cmdLineArgumentHandler.isArgumentPassed("format") ? cmdLineArgumentHandler.getArgumentValue("format").equalsIgnoreCase("tar") : false;
                if (isTarFormat) {
                    String tarBinary = System.getProperty("TAR_LOCATION", "/bin/tar");
                    args.add(tarBinary);
                    String tarArgs = "f";
                    if (!honorSymlinks) {
                        tarArgs = tarArgs + "h";
                    }
                    tarArgs = new File(this.destinationLocation + sep + this.goldImageName).exists() ? tarArgs + "r" : tarArgs + "c";
                    args.add(tarArgs);
                    args.add(this.destinationLocation + sep + this.goldImageName);
                    for (File file : filesBatch) {
                        args.add(file.getAbsolutePath().substring(workingDir.length() + 1));
                    }
                } else {
                    args.add(System.getProperty("ORACLE_HOME") + sep + "bin" + sep + "zip");
                    args.add("-q");
                    if (honorSymlinks && !PlatformInfo.getInstance().isWindows()) {
                        args.add("-y");
                    }
                    if (new File(this.destinationLocation + sep + this.goldImageName).exists()) {
                        args.add("-g");
                    }
                    args.add(this.destinationLocation + sep + this.goldImageName);
                    for (File file : filesBatch) {
                        args.add(file.getAbsolutePath().substring(workingDir.length() + 1));
                    }
                }
                if (!(succeed = this.runCmd(args.toArray(new String[0]), workingDir, false, 0.0f))) {
                    new File(this.destinationLocation + sep + this.goldImageName).delete();
                    break;
                }
                if (currentProgress == -1.0f) continue;
                this.setProgress(this.getProgress() + progressIncrement);
            }
        }
        return succeed;
    }

    private boolean runCmd(String[] args, String currentWorkingDir, final boolean processProgress, final float progressByStdoutLine) {
        boolean succeed = true;
        AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                if (processProgress) {
                    CreateGoldImageJob.this.setProgress(CreateGoldImageJob.this.getProgress() + progressByStdoutLine);
                } else {
                    logger.info(line);
                }
            }
        };
        AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                logger.warning(line);
            }
        };
        ProcessBuilder pb = new ProcessBuilder(args);
        if (currentWorkingDir != null) {
            pb.directory(new File(currentWorkingDir));
        }
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
        int exitCode = 0;
        try {
            exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        }
        catch (Exception e) {
            succeed = false;
            logger.log(Level.INFO, "Gold image creation failed", e);
            logger.log(Level.INFO, e.getMessage());
        }
        if (exitCode != 0) {
            succeed = false;
        }
        return succeed;
    }

    protected List<String> getExcludedFiles(String sourceHome) {
        boolean recreateFilesListAction;
        String[] exclFiles;
        ArrayList<String> files = new ArrayList<String>();
        if (this.cmdLineExclFiles != null && !this.cmdLineExclFiles.isEmpty() && (exclFiles = this.cmdLineExclFiles.split(comma)) != null && exclFiles.length > 0) {
            for (String exclFile : exclFiles) {
                if (exclFile == null || !exclFile.startsWith(sourceHome)) continue;
                File excl = null;
                try {
                    excl = new File(exclFile);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get file object from: " + exclFile, e);
                }
                if (excl == null || !excl.exists()) continue;
                files.add(exclFile.substring(sourceHome.length() + 1));
                Set<File> subFiles = this.getAllFilesRecursively(excl);
                if (subFiles == null || subFiles.isEmpty()) continue;
                for (File subFile : subFiles) {
                    files.add(subFile.getAbsolutePath().substring(sourceHome.length() + 1));
                }
            }
        }
        List<String> nonReadableFiles = null;
        try {
            nonReadableFiles = FileInfo.getNonReadableFiles(new File(sourceHome));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not get the non readable files from the source home " + sourceHome, e);
        }
        if (nonReadableFiles != null && !nonReadableFiles.isEmpty()) {
            logger.warning("Following files are not readable: " + nonReadableFiles.toString());
            for (String file : nonReadableFiles) {
                files.add(file.substring(sourceHome.length() + 1));
            }
        }
        List<String> ouibakFiles = null;
        String extensionPattern = "ouibak.*";
        try {
            Pattern excludePattern = Pattern.compile(extensionPattern);
            ouibakFiles = FileInfo.getAllFilesRecursiveByExt(new File(sourceHome), excludePattern);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Could not get the ouibak files from the source home " + sourceHome, e);
        }
        if (ouibakFiles != null && !ouibakFiles.isEmpty()) {
            for (String file : ouibakFiles) {
                files.add(file.substring(sourceHome.length() + 1));
            }
        }
        if (recreateFilesListAction = this.isRecreateFilesList()) {
            files.add(fileslst);
        }
        return files;
    }

    private boolean isRecreateFilesList() {
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        boolean recreateFilesList = cmdLineArgumentHandler.isArgumentPassed("recreateFilesList");
        boolean recreateFilesListInternal = cmdLineArgumentHandler.isArgumentPassed("recreateFilesListInternal");
        boolean cmdLineExclFilesSpecified = this.cmdLineExclFiles != null && !this.cmdLineExclFiles.isEmpty();
        boolean recreateFilesListAction = recreateFilesList || recreateFilesListInternal || cmdLineExclFilesSpecified;
        return recreateFilesListAction;
    }

    protected List<String> getFilesMatchingRegexLine(String line, String topDir) {
        ArrayList<String> files;
        block18: {
            block19: {
                files = new ArrayList<String>();
                if (line == null) break block18;
                if (PlatformInfo.getInstance().isWindows()) {
                    line = line.replace('/', '\\');
                }
                if (!line.contains("*")) break block19;
                if (line.indexOf(42) != line.lastIndexOf(42)) break block18;
                String wildcard = "*";
                if (line.contains(".*")) {
                    wildcard = ".*";
                }
                String firstHalf = line.substring(0, line.indexOf(wildcard));
                String secondHalf = null;
                if (line.length() > firstHalf.length() + wildcard.length()) {
                    secondHalf = line.substring(line.indexOf(wildcard) + wildcard.length(), line.length());
                }
                String lastDirPath = firstHalf.substring(0, firstHalf.lastIndexOf(sep) + 1);
                File lastDir = null;
                try {
                    lastDir = new File(topDir + sep + lastDirPath);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not create file object from: " + topDir + sep + lastDirPath, e);
                }
                if (lastDir != null && lastDir.exists()) {
                    String fileNamePrefix = "";
                    if (firstHalf.length() > lastDirPath.length()) {
                        fileNamePrefix = firstHalf.substring(lastDirPath.length());
                    }
                    String fileNameSuffix = "";
                    if (secondHalf != null) {
                        fileNameSuffix = secondHalf;
                    }
                    File[] subFiles = null;
                    try {
                        final String namePrefix = fileNamePrefix;
                        final String nameSuffix = fileNameSuffix;
                        subFiles = lastDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String name) {
                                return name.startsWith(namePrefix) && name.endsWith(nameSuffix);
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Could not expand the files from: " + line, e);
                    }
                    if (subFiles != null && subFiles.length > 0) {
                        for (File subFile : subFiles) {
                            Set<File> innerFiles;
                            files.add(subFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                            if (!subFile.isDirectory() || (innerFiles = this.getAllFilesRecursively(subFile)) == null || innerFiles.isEmpty()) continue;
                            for (File innerFile : innerFiles) {
                                files.add(innerFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                            }
                        }
                    }
                }
                break block18;
            }
            File lineFile = null;
            try {
                lineFile = new File(topDir + sep + line);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not create file object from: " + topDir + sep + line, e);
            }
            if (lineFile != null && lineFile.exists()) {
                Set<File> innerFiles;
                files.add(lineFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                if (lineFile.isDirectory() && (innerFiles = this.getAllFilesRecursively(lineFile)) != null && !innerFiles.isEmpty()) {
                    for (File innerFile : innerFiles) {
                        files.add(innerFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                    }
                }
            }
        }
        return files;
    }

    protected List<String> getExistentFilesFromRegexListFile(String topDir, String regexListFile) {
        ArrayList<String> files = new ArrayList<String>();
        if (regexListFile != null) {
            File file = null;
            try {
                file = new File(topDir + sep + regexListFile);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not create file object from: " + regexListFile, e);
            }
            if (file != null) {
                if (file.exists()) {
                    ArrayList<String> regexLines = FileInfo.getFileContentLines(regexListFile);
                    if (regexLines != null && !regexLines.isEmpty()) {
                        for (String line : regexLines) {
                            files.addAll(this.getFilesMatchingRegexLine(line, topDir));
                        }
                    }
                } else {
                    logger.log(Level.INFO, "File " + regexListFile + "does not exist.");
                }
            }
        }
        return files;
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add((Job)this);
            }
        }
        return retriableJobs;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public Callable<?> getWork() {
        return this;
    }

    protected void log(Level level, String message, Object ... args) {
        if (this.progressUI != null) {
            this.progressUI.log(level, message, args);
        } else {
            logger.log(level, message, args);
        }
    }
}

