/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OFAWrapper {
    private static OFAWrapper instance = null;
    private static final Logger logger = Logger.getLogger(OFAWrapper.class.getName());
    public static Properties props = Application.getInstance() instanceof Installer ? ((Installer)Application.getInstance()).getFlowDataDefaults() : null;
    public static final String TEMP_OB = "temp_ob";
    private static String errorHint = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)"INSTALL_COMMON_HINT_DATABASE_LOCATION_ERROR"), new Object[0]);
    public static final int S_ORACLE_HOME = 0;
    public static final int S_APPLTOP = 1;
    public static final int S_VIRTUAL_HOME = 2;
    public static final int S_ORCA_HOME = 3;

    protected OFAWrapper() {
    }

    public static OFAWrapper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (OFAWrapper)(proxyFactory = ProxyFactory.getInstance()).createProxy(OFAWrapper.class)) == null) {
            instance = new OFAWrapper();
        }
        return instance;
    }

    public String[] getOracleBases() throws InstallException {
        OiiiInstallInventory installInventory;
        String[] oracleBases = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null && (installInventory = installAreaControl.getInstallInventory()) != null) {
            TreeSet<String> oracleBasesSet = new TreeSet<String>();
            Vector v = installInventory.getHomes(0);
            if (v != null) {
                for (OiiiOracleHomeInfo homeInfo : v) {
                    String oracleBase;
                    if (homeInfo == null || (oracleBase = homeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE")) == null || oracleBase.equals("")) continue;
                    oracleBasesSet.add(oracleBase);
                }
            }
            if (oracleBasesSet.size() > 0) {
                oracleBases = new String[oracleBasesSet.size()];
                oracleBasesSet.toArray(oracleBases);
            }
        }
        if (oracleBases == null) {
            return new String[]{this.getDefaultOracleBaseLocation()};
        }
        return oracleBases;
    }

    public boolean isPreset(String presetVar) {
        presetVar = presetVar.toLowerCase();
        boolean ret = props != null && props.containsKey(presetVar);
        return ret;
    }

    public String getDefaultOracleBaseLocation() {
        String obEnvPath;
        String key = "ORACLE_BASE";
        if (this.isPreset(key) && (obEnvPath = props.getProperty(key)) != null) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String envBaseName = PlatformInfo.getInstance().getEnv(key);
        if (envBaseName != null && envBaseName.trim().length() > 1) {
            return envBaseName;
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        switch (curPlatGroup) {
            case -3: {
                break;
            }
            case -1: {
                for (int i = 1; i <= 9; ++i) {
                    String path = "/u0" + i;
                    if (!new File(path).exists()) continue;
                    return path + File.separator + "app" + File.separator + OiixEnvironmentOps.ssgetUidNameux();
                }
                break;
            }
        }
        String defHomeDrive = System.getProperty("user.home", "");
        String defBaseLoc = "app" + File.separator + System.getProperty("user.name", "");
        switch (curPlatGroup) {
            case -3: {
                defHomeDrive = new OiipgFileSystem().getMaxFreeVolume();
                if (defHomeDrive == null) {
                    defHomeDrive = "c:";
                }
                defHomeDrive = defHomeDrive.replace('\\', '/');
                defBaseLoc = defBaseLoc.replace('\\', '/');
                break;
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        defBaseLoc = OiixPathOps.getStandardForm((String)defBaseLoc);
        defBaseLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)defBaseLoc);
        defBaseLoc = OiixPathOps.getNativeForm((String)defBaseLoc);
        return defBaseLoc;
    }

    public String getDefaultOracleBaseLocation(String s_userName) {
        String obEnvPath;
        String key = "ORACLE_BASE";
        if (this.isPreset(key) && (obEnvPath = props.getProperty(key)) != null) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String envBaseName = PlatformInfo.getInstance().getEnv(key);
        if (envBaseName != null && envBaseName.trim().length() > 1) {
            return envBaseName;
        }
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        switch (curPlatGroup) {
            case -3: {
                break;
            }
            case -1: {
                for (int i = 1; i <= 9; ++i) {
                    String path = "/u0" + i;
                    if (!new File(path).exists()) continue;
                    return path + File.separator + "app" + File.separator + s_userName;
                }
                break;
            }
        }
        String defHomeDrive = System.getProperty("user.home", "");
        String defBaseLoc = "app" + File.separator + s_userName;
        switch (curPlatGroup) {
            case -3: {
                defHomeDrive = new OiipgFileSystem().getMaxFreeVolume();
                if (defHomeDrive == null) {
                    defHomeDrive = "c:";
                }
                defHomeDrive = defHomeDrive.replace('\\', '/');
                defBaseLoc = defBaseLoc.replace('\\', '/');
                break;
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        defBaseLoc = OiixPathOps.getStandardForm((String)defBaseLoc);
        defBaseLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)defBaseLoc);
        defBaseLoc = OiixPathOps.getNativeForm((String)defBaseLoc);
        return defBaseLoc;
    }

    public String getDBHomeLoc(String oracleBase) {
        String obEnvPath;
        String key = "ORACLE_HOME";
        boolean valuePreset = this.isPreset(key);
        if (valuePreset && (obEnvPath = props.getProperty(key)) != null && obEnvPath.length() > 0) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String dbHomeLoc = null;
        String defLocation = OiixOraparam.getOraparamProfileString((String)"DEFAULT_HOME_LOCATION", null);
        if (defLocation == null || defLocation.trim().length() == 0) {
            defLocation = "/OraHome";
        }
        String defHomeDrive = System.getProperty("user.home", "");
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        if (oracleBase != null && oracleBase.trim().length() > 0) {
            defHomeDrive = oracleBase;
        } else {
            switch (curPlatGroup) {
                case -3: {
                    defHomeDrive = "c:";
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    defLocation = defLocation.replace('\\', '/');
                    break;
                }
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        defLocation = OiixPathOps.getStandardForm((String)defLocation);
        dbHomeLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)defLocation);
        dbHomeLoc = OiixPathOps.getNativeForm((String)dbHomeLoc);
        dbHomeLoc = dbHomeLoc + "_" + this.getNewHomeLocIndex(dbHomeLoc);
        File file = new File(dbHomeLoc);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return dbHomeLoc;
    }

    public String getDefaultOraDataLocation(String oracleBase) throws InstallException {
        String defHomeDrive = System.getProperty("user.home", "");
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        if (oracleBase != null && oracleBase.trim().length() > 0) {
            defHomeDrive = oracleBase;
        } else {
            switch (curPlatGroup) {
                case -3: {
                    try {
                        defHomeDrive = OiipwWin32NativeCalls.GetProgramFilesDir();
                        if (!defHomeDrive.endsWith("\\")) {
                            defHomeDrive = defHomeDrive + "\\";
                        }
                        defHomeDrive = defHomeDrive + "Oracle\\";
                    }
                    catch (Exception e) {
                        throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TOGET_DEFAULT_ORADATA_LOCATION, new Object[0]);
                    }
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    break;
                }
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        String oradataLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)"oradata");
        oradataLoc = OiixPathOps.getNativeForm((String)oradataLoc);
        return oradataLoc;
    }

    public String getDefaultHALocation(String oracleBase) {
        String defHomeDrive = System.getProperty("user.home", "");
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        if (oracleBase != null && oracleBase.trim().length() > 0) {
            defHomeDrive = oracleBase;
        } else {
            switch (curPlatGroup) {
                case -3: {
                    defHomeDrive = "c:";
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    break;
                }
            }
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        String defHAHome = OiixPathOps.concatPath((String)defHomeDrive, (String)"grid");
        defHAHome = OiixPathOps.getNativeForm((String)defHAHome);
        return defHAHome;
    }

    public String[] getAllOracleHomeLocs() throws InstallException {
        String[] ohLocations = null;
        try {
            if (PlatformInfo.getInstance().isWindows()) {
                Set homeLoc = OiipgOracleHomes.getAllWindowsOracleHomes();
                ohLocations = homeLoc.toArray(new String[homeLoc.size()]);
            } else {
                ohLocations = OiipgOracleHomes.getAllOracleHomes();
            }
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_GET_ALL_ORACLE_HOME_LOCS_ERROR, new Object[0]);
        }
        return ohLocations;
    }

    public String getCRSHomeLocation(String sOracleBase) {
        String obEnvPath;
        String key = "ORACLE_HOME";
        boolean valuePreset = this.isPreset(key);
        if (valuePreset && (obEnvPath = props.getProperty(key)) != null && obEnvPath.length() > 0) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String defHomeLoc = null;
        String defLocation = OiixOraparam.getOraparamProfileString((String)"DEFAULT_HOME_LOCATION", null);
        if (defLocation == null || defLocation.trim().length() == 0) {
            defLocation = "/OraHome";
        }
        String defHomeDrive = System.getProperty("user.home", "");
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        if (sOracleBase != null && sOracleBase.trim().length() > 0) {
            File file = new File(defHomeDrive);
            if (!defHomeDrive.endsWith("/")) {
                defHomeDrive = file.getAbsolutePath() + File.separatorChar;
            }
            if (file == null || !sOracleBase.startsWith(defHomeDrive)) {
                defHomeDrive = sOracleBase;
            }
        } else {
            switch (curPlatGroup) {
                case -3: {
                    defHomeDrive = new OiipgFileSystem().getMaxFreeVolume();
                    if (defHomeDrive == null) {
                        defHomeDrive = "c:";
                    }
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    defLocation = defLocation.replace('\\', '/');
                    break;
                }
            }
        }
        while (defHomeDrive.endsWith("/")) {
            defHomeDrive = defHomeDrive.substring(0, defHomeDrive.length() - 1);
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        defLocation = OiixPathOps.getStandardForm((String)defLocation);
        defHomeLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)defLocation);
        defHomeLoc = OiixPathOps.getNativeForm((String)defHomeLoc);
        File loc = new File(defHomeLoc);
        try {
            if (new File(loc.getCanonicalPath()).exists()) {
                defHomeLoc = defHomeLoc + "_" + this.getNewHomeLocIndex(loc.getCanonicalPath());
                loc = new File(defHomeLoc);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (loc != null) {
            try {
                return loc.getCanonicalPath();
            }
            catch (IOException exception) {
                return loc.getAbsolutePath();
            }
        }
        return defHomeLoc;
    }

    public boolean isHomeWithLocationExist(String homeLoc) {
        return InventoryInfo.getInstance().isHomeWithLocationExist(homeLoc);
    }

    public String getBaseForLocation(String oraHomeLoc) {
        OiiiInstallInventory inventory;
        String base = null;
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        if (invAreaControl != null && (inventory = invAreaControl.getInstallInventory()) != null && inventory.getHomeWithLocation(oraHomeLoc) != null) {
            base = inventory.getHomeWithLocation(oraHomeLoc).getAdditionalOracleHomeProperty("ORACLE_BASE");
        }
        return base;
    }

    public List<String> getOracleHomesUnderGivenBase(String oraBase) {
        ArrayList<String> homesUnderCurrentBase = new ArrayList<String>();
        if (PlatformInfo.getInstance().isWindows()) {
            Set homeLoc = OiipgOracleHomes.getAllWindowsOracleHomes();
            for (String orahome : homeLoc) {
                if (orahome == null || !orahome.toUpperCase().startsWith(oraBase.toUpperCase())) continue;
                homesUnderCurrentBase.add(orahome);
            }
            logger.log(Level.INFO, "Oracle homes under current base" + homesUnderCurrentBase);
        }
        return homesUnderCurrentBase;
    }

    public String getHAHomeLocation(String sOracleBase) {
        String obEnvPath;
        String key = "ORACLE_HOME";
        boolean valuePreset = this.isPreset(key);
        if (valuePreset && (obEnvPath = props.getProperty(key)) != null && obEnvPath.length() > 0) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String location = OiixOraparam.getOraparamProfileString((String)"DEFAULT_HOME_LOCATION", null);
        if (location == null || location.trim().length() == 0) {
            location = "/OraHome";
        }
        location = location.replaceFirst("..", "product");
        String defHomeDrive = System.getProperty("user.home", "");
        String defHomeLoc = location;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
        if (sOracleBase != null && sOracleBase.trim().length() > 0) {
            File file = new File(sOracleBase);
            defHomeDrive = file != null ? file.getAbsolutePath() : sOracleBase;
        } else {
            switch (curPlatGroup) {
                case -3: {
                    defHomeDrive = new OiipgFileSystem().getMaxFreeVolume();
                    if (defHomeDrive == null) {
                        defHomeDrive = "c:";
                    }
                    defHomeDrive = defHomeDrive.replace('\\', '/');
                    defHomeLoc = defHomeLoc.replace('\\', '/');
                    break;
                }
            }
        }
        while (defHomeDrive.endsWith("/")) {
            defHomeDrive = defHomeDrive.substring(0, defHomeDrive.length() - 1);
        }
        defHomeDrive = OiixPathOps.getStandardForm((String)defHomeDrive);
        defHomeLoc = OiixPathOps.getStandardForm((String)defHomeLoc);
        defHomeLoc = OiixPathOps.concatPath((String)defHomeDrive, (String)defHomeLoc);
        defHomeLoc = OiixPathOps.getNativeForm((String)defHomeLoc);
        File loc = new File(defHomeLoc);
        try {
            if (new File(loc.getCanonicalPath()).exists()) {
                defHomeLoc = defHomeLoc + "_" + this.getNewHomeLocIndex(loc.getCanonicalPath());
                loc = new File(defHomeLoc);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (loc != null) {
            return loc.getAbsolutePath();
        }
        return defHomeLoc;
    }

    private int getNewHomeLocIndex(String sNewHome) {
        int idx = 1;
        boolean bPathExists = true;
        while (bPathExists) {
            String sPath = sNewHome + "_" + idx;
            bPathExists = new File(sPath).exists();
            if (!bPathExists) continue;
            ++idx;
        }
        return idx;
    }

    public String getOracleHomeFromEnv() {
        String obEnvPath;
        String key = "ORACLE_HOME";
        boolean valuePreset = this.isPreset(key);
        if (valuePreset && (obEnvPath = props.getProperty(key)) != null && obEnvPath.length() > 0) {
            obEnvPath = obEnvPath.endsWith(File.separator) ? obEnvPath.substring(0, obEnvPath.length() - 1) : obEnvPath;
            return obEnvPath;
        }
        String envHomeName = PlatformInfo.getInstance().getEnv(key);
        if (envHomeName != null && envHomeName.length() > 1) {
            return envHomeName;
        }
        return null;
    }

    public String[] getExistingOracleBases() throws InstallException {
        OiiiInstallInventory installInventory;
        String[] oracleBases = null;
        OiiiInstallAreaControl installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        if (installAreaControl != null && (installInventory = installAreaControl.getInstallInventory()) != null) {
            TreeSet<String> oracleBasesSet = new TreeSet<String>();
            Vector v = installInventory.getHomes(0);
            if (v != null) {
                for (OiiiOracleHomeInfo homeInfo : v) {
                    String oracleBase;
                    if (homeInfo == null || (oracleBase = homeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE")) == null || oracleBase.equals("")) continue;
                    oracleBasesSet.add(oracleBase);
                }
            }
            if (oracleBasesSet.size() > 0) {
                oracleBases = new String[oracleBasesSet.size()];
                oracleBasesSet.toArray(oracleBases);
            }
        }
        return oracleBases;
    }

    public boolean isExistingBase(String sOracleBase) throws InstallException {
        String[] oraBases = this.getExistingOracleBases();
        boolean isExistingBase = false;
        if (oraBases != null && oraBases.length > 0) {
            for (String oraBaseLoc : oraBases) {
                if (!oraBaseLoc.equalsIgnoreCase(sOracleBase)) continue;
                return true;
            }
        }
        return false;
    }

    public String getTempOracleBaseLocation() {
        String logsDir = null;
        String tempOB = null;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        logsDir = invInfo.isInventoryExist() ? invInfo.getDefaultInventoryLoc() + File.separator + "logs" + File.separator + "GridSetupActions" + FunctionsUtil.getTimeStamp() : System.getProperty("oracle.installer.tempLogDir");
        if (logsDir != null) {
            tempOB = logsDir + File.separator + TEMP_OB;
        }
        return tempOB;
    }
}

