/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.PermissionType;
import oracle.cluster.winsecurity.ServiceUserTypes;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WinSecurityUtil;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.cluster.winsecurity.WindowsStorageType;
import oracle.install.commons.util.Version;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;

public class WinHelper {
    public static final Logger logger = Logger.getLogger(WinHelper.class.getName());
    static User user = null;

    public static boolean checkAclsForUser(String userName, WindowsStorageType windowsStorageType, String path, PermissionType permissionType) {
        oracle.ops.mgmt.cluster.Version m_version = new oracle.ops.mgmt.cluster.Version();
        UserPrivilege m_userPriv = null;
        Credentials credentials = null;
        WinSecurityFactory winSecurityFactory = null;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String srvmLibLoc = startupLocation + "/../stage/cvu/bin";
        try {
            credentials = new Credentials(userName);
            winSecurityFactory = WinSecurityFactory.getInstance((String)srvmLibLoc, null);
            m_userPriv = winSecurityFactory.getUserPrivilege(credentials, null);
            boolean ret = m_userPriv.checkAclsForUser(windowsStorageType, path, permissionType, true);
            return ret;
        }
        catch (WindowsSecurityException wse) {
            wse.printStackTrace();
            return false;
        }
    }

    public static boolean UserExists(String userName, String password) {
        boolean m_userExists = false;
        user = WinHelper.getUser(userName, password);
        try {
            if (user.isExists()) {
                m_userExists = true;
            }
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return m_userExists;
    }

    public static boolean isValidPassword(String userName, String password) {
        boolean b_validPassword = false;
        user = WinHelper.getUser(userName, password);
        try {
            if (user.isValidPassword()) {
                b_validPassword = true;
            }
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return b_validPassword;
    }

    public static boolean isMemberOf(String userName, String groupName, boolean recurse) {
        Group m_group = WinHelper.getGroup(groupName);
        boolean ret = false;
        try {
            if (m_group.isMemberOf(userName, recurse)) {
                ret = true;
            }
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return ret;
    }

    public static boolean isValidUser(String userName, String password) {
        boolean valid = false;
        user = WinHelper.getUser(userName, password);
        try {
            valid = user.isValidUser();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return valid;
    }

    public static boolean isAdministrator(String userName, String password) {
        boolean valid = false;
        user = WinHelper.getUser(userName, password);
        try {
            valid = user.isAdministrator();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return valid;
    }

    public static boolean isGMSAUser(String userName) {
        boolean valid = false;
        user = WinHelper.getUser(userName, null);
        try {
            valid = user.isGroupMSA();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return valid;
    }

    public static boolean isGMSAUser(String localNodeName, String[] nodeList) {
        boolean valid = false;
        try {
            Map map = user.isGroupMSA(localNodeName, nodeList);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Boolean value = (Boolean)entry.getValue();
                logger.log(Level.FINEST, "Key ::" + key + "  Value::" + value);
            }
            valid = !user.isGroupMSA(localNodeName, nodeList).containsValue(false);
        }
        catch (WindowsSecurityException windowsSecurityException) {
        }
        catch (CompositeOperationException compositeOperationException) {
            // empty catch block
        }
        return valid;
    }

    public static boolean isMSAUser(String userName, String password) {
        boolean valid = false;
        user = WinHelper.getUser(userName, password);
        try {
            valid = user.isUserMSA();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return valid;
    }

    public static boolean isDomainUser(String userName, String password) {
        boolean valid = false;
        user = WinHelper.getUser(userName, password);
        try {
            valid = user.isUserDomainUser();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        return valid;
    }

    public static String getOracleHomeUser(String oracleHome) {
        WinSecurityFactory winSecurityFactory = null;
        Home home = null;
        Credentials credentials = null;
        String serviceUserName = null;
        try {
            winSecurityFactory = WinSecurityFactory.getInstance((String)oracleHome, null);
            home = winSecurityFactory.getHome(oracleHome, new oracle.ops.mgmt.cluster.Version());
            credentials = home.getServiceUserFromHomePath();
            serviceUserName = credentials.getUsername();
        }
        catch (WindowsSecurityException we) {
            we.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceUserName;
    }

    public static User getUser(String userName, String password) {
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        Credentials credentials = null;
        WinSecurityFactory winSecurityFactory = null;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String srvmLibLoc = startupLocation + "/../stage/cvu/bin";
        try {
            credentials = password != null ? new Credentials(userName, password) : new Credentials(userName);
            winSecurityFactory = WinSecurityFactory.getInstance((String)srvmLibLoc, null);
            user = winSecurityFactory.getUser(credentials, version);
        }
        catch (WindowsSecurityException windowsSecurityException) {
            // empty catch block
        }
        return user;
    }

    public static Group getGroup(String groupName) {
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        Group m_group = null;
        WinSecurityFactory winSecurityFactory = null;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String srvmLibLoc = startupLocation + "/../stage/cvu/bin";
        try {
            winSecurityFactory = WinSecurityFactory.getInstance((String)srvmLibLoc, null);
            m_group = winSecurityFactory.getGroup(groupName, version);
        }
        catch (WindowsSecurityException windowsSecurityException) {
            // empty catch block
        }
        return m_group;
    }

    public static void removeMemberFromGroup(String member, String parentGroupName) {
        try {
            Group m_group = WinHelper.getGroup(parentGroupName);
            boolean b_isMember = WinHelper.isMemberOf(member, parentGroupName, false);
            if (b_isMember) {
                m_group.removeMember(member);
            }
        }
        catch (WindowsSecurityException windowsSecurityException) {
            // empty catch block
        }
    }

    public static void removeMemberFromGroup(String member, String parentGroupName, String localNodeName, String[] nodeNames) {
        try {
            Group m_group = WinHelper.getGroup(parentGroupName);
            m_group.removeMember(member, localNodeName, nodeNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean groupExists(String groupName) {
        try {
            Group m_group = WinHelper.getGroup(groupName);
            return m_group.isExists();
        }
        catch (WindowsSecurityException windowsSecurityException) {
            return false;
        }
    }

    public static void deleteGroup(String groupName) {
        try {
            Group m_group = WinHelper.getGroup(groupName);
            if (WinHelper.groupExists(groupName)) {
                m_group.delete();
            }
        }
        catch (WindowsSecurityException windowsSecurityException) {
            // empty catch block
        }
    }

    public static void deleteGroup(String groupName, String localNodeName, String[] nodeNames) {
        try {
            Group m_group = WinHelper.getGroup(groupName);
            m_group.delete(localNodeName, nodeNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getServiceUsersForBase(String OracleBase) {
        ArrayList<String> serviceUserList = new ArrayList<String>();
        try {
            String[] oraHomeLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
            String[] oraBases = OFAWrapper.getInstance().getOracleBases();
            if (oraHomeLocs != null && oraHomeLocs.length > 0) {
                for (String oraHomeLoc : oraHomeLocs) {
                    String relevantBase = OFAWrapper.getInstance().getBaseForLocation(oraHomeLoc);
                    if (relevantBase == null || relevantBase.trim().length() <= 0 || !relevantBase.equalsIgnoreCase(OracleBase)) continue;
                    String topLevelComponent = InventoryInfo.getInstance().getToplevelComponentName(oraHomeLoc);
                    Version topLevelCompVersion = InventoryInfo.getInstance().getTopLevelCompVersion(oraHomeLoc, topLevelComponent);
                    if (topLevelCompVersion != null && topLevelCompVersion.compareTo(InstallConstants.VERSION_12_1) >= 0) {
                        String oracleHomeUser = WinHelper.getOracleHomeUser(oraHomeLoc);
                        if (oracleHomeUser != null && oracleHomeUser.trim().length() > 0) {
                            serviceUserList.add(oracleHomeUser);
                            continue;
                        }
                        serviceUserList.add(Credentials.BuiltinUser.LOCALSYSTEM.toString());
                        continue;
                    }
                    serviceUserList.add(Credentials.BuiltinUser.LOCALSYSTEM.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceUserList;
    }

    public static boolean userOwnsMultipleHomes(String userName) {
        boolean ret = false;
        List<String> ohList = WinHelper.getOracleHomesOwnedByServiceUser(userName);
        if (ohList != null && ohList.size() > 1) {
            return true;
        }
        return ret;
    }

    public static boolean userOwnsSpecifiedBase(String userName, String oracleBase, boolean inPlaceUpgrade) {
        return WinHelper.userOwnsSpecifiedBase(userName, oracleBase, inPlaceUpgrade, false);
    }

    public static boolean userOwnsSpecifiedBase(String userName, String oracleBase, boolean inPlaceUpgrade, boolean isVirtualUser) {
        boolean ret = true;
        boolean b_existingOwnerLocalService = false;
        boolean b_existingOwnerLocalSystem = false;
        boolean b_existingOwnerWindowsAcccount = false;
        boolean isExistingOwnerVirtualAccount = false;
        boolean b_currentUserLocalService = false;
        boolean b_currentUserLocalSystem = false;
        boolean b_currentUserWindowsAcccount = false;
        String s_existingOwnerUserName = null;
        try {
            if (!OFAWrapper.getInstance().isExistingBase(oracleBase)) {
                return true;
            }
            List<String> ohUsers = WinHelper.getServiceUsersForBase(oracleBase);
            if (ohUsers != null) {
                for (int i = 0; i < ohUsers.size(); ++i) {
                    Credentials credentialsLocalSystem = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                    Credentials credentialsLocalService = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
                    if (ohUsers.get(i).toString().equalsIgnoreCase(credentialsLocalSystem.getUsername().toString())) {
                        b_existingOwnerLocalSystem = true;
                        continue;
                    }
                    if (ohUsers.get(i).toString().equalsIgnoreCase(credentialsLocalService.getUsername().toString())) {
                        b_existingOwnerLocalService = true;
                        continue;
                    }
                    if (WinHelper.isVirtualUser(ohUsers.get(i).toString())) {
                        isExistingOwnerVirtualAccount = true;
                        continue;
                    }
                    b_existingOwnerWindowsAcccount = true;
                    s_existingOwnerUserName = ohUsers.get(i).toString();
                }
            }
            if (!isVirtualUser && userName != null) {
                if (userName.equalsIgnoreCase(Credentials.BuiltinUser.LOCALSYSTEM.toString())) {
                    b_currentUserLocalSystem = true;
                } else if (userName.equalsIgnoreCase(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                    b_currentUserLocalService = true;
                } else {
                    b_currentUserWindowsAcccount = true;
                }
            }
            if (inPlaceUpgrade && b_existingOwnerLocalSystem && b_currentUserLocalService) {
                return true;
            }
            if (b_existingOwnerLocalService && b_currentUserLocalService) {
                return true;
            }
            if (b_existingOwnerLocalService && !b_currentUserLocalService) {
                return false;
            }
            if (b_existingOwnerWindowsAcccount && b_currentUserLocalService) {
                return false;
            }
            if (b_existingOwnerLocalSystem && b_currentUserLocalService) {
                return false;
            }
            if (isExistingOwnerVirtualAccount && isVirtualUser) {
                return true;
            }
            if (isExistingOwnerVirtualAccount && b_currentUserLocalSystem) {
                return true;
            }
            if (b_existingOwnerLocalSystem && isVirtualUser) {
                ret = true;
            }
            if (b_existingOwnerWindowsAcccount && isVirtualUser) {
                return false;
            }
            if (isExistingOwnerVirtualAccount && b_currentUserWindowsAcccount) {
                return false;
            }
            if (isExistingOwnerVirtualAccount && b_currentUserLocalService) {
                return false;
            }
            if (b_currentUserLocalSystem && !b_existingOwnerLocalService) {
                return true;
            }
            if (s_existingOwnerUserName != null) {
                return s_existingOwnerUserName.equalsIgnoreCase(userName);
            }
            if (b_existingOwnerLocalSystem) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isVirtualAccountUserTypeSupportedOnCurrentOS() {
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        WinSecurityUtil winSecurityUtil = null;
        WinSecurityFactory winSecurityFactory = null;
        boolean retVal = false;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String srvmLibLoc = startupLocation + "/../stage/cvu/bin";
        try {
            winSecurityFactory = WinSecurityFactory.getInstance((String)srvmLibLoc, null);
            winSecurityUtil = winSecurityFactory.getWinSecurityUtil(version);
            retVal = winSecurityUtil.isUserTypeSupported(ServiceUserTypes.VIRTUALACCOUNT);
            logger.log(Level.INFO, "isVirtualAccountUserTypeSupportedOnCurrentOS::" + retVal);
        }
        catch (WindowsSecurityException wse) {
            wse.printStackTrace();
        }
        return retVal;
    }

    public static boolean isDomainController() {
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        WinSecurityUtil winSecurityUtil = null;
        WinSecurityFactory winSecurityFactory = null;
        boolean isDomainController = false;
        String startuplocation = System.getProperty("oracle.installer.startup_location");
        String srvmLibLoc = startuplocation + "/../stage/cvu/bin";
        try {
            winSecurityFactory = WinSecurityFactory.getInstance((String)srvmLibLoc, null);
            winSecurityUtil = winSecurityFactory.getWinSecurityUtil(version);
            isDomainController = winSecurityUtil.isDomainController();
        }
        catch (WindowsSecurityException wse) {
            wse.printStackTrace();
        }
        return isDomainController;
    }

    public static String getVirtualHomeUserName(String oracleHome, String oracleHomeName) {
        String virtualUserName = null;
        try {
            Credentials credentials = new Credentials(Credentials.BuiltinUser.VIRTUALACCOUNT, oracleHomeName);
            virtualUserName = credentials.getUsername();
            logger.log(Level.INFO, "Oracle Home Name::" + oracleHomeName);
            logger.log(Level.INFO, "Virtual User Name::" + virtualUserName);
        }
        catch (WindowsSecurityException wse) {
            wse.printStackTrace();
        }
        return virtualUserName;
    }

    public static boolean isVirtualUser(String username) {
        boolean ret = false;
        if (username.toLowerCase().startsWith("ora_") && username.toLowerCase().endsWith("_svcaccts")) {
            ret = true;
        }
        return ret;
    }

    public static List<String> getOracleHomesOwnedByServiceUser(String svcUser) {
        ArrayList<String> ohList = new ArrayList<String>();
        try {
            String[] oraHomeLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
            if (oraHomeLocs != null && oraHomeLocs.length > 0) {
                for (String oraHomeLoc : oraHomeLocs) {
                    String oracleHomeUser = WinHelper.getOracleHomeUser(oraHomeLoc);
                    if (oracleHomeUser != null && oracleHomeUser.trim().length() > 0 && oracleHomeUser.equalsIgnoreCase(svcUser)) {
                        ohList.add(oraHomeLoc);
                    }
                    if (!svcUser.equalsIgnoreCase(Credentials.BuiltinUser.LOCALSYSTEM.toString()) || oracleHomeUser != null) continue;
                    ohList.add(oraHomeLoc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ohList;
    }

    public static boolean isExistingHomeUserSecureUser(String userName) {
        boolean isBuiltInUser = false;
        try {
            Credentials credentialsLocalSystem = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
            Credentials credentialsLocalService = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
            logger.log(Level.FINEST, "Username::" + userName);
            logger.log(Level.FINEST, "Credentials LocalSystem Username::" + credentialsLocalSystem.getUsername().toString());
            logger.log(Level.FINEST, "Credetials LocalService Username::" + credentialsLocalService.getUsername().toString());
            if (userName.equals(credentialsLocalSystem.getUsername().toString()) || userName.equals(credentialsLocalService.getUsername().toString())) {
                isBuiltInUser = true;
            }
        }
        catch (WindowsSecurityException e) {
            logger.log(Level.FINEST, e.getMessage());
        }
        return isBuiltInUser;
    }

    public static Map<String, Boolean> getNodesAdminMap(String userName, String password, String[] nodelist) {
        String localNodeName = MachineInfo.getInstance().getLocalMachineName();
        Map nodesAdminMap = null;
        user = WinHelper.getUser(userName, password);
        try {
            nodesAdminMap = user.isAdministrator(localNodeName, nodelist);
        }
        catch (WindowsSecurityException we) {
            logger.log(Level.INFO, "Exception occurred while determining if the user has Administrative privileges on remote nodes" + (Object)((Object)we));
        }
        catch (CompositeOperationException ce) {
            logger.log(Level.INFO, "Exception occurred while determining if the user has Administrative privileges on remote nodes" + (Object)((Object)ce));
        }
        return nodesAdminMap;
    }

    public static boolean isBuiltInAccount(String userName) {
        boolean valid = false;
        user = WinHelper.getUser(userName, null);
        try {
            valid = user.isBuiltinAccount();
        }
        catch (WindowsSecurityException we) {
            logger.log(Level.INFO, "Exception occurred while determining if the user is a built-in account" + (Object)((Object)we));
        }
        return valid;
    }
}

