/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Restorable;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;

class BackupRestoreState
extends OPatchState {
    public BackupRestoreState() {
        super(6, 45, 49, "Back up for restore", OLogger.INFO, false);
    }

    protected String getStateAssociatedMessage(String oracleHomePath, PatchObject[] patchObject) {
        StringBuffer buffer = new StringBuffer("");
        int backUpFileNumber = 0;
        for (int i2 = 0; i2 < patchObject.length; ++i2) {
            backUpFileNumber += this.getBackupRestoreFileNumber(oracleHomePath, patchObject[i2]);
        }
        buffer.append("Back up " + backUpFileNumber + " files for Oracle Home restore in case of patching error.");
        return buffer.toString();
    }

    private int getBackupRestoreFileNumber(String oracleHomePath, PatchObject patchObject) {
        int i2;
        int numberOfPatchFile = 0;
        int numberOfInventoryFile = 0;
        String oneOffsSrc = IPMUtil.getOneoffsLocation(oracleHomePath);
        String contentsXMLSrc = IPMUtil.getCompsXMLLocation(oracleHomePath);
        File srcFile = new File(oneOffsSrc);
        if (srcFile.exists()) {
            numberOfInventoryFile += this.getFileNumberForDirectory(srcFile);
        }
        if ((srcFile = new File(contentsXMLSrc)).exists()) {
            ++numberOfInventoryFile;
        }
        String cookedPatchID = patchObject.getCookedPatchID();
        String patchID = patchObject.getPatchID();
        PatchComponent[] includedPatchComponents = patchObject.getIncludedPatchComponents();
        int nComps = includedPatchComponents.length;
        int nActions = patchObject.getPatchActions().length;
        TreeSet<String> set = new TreeSet<String>();
        ArrayList<Restorable> backupList = new ArrayList<Restorable>();
        for (i2 = 0; i2 < nComps; ++i2) {
            PatchComponent pc = includedPatchComponents[i2];
            PatchAction[] includedPatchActions = patchObject.getPatchActionsForComponent(pc);
            Restorable ra = null;
            for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                PatchAction pa = includedPatchActions[j2];
                if (!pa.isAppliedOK() || !(pa instanceof Restorable)) continue;
                try {
                    String desc;
                    ra = (Restorable)((Object)pa);
                    String key = desc = ra.getBackupForRestoreDesc(oracleHomePath, cookedPatchID);
                    if (set.contains(key)) continue;
                    if (ra.restorable(oracleHomePath, cookedPatchID)) {
                        backupList.add(ra);
                    }
                    set.add(key);
                    continue;
                }
                catch (RuntimeException e2) {
                    OLogger.printStackTrace(e2);
                }
            }
        }
        for (i2 = 0; i2 < backupList.size(); ++i2) {
            Object obj = backupList.get(i2);
            PatchAction dummy = (PatchAction)obj;
            if (!(obj instanceof Restorable)) continue;
            Restorable restoreAction = (Restorable)obj;
            try {
                ++numberOfPatchFile;
                continue;
            }
            catch (RuntimeException e3) {
                OLogger.printStackTrace(e3);
            }
        }
        if (!OPatchEnv.isNApply() && !OPatchEnv.isNRollback()) {
            StringBuffer srcScriptLoc = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID));
            if (OPatchEnv.isWindows()) {
                srcScriptLoc.append(File.separator);
                srcScriptLoc.append("rollback.bat");
            } else {
                srcScriptLoc.append(File.separator);
                srcScriptLoc.append("rollback.sh");
            }
            File srcScriptFile = new File(srcScriptLoc.toString());
            if (srcScriptFile.exists() && srcScriptFile.canRead()) {
                ++numberOfPatchFile;
            }
        }
        return numberOfPatchFile + numberOfInventoryFile;
    }
}

