/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import oracle.opatch.OCMException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.ZipUtilities;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;

public class SCM {
    private static int SET_UP_CCR_PERM = 480;
    private static String ocmZipLoc = "";
    private static boolean isMwInstall = false;
    private static String oracleHome = "";
    private static String middlewareHome = "";
    private static boolean noPlatformCheck = true;
    private static int[] ouiPlatforms = new int[]{912, 233, 46, 30, 227, 453, 610, 2, 197, 110};
    private static int[] ocmPlatforms = new int[]{23, 100, 207, 214, 29, 212, 38, 214, 226};

    protected static boolean isEBSHome(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr_stage");
        File f2 = new File(buff.toString());
        return f2 != null && f2.exists() && f2.isDirectory();
    }

    private static String getTopLevelDir(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr");
        return buff.toString();
    }

    protected static boolean isInstalled(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr");
        File fDir = new File(buff.toString());
        return fDir != null && fDir.exists() && fDir.isDirectory();
    }

    protected static boolean isConfigured(String oracleHomePath) {
        File f2;
        if (!SCM.isInstalled(oracleHomePath)) {
            return false;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr");
        buff.append(File.separator);
        buff.append("bin");
        buff.append(File.separator);
        buff.append("emCCR");
        if (OPatchEnv.isWindows()) {
            buff.append(".bat");
        }
        return (f2 = new File(buff.toString())) != null && f2.exists() && !f2.isDirectory();
    }

    public static boolean isPlatformSpecific(String curWorkDir, String oracleHomePath) {
        StringBuffer buff = new StringBuffer(curWorkDir);
        if (curWorkDir.equals(oracleHomePath)) {
            buff.append(File.separator).append("OPatch");
        }
        buff.append(File.separator).append("ocm");
        buff.append(File.separator).append("ocm.zip");
        File f2 = new File(buff.toString());
        return f2.exists() && !f2.isDirectory();
    }

    private static boolean isGeneric(String curWorkDir, String oracleHomePath) {
        StringBuffer buff = new StringBuffer(curWorkDir);
        if (curWorkDir.equals(oracleHomePath)) {
            buff.append(File.separator).append("OPatch");
        }
        buff.append(File.separator).append("ocm");
        buff.append(File.separator).append("generic.zip");
        File f2 = new File(buff.toString());
        return f2.exists() && !f2.isDirectory();
    }

    protected static String getRespUtilityPath(String curWorkDir) {
        StringBuffer buff = new StringBuffer(curWorkDir);
        buff.append(File.separator).append("ocm");
        buff.append(File.separator).append("bin");
        String utilityFile = "";
        utilityFile = OPatchEnv.isWindows() ? "emocmrsp.bat" : "emocmrsp";
        buff.append(File.separator).append(utilityFile);
        return buff.toString();
    }

    protected static boolean isOCMBundledOPatch(String curWorkDir, String oracleHomePath) {
        boolean isPlatformSpecific = false;
        isPlatformSpecific = SCM.isPlatformSpecific(curWorkDir, oracleHomePath);
        return isPlatformSpecific;
    }

    private static void setOPatchOCMZipPath(String curWorkDir, String oracleHomePath) throws OCMException {
        boolean isPlatformSpecific = false;
        boolean isPlatSuccess = false;
        int platformID = 0;
        isPlatformSpecific = SCM.isPlatformSpecific(curWorkDir, oracleHomePath);
        StringBuffer buff = new StringBuffer(curWorkDir);
        if (curWorkDir.equals(oracleHomePath)) {
            buff.append(File.separator).append("OPatch");
        }
        buff.append(File.separator).append("ocm");
        buff.append(File.separator).append("ocm.zip");
        if (isPlatformSpecific) {
            OLogger.justlog(OLogger.INFO, "platform specific OPatch with ocm.zip has been used");
            OLogger.justlog(OLogger.INFO, "The ocm location is " + buff.toString());
            ocmZipLoc = buff.toString();
        } else {
            int i2;
            if (noPlatformCheck) {
                return;
            }
            OLogger.debug(new StringBuffer("ocm.zip is not present. Performing platform validation..."));
            String aruIDStr = OPatchEnv.getUserDefinedPlatformID();
            if (aruIDStr != null && !aruIDStr.equals("")) {
                try {
                    platformID = Integer.parseInt(aruIDStr);
                }
                catch (NumberFormatException e2) {
                    OLogger.printStackTrace(e2);
                    platformID = 0;
                }
            }
            if (platformID == 0) {
                platformID = OUIReplacer.Platform.getCurrentPlatform();
            }
            if (platformID == 0) {
                platformID = PatchObjectUtil.getIdFromUname(oracleHomePath);
            }
            if (platformID == 0) {
                throw new OCMException("\nUnable to detect platform information for OCM configuration.");
            }
            for (i2 = 0; i2 < ouiPlatforms.length && !isPlatSuccess; ++i2) {
                if (platformID != ouiPlatforms[i2]) continue;
                isPlatSuccess = true;
                break;
            }
            for (i2 = 0; i2 < ocmPlatforms.length && !isPlatSuccess; ++i2) {
                if (platformID != ocmPlatforms[i2]) continue;
                isPlatSuccess = true;
                break;
            }
            ocmZipLoc = "";
            if (isPlatSuccess) {
                OLogger.println(OLogger.getString("OUI-67601", new Object[]{new Integer(platformID).toString()}));
                throw new OCMException(OLogger.getString("OUI-67602"));
            }
        }
    }

    private static String getOPatchOCMZipPath() {
        return ocmZipLoc;
    }

    private static boolean isOcmResponseFileOK() {
        if (OPatchEnv.isReport()) {
            return true;
        }
        if (OPatchEnv.isOCMResponseFile()) {
            String responseFileLocation = OPatchEnv.getOCMResponseFileLoc();
            File f2 = new File(responseFileLocation);
            return f2.exists() && !f2.isDirectory();
        }
        return false;
    }

    private static boolean removeOCM(String oracleHomePath) {
        SystemCall.ExecReturn ret = null;
        String[] cmd = new String[1];
        String ohCCR = oracleHomePath + File.separator + "ccr";
        String delCommand = "";
        String runDir = oracleHomePath;
        OLogger.justlog(OLogger.INFO, "Uninstalling Oracle Configuration Manager...");
        if (!OPatchEnv.isWindows()) {
            cmd[0] = delCommand = "rm -rf " + ohCCR;
        } else {
            delCommand = "rmdir /S /Q " + ohCCR;
            cmd[0] = "cmd /C \"" + delCommand + "\"";
        }
        OLogger.justlog(OLogger.INFO, "Command to invoke for removing OCM is : " + cmd[0]);
        if (OPatchEnv.isReport()) {
            OLogger.println("[Report: skip \"" + cmd[0] + "\"]");
            return true;
        }
        OLogger.log(OLogger.FINE, "Invoking \"" + cmd[0] + "\"");
        ret = SystemCall.runtimeExec(cmd, runDir);
        if (ret == null) {
            OLogger.justlog(OLogger.INFO, "Execution object ret is null");
            return false;
        }
        OLogger.justlog(OLogger.INFO, ret.getNormalMessage());
        OLogger.justlog(OLogger.INFO, ret.getErrorMessage());
        return ret.isOK();
    }

    private static boolean OCMUpgrade(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("SCM::OCMUpgrade() called");
        OLogger.debug(buff);
        if (!SCM.isInstalled(oracleHomePath) || !SCM.isConfigured(oracleHomePath)) {
            return false;
        }
        buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr");
        buff.append(File.separator);
        buff.append("bin");
        String runDir = buff.toString();
        buff.append(File.separator);
        buff.append("emCCR");
        if (OPatchEnv.isWindows()) {
            buff.append(".bat");
        }
        String emCCR = buff.toString();
        buff.append(" ");
        buff.append("update_components -distribution=");
        try {
            String relPath = SCM.getOPatchOCMZipPath();
            buff.append(new File(relPath).getCanonicalPath());
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        String completeCmd = buff.toString();
        SystemCall.ExecReturn ret = null;
        String[] cmd = new String[1];
        if (!OPatchEnv.isWindows()) {
            String shLoc = SCM.findShLocation(emCCR);
            cmd[0] = shLoc + " " + completeCmd;
        } else {
            cmd[0] = "cmd /C \"" + completeCmd + "\"";
        }
        if (OPatchEnv.isReport()) {
            OLogger.println("[Report: Skip calling \"" + cmd[0] + "\" under \"" + runDir + "\"]");
            return true;
        }
        OLogger.justlog(OLogger.INFO, "Invoking \"" + cmd[0] + "\" under \"" + runDir + "\"");
        ret = SystemCall.runtimeExec(cmd, runDir);
        if (ret == null) {
            OLogger.justlog(OLogger.INFO, "ret Object is null");
            return false;
        }
        OLogger.justlog(OLogger.INFO, ret.getNormalMessage());
        OLogger.justlog(OLogger.INFO, ret.getErrorMessage());
        return ret.isOK();
    }

    private static boolean install(String oracleHomePath) {
        OPatchStateManagerFactory.getInstance().setCurrentState("Install OCM");
        OLogger.debug(new StringBuffer("OCM::install()"));
        StringBuffer buff = new StringBuffer();
        String ocmZipPath = SCM.getOPatchOCMZipPath();
        OLogger.justlog(OLogger.INFO, "OCM zip file to be installed is:\"" + ocmZipPath + "\"");
        try {
            if (OPatchEnv.isReport()) {
                OLogger.println("[Report: skip unzipping \"" + ocmZipPath + "\"]");
                return true;
            }
            ZipUtilities.unzip(ocmZipPath, oracleHomePath);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            OLogger.justlog(OLogger.INFO, e2.getMessage());
            return false;
        }
        if (!OPatchEnv.isWindows()) {
            buff = new StringBuffer(oracleHomePath);
            buff.append(File.separator);
            buff.append("ccr");
            buff.append(File.separator);
            buff.append("bin");
            buff.append(File.separator);
            buff.append("setupCCR");
            File f2 = new File(buff.toString());
            if (f2 != null && f2.exists() && !f2.isDirectory()) {
                if (OPatchEnv.isReport()) {
                    OLogger.println("[Report: skip chmod on \"" + buff.toString() + "\"]");
                } else {
                    OUIReplacer.changePermission(buff.toString(), SET_UP_CCR_PERM);
                }
            }
            buff = new StringBuffer(oracleHomePath);
            buff.append(File.separator);
            buff.append("ccr");
            buff.append(File.separator);
            buff.append("bin");
            buff.append(File.separator);
            buff.append("emocmrsp");
            f2 = new File(buff.toString());
            if (f2 != null && f2.exists() && !f2.isDirectory()) {
                if (OPatchEnv.isReport()) {
                    OLogger.println("[Report: skip chmod on \"" + buff.toString() + "\"]");
                } else {
                    OUIReplacer.changePermission(buff.toString(), SET_UP_CCR_PERM);
                }
            }
        }
        return true;
    }

    private static String findShLocation(String scmSetupFile) {
        String shLoc;
        block7: {
            if (OPatchEnv.isWindows()) {
                return "";
            }
            shLoc = "sh";
            FileReader fRead = null;
            BufferedReader bRead = null;
            String inputLine = "";
            try {
                fRead = new FileReader(scmSetupFile);
            }
            catch (FileNotFoundException e2) {
                OLogger.printStackTrace(e2);
                return shLoc;
            }
            try {
                bRead = new BufferedReader(fRead);
                while ((inputLine = bRead.readLine()) != null) {
                    if (!(inputLine = inputLine.trim()).startsWith("#!")) continue;
                    String[] parts = inputLine.split("\\s+");
                    for (int i2 = 0; i2 < parts.length; ++i2) {
                        if (!parts[i2].startsWith("#!")) continue;
                        shLoc = parts[i2].replaceFirst("#!", "");
                        break block7;
                    }
                    break;
                }
            }
            catch (IOException e3) {
                OLogger.printStackTrace(e3);
                return shLoc;
            }
        }
        return shLoc;
    }

    private static int configure(String oracleHomePath, boolean delRespFile) {
        OPatchStateManagerFactory.getInstance().setCurrentState("Configure OCM");
        boolean success = false;
        OLogger.debug(new StringBuffer("OCM::configure()"));
        StringBuffer buff = new StringBuffer();
        String inputLine = "";
        buff.append(oracleHomePath);
        buff.append(File.separator);
        buff.append("ccr");
        buff.append(File.separator);
        buff.append("bin");
        String runDir = buff.toString();
        buff.append(File.separator);
        buff.append("setupCCR");
        if (OPatchEnv.isWindows()) {
            buff.append(".exe");
        }
        String setupCCR = buff.toString();
        String responseFileLoc = "";
        File f2 = new File(setupCCR);
        if (f2 != null && f2.exists() && !f2.isDirectory() || OPatchEnv.isReport()) {
            if (!SCM.isOcmResponseFileOK()) {
                OLogger.println("Problem with accessing response file of \"" + setupCCR + "\".");
                return -1;
            }
        } else {
            OLogger.println("The setup file to configure OCM \"" + setupCCR + "\" could not be used.");
            return -1;
        }
        buff.append(" -R ");
        responseFileLoc = OPatchEnv.getOCMResponseFileLoc();
        buff.append(responseFileLoc);
        buff.append(" -S ");
        buff.append("OPatch");
        buff.append(" -V ");
        buff.append(OPatchSession.getVersion());
        String completeCmd = buff.toString();
        SystemCall.ExecReturn ret = null;
        String[] cmd = new String[1];
        if (!OPatchEnv.isWindows()) {
            String shLoc = SCM.findShLocation(setupCCR);
            cmd[0] = shLoc + " " + completeCmd;
        } else {
            cmd[0] = "cmd /C \"" + completeCmd + "\"";
        }
        if (OPatchEnv.isReport()) {
            OLogger.println("[Report: Skip calling \"" + cmd[0] + "\" under \"" + runDir + "\"]");
            return 0;
        }
        OLogger.justlog(OLogger.INFO, "\nInvoking \"" + cmd[0] + "\" under \"" + runDir + "\"");
        ret = SystemCall.runtimeExec(cmd, runDir);
        if (ret == null) {
            OLogger.justlog(OLogger.INFO, "ret Object is null");
            return -1;
        }
        OLogger.justlog(OLogger.INFO, ret.getNormalMessage());
        OLogger.justlog(OLogger.INFO, ret.getErrorMessage());
        if (!ret.isOK()) {
            int ocmCode;
            if (delRespFile && !(success = SCM.deleteResponseFile(responseFileLoc))) {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67299", new Object[]{responseFileLoc}));
            }
            if ((ocmCode = ret.getReturnCode()) == 12) {
                return 12;
            }
        }
        if (delRespFile && !(success = SCM.deleteResponseFile(responseFileLoc))) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67299", new Object[]{responseFileLoc}));
        }
        return 0;
    }

    public static boolean deleteResponseFile(String responseFileLoc) {
        boolean success = true;
        boolean isDebug = false;
        try {
            isDebug = Boolean.valueOf(OPatchACL.invokeOLogger(new SCM(), "isDebug", null).toString());
        }
        catch (IllegalAccessException e2) {
            RuntimeException rte = new RuntimeException(e2.getMessage());
            rte.setStackTrace(e2.getStackTrace());
            throw rte;
        }
        if (isDebug) {
            return true;
        }
        if (responseFileLoc == null) {
            return false;
        }
        File f2 = new File(responseFileLoc);
        try {
            new FileWriter(f2).close();
        }
        catch (IOException e3) {
            OLogger.printStackTrace(e3);
        }
        if (f2.exists() && !f2.isDirectory()) {
            success = f2.delete();
        }
        return success;
    }

    public static boolean needToConfigureOHInMiddleware(IIPMReadServices readServices) {
        if (!Rules.shouldDoMiddlewareHomeOCM()) {
            return false;
        }
        InstalledComponent[] ic = readServices.getInstalledComponents();
        boolean proceedWithOH = false;
        for (int i2 = 0; ic != null && i2 < ic.length; ++i2) {
            String id = ic[i2].getID();
            if (!id.equals("oracle.sysman.ccr")) continue;
            proceedWithOH = true;
            break;
        }
        return proceedWithOH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processMiddlewareOCM(String mwHome, String oracleHomePath, IIPMReadServices readServices) throws Exception, OCMException {
        StringBuffer buff = new StringBuffer("OCM::processMiddlewareOCM()");
        OLogger.debug(buff);
        boolean deleteResp = true;
        try {
            block8: {
                try {
                    if (!readServices.isInventoryLoaded()) {
                        throw new OCMException("Unable to get inventory information from IIPMReadServices.");
                    }
                    isMwInstall = true;
                    oracleHome = oracleHomePath;
                    middlewareHome = mwHome;
                    String parentCCR = mwHome + File.separator + "utils";
                    File mwCCR = new File(parentCCR);
                    if (!mwCCR.exists()) throw new OCMException("\nOPatch was not able to find the Middleware Home's directory \"" + parentCCR + "\" to configure OCM.");
                    if (!mwCCR.isDirectory()) {
                        throw new OCMException("\nOPatch was not able to find the Middleware Home's directory \"" + parentCCR + "\" to configure OCM.");
                    }
                    if (OPatchEnv.isOCMResponseFile()) {
                        deleteResp = false;
                    }
                    SCM.processOCM(parentCCR);
                    isMwInstall = false;
                    if (!SCM.needToConfigureOHInMiddleware(readServices)) break block8;
                    SCM.processOCM(oracleHome);
                }
                catch (OCMException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw e3;
                }
            }
            Object var8_9 = null;
            isMwInstall = false;
            oracleHome = "";
            middlewareHome = "";
            if (!deleteResp) return;
            OPatchEnv.setOcmResponseFileDelete(true);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            isMwInstall = false;
            oracleHome = "";
            middlewareHome = "";
            if (!deleteResp) throw throwable;
            OPatchEnv.setOcmResponseFileDelete(true);
            throw throwable;
        }
    }

    public static void processOCM(String oracleHomePath) throws OCMException, Exception {
        int ocmCode;
        StringBuffer buff = new StringBuffer("OCM::processOCM()");
        OLogger.debug(buff);
        String advHomePath = "";
        advHomePath = isMwInstall ? middlewareHome : oracleHomePath;
        if (SCM.isEBSHome(oracleHomePath) && !isMwInstall) {
            OLogger.justlog(OLogger.INFO, "EBS home detected, no OCM installation, configuration will be performed");
            return;
        }
        String msg = "";
        boolean success = false;
        boolean isDeleteResp = true;
        String curWorkDir = System.getProperty("OPatch.RUNNING_DIR");
        if (curWorkDir == null || curWorkDir.equals("")) {
            curWorkDir = oracleHomePath;
        }
        OLogger.justlog(OLogger.INFO, "Current working directory is : " + curWorkDir);
        SCM.setOPatchOCMZipPath(curWorkDir, oracleHomePath);
        boolean chkOcm = false;
        chkOcm = SCM.isOcmResponseFileOK();
        if (SCM.isGeneric(curWorkDir, oracleHomePath) && !SCM.isPlatformSpecific(curWorkDir, oracleHomePath) && chkOcm) {
            String ocmrfStr = "You are calling OPatch with -ocmrf option while this OPatch is generic, not being bundled with OCM. The -ocmrf option is being deprecated. Please remove it while calling OPatch.";
            OLogger.println(ocmrfStr);
            return;
        }
        if (SCM.isGeneric(curWorkDir, oracleHomePath) && !SCM.isPlatformSpecific(curWorkDir, oracleHomePath)) {
            OLogger.justlog(OLogger.INFO, "OPatch is generic, it is not bundled with OCM.");
            return;
        }
        boolean isEMOPatch = false;
        if (!SCM.isOCMBundledOPatch(curWorkDir, oracleHomePath)) {
            boolean emcall;
            isEMOPatch = true;
            if (!SCM.isInstalled(oracleHomePath) && !OPatchEnv.isEmOcmSkip()) {
                String genericOPatchMsg = "\n\nThis version of OPatch is obsolete. Please go to \"https://myoraclesupport.oracle.com\" \nand download Patch 6880880, choosing your platform and the OPatch version \napplicable to your system.\n";
                OLogger.println(genericOPatchMsg);
                throw new OCMException(genericOPatchMsg);
            }
            if (SCM.isInstalled(oracleHomePath) && !SCM.isConfigured(oracleHomePath) && !(emcall = OPatchEnv.isEmOcmSkip())) {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67294"));
            }
            return;
        }
        OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67603"));
        if (SCM.isInstalled(oracleHomePath)) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67295", new Object[]{advHomePath}));
            if (!SCM.isConfigured(oracleHomePath)) {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67297", new Object[]{advHomePath}));
                success = SCM.removeOCM(oracleHomePath);
                if (!success) {
                    OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67298"));
                    return;
                }
            } else {
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67600", new Object[]{advHomePath}));
                if (!isMwInstall && !(success = SCM.OCMUpgrade(oracleHomePath))) {
                    OLogger.justlog(OLogger.INFO, "\nOPatch failed to upgrade OCM.  Please refer log file for details.");
                }
                return;
            }
        }
        msg = OLogger.getString("OUI-67290", new Object[]{advHomePath});
        OLogger.justlog(OLogger.INFO, msg);
        success = SCM.install(oracleHomePath);
        if (!success) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67292", new Object[]{advHomePath}));
            return;
        }
        OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67296", new Object[]{"installed ", advHomePath}));
        if (OPatchEnv.isSilent()) {
            if (OPatchEnv.isEmOcmSkip() && !OPatchEnv.isOCMResponseFile()) {
                if (!SCM.isConfigured(oracleHomePath)) {
                    OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67294"));
                }
                return;
            }
            if (!SCM.isOcmResponseFileOK()) {
                throw new OCMException("\nThe response file for OCM configuration does not exist (or) is not readable. Please provide a valid response file.");
            }
            isDeleteResp = false;
            OPatchEnv.setOcmResponseFileDelete(false);
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67291", new Object[]{advHomePath}));
        } else if (!OPatchEnv.isOCMResponseFile()) {
            String patchStorage = "";
            patchStorage = !isMwInstall ? OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath) : OPatchEnv.getPatchStorageDirectoryPath(oracleHome);
            buff = new StringBuffer(patchStorage);
            buff.append(File.separator);
            buff.append("ocmRespFile");
            String responseFile = buff.toString();
            File respFile = new File(responseFile);
            if (respFile.exists() && !(success = respFile.delete())) {
                throw new OCMException(OLogger.getString("OUI-67299", new Object[]{responseFile}));
            }
            try {
                String topLevelDir = SCM.getTopLevelDir(oracleHomePath);
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67291", new Object[]{advHomePath}));
                OUIReplacer.createResponseFile(responseFile, topLevelDir);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                OPatchEnv.setOcmResponseFileDelete(true);
                OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67293", new Object[]{advHomePath}));
                throw e2;
            }
            OPatchEnv.setOCMResponseFileLoc(responseFile);
            isDeleteResp = true;
            OPatchEnv.setOcmResponseFileDelete(true);
        } else {
            if (!SCM.isOcmResponseFileOK()) {
                throw new OCMException("\nThe response file for OCM configuration does not exist (or) is not readable. Please provide a valid response file.");
            }
            isDeleteResp = false;
            OPatchEnv.setOcmResponseFileDelete(false);
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67291"));
        }
        if (isMwInstall) {
            isDeleteResp = false;
        }
        if ((ocmCode = SCM.configure(oracleHomePath, isDeleteResp)) != 0) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67293", new Object[]{advHomePath}));
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67294"));
        } else {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67296", new Object[]{"configured", advHomePath}));
        }
        if (!SCM.isConfigured(oracleHomePath) && !OPatchEnv.isReport()) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67293", new Object[]{advHomePath}));
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67294"));
        }
    }
}

