/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseCopyPreCustomizedAction
implements ICustomizedActions {
    private List<SparseCopyContext> sccs;
    private String oracleHomePath;
    private PatchObject pObject;
    private Set<String> leftAppDirs;

    public SparseCopyPreCustomizedAction(List<SparseCopyContext> sccs, String oracleHomePath, PatchObject pObject, Set<String> leftAppDirs) {
        this.sccs = sccs;
        this.oracleHomePath = oracleHomePath;
        this.pObject = pObject;
        this.leftAppDirs = leftAppDirs;
    }

    @Override
    public ICustomizedActionResults run() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: SparseCopyPreCustomizedAction::run()");
        ArrayList appDirs = this.pObject.getApplicationDirs();
        for (String appDir : appDirs) {
            File oldAppVerDir;
            File priorAppPtrFile;
            if (!this.leftAppDirs.contains(appDir)) {
                OLogger.printlnOnLog(MessageFormat.format("The application directory {0} has been prepared", appDir));
                continue;
            }
            OLogger.printlnOnLog(MessageFormat.format("prepare for the application directory {0}", appDir));
            SparseCopyContext scc = new SparseCopyContext();
            scc.setApplicationDir(appDir);
            boolean isFirstAppVerDirExist = this.checkFirstAppVerDirExist(appDir);
            scc.setFirstAppVerDirExist(isFirstAppVerDirExist);
            if (!isFirstAppVerDirExist) {
                this.sccs.add(scc);
                continue;
            }
            scc.setDeleteOldDirectory(this.pObject.isDeleteOldDirectory());
            OLogger.printlnOnLog(MessageFormat.format("The flag DELETE_OLD_DIRECTORY is set to {0}", scc.isDeleteOldDirectory()));
            File latestAppPtrFile = this.getLatestAppPtrFile(this.oracleHomePath, appDir);
            if (latestAppPtrFile != null) {
                OLogger.printlnOnLog(MessageFormat.format("The Latest pointer file is: {0}", latestAppPtrFile.getAbsolutePath()));
                scc.setLatestAppPtrFile(latestAppPtrFile);
            }
            if ((priorAppPtrFile = this.getPriorAppPtrFile(this.oracleHomePath, appDir)) != null) {
                OLogger.printlnOnLog(MessageFormat.format("The prior pointer file is: {0}", priorAppPtrFile.getAbsolutePath()));
                scc.setPriorAppPtrFile(priorAppPtrFile);
            }
            if ((oldAppVerDir = this.getOldAppVerDir(appDir)) != null) {
                OLogger.printlnOnLog(MessageFormat.format("The old application version directory is: {0}", oldAppVerDir.getAbsolutePath()));
                scc.setOldAppVerDir(oldAppVerDir);
            }
            File newAppVerFromPatchDir = this.getNewAppVerFromPatchDir(appDir);
            OLogger.printlnOnLog(MessageFormat.format("The new application version directory is: {0}", newAppVerFromPatchDir.getAbsolutePath()));
            try {
                if (!newAppVerFromPatchDir.exists()) {
                    newAppVerFromPatchDir.mkdir();
                }
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException("OPatch failed to create new application version directory " + newAppVerFromPatchDir.getAbsolutePath());
                throw re;
            }
            scc.setNewAppVerFromPatchDir(newAppVerFromPatchDir);
            File currentAppVerDir = this.getCurrentAppVerDir(appDir);
            if (currentAppVerDir != null && currentAppVerDir.exists()) {
                OLogger.printlnOnLog(MessageFormat.format("The current application version directory is: {0}", currentAppVerDir.getAbsolutePath()));
                scc.setCurrentAppVerDir(currentAppVerDir);
            } else {
                scc.setCurrentAppVerDir(newAppVerFromPatchDir);
            }
            if (scc.getCurrentAppVerDir() != scc.getNewAppVerFromPatchDir()) {
                this.copyFilesCurrentAppToNewAppVer(currentAppVerDir, newAppVerFromPatchDir, scc);
                OLogger.printlnOnLog(MessageFormat.format("copied {0} to {1}", currentAppVerDir.getAbsolutePath(), newAppVerFromPatchDir.getAbsolutePath()));
            }
            this.sccs.add(scc);
        }
        return null;
    }

    private File getOldAppVerDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getOldAppVerDir::get the old application version directory");
        File priorAppPtrFile = this.getPriorAppPtrFile(this.oracleHomePath, appDir);
        if (priorAppPtrFile != null) {
            String priorAppPtrFileName = this.getPriorAppPtrFile(this.oracleHomePath, appDir).getName();
            String oldAppVerDirName = priorAppPtrFileName.substring("prior-ptr-".length());
            String oldAppVerDir = this.oracleHomePath + File.separator + appDir + File.separator + oldAppVerDirName;
            return new File(oldAppVerDir);
        }
        return null;
    }

    private File getCurrentAppVerDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getCurrentAppVerDir::get the current application version directory");
        File latestAppPtrFile = this.getLatestAppPtrFile(this.oracleHomePath, appDir);
        if (latestAppPtrFile != null) {
            String latestAppPtrFileName = latestAppPtrFile.getName();
            String currentAppVerDirName = latestAppPtrFileName.substring("latest-ptr-".length());
            String currentAppVerDir = this.oracleHomePath + File.separator + appDir + File.separator + currentAppVerDirName;
            return new File(currentAppVerDir);
        }
        return null;
    }

    private File getNewAppVerFromPatchDir(String appDir) {
        OLogger.justlog(OLogger.INFO, "getNewAppVerFromPatchDir::get the new application version directory");
        String newAppDir = this.oracleHomePath + File.separator + appDir + File.separator + this.pObject.getApplicationVersion();
        return new File(newAppDir);
    }

    private File getPriorAppPtrFile(String oracleHomePath, String appDir) {
        OLogger.justlog(OLogger.INFO, "getPriorAppPtrFile::get the prior application pointer file");
        String priorAppPtrFileStartString = "prior-ptr-";
        return OPatchEnv.getLatestFileWtihStartString(oracleHomePath, appDir, priorAppPtrFileStartString);
    }

    private File getLatestAppPtrFile(String oracleHomePath, String appDir) {
        OLogger.justlog(OLogger.INFO, "getLatestAppPtrFile::get the latest application pointer file");
        String latestAppPtrFileStartString = "latest-ptr-";
        return OPatchEnv.getLatestFileWtihStartString(oracleHomePath, appDir, latestAppPtrFileStartString);
    }

    private void copyFilesCurrentAppToNewAppVer(File currentAppVerDir, File newAppVerDir, SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "copyFilesCurrentAppToNewAppVer::copy files from the current application version directory to the new application version directory");
        try {
            SystemCall.copyRecurse(currentAppVerDir, newAppVerDir, true);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(MessageFormat.format("OPatch failed to copy files from {0} to {1}", scc.getCurrentAppVerDir().getAbsolutePath(), scc.getNewAppVerFromPatchDir().getAbsolutePath()));
            throw re;
        }
    }

    private boolean checkFirstAppVerDirExist(String appDir) {
        boolean isSparseCopyType;
        boolean bl = isSparseCopyType = this.pObject.getApplicationDirs().size() > 0;
        if (isSparseCopyType) {
            OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PatchObject::checkFirstAppVerDirExist()");
            File appFile = new File(OPatchEnv.getOracleHome() + File.separator + appDir);
            OLogger.printlnOnLog("The application location is " + appFile.getAbsolutePath());
            if (appFile.exists()) {
                File latestPointerFile = OPatchEnv.getLatestFileWtihStartString(OPatchEnv.getOracleHome(), appDir, "latest-ptr-");
                if (latestPointerFile == null || !latestPointerFile.exists()) {
                    OLogger.printlnOnLog("The latest pointer file doesn't exists.");
                    return false;
                }
                OLogger.printlnOnLog("The latest pointer file is in " + latestPointerFile.getAbsolutePath());
                String fileName = latestPointerFile.getName();
                String firstAppVerDirName = fileName.substring("latest-ptr-".length());
                File firstAppVerFile = new File(appFile.getAbsolutePath() + File.separator + firstAppVerDirName);
                OLogger.printlnOnLog("The location of the first version directory is " + firstAppVerFile.getAbsolutePath());
                if (firstAppVerFile.exists()) {
                    OLogger.printlnOnLog("The first application version directory exists.");
                    return true;
                }
                OLogger.printlnOnLog("The first application version directory doesn't exist.");
                return false;
            }
            OLogger.printlnOnLog("The application directory doesn't exist.");
            return true;
        }
        return false;
    }
}

