/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoNeedListParser {
    private Collection<NoNeedReason> noNeedBysubSet = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedByDuplicate = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedByWorse = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedByLowerPSU = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedBySubSetOfBigPoh = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedBySkipConflict = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedBySkipConflictToCompositePatch = new ArrayList<NoNeedReason>();
    private Collection<NoNeedReason> noNeedBySubsetPSU = new ArrayList<NoNeedReason>();

    public NoNeedListParser(Collection<IPatch> patches, IConflictMap map) {
        for (IPatch patch : patches) {
            NoNeedReason reason;
            if (!map.getRelations(patch).getWholeSubsets().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getSingleSubsets(), NoNeedReasonCode.SUBSET);
                this.noNeedBysubSet.add(reason);
            }
            if (!map.getRelations(patch).getWorses().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getWorses(), NoNeedReasonCode.WORSE_DUPLICATE);
                this.noNeedByWorse.add(reason);
            }
            if (!map.getRelations(patch).getDuplicates().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getDuplicates(), NoNeedReasonCode.DUPLICATE);
                this.noNeedByDuplicate.add(reason);
            }
            if (!map.getRelations(patch).getLowerPSUs().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getLowerPSUs(), NoNeedReasonCode.LOWER_PSU);
                this.noNeedByLowerPSU.add(reason);
            }
            if (!map.getRelations(patch).getSubsetPSU().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getSubsetPSU(), NoNeedReasonCode.SUBSET_PSU);
                this.noNeedBySubsetPSU.add(reason);
            }
            if (patch.isSubSetOfBigPoh()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getSingleConflicts(), NoNeedReasonCode.SUBSET_OF_BIG_POH);
                this.noNeedBySubSetOfBigPoh.add(reason);
            }
            if (OPatchEnv.isIgnoreConflict() && !map.getRelations(patch).getWholeConflicts().isEmpty()) {
                reason = new NoNeedReason(patch, map.getRelations(patch).getSingleConflicts(), NoNeedReasonCode.SKIP_CONFLICT);
                this.noNeedBySkipConflict.add(reason);
            }
            if (!OPatchEnv.isOptimize() || map.getRelations(patch).getWholeConflicts().isEmpty()) continue;
            reason = new NoNeedReason(patch, map.getRelations(patch).getSingleConflicts(), NoNeedReasonCode.SKIP_CONFLICT_BY_OPTIMIZE);
            this.noNeedBySkipConflictToCompositePatch.add(reason);
        }
    }

    public Collection<NoNeedReason> getNoNeedBysubSet() {
        return this.noNeedBysubSet;
    }

    public Collection<NoNeedReason> getNoNeedByDuplicate() {
        return this.noNeedByDuplicate;
    }

    public Collection<NoNeedReason> getNoNeedByWorse() {
        return this.noNeedByWorse;
    }

    public Collection<NoNeedReason> getNoNeedByLowerPSU() {
        return this.noNeedByLowerPSU;
    }

    public Collection<NoNeedReason> getNoNeedBySubSetOfBigPoh() {
        return this.noNeedBySubSetOfBigPoh;
    }

    public Collection<NoNeedReason> getNoNeedBySkipConflict() {
        return this.noNeedBySkipConflict;
    }

    public Collection<NoNeedReason> getNoNeedBySkipConflictToCompositePatch() {
        return this.noNeedBySkipConflictToCompositePatch;
    }

    public Collection<NoNeedReason> getNoNeedBySubsetPSU() {
        return this.noNeedBySubsetPSU;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NoNeedReason {
        private Collection<NPatchRelation> relations;
        private NoNeedReasonCode code;
        private IPatch patch;

        public NoNeedReason(IPatch patch, Collection<NPatchRelation> relations, NoNeedReasonCode code) {
            this.relations = relations;
            this.code = code;
            this.patch = patch;
        }

        public Collection<NPatchRelation> getRelations() {
            return this.relations;
        }

        public NoNeedReasonCode getCode() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoNeedReasonCode {
        SUBSET,
        WORSE_DUPLICATE,
        DUPLICATE,
        LOWER_PSU,
        SUBSET_PSU,
        SUBSET_OF_BIG_POH,
        SKIP_CONFLICT,
        SKIP_CONFLICT_BY_OPTIMIZE;

    }
}

