/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.diagtool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PrereqSession;
import oracle.opatch.diagtool.OPatchDiagEnv;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchDiagHelper {
    public static LEVEL level = LEVEL.FINE;
    private static final int WARNING_CODE = 205;
    private static final int ERROR_CODE = 1;
    private static final String UNDEFINED_CHECKSUM = "-1";
    public static ArrayList<String> warningList = new ArrayList();

    public static String getChecksum(String absoluteFileName) throws RuntimeException {
        String checksum = UNDEFINED_CHECKSUM;
        try {
            boolean check;
            File f2 = new File(absoluteFileName);
            boolean bl = check = !f2.exists() || f2.exists() && f2.isDirectory();
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            checksum = OPatchSessionHelper.computeChecksum(absoluteFileName);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
        return checksum;
    }

    public static void diagPrint(String msg) {
        System.out.println(msg);
    }

    public static void diagWarn(String msg) {
        OPatchDiagHelper.logres(LEVEL.WARNING, msg);
    }

    public static void diagError(String msg) {
        OPatchDiagHelper.logres(LEVEL.ERROR, msg);
    }

    public static void diagError(String key, Object[] objs) {
        OPatchDiagHelper.logres(LEVEL.ERROR, key, objs);
    }

    public static void diagWarn(String key, Object[] objs) {
        OPatchDiagHelper.logres(LEVEL.WARNING, key, objs);
    }

    private static void logres(LEVEL level, String msg) {
        if (level == LEVEL.WARNING) {
            msg = "\nopatchdiag Warning : " + msg;
            warningList.add(msg);
        } else if (level == LEVEL.ERROR) {
            System.err.println(msg);
        }
        if (level.ordinal() > OPatchDiagHelper.level.ordinal()) {
            switch (level) {
                case WARNING: {
                    OPatchDiagEnv.setExitCode(205);
                    break;
                }
                case ERROR: {
                    OPatchDiagEnv.setExitCode(1);
                }
            }
        }
        OPatchDiagHelper.level = level;
    }

    private static void logres(LEVEL level, String key, Object[] objs) {
        String msg = OLogger.getString(key, objs);
        msg = msg.replace("OPatch", "opatchdiag");
        if (level == LEVEL.WARNING) {
            msg = "\nopatchdiag Warning : " + msg;
            warningList.add(msg);
        } else if (level == LEVEL.ERROR) {
            System.err.println(msg);
        }
        String strP = key;
        int opatchExitCode = 0;
        if (key != null && key.startsWith("OUI-67") && key.length() >= 9) {
            strP = key.substring(4, 9);
            try {
                int i2 = Integer.parseInt(strP);
                if (i2 > 67000) {
                    opatchExitCode = i2 - 67000;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (level.ordinal() > OPatchDiagHelper.level.ordinal()) {
                OPatchDiagEnv.setExitCode(opatchExitCode);
            }
        }
        OPatchDiagHelper.level = level;
    }

    public static void displayHelp() {
        String helpfile = "opatchdaig_help.txt";
        StringBuffer helpMsg = new StringBuffer();
        try {
            String line;
            InputStream is = OPatchDiagHelper.class.getResourceAsStream(helpfile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                helpMsg.append(line);
                helpMsg.append("\n");
            }
            OPatchDiagHelper.diagPrint(helpMsg.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpfile});
            OPatchDiagHelper.diagPrint(msg);
        }
    }

    public static HashMap<String, HashSet<DiagChecksumComparision>> getChecksumsList(String oracleHomePath) throws RuntimeException {
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Cannot access inventory of the Oracle Home..", e2);
        }
        OneOffEntry[] actives = readServices.getInstalledPatches();
        OneOffEntry[] inactive = readServices.getInactivePatches();
        if (actives == null || inactive == null) {
            throw new RuntimeException("Can't get valid installed patches.");
        }
        Object[] oneoffs = new OneOffEntry[actives.length + inactive.length];
        System.arraycopy(actives, 0, oneoffs, 0, actives.length);
        System.arraycopy(inactive, 0, oneoffs, actives.length, inactive.length);
        Arrays.sort(oneoffs);
        HashMap<PatchAction, String> actionsMap = new HashMap<PatchAction, String>();
        for (int i2 = oneoffs.length - 1; i2 >= 0; --i2) {
            PatchAction[] actions = ((OneOffEntry)oneoffs[i2]).getPatchActions();
            for (int j2 = 0; j2 < actions.length; ++j2) {
                if (!(actions[j2] instanceof CopyAction)) continue;
                actionsMap.put(actions[j2], ((OneOffEntry)oneoffs[i2]).getID());
            }
        }
        HashMap<String, HashSet<DiagChecksumComparision>> allChecksums = new HashMap<String, HashSet<DiagChecksumComparision>>();
        for (int i3 = 0; i3 < oneoffs.length; ++i3) {
            String patchID = ((OneOffEntry)oneoffs[i3]).getID();
            ChecksumEntity[] checksums = ((OneOffEntry)oneoffs[i3]).getChecksumList();
            HashSet<DiagChecksumComparision> checksumArr = new HashSet<DiagChecksumComparision>();
            for (int j3 = 0; j3 < checksums.length; ++j3) {
                ChecksumEntity checksum = checksums[j3];
                String filePath = checksum.getComputeFilePath(oracleHomePath, ((OneOffEntry)oneoffs[i3]).getCurrentAppVerDirs().size() > 0, OPatchEnv.getApplicationVersion(), ((OneOffEntry)oneoffs[i3]).getCurrentAppVerDirs());
                String checksumKey = "";
                File checksumFile = new File(filePath);
                try {
                    checksumKey = checksumFile.getCanonicalPath();
                }
                catch (IOException e3) {
                    checksumKey = checksumFile.getAbsolutePath();
                }
                DiagChecksumComparision compare = new DiagChecksumComparision(patchID, checksumKey, OPatchDiagHelper.getChecksum(checksumKey), checksum.getChecksum());
                for (CopyAction action : actionsMap.keySet()) {
                    String latestPatchID = (String)actionsMap.get(action);
                    File f2 = new File(action.getParentFilePath(oracleHomePath));
                    String path = "";
                    try {
                        path = f2.getCanonicalPath();
                    }
                    catch (IOException e4) {
                        path = f2.getAbsolutePath();
                    }
                    if (!checksumKey.equals(path) || !patchID.equals(latestPatchID)) continue;
                    checksumArr.add(compare);
                }
            }
            if (checksumArr.size() <= 0) continue;
            allChecksums.put(patchID, checksumArr);
        }
        return allChecksums;
    }

    public static void copy(File src, File dst) throws RuntimeException {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Throwable e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiagChecksumComparision
    implements Comparable<DiagChecksumComparision> {
        private String filePath;
        private String patchID;
        private String currentChecksum;
        private String installedChecksum;

        public DiagChecksumComparision(String patchID, String filePath, String currentChecksum, String installedChecksum) {
            this.filePath = filePath;
            this.currentChecksum = currentChecksum;
            this.installedChecksum = installedChecksum;
            this.patchID = patchID;
        }

        public String getPatchID() {
            return this.patchID;
        }

        public void setPatchID(String patchID) {
            this.patchID = patchID;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getCurrentChecksum() {
            return this.currentChecksum;
        }

        public String getInstalledChecksum() {
            return this.installedChecksum;
        }

        public boolean isDiff() {
            return !this.currentChecksum.equals(this.installedChecksum);
        }

        public boolean equals(Object compare) {
            if (compare instanceof DiagChecksumComparision) {
                String myFilePath = this.getFilePath();
                DiagChecksumComparision other = (DiagChecksumComparision)compare;
                String otherFilePath = other.getFilePath();
                return myFilePath.equals(otherFilePath);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.filePath.hashCode();
            return result;
        }

        @Override
        public int compareTo(DiagChecksumComparision compare) {
            boolean isDiffForOther;
            boolean different = this.isDiff();
            if (!(different ^ (isDiffForOther = compare.isDiff()))) {
                return 0;
            }
            if (different && !isDiffForOther) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LEVEL {
        FINE,
        WARNING,
        ERROR;

    }
}

