/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.HeapMemory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.conflicttextualinterpreter.CompositePatchCategorizer;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.ipm.HomeInventoryHelper;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookedInventory {
    private static CookedInventory instance = null;
    private static String instanceOHPath = null;
    private static boolean loaded = false;
    private OneOffEntry[] installedOneOffs = null;
    private OneOffEntry[] inactiveOneOffs = null;
    private OneOffEntry[] inactivePSUTrain = null;
    private OneOffEntry[] inactiveSubsetOneOffs = null;
    private OneOffEntry[] installedOneOffsIncludingInactives = null;
    private OneOffEntry[] oneOffs = null;
    private static List cookedInstalledProducts = null;
    private static List<OneOffEntry> cookedOneOffs = null;
    private static OracleHomeInventory nextGenInv = null;
    private static Collection<Distribution> installedNextGenDistributions = null;
    private static Collection<Component> installedNextGenComponents = null;
    private static final OneOffEntry[] EMPTY_ONEOFF_ARRAY = new OneOffEntry[0];

    private CookedInventory(RawInventory rawInventory) throws Throwable {
        loaded = false;
        CookedInventory.loadCookedInventory(rawInventory);
        OLogger.debug(new StringBuffer("CookedInventory::init() construction done"));
    }

    protected static synchronized CookedInventory getInstance(RawInventory rawInv) throws NullPointerException, Throwable {
        if (instance == null || rawInv != null && !rawInv.getOracleHomePath().equals(instanceOHPath)) {
            instance = CookedInventory.init(rawInv);
        }
        return instance;
    }

    private static CookedInventory init(RawInventory rawInventory) throws Throwable {
        StringBuffer buff = new StringBuffer("CookedInventory::init()");
        if (rawInventory != null) {
            OLogger.debug(buff);
            try {
                buff.append(" gets CookedInventory object");
                OLogger.debug(buff);
                cookedInstalledProducts = new LinkedList();
                cookedOneOffs = new LinkedList<OneOffEntry>();
                return new CookedInventory(rawInventory);
            }
            catch (Throwable t) {
                buff = new StringBuffer("CookedInventory::init() gets an error: ");
                buff.append(t.getMessage());
                OLogger.debug(buff);
                throw t;
            }
        }
        NullPointerException e2 = new NullPointerException("CookedInventory::init() gets null RawInventory");
        throw e2;
    }

    private static void loadCookedInventory(RawInventory rawInventory) throws Throwable {
        if (loaded) {
            return;
        }
        StringBuffer buff = new StringBuffer("CookedInventory::load()");
        instanceOHPath = rawInventory.getOracleHomePath();
        OLogger.debug(buff);
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Loading cooked inventory");
        Vector rawInstalledProducts = rawInventory.getRawInstalledProducts();
        Vector rawOneOffList = rawInventory.getRawOneOffList();
        Iterator iter = rawInstalledProducts.iterator();
        cookedInstalledProducts.clear();
        if (OPatchEnv.isApplyOrNApplySession()) {
            OPatchEnv.setLoadPoh(true);
        }
        while (iter.hasNext()) {
            Object name = null;
            Object desc = null;
            Object id = null;
            Object version = null;
            Object obj = iter.next();
            if (!(obj instanceof OiiiCompInvEntry)) continue;
            OiiiInstallCompInvEntry eachProduct = (OiiiInstallCompInvEntry)obj;
            try {
                InstalledComponent instComp = new InstalledComponent(eachProduct);
                cookedInstalledProducts.add(instComp);
            }
            catch (NullPointerException e2) {
                OLogger.debug(new StringBuffer("CookedInventory::load() cannot construct InstallComponent"));
                throw e2;
            }
        }
        OLogger.debug(new StringBuffer("CookedInventory::load() begins to process raw data from OUI to build up OPatch primitive classes"));
        iter = rawOneOffList.iterator();
        String eachOneOffPatchNumber = null;
        Date eachOneOffAppliedDate = null;
        String patchLanguage = "";
        cookedOneOffs.clear();
        OLogger.printlnOnLog("[OPSR-MEMORY] : Loading cooked one offs. Heap memory used " + HeapMemory.getHeapUsedMB() + " (MB)");
        boolean langSupported = CookedInventory.canGetLangsForInvEntry();
        boolean uniqIDSupported = CookedInventory.canGetUniqueIDForInvEntry();
        while (iter.hasNext()) {
            OiiiInstallOneoffInvEntry invEntry;
            OiiiOneoffInstallID installID;
            Object obj = iter.next();
            if (obj instanceof OiiiInstallOneoffInvEntry && (installID = (invEntry = (OiiiInstallOneoffInvEntry)obj).getID()) != null) {
                Vector installedLangs;
                eachOneOffPatchNumber = installID.getID();
                eachOneOffAppliedDate = invEntry.getTimestamp();
                if (langSupported && (installedLangs = invEntry.getLangs()) != null && installedLangs.size() != 0) {
                    String uniqID;
                    patchLanguage = OiixLanguage.vectToStr((Vector)installedLangs);
                    eachOneOffPatchNumber = eachOneOffPatchNumber + "_" + patchLanguage;
                    if (uniqIDSupported && (uniqID = invEntry.getUniqID()) != null && !uniqID.equals("")) {
                        eachOneOffPatchNumber = eachOneOffPatchNumber + "_" + uniqID;
                    }
                }
            }
            if (eachOneOffPatchNumber == null || eachOneOffAppliedDate == null) {
                if (eachOneOffPatchNumber == null) {
                    OLogger.debug(new StringBuffer("CookedInventory::load() gets a null patchNumber"));
                }
                if (eachOneOffAppliedDate == null) {
                    OLogger.debug(new StringBuffer("CookedInventory::load() gets a null appliedTime"));
                }
                eachOneOffPatchNumber = null;
                eachOneOffAppliedDate = null;
                continue;
            }
            OPatchEnv.needSearchTripletID(false);
            OneOffEntry cookedOneOff = HomeInventoryHelper.getOneOffEntry(rawInventory.getOracleHomePath(), eachOneOffPatchNumber);
            OPatchEnv.needSearchTripletID(true);
            cookedOneOff.setAppliedDate(eachOneOffAppliedDate);
            cookedOneOffs.add(cookedOneOff);
        }
        OLogger.printlnOnLog("[OPSR-MEMORY] : Loaded cooked oneoffs. Heap memory used : " + HeapMemory.getHeapUsedMB() + " (MB)");
        if (OPatchEnv.isApplyOrNApplySession()) {
            OPatchEnv.setLoadPoh(false);
        }
        loaded = true;
        OPatchEnv.stringPool.clear();
        if (OPatchEnv.isNextGen() && (nextGenInv = InventoryFactory.getOracleHomeInventory((File)new File(rawInventory.getOracleHomePath()))) != null) {
            try {
                installedNextGenDistributions = nextGenInv.getInstalledDistributions();
                installedNextGenComponents = nextGenInv.getInstalledComponents();
            }
            catch (Exception e3) {
                nextGenInv = null;
                installedNextGenDistributions = null;
                installedNextGenComponents = null;
            }
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Cooked inventory loaded successfully");
    }

    public CookedInventory reload(RawInventory rawInventory) throws RuntimeException {
        try {
            loaded = false;
            this.installedOneOffs = null;
            this.inactiveOneOffs = null;
            this.inactivePSUTrain = null;
            this.inactiveSubsetOneOffs = null;
            this.installedOneOffsIncludingInactives = null;
            this.oneOffs = null;
            instanceOHPath = null;
            OracleHomeConflictMap.clear();
            CookedInventory.loadCookedInventory(rawInventory);
        }
        catch (Throwable e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return instance;
    }

    public OneOffEntry[] getInstalledPatches() throws RuntimeException {
        if (null != this.installedOneOffs) {
            return this.installedOneOffs;
        }
        this.initOneOffs();
        OneOffEntry[] inactiveOneOffs = this.getInactivePatches();
        ArrayList<OneOffEntry> filteredOneOffList = new ArrayList<OneOffEntry>(Arrays.asList(this.oneOffs));
        filteredOneOffList.removeAll(Arrays.asList(inactiveOneOffs));
        this.installedOneOffs = new OneOffEntry[filteredOneOffList.size()];
        filteredOneOffList.toArray(this.installedOneOffs);
        Arrays.sort(this.installedOneOffs);
        return this.installedOneOffs;
    }

    public OneOffEntry[] getAllInstalledPatches() throws RuntimeException {
        if (null != this.installedOneOffs) {
            return this.installedOneOffs;
        }
        this.initOneOffs();
        OneOffEntry[] inactiveOneOffs = this.getInactivePSUTrain();
        OneOffEntry[] inactiveSubsetOneOffs = this.getInactiveSubsetPatches();
        if (inactiveOneOffs.length > 0 || inactiveSubsetOneOffs.length > 0) {
            ArrayList<OneOffEntry> filteredOneOffList = new ArrayList<OneOffEntry>(Arrays.asList(this.oneOffs));
            filteredOneOffList.removeAll(Arrays.asList(inactiveOneOffs));
            filteredOneOffList.removeAll(Arrays.asList(inactiveSubsetOneOffs));
            this.installedOneOffs = new OneOffEntry[filteredOneOffList.size()];
            filteredOneOffList.toArray(this.installedOneOffs);
            Arrays.sort(this.installedOneOffs);
            return this.installedOneOffs;
        }
        Arrays.sort(this.oneOffs);
        this.installedOneOffs = this.oneOffs;
        return this.oneOffs;
    }

    public OneOffEntry[] getInactivePatches() throws RuntimeException {
        if (null != this.inactiveOneOffs) {
            return this.inactiveOneOffs;
        }
        Object[] subsetOneOffs = null;
        ArrayList<OneOffEntry> subsetList = new ArrayList<OneOffEntry>();
        this.initOneOffs();
        if (this.oneOffs == null) {
            return EMPTY_ONEOFF_ARRAY;
        }
        ArrayList activePatches = new ArrayList();
        ArrayList<OneOffEntry> inactivePatches = new ArrayList<OneOffEntry>();
        int patchingModel = PatchingModel.returnModelCode(instanceOHPath);
        if (patchingModel == 2) {
            Map copyDelete = this.getCopyDeleteMap();
            ArrayList<String> preDeleteActive = new ArrayList<String>();
            for (int i2 = 0; i2 < this.oneOffs.length; ++i2) {
                boolean inactive = true;
                PatchAction[] pas = this.oneOffs[i2].getPatchActions();
                Map cpMap = this.getCopyMap(i2);
                boolean inact = false;
                for (PatchAction pa : pas) {
                    String file;
                    if (pa instanceof CopyAction) {
                        file = ((CopyAction)pa).getFilename();
                        String version = ((CopyAction)pa).getFileVersion();
                        String curVer = (String)copyDelete.get(file);
                        if (copyDelete.containsKey(file)) {
                            if (!this.isAvailableVersion(version, curVer)) {
                                inact = true;
                            } else if (this.hasPostDelete((CopyAction)pa, i2)) {
                                inact = true;
                            }
                        } else {
                            inact = true;
                        }
                    }
                    if (pa instanceof DeleteAction) {
                        file = ((DeleteAction)pa).getFileName();
                        String fileVersion = ((DeleteAction)pa).getFileVersion();
                        boolean less = fileVersion.contains("le");
                        String version = fileVersion.replace("le", "");
                        String cpDelVer = (String)copyDelete.get(file);
                        if (copyDelete.containsKey(file)) {
                            inact = true;
                        } else if (cpMap.containsKey(file)) {
                            String cpVer = (String)cpMap.get(file);
                            if (!this.isAvailableVersion(fileVersion, cpVer) || preDeleteActive.contains(file)) {
                                inact = true;
                            } else if (this.hasPostCopy((DeleteAction)pa, i2)) {
                                inact = true;
                            }
                        } else if (fileVersion != null && !less) {
                            inact = true;
                        }
                        if (!inactive) {
                            preDeleteActive.add(file);
                        }
                    }
                    inactive = inactive && inact;
                    inact = false;
                }
                if (!inactive) continue;
                inactivePatches.add(this.oneOffs[i2]);
            }
            this.inactiveOneOffs = inactivePatches.toArray(new OneOffEntry[inactivePatches.size()]);
        } else {
            OneOffEntry[] inactiveSubsetPatches;
            OneOffEntry[] inactivePSUs;
            for (OneOffEntry inactivePSU : inactivePSUs = this.getInactivePSUTrain()) {
                subsetList.add(inactivePSU);
            }
            for (OneOffEntry inactiveSubsetPatch : inactiveSubsetPatches = this.getInactiveSubsetPatches()) {
                subsetList.add(inactiveSubsetPatch);
            }
            subsetOneOffs = new OneOffEntry[subsetList.size()];
            subsetList.toArray(subsetOneOffs);
            Arrays.sort(subsetOneOffs);
            this.inactiveOneOffs = subsetOneOffs;
        }
        return this.inactiveOneOffs;
    }

    private boolean isAvailableVersion(String fileVer, String cpVer) {
        String ver = fileVer;
        if (fileVer == null || "".equals(fileVer)) {
            return true;
        }
        if (fileVer.indexOf("le") != -1) {
            ver = fileVer.replace("le", "");
        }
        return cpVer.compareTo(ver) <= 0;
    }

    private Map getCopyDeleteMap() {
        HashMap<String, String> cpDelMap = new HashMap<String, String>();
        for (OneOffEntry one : this.oneOffs) {
            PatchAction[] pas;
            for (PatchAction pa : pas = one.getPatchActions()) {
                String version;
                String file;
                if (pa instanceof CopyAction) {
                    file = ((CopyAction)pa).getFilename();
                    version = ((CopyAction)pa).getFileVersion();
                    cpDelMap.put(file, version);
                }
                if (!(pa instanceof DeleteAction)) continue;
                file = ((DeleteAction)pa).getFileName();
                version = ((DeleteAction)pa).getFileVersion();
                if (!cpDelMap.containsKey(file)) continue;
                cpDelMap.remove(file);
            }
        }
        return cpDelMap;
    }

    private Map getCopyMap(int n2) {
        HashMap<String, String> cpMap = new HashMap<String, String>();
        for (int i2 = 0; i2 <= n2; ++i2) {
            PatchAction[] pas;
            for (PatchAction pa : pas = this.oneOffs[i2].getPatchActions()) {
                if (!(pa instanceof CopyAction)) continue;
                String file = ((CopyAction)pa).getFilename();
                String version = ((CopyAction)pa).getFileVersion();
                String orgVer = (String)cpMap.get(file);
                if (orgVer != null) {
                    if (orgVer.compareTo(version) >= 0) continue;
                    cpMap.put(file, version);
                    continue;
                }
                cpMap.put(file, version);
            }
        }
        return cpMap;
    }

    private boolean hasPostDelete(CopyAction copyAct, int n2) {
        for (int i2 = n2; i2 < this.oneOffs.length; ++i2) {
            PatchAction[] pas;
            for (PatchAction pa : pas = this.oneOffs[i2].getPatchActions()) {
                if (!(pa instanceof DeleteAction)) continue;
                String file = ((DeleteAction)pa).getFileName();
                String version = ((DeleteAction)pa).getFileVersion();
                if (!copyAct.getFilename().equals(file)) continue;
                if (version.indexOf("le") != -1) {
                    version = version.replace("le", "");
                    if (copyAct.getFileVersion().compareTo(version) >= 0) continue;
                    return true;
                }
                if (copyAct.getFileVersion().compareTo(version) > 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPostCopy(DeleteAction delAction, int n2) {
        for (int i2 = n2; i2 < this.oneOffs.length; ++i2) {
            PatchAction[] pas;
            for (PatchAction pa : pas = this.oneOffs[i2].getPatchActions()) {
                if (!(pa instanceof CopyAction)) continue;
                String file = ((CopyAction)pa).getFilename();
                String version = ((CopyAction)pa).getFileVersion();
                if (!delAction.getFileName().equals(file) || !this.isBetterVersion(delAction.getFileVersion(), version)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBetterVersion(String delVer, String cpVer) {
        if (delVer.indexOf("le") != -1) {
            return true;
        }
        return delVer.compareTo(cpVer) <= 0;
    }

    public OneOffEntry[] getInactivePSUTrain_legacy() throws RuntimeException {
        if (this.inactivePSUTrain != null) {
            return this.inactivePSUTrain;
        }
        this.initOneOffs();
        HashMap<OneOffEntry, String[]> psuMap = new HashMap<OneOffEntry, String[]>();
        for (OneOffEntry oneOff : this.oneOffs) {
            if (!oneOff.getIsComposite() || !oneOff.getConstituentActiveField().equals(oneOff.getID())) continue;
            psuMap.put(oneOff, CompositePatchObject.getOverrideUPIs(oneOff.getCompositeFileLocation()));
        }
        OneOffEntry inactiveTopLevelPSU = null;
        ArrayList<Object> inactivePSUTrainList = new ArrayList<Object>();
        if (psuMap.size() < 2) {
            this.inactivePSUTrain = new OneOffEntry[0];
        } else {
            Set psuset = psuMap.keySet();
            Object[] psus = psuset.toArray();
            if (psus.length < 2) {
                this.inactivePSUTrain = new OneOffEntry[0];
                return this.inactivePSUTrain;
            }
            String[] overridingUPIs = (String[])psuMap.get(psus[1]);
            for (String upi : overridingUPIs) {
                if (!upi.equals(((OneOffEntry)psus[0]).getPSENumber())) continue;
                inactiveTopLevelPSU = (OneOffEntry)psus[0];
                break;
            }
            if ((inactiveTopLevelPSU = (OneOffEntry)psus[1]) != null) {
                String[] subPatchIds = CompositePatchObject.getConstituentList(inactiveTopLevelPSU.getCompositeFileLocation());
                for (OneOffEntry oneOff : this.oneOffs) {
                    for (String subPatchId : subPatchIds) {
                        if (!oneOff.getID().equals(subPatchId)) continue;
                        inactivePSUTrainList.add(oneOff);
                    }
                }
            }
            this.inactivePSUTrain = new OneOffEntry[inactivePSUTrainList.size()];
            inactivePSUTrainList.toArray(this.inactivePSUTrain);
        }
        CompositePatchCategorizer.setInactivePSUTrain(this.inactivePSUTrain);
        return this.inactivePSUTrain;
    }

    public OneOffEntry[] getInactiveSubsetPatches() throws RuntimeException {
        if (this.inactiveSubsetOneOffs != null) {
            return this.inactiveSubsetOneOffs;
        }
        int patchingModel = PatchingModel.returnModelCode(instanceOHPath);
        if (patchingModel == 2) {
            this.inactiveSubsetOneOffs = EMPTY_ONEOFF_ARRAY;
            return this.inactiveSubsetOneOffs;
        }
        this.initOneOffs();
        OracleHomeConflictMap conflictMap = OracleHomeConflictMap.getInstance(this.oneOffs, instanceOHPath);
        this.inactiveSubsetOneOffs = new OneOffEntry[conflictMap.getSubsetPatches().size()];
        conflictMap.getSubsetPatches().toArray(this.inactiveSubsetOneOffs);
        return this.inactiveSubsetOneOffs;
    }

    public OneOffEntry[] getInactivePSUTrain() throws RuntimeException {
        if (this.inactivePSUTrain != null) {
            return this.inactivePSUTrain;
        }
        int patchingModel = PatchingModel.returnModelCode(instanceOHPath);
        if (patchingModel == 2) {
            this.inactivePSUTrain = EMPTY_ONEOFF_ARRAY;
            return this.inactivePSUTrain;
        }
        this.initOneOffs();
        OracleHomeConflictMap conflictMap = OracleHomeConflictMap.getInstance(this.oneOffs, instanceOHPath);
        this.inactivePSUTrain = new OneOffEntry[conflictMap.getSubsetPSUTrain().size()];
        conflictMap.getSubsetPSUTrain().toArray(this.inactivePSUTrain);
        CompositePatchCategorizer.setInactivePSUTrain(this.inactivePSUTrain);
        return this.inactivePSUTrain;
    }

    public OneOffEntry[] getInstalledPatchesIncludeInactive() throws RuntimeException {
        if (null != this.installedOneOffsIncludingInactives) {
            return this.installedOneOffsIncludingInactives;
        }
        int patchingModel = PatchingModel.returnModelCode(instanceOHPath);
        if (patchingModel == 1) {
            if (this.oneOffs == null) {
                this.initOneOffs();
            }
            this.installedOneOffsIncludingInactives = Arrays.copyOf(this.oneOffs, this.oneOffs.length);
        } else {
            this.installedOneOffsIncludingInactives = this.getInstalledPatches();
        }
        return this.installedOneOffsIncludingInactives;
    }

    protected void initOneOffs() throws RuntimeException {
        int size;
        ListIterator<OneOffEntry> listIter = cookedOneOffs.listIterator();
        int n2 = size = cookedOneOffs == null ? 0 : cookedOneOffs.size();
        if (null == this.oneOffs) {
            this.oneOffs = new OneOffEntry[size];
            int i2 = 0;
            while (listIter.hasNext()) {
                OneOffEntry obj = listIter.next();
                if (obj instanceof OneOffEntry) {
                    OneOffEntry entry = obj;
                    this.oneOffs[i2] = (OneOffEntry)entry.clone();
                }
                ++i2;
            }
        }
    }

    public InstalledComponent[] getInstalledComponents() throws RuntimeException {
        InstalledComponent[] list = null;
        ListIterator listIter = cookedInstalledProducts.listIterator();
        int size = cookedInstalledProducts == null ? 0 : cookedInstalledProducts.size();
        list = new InstalledComponent[size];
        int i2 = 0;
        while (listIter.hasNext()) {
            Object obj = listIter.next();
            if (obj instanceof InstalledComponent) {
                InstalledComponent c2 = (InstalledComponent)obj;
                list[i2] = (InstalledComponent)c2.clone();
            }
            ++i2;
        }
        return list;
    }

    private HashMap<String, String> getFileVersionMap(OneOffEntry[] oneOffs) {
        HashMap<String, String> fileVerMap = new HashMap<String, String>();
        StringBuffer buff = new StringBuffer("CookedInventory::getFileVersionMap()");
        OLogger.debug(buff);
        buff = new StringBuffer("Constructing HashMap of all incoming Snowball Copy Actions {filename,filename_version} ");
        OLogger.debug(buff);
        for (int i2 = 0; oneOffs != null && i2 < oneOffs.length; ++i2) {
            OneOffEntry myOneOff = oneOffs[i2];
            PatchAction[] pa = myOneOff.getPatchActions();
            for (int j2 = 0; pa != null && j2 < pa.length; ++j2) {
                PatchAction paIndiv = pa[j2];
                if (!(paIndiv instanceof CopyAction)) continue;
                CopyAction act = (CopyAction)paIndiv;
                String file = act.getFilename();
                String version = act.getFileVersion();
                if (!act.isSnowBallCopyAction() || !act.isHasFileVersion()) continue;
                boolean fileExists = fileVerMap.containsKey(file);
                int retVal = -1;
                if (fileExists) {
                    String curFileVersion = fileVerMap.get(file);
                    String[] strSplits = curFileVersion.split("_");
                    String curVersion = strSplits[strSplits.length - 1];
                    retVal = OPatchSessionHelper.isGreaterDecimal(version, curVersion);
                    if (retVal != 1) continue;
                    String fileVersion = file + "_" + version;
                    fileVerMap.put(file, fileVersion);
                    continue;
                }
                String fileVersion = file + "_" + version;
                fileVerMap.put(file, fileVersion);
            }
        }
        return fileVerMap;
    }

    public InstalledComponent[] getNextGenInstalledDistributions() {
        if (OPatchEnv.isNextGen() && nextGenInv != null) {
            InstalledComponent[] comps = new InstalledComponent[installedNextGenDistributions.size()];
            int i2 = 0;
            try {
                for (Distribution dist : installedNextGenDistributions) {
                    comps[i2++] = new InstalledComponent(dist.getName(), new String[]{dist.getVersion()}, true);
                }
            }
            catch (Exception e2) {
                comps = null;
            }
            return comps;
        }
        return null;
    }

    public InstalledComponent[] getNextGenInstalledComponents() {
        if (OPatchEnv.isNextGen() && nextGenInv != null) {
            InstalledComponent[] comps = new InstalledComponent[installedNextGenComponents.size()];
            int i2 = 0;
            try {
                for (Component comp : installedNextGenComponents) {
                    comps[i2++] = new InstalledComponent(comp.getDescription(), new String[]{comp.getVersion()}, false);
                }
            }
            catch (Exception e2) {
                comps = null;
            }
            return comps;
        }
        return null;
    }

    public InstalledComponent[] getTopLevelInstalledComponents() throws RuntimeException {
        InstalledComponent c2;
        InstalledComponent[] list = null;
        ListIterator listIter = cookedInstalledProducts.listIterator();
        ArrayList<InstalledComponent> tmpList = new ArrayList<InstalledComponent>();
        int i2 = 0;
        while (listIter.hasNext()) {
            Object obj = listIter.next();
            if (obj instanceof InstalledComponent && (c2 = (InstalledComponent)obj) != null && c2.isTopLevel()) {
                InstalledComponent tmp = (InstalledComponent)c2.clone();
                tmpList.add(tmp);
            }
            ++i2;
        }
        int size = tmpList.size();
        list = new InstalledComponent[size];
        for (int i3 = 0; i3 < size; ++i3) {
            list[i3] = c2 = (InstalledComponent)tmpList.get(i3);
        }
        return list;
    }

    public boolean isDesiredHome() {
        OiiiVersion desiredVer;
        InstalledComponent[] comps = this.getTopLevelInstalledComponents();
        if (comps.length < 1) {
            return false;
        }
        InstalledComponent dbComp = comps[0];
        if (dbComp == null) {
            return false;
        }
        String topCompID = dbComp.getID();
        if (!topCompID.equals("oracle.crs")) {
            return false;
        }
        String topCompVer = dbComp.getVersion();
        OiiiVersion curVer = new OiiiVersion(topCompVer);
        return curVer.equals(desiredVer = new OiiiVersion("12.1.0.0.0")) || curVer.laterThan(desiredVer);
    }

    private static boolean canGetLangsForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getLang = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getLangs")) continue;
                    getLang = true;
                    break;
                }
            }
            return getLang;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    private static boolean canGetUniqueIDForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getUniq = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getUniqID")) continue;
                    getUniq = true;
                    break;
                }
            }
            return getUniq;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    protected void clearInventory() {
        instance = null;
    }

    public static void destroyObject() {
        if (instance != null) {
            CookedInventory.instance.installedOneOffs = null;
            CookedInventory.instance.inactiveOneOffs = null;
            CookedInventory.instance.inactivePSUTrain = null;
            CookedInventory.instance.inactiveSubsetOneOffs = null;
            CookedInventory.instance.installedOneOffsIncludingInactives = null;
            CookedInventory.instance.oneOffs = null;
        }
        if (cookedInstalledProducts != null) {
            cookedInstalledProducts.clear();
        }
        if (cookedOneOffs != null) {
            cookedOneOffs.clear();
        }
        if (nextGenInv != null) {
            nextGenInv = null;
        }
        if (installedNextGenComponents != null) {
            installedNextGenComponents.clear();
        }
        if (installedNextGenDistributions != null) {
            installedNextGenDistributions.clear();
        }
    }
}

