/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HomeInventoryHelper {
    public static void savePatchMetaFileToInventory(String oracleHomePath, PatchObject patchObject) throws RuntimeException {
        block17: {
            String patchID = patchObject.getPatchID();
            String patchLoc = patchObject.getPatchLocation();
            boolean cont = true;
            StringBuffer buff = new StringBuffer("ApplySession::savePatchMetaFileToInventory()");
            OLogger.debug(buff);
            String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchObject.getTripletPatchID());
            String patchLocation = patchObject.getPatchLocation();
            StringBuffer etcConfig = new StringBuffer(ohPatchLocToSave);
            etcConfig.append(File.separator);
            etcConfig.append("etc");
            etcConfig.append(File.separator);
            String ohEtcLoc = etcConfig.toString();
            StringBuffer custom = new StringBuffer(ohPatchLocToSave);
            custom.append(File.separator);
            custom.append("custom");
            custom.append(File.separator);
            String ohCustomLoc = custom.toString();
            etcConfig.append("config");
            StringBuffer ohActionLoc = new StringBuffer(etcConfig.toString());
            ohActionLoc.append(File.separator);
            ohActionLoc.append("actions.xml");
            StringBuffer ohCompositeLoc = new StringBuffer(etcConfig.toString());
            ohCompositeLoc.append(File.separator);
            ohCompositeLoc.append("composite.xml");
            StringBuffer ohInventoryLoc = new StringBuffer(etcConfig.toString());
            ohInventoryLoc.append(File.separator);
            ohInventoryLoc.append("inventory.xml");
            StringBuffer ohPADLoc = new StringBuffer(etcConfig.toString());
            ohPADLoc.append(File.separator);
            ohPADLoc.append("patchdeploy.xml");
            StringBuffer ohDeployLoc = new StringBuffer(etcConfig.toString());
            ohDeployLoc.append(File.separator);
            ohDeployLoc.append("deploy.xml");
            StringBuffer ohAutomationLoc = new StringBuffer(etcConfig.toString());
            ohAutomationLoc.append(File.separator);
            ohAutomationLoc.append("automation.xml");
            StringBuffer ohInterviewLoc = new StringBuffer(etcConfig.toString());
            ohInterviewLoc.append(File.separator);
            ohInterviewLoc.append("sequence.xml");
            StringBuffer ohEmLoc = new StringBuffer(etcConfig.toString());
            ohEmLoc.append(File.separator);
            ohEmLoc.append("em.xml");
            StringBuffer jlibDir = new StringBuffer(ohPatchLocToSave);
            jlibDir.append(File.separator);
            jlibDir.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            StringBuffer ohOextJar = new StringBuffer(jlibDir.toString());
            ohOextJar.append(File.separator);
            ohOextJar.append("oext.jar");
            File patchLocFile = new File(ohPatchLocToSave);
            StringBuffer patchCustomLoc = new StringBuffer(patchLoc);
            patchCustomLoc.append(File.separator);
            patchCustomLoc.append("custom");
            String patchEtcConfig = PatchObject.getEtcConfigPath(patchLoc);
            StringBuffer patchActionLoc = new StringBuffer(patchEtcConfig);
            patchActionLoc.append(File.separator);
            patchActionLoc.append("actions.xml");
            StringBuffer patchCompositeLoc = new StringBuffer(patchEtcConfig);
            patchCompositeLoc.append(File.separator);
            patchCompositeLoc.append("composite.xml");
            StringBuffer patchInventoryLoc = new StringBuffer(patchEtcConfig);
            patchInventoryLoc.append(File.separator);
            patchInventoryLoc.append("inventory.xml");
            StringBuffer patchChecksumLoc = new StringBuffer(patchEtcConfig.toString());
            patchChecksumLoc.append(File.separator);
            patchChecksumLoc.append("checksum.xml");
            StringBuffer patchPADLoc = new StringBuffer(patchEtcConfig);
            patchPADLoc.append(File.separator);
            patchPADLoc.append("patchdeploy.xml");
            StringBuffer patchDeployLoc = new StringBuffer(patchEtcConfig);
            patchDeployLoc.append(File.separator);
            patchDeployLoc.append("deploy.xml");
            StringBuffer patchAutomationLoc = new StringBuffer(patchEtcConfig);
            patchAutomationLoc.append(File.separator);
            patchAutomationLoc.append("automation.xml");
            StringBuffer patchInterviewLoc = new StringBuffer(patchEtcConfig);
            patchInterviewLoc.append(File.separator);
            patchInterviewLoc.append("sequence.xml");
            StringBuffer checksumLoc = new StringBuffer(etcConfig.toString());
            checksumLoc.append(File.separator);
            checksumLoc.append("checksum.xml");
            StringBuffer patchOextJarFileLoc = new StringBuffer(patchLoc);
            patchOextJarFileLoc.append(File.separator);
            patchOextJarFileLoc.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            patchOextJarFileLoc.append(File.separator);
            patchOextJarFileLoc.append("oext.jar");
            StringBuffer patchEmXmlLoc = new StringBuffer(patchEtcConfig);
            patchEmXmlLoc.append(File.separator);
            patchEmXmlLoc.append("em.xml");
            boolean ok = true;
            if (!patchLocFile.exists() && !(ok = patchLocFile.mkdirs())) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
            patchLocFile = new File(etcConfig.toString());
            if (!patchLocFile.exists() && !(ok = patchLocFile.mkdirs())) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
            patchLocFile = new File(jlibDir.toString());
            if (!patchLocFile.exists() && !(ok = patchLocFile.mkdirs())) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
            String srcInv = patchInventoryLoc.toString();
            String dstInv = ohInventoryLoc.toString();
            File srcInvFile = new File(srcInv);
            File dstInvFile = new File(dstInv);
            String srcChecksum = patchChecksumLoc.toString();
            String dstChecksum = checksumLoc.toString();
            File srcChecksumFile = new File(srcChecksum);
            File dstChecksumFile = new File(dstChecksum);
            String srcPAD = patchPADLoc.toString();
            String dstPAD = ohPADLoc.toString();
            File srcPADFile = new File(srcPAD);
            File dstPADFile = new File(dstPAD);
            String srcDeploy = patchDeployLoc.toString();
            String dstDeploy = ohDeployLoc.toString();
            File srcDeployFile = new File(srcDeploy);
            File dstDeployFile = new File(dstDeploy);
            String srcInterview = patchInterviewLoc.toString();
            String dstInterview = ohInterviewLoc.toString();
            File srcInterviewFile = new File(srcInterview);
            File dstInterviewFile = new File(dstInterview);
            String srcAutomation = patchAutomationLoc.toString();
            String dstAutomation = ohAutomationLoc.toString();
            File srcAutomationFile = new File(srcAutomation);
            File dstAutomationFile = new File(dstAutomation);
            String dstAct = ohActionLoc.toString();
            File dstActFile = new File(dstAct);
            String srcComposite = patchCompositeLoc.toString();
            String dstComposite = ohCompositeLoc.toString();
            File srcCompositeFile = new File(srcComposite);
            File dstCompositeFile = new File(dstComposite);
            File ohEmLocFile = new File(ohEmLoc.toString());
            File patchEmLocFile = new File(patchEmXmlLoc.toString());
            String srcOext = patchOextJarFileLoc.toString();
            String dstOext = ohOextJar.toString();
            File srcOextFile = new File(srcOext);
            File dstOextFile = new File(dstOext);
            if (!srcInvFile.exists()) {
                patchInventoryLoc = new StringBuffer(patchEtcConfig);
                patchInventoryLoc.append(File.separator);
                patchInventoryLoc.append("inventory");
                srcInv = patchInventoryLoc.toString();
                srcInvFile = new File(srcInv);
            }
            SystemCall.copyFile(srcInvFile, dstInvFile);
            if (srcPADFile.exists()) {
                OLogger.printlnOnLog("Saving \"" + dstPAD + "\"" + " to OH.");
                SystemCall.copyFile(srcPADFile, dstPADFile);
            }
            if (srcCompositeFile.exists()) {
                SystemCall.copyFile(srcCompositeFile, dstCompositeFile);
            }
            if (srcDeployFile.exists()) {
                SystemCall.copyFile(srcDeployFile, dstDeployFile);
            }
            if (srcInterviewFile.exists()) {
                SystemCall.copyFile(srcInterviewFile, dstInterviewFile);
            }
            if (srcAutomationFile.exists()) {
                SystemCall.copyFile(srcAutomationFile, dstAutomationFile);
            }
            if (patchEmLocFile.exists()) {
                SystemCall.copyFile(patchEmLocFile, ohEmLocFile);
            }
            OPatchSessionHelper.commitChecksumXML(checksumLoc.toString(), patchObject, oracleHomePath);
            if (!dstChecksumFile.exists() && srcChecksumFile.exists()) {
                SystemCall.copyFile(srcChecksumFile, dstChecksumFile);
            }
            String actionsXML = patchObject.actionsToXML();
            StringReader actionsReader = new StringReader(actionsXML);
            Document actionsDoc = null;
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                actionsDoc = builder.parse(new InputSource(actionsReader));
                FileWriter actionsWriter = new FileWriter(dstActFile);
                StreamResult xmlStream = new StreamResult(actionsWriter);
                DOMSource source = new DOMSource(actionsDoc);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.transform(source, xmlStream);
                actionsWriter.close();
            }
            catch (Exception e2) {
                OPatchStateManagerFactory.getInstance().setErrorCode(116);
                OLogger.printlnOnLog("Not able to save actions.xml file to inventory.");
                RuntimeException re = new RuntimeException(e2);
                throw re;
            }
            if (!srcOextFile.exists()) break block17;
            try {
                SystemCall.copyFile(srcOextFile, dstOextFile);
            }
            catch (RuntimeException e3) {
                OPatchStateManagerFactory.getInstance().setErrorCode(116);
                OLogger.printlnOnLog("Not able to copy oext.jar to inventory.");
                throw e3;
            }
        }
    }

    public static OneOffEntry getOneOffEntry(String oracleHomePath, String patchID) throws RuntimeException {
        PatchObject patchObject = null;
        try {
            patchObject = PatchObject.getInstance(oracleHomePath, patchID, OPatchEnv.needSearchTripletID());
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("Unable to create patchObject\n");
            buff.append("Possible causes are:\n");
            StringBuffer sb = new StringBuffer();
            sb.append("ORACLE_HOME" + File.separator);
            sb.append("inventory");
            sb.append(File.separator);
            sb.append("oneoffs" + File.separator + patchID);
            buff.append("   " + sb);
            buff.append(" is corrupted. ");
            if (e2.getMessage() != null) {
                buff.append(e2.getMessage()).append("\n");
            } else {
                buff.append("\n");
                buff.append("   No read permission to above directory\n");
                buff.append("Please remove one-off entry [ " + patchID);
                String comps = IPMUtil.getCompsXMLLocation(oracleHomePath);
                buff.append(" ] from " + comps + " and retry if above directory corrupted, ");
                buff.append("or Please check the contents of the directory ");
                buff.append(sb);
                buff.append(" for read permission");
            }
            RuntimeException re = new RuntimeException(buff.toString(), e2);
            throw re;
        }
        return patchObject.toOneOffEntry("ORACLE_HOME");
    }

    public static void removePatchDirectoryStructure(String ohPatchLocToSave) throws Exception {
        String actionsFile = PatchObject.getActionFilePath(ohPatchLocToSave);
        String actionsFileWithoutXML = PatchObject.getActionWithOutXMLFilePath(ohPatchLocToSave);
        String inventoryFile = PatchObject.getInventoryFilePath(ohPatchLocToSave);
        String padFile = PatchObject.getPADFilePath(ohPatchLocToSave);
        String inventoryFileWithoutXML = PatchObject.getInventoryWithOutXMLFilePath(ohPatchLocToSave);
        String etcPath = PatchObject.getEtcPath(ohPatchLocToSave);
        String etcConfigPath = PatchObject.getEtcConfigPath(ohPatchLocToSave);
        String jlibPath = PatchObject.getJlibPath(ohPatchLocToSave);
        String oextJarFile = PatchObject.getExternalJarFilePath(ohPatchLocToSave);
        String emXmlFile = PatchObject.getEmXmlFilePath(ohPatchLocToSave);
        String interviewFile = PatchObject.getInterviewFilePath(ohPatchLocToSave);
        String deployFile = PatchObject.getDeployFilePath(ohPatchLocToSave);
        String automationFile = PatchObject.getAutomationFilePath(ohPatchLocToSave);
        String checksumFile = PatchObject.getChecksumFilePath(ohPatchLocToSave);
        String compositeFile = PatchObject.getCompositeFilePath(ohPatchLocToSave);
        File ohCompositeLocFile = new File(compositeFile);
        File patchLocFile = new File(ohPatchLocToSave);
        File patchLocEtcFile = new File(etcPath);
        File patchLocEtcConfigFile = new File(etcConfigPath);
        File ohActionLocFile = new File(actionsFile);
        File ohActionWoXmlLocFile = new File(actionsFileWithoutXML);
        File ohInventoryLocFile = new File(inventoryFile);
        File ohInventoryWoXmlLocFile = new File(inventoryFileWithoutXML);
        File ohPADLocFile = new File(padFile);
        File patchLocJlibFile = new File(jlibPath);
        File ohOextJarFile = new File(oextJarFile);
        File ohEmXmlFile = new File(emXmlFile);
        File ohInterviewFile = new File(interviewFile);
        File ohDeployFile = new File(deployFile);
        File ohAutomationFile = new File(automationFile);
        File ohChecksumFile = new File(checksumFile);
        if (ohInventoryLocFile.exists()) {
            ohInventoryLocFile.delete();
        }
        if (ohPADLocFile.exists()) {
            ohPADLocFile.delete();
        }
        if (ohInventoryWoXmlLocFile.exists()) {
            ohInventoryWoXmlLocFile.delete();
        }
        if (ohEmXmlFile.exists()) {
            ohEmXmlFile.delete();
        }
        if (ohActionLocFile.exists()) {
            ohActionLocFile.delete();
        }
        if (ohCompositeLocFile.exists()) {
            ohCompositeLocFile.delete();
        }
        if (ohChecksumFile.exists()) {
            ohChecksumFile.delete();
        }
        if (ohActionWoXmlLocFile.exists()) {
            ohActionWoXmlLocFile.delete();
        }
        if (ohInterviewFile.exists()) {
            ohInterviewFile.delete();
        }
        if (ohDeployFile.exists()) {
            ohDeployFile.delete();
        }
        if (ohAutomationFile.exists()) {
            ohAutomationFile.delete();
        }
        if (ohOextJarFile.exists()) {
            ohOextJarFile.delete();
        }
        if (patchLocEtcConfigFile.exists()) {
            patchLocEtcConfigFile.delete();
        }
        if (patchLocEtcFile.exists()) {
            patchLocEtcFile.delete();
        }
        if (patchLocJlibFile.exists()) {
            patchLocJlibFile.delete();
        }
        if (patchLocFile.exists()) {
            OPatchSessionHelper.deleteRecurse(ohPatchLocToSave);
        }
    }

    protected static void createMissingInventoryActionsFiles(String oracleHomePath) {
        try {
            StringBuffer ohOneoffs = new StringBuffer(oracleHomePath);
            ohOneoffs.append(File.separator);
            ohOneoffs.append("inventory");
            ohOneoffs.append(File.separator);
            ohOneoffs.append("oneoffs");
            StringBuffer etcConfig = new StringBuffer("etc");
            etcConfig.append(File.separator);
            etcConfig.append("config");
            etcConfig.append(File.separator);
            String actions = etcConfig.toString() + "actions";
            String actionsXML = etcConfig.toString() + "actions.xml";
            String inventory = etcConfig.toString() + "inventory";
            String inventoryXML = etcConfig.toString() + "inventory.xml";
            File oneoffsFolder = new File(ohOneoffs.toString());
            File[] patchSubfolders = oneoffsFolder.listFiles();
            for (int i2 = 0; i2 < patchSubfolders.length; ++i2) {
                if (!patchSubfolders[i2].isDirectory()) continue;
                try {
                    File fileActions = new File(patchSubfolders[i2], actions);
                    File fileActionsXML = new File(patchSubfolders[i2], actionsXML);
                    if (fileActionsXML.exists() && !fileActions.exists()) {
                        SystemCall.copyFile(fileActionsXML, fileActions);
                    }
                }
                catch (Exception e2) {
                    OLogger.printStackTrace(e2);
                }
                try {
                    File fileInventory = new File(patchSubfolders[i2], inventory);
                    File fileInventoryXML = new File(patchSubfolders[i2], inventoryXML);
                    if (!fileInventoryXML.exists() || fileInventory.exists()) continue;
                    SystemCall.copyFile(fileInventoryXML, fileInventory);
                    continue;
                }
                catch (Exception e3) {
                    OLogger.printStackTrace(e3);
                }
            }
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
        }
    }
}

