/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Rac;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.RemoteShellRunCommand;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;

public class hotpatchAction
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
RemoteShellRunCommand,
ConflictDetectable,
Verifiable {
    private String hotPatchName;
    private String path;
    private String mkpatchParams;
    private String fileName;
    private String[] objectNames;
    private String[] modifiedFunctions;
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    public int APPLY_MODE = 0;
    public int ROLLBACK_MODE = 1;
    public int VERIFY_MODE = 2;

    public hotpatchAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        String tmp;
        String hotPatchName = null;
        String path = null;
        String mkpatchParams = null;
        String fileName = null;
        String[] objectNames = null;
        String[] modifiedFunctions = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for onewaycopyAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("name")) {
                hotPatchName = val;
            }
            if (arg.equals("path")) {
                path = val;
            }
            if (arg.equals("mkpatch_param")) {
                mkpatchParams = val;
            }
            if (arg.equals("object_name")) {
                objectNames = val.split(",");
            }
            if (arg.equals("modified_function")) {
                modifiedFunctions = val.split(",");
            }
            if (!arg.equals("filename")) continue;
            fileName = val;
        }
        if (hotPatchName == null || path == null || fileName == null) {
            String errMsg = "The hot patch action is null";
            if (hotPatchName == null) {
                errMsg = errMsg + "The hot patch name is null";
            }
            if (path == null) {
                errMsg = errMsg + "The hot patch destination dir is null";
            }
            if (fileName == null) {
                errMsg = errMsg + "The hot patch destination dir is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.hotPatchName = hotPatchName;
        this.path = tmp = PatchObjectUtil.filterString(path);
        this.mkpatchParams = mkpatchParams;
        this.fileName = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.objectNames = PatchObjectUtil.getPlatformDependentPath(objectNames);
        this.modifiedFunctions = modifiedFunctions;
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public String getHotPatchName() {
        return this.hotPatchName;
    }

    public String getPath() {
        return this.path;
    }

    public String getMKPatchParams() {
        return this.mkpatchParams;
    }

    public String[] getModifiedFunctions() {
        return this.modifiedFunctions;
    }

    public String[] getObjectNames() {
        return this.objectNames;
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.path);
        return buff.toString();
    }

    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.fileName);
        return buff.toString();
    }

    public String getSourceFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        if (OnlinePatchProcessor.isOnlinePart(patchLocation)) {
            buff.append("files_online");
        } else {
            buff.append("files");
        }
        buff.append(File.separator);
        buff.append(this.fileName);
        return buff.toString();
    }

    public String getSourceFileName() {
        String ret = this.fileName;
        int index = ret.lastIndexOf(File.separator);
        if (index != -1) {
            return ret.substring(index + 1);
        }
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[hotpatchAction: Name=\"");
        buff.append(this.hotPatchName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName= \"");
        buff.append(this.fileName);
        buff.append("\", mkpatch params=\"");
        buff.append(this.mkpatchParams);
        buff.append("\", lineNumer=\"");
        buff.append(String.valueOf(this.lineNumber));
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", filesTouched=\"");
        for (int i2 = 0; i2 < this.objectNames.length; ++i2) {
            buff.append(this.objectNames[i2] + "\", \"");
        }
        buff.append("\", modifiedFunctions=\"");
        for (int j2 = 0; j2 < this.modifiedFunctions.length; ++j2) {
            buff.append(this.modifiedFunctions[j2] + "\", \"");
        }
        buff.append("\" rawCopyAction=\" ");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        OLogger.printlnOnLog(buff.toString());
        buff = new StringBuffer("   Patch the Database instances with Online Patch ");
        buff.append(this.fileName);
        return buff.toString();
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("hotpatchAction::restorable()");
        OLogger.debug(buff);
        return true;
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::backupForRestore()\n");
        buff.append("The files copied are new files, they won't be deleted. So nothing to do here.");
        OLogger.debug(buff);
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::restore()");
        OLogger.debug(buff);
        try {
            if (apply) {
                this.updateDBInstances(oracleHomePath, this.ROLLBACK_MODE);
            } else if (rollback) {
                this.updateDBInstances(oracleHomePath, this.APPLY_MODE);
            }
        }
        catch (Exception e2) {
            OLogger.printlnOnLog(e2.getMessage());
        }
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append("The files copied are new files, they won't be deleted. So nothing to do here.");
        return buff.toString();
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("hotpatchAction::rollbackable()");
        OLogger.debug(buff);
        return true;
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::backupForRollback()\n");
        buff.append("The files are new, so nothing to back up for rollback.");
        OLogger.debug(buff);
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer("hotpatchAction::getRollbackScriptEntry()\n");
        buff.append("For hot patch, nothing can be done from rollback script.");
        OLogger.debug(buff);
        return "";
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff;
        block4: {
            buff = new StringBuffer("hotpatchAction::rollback()");
            OLogger.debug(buff);
            buff = new StringBuffer("Connecting to DB and disable/remove the patch.");
            OLogger.debug(buff);
            OLogger.info("OUI-67124", new Object[]{"The patch will be removed from database instances."});
            if (Rules.SystemWrite_continue()) {
                if (!this.updateDBInstances(oracleHomePath, this.ROLLBACK_MODE)) {
                    String verifySqlFile = this.createSQLFile(oracleHomePath, this.VERIFY_MODE, this.getSourceFileName());
                    String rollbackSqlFile = this.createSQLFile(oracleHomePath, this.ROLLBACK_MODE, this.getSourceFileName());
                    OLogger.info("OUI-67509", new Object[]{rollbackSqlFile, verifySqlFile});
                    throw new RuntimeException("Rollback of Online Patch failed on some SIDs.");
                }
                break block4;
            }
            buff = new StringBuffer("Skip invocation of SQL command... ");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer("hotpatchAction done");
        OLogger.verbose(this, buff);
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("hotpatchAction::applicable()");
        OLogger.debug(buff);
        File destinationDir = new File(this.path);
        if (!(!destinationDir.exists() || destinationDir.canRead() && destinationDir.canWrite())) {
            this.nonApplicableDesc = "Destination directory is not readable or writable.";
            return false;
        }
        String srcFile = this.getSourceFile(patchLocation);
        File sf = new File(srcFile);
        if (!sf.exists() || !sf.canRead()) {
            this.nonApplicableDesc = "The file \"" + srcFile + "\" does not exist or is not readable.";
            return false;
        }
        String dst = this.getParentFilePath(oracleHomePath);
        File df = new File(dst);
        if (df.exists()) {
            long patchFileSize = sf.length();
            long ohFileSize = df.length();
            if (ohFileSize != patchFileSize) {
                this.nonApplicableDesc = "The file by name \"" + dst + "\" already exists in the Oracle Home, but its size is different in the Patch. OPatch cannot overwrite the file as it may be in use.";
                return false;
            }
        }
        for (int j2 = 0; j2 < this.objectNames.length; ++j2) {
            int endIndex = this.objectNames[j2].lastIndexOf(File.separator);
            String libraryFile = this.objectNames[j2].substring(0, endIndex);
            libraryFile = oracleHomePath + File.separator + libraryFile;
            File f2 = new File(libraryFile);
            if (f2.exists()) continue;
            this.nonApplicableDesc = "The library file \"" + libraryFile + "\" does not exist.";
            return false;
        }
        return true;
    }

    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        block4: {
            StringBuffer buff = new StringBuffer("hotpatchAction::verify()");
            OLogger.debug(buff);
            buff = new StringBuffer("Connecting to DB to verify the patch.");
            OLogger.debug(buff);
            if (Rules.SystemWrite_continue()) {
                if (!this.updateDBInstances(oracleHomePath, this.VERIFY_MODE)) {
                    String applySqlFile = this.createSQLFile(oracleHomePath, this.APPLY_MODE, this.getSourceFileName());
                    String verifySqlFile = this.createSQLFile(oracleHomePath, this.VERIFY_MODE, this.getSourceFileName());
                    OLogger.info("OUI-67505", new Object[]{applySqlFile, verifySqlFile});
                    return false;
                }
                break block4;
            }
            buff = new StringBuffer("Skipping verification... ");
            OLogger.println(buff.toString());
            return true;
        }
        return true;
    }

    private String createSQLFile(String oracleHomePath, int mode, String patchFile) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::createSQLFile()");
        OLogger.debug(buff);
        if (mode == this.APPLY_MODE) {
            buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
            buff.append(File.separator);
            buff.append("oradebug_apply.sql");
            StringBuffer oradebugCmds = new StringBuffer();
            oradebugCmds.append("oradebug patch install ");
            oradebugCmds.append(patchFile);
            oradebugCmds.append(";\noradebug patch enable ");
            oradebugCmds.append(patchFile);
            oradebugCmds.append(";\nexit;\n");
            try {
                File f2 = new File(buff.toString());
                if (!f2.exists()) {
                    f2.createNewFile();
                }
                if (!f2.exists()) {
                    throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
                }
                FileWriter fw = new FileWriter(f2);
                fw.write(oradebugCmds.toString());
                fw.close();
            }
            catch (IOException e2) {
                RuntimeException re = new RuntimeException(e2);
                throw re;
            }
        }
        if (mode == this.ROLLBACK_MODE) {
            buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
            buff.append(File.separator);
            buff.append("oradebug_rollback.sql");
            StringBuffer oradebugCmds = new StringBuffer();
            oradebugCmds.append("oradebug patch disable ");
            oradebugCmds.append(patchFile);
            oradebugCmds.append("\noradebug patch remove ");
            oradebugCmds.append(patchFile);
            oradebugCmds.append(";\nexit;\n");
            try {
                File f3 = new File(buff.toString());
                if (!f3.exists()) {
                    f3.createNewFile();
                }
                if (!f3.exists()) {
                    throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
                }
                FileWriter fw = new FileWriter(f3);
                fw.write(oradebugCmds.toString());
                fw.close();
            }
            catch (IOException e3) {
                RuntimeException re = new RuntimeException(e3);
                throw re;
            }
        }
        if (mode == this.VERIFY_MODE) {
            buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, OPatchEnv.getCookedPatchID()));
            buff.append(File.separator);
            buff.append("oradebug_verify.sql");
            StringBuffer oradebugCmds = new StringBuffer();
            oradebugCmds.append("oradebug patch list functions;\n");
            oradebugCmds.append("exit;\n");
            try {
                File f4 = new File(buff.toString());
                if (!f4.exists()) {
                    f4.createNewFile();
                }
                if (!f4.exists()) {
                    throw new RuntimeException("Cannot create \"" + buff.toString() + "\"");
                }
                FileWriter fw = new FileWriter(f4);
                fw.write(oradebugCmds.toString());
                fw.close();
            }
            catch (IOException e4) {
                RuntimeException re = new RuntimeException(e4);
                throw re;
            }
        }
        return buff.toString();
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff;
        block25: {
            buff = new StringBuffer("hotpatchAction::apply()");
            OLogger.debug(buff);
            String src = this.getSourceFile(patchLocation);
            String dst = this.getParentFilePath(oracleHomePath);
            boolean cont = Rules.SystemWrite_continue();
            buff = new StringBuffer(" OnlinePatchAction: src=\"");
            buff.append(src);
            buff.append("\", dst=\"");
            buff.append(dst);
            buff.append("\"");
            OLogger.verbose(this, buff);
            File srcFile = new File(src);
            File dstFile = new File(dst);
            File parentFile = dstFile.getParentFile();
            boolean pchFileCopied = false;
            if (!parentFile.exists()) {
                if (cont) {
                    parentFile.mkdirs();
                } else {
                    OLogger.debug("Directory " + parentFile + " no exist. Ignored since we are in analyze mode.");
                }
            }
            if (!parentFile.exists() && cont) {
                buff = new StringBuffer("hotpatchAction::apply(): cannot mkdirs on parent directory ");
                try {
                    buff.append(parentFile.getCanonicalPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            if (!srcFile.exists()) {
                buff = new StringBuffer("hotpatchAction::apply()");
                buff.append(": the src file is not there.  This should not happen because ");
                buff.append("caller has certified that this hotpatchAction is applicable. src = ");
                buff.append(src);
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            try {
                if (cont && !dstFile.exists()) {
                    StringBuffer ts = new StringBuffer("Start hotpatch Action at ");
                    OLogger.logTime(ts);
                    SystemCall.copyFile(srcFile, dstFile);
                    pchFileCopied = true;
                    ts = new StringBuffer("Finish hotpatch Action at ");
                    OLogger.logTime(ts);
                } else {
                    buff = new StringBuffer("hotpatchAction::apply() skips copying the file from ");
                    buff.append(srcFile);
                    buff.append(" to ");
                    buff.append(dstFile);
                    OLogger.debug(buff);
                }
            }
            catch (RuntimeException e2) {
                OLogger.printStackTrace(e2);
                String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
                buff = new StringBuffer("hotpatchAction::apply() failed: \"");
                buff.append(e2.getMessage());
                buff.append("\"");
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(warnMsg);
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            File ohOracleBinary = new File(oracleHomePath + File.separator + "bin" + File.separator + "oracle");
            long ohOracleBinTS = ohOracleBinary.lastModified();
            long pchFileTS = dstFile.lastModified();
            if (!pchFileCopied && ohOracleBinTS > pchFileTS || pchFileCopied) {
                buff = new StringBuffer("hotpatchAction::apply()Now running the mkpatch command on it.");
                OLogger.debug(buff);
                OPatchProperty opp = new OPatchProperty();
                StringBuffer mkpatchCommand = null;
                try {
                    mkpatchCommand = new StringBuffer(opp.getMkPatchCommand());
                    String mkpatchParams = this.getMKPatchParams();
                    if (mkpatchParams == null || mkpatchParams.equals("")) {
                        mkpatchParams = "-fixup";
                    }
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(mkpatchParams);
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(this.getSourceFileName());
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(opp.getOracleBinary());
                }
                catch (Exception e3) {
                    buff = new StringBuffer("hotpatchAction::apply()\n");
                    buff.append("    " + e3.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException("Command 'mkpatch' not found.", e3);
                    throw re;
                }
                String cmd = mkpatchCommand.toString();
                if (Rules.isMkPatchRequired()) {
                    buff = new StringBuffer("hotpatchAction::apply(), set mkpatch command to \"");
                    buff.append(cmd);
                    buff.append("\"");
                    OLogger.debug(buff);
                    OLogger.log(OLogger.FINE, "Executing '" + cmd + "'");
                } else {
                    buff = new StringBuffer("Skipping validation and execution of mkpatch command ...");
                    OLogger.debug(buff);
                }
                if (cont && Rules.isMkPatchRequired()) {
                    OLogger.info("OUI-67504", new Object[]{this.getSourceFileName()});
                    String[] systemCommands = new String[]{cmd};
                    SystemCall.ExecReturn ret = SystemCall.runtimeExec(systemCommands, this.getParentDirPath(oracleHomePath));
                    boolean ok = ret.isOK();
                    buff = new StringBuffer(ret.toString());
                    OLogger.debug(buff);
                    if (!ok) {
                        buff = new StringBuffer("hotpatchAction::apply() failed: \"");
                        String errMsg = ret.getErrorMessage();
                        if (errMsg == null || errMsg.equals("")) {
                            errMsg = ret.getNormalMessage();
                        }
                        buff.append(errMsg);
                        buff.append("\"");
                        throw new RuntimeException(buff.toString());
                    }
                }
            } else {
                buff = new StringBuffer("Skipping invoking \"");
                buff.append("mkpatch");
                buff.append("\".");
                OLogger.log(OLogger.FINE, buff.toString());
            }
            if (cont) {
                if (!this.updateDBInstances(oracleHomePath, this.APPLY_MODE)) {
                    throw new RuntimeException("Apply of Online Patch failed on some SIDs.");
                }
                break block25;
            }
            buff = new StringBuffer("Skip invocation of SQL commands...");
            OLogger.println(buff.toString());
        }
        buff = new StringBuffer("hotpatchAction done");
        OLogger.verbose(this, buff);
    }

    public boolean updateDBInstances(String oracleHomePath, int mode) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::updateDBInstances()");
        buff.append("\nNow, lets connect to DB and enable/install the patch.");
        OLogger.debug(buff);
        String sqlFilePath = this.createSQLFile(oracleHomePath, mode, this.getSourceFileName());
        String localNode = OPatchEnv.getLocalNode();
        boolean allSIDsPassed = true;
        if (Rules.SystemWrite_continue()) {
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] dbUsers = OPatchEnv.getDBUsers();
            String[] dbPasswds = OPatchEnv.getDBPasswds();
            String[] dbNodes = OPatchEnv.getDBNodes();
            Boolean[] dbStatus = OPatchEnv.getSIDStatus();
            if (dbSids == null || dbSids.length < 1) {
                RuntimeException re = new RuntimeException("Onlinepatch : Database SIDs are not provided.");
                throw re;
            }
            for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
                String regEx;
                String str;
                int stateIndex;
                if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode)) continue;
                if (mode == this.APPLY_MODE) {
                    OLogger.info("OUI-67502", new Object[]{this.getSourceFileName(), dbSids[sidIter]});
                } else if (mode == this.ROLLBACK_MODE) {
                    OLogger.info("OUI-67503", new Object[]{this.getSourceFileName(), dbSids[sidIter]});
                } else if (mode == this.VERIFY_MODE) {
                    OLogger.log(OLogger.FINE, OLogger.getString("OUI-67510", new Object[]{this.getSourceFileName(), dbSids[sidIter]}));
                }
                boolean ok = false;
                SystemCall.ExecReturn ret = null;
                if (dbStatus[sidIter].booleanValue()) {
                    if (mode == this.ROLLBACK_MODE) {
                        ok = OPatchEnv.createNewOnlineRollbackFile(oracleHomePath, this.getSourceFileName(), dbSids[sidIter]);
                        String rollbackDelFile = OPatchEnv.getOnlineRollbackDeleteFile(oracleHomePath, this.getSourceFileName(), dbSids[sidIter]);
                        OLogger.printlnOnLog("DB instance \"" + dbSids[sidIter] + "\" is down. Created online rollback file \"" + rollbackDelFile + "\"");
                    } else if (mode == this.VERIFY_MODE) {
                        continue;
                    }
                } else {
                    ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter]);
                    ok = ret.isOK();
                }
                if (!ok) {
                    if (mode == this.APPLY_MODE) {
                        OLogger.warn("OUI-67506", new Object[]{this.getSourceFileName(), dbSids[sidIter], ret.getErrorMessage()});
                    } else if (mode == this.ROLLBACK_MODE) {
                        String errMsg = null;
                        errMsg = dbStatus[sidIter] != false ? "Unable to create file for instance-down online rollback : " + OPatchEnv.getOnlineRollbackDeleteFile(oracleHomePath, this.getSourceFileName(), dbSids[sidIter]) : ret.getErrorMessage();
                        OLogger.warn("OUI-67507", new Object[]{this.getSourceFileName(), dbSids[sidIter], errMsg});
                    } else if (mode == this.VERIFY_MODE) {
                        OLogger.warn("OUI-67508", new Object[]{this.getSourceFileName(), dbSids[sidIter], ret.getErrorMessage()});
                    }
                    allSIDsPassed = false;
                    continue;
                }
                if (mode == this.APPLY_MODE || mode == this.ROLLBACK_MODE && !dbStatus[sidIter].booleanValue()) {
                    String searchStr = "Statement processed";
                    String normalOutput = ret.getNormalMessage();
                    int ind = normalOutput.indexOf(searchStr);
                    if (ind != -1) {
                        if ((ind = normalOutput.indexOf(searchStr, ind + searchStr.length())) != -1) continue;
                        if (mode == this.APPLY_MODE) {
                            OLogger.warn("OUI-67506", new Object[]{this.getSourceFileName(), dbSids[sidIter], normalOutput});
                        } else if (mode == this.ROLLBACK_MODE) {
                            OLogger.warn("OUI-67507", new Object[]{this.getSourceFileName(), dbSids[sidIter], normalOutput});
                        }
                        allSIDsPassed = false;
                        continue;
                    }
                    boolean patchAlreadyInstalled = false;
                    if (mode == this.APPLY_MODE) {
                        if (normalOutput.indexOf("Patch already installed") != -1 && normalOutput.indexOf("Patch file already enabled") != -1) {
                            patchAlreadyInstalled = true;
                        }
                        OLogger.warn("OUI-67506", new Object[]{this.getSourceFileName(), dbSids[sidIter], normalOutput});
                    } else if (mode == this.ROLLBACK_MODE) {
                        OLogger.warn("OUI-67507", new Object[]{this.getSourceFileName(), dbSids[sidIter], normalOutput});
                    }
                    if (patchAlreadyInstalled) continue;
                    allSIDsPassed = false;
                    continue;
                }
                if (mode != this.VERIFY_MODE) continue;
                String normalOutput = ret.getNormalMessage();
                int fileIndex = normalOutput.indexOf(this.getSourceFileName());
                if (fileIndex != -1 && (stateIndex = normalOutput.indexOf("ENABLED", fileIndex + this.getSourceFileName().length())) != -1 && (str = normalOutput.substring(fileIndex + this.getSourceFileName().length(), stateIndex)).matches(regEx = "\\s+")) {
                    buff = new StringBuffer("Verification of hotpatch '");
                    buff.append(this.getSourceFileName());
                    buff.append("' on database instance with SID = ");
                    buff.append(dbSids[sidIter]);
                    buff.append(" passed.");
                    OLogger.debug(buff);
                    continue;
                }
                OLogger.warn("OUI-67508", new Object[]{this.getSourceFileName(), dbSids[sidIter], normalOutput});
                allSIDsPassed = false;
            }
        }
        return allSIDsPassed;
    }

    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        String src = this.fileName;
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67513", new Object[]{owningComp, src});
        return desc;
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        String src = this.fileName;
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67513", new Object[]{owningComp, src});
        return desc;
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    public String getFilePathToPropagate(String oracleHomePath) {
        return this.getParentFilePath(oracleHomePath);
    }

    public String getRemoteCommand(String oracleHomePath, boolean patchApply) throws RuntimeException {
        StringBuffer buff = new StringBuffer("hotpatchAction::getRemoteCommand ");
        OLogger.debug(buff);
        if (Rules.isMkPatchRequired()) {
            OPatchProperty opp = new OPatchProperty();
            StringBuffer cmd = new StringBuffer();
            if (patchApply) {
                StringBuffer mkpatchCommand = null;
                try {
                    mkpatchCommand = new StringBuffer(opp.getMkPatchCommand());
                    String mkpatchParams = this.getMKPatchParams();
                    if (mkpatchParams == null || mkpatchParams.equals("")) {
                        mkpatchParams = "-fixup";
                    }
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(mkpatchParams);
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(this.getParentFilePath(oracleHomePath));
                    mkpatchCommand.append(" ");
                    mkpatchCommand.append(opp.getOracleBinary());
                }
                catch (Exception e2) {
                    buff = new StringBuffer("hotpatchAction::getRemoteCommand()\n");
                    buff.append("    " + e2.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException("Command 'mkpatch' not found.", e2);
                    throw re;
                }
                cmd.append(mkpatchCommand.toString());
                buff = new StringBuffer("hotpatchAction::getRemoteCommand() ");
                buff.append("remote mkpatch cmd is \"");
                buff.append(cmd.toString());
                buff.append("\"");
                OLogger.debug(buff);
            } else {
                buff = new StringBuffer("hotpatchAction::getRemoteCommand() ");
                buff.append("Mkpatch should be run for apply only.");
                OLogger.debug(buff);
            }
            return cmd.toString();
        }
        buff = new StringBuffer("hotPatchAction::getRemoteCommand() - is a NoOp");
        OLogger.debug(buff);
        return "";
    }

    public void runRemoteCommand(String oracleHomePath, boolean patchApply, String cookedPatchID, String[] remoteNodes, String localNode) throws RuntimeException {
        if (OPatchEnv.isWindows()) {
            if (patchApply) {
                OLogger.warn("OUI-67624");
            } else {
                OLogger.warn("OUI-67625");
            }
            return;
        }
        StringBuffer buff = new StringBuffer("hotpatchAction::getRemoteCommand() ");
        buff.append("Building the opatch util command ...");
        OLogger.debug(buff);
        StringBuffer opatchUtilCmd = new StringBuffer(oracleHomePath);
        opatchUtilCmd.append(File.separator);
        opatchUtilCmd.append("OPatch");
        opatchUtilCmd.append(File.separator);
        opatchUtilCmd.append("opatch");
        opatchUtilCmd.append(" util");
        if (patchApply) {
            opatchUtilCmd.append(" enableOnlinePatch");
        } else {
            opatchUtilCmd.append(" disableOnlinePatch");
        }
        opatchUtilCmd.append(" -local ");
        if (patchApply) {
            opatchUtilCmd.append(" -id ");
            String patchID = cookedPatchID;
            opatchUtilCmd.append(patchID);
        } else {
            opatchUtilCmd.append(" -ph ");
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            opatchUtilCmd.append(originalPatchLoc);
        }
        opatchUtilCmd.append(" -oh ");
        opatchUtilCmd.append(oracleHomePath);
        if (!OPatchEnv.isWindows()) {
            opatchUtilCmd.append(" -invPtrLoc ");
            opatchUtilCmd.append(OPatchEnv.getInvPtrLoc());
        }
        opatchUtilCmd.append(" -connectString ");
        String[] dbNodes = OPatchEnv.getDBNodes();
        String[] dbSIDs = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswds = OPatchEnv.getDBPasswds();
        for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
            String nodeName = remoteNodes[i2];
            StringBuffer sids = new StringBuffer();
            if (nodeName.equals(localNode) || nodeName.equals("")) continue;
            StringBuffer connStr = new StringBuffer(" ");
            boolean firstConnStr = true;
            for (int j2 = 0; j2 < dbSIDs.length; ++j2) {
                if (!dbNodes[j2].equals(nodeName)) continue;
                if (!firstConnStr) {
                    connStr.append(",");
                    sids.append(" ,");
                }
                connStr.append(dbSIDs[j2]);
                connStr.append(":");
                connStr.append(dbUsers[j2]);
                connStr.append(":");
                connStr.append(dbPasswds[j2]);
                connStr.append(":");
                connStr.append(":");
                firstConnStr = false;
                sids.append(dbSIDs[j2]);
            }
            if (firstConnStr) continue;
            if (patchApply) {
                OLogger.info("OUI-67511", new Object[]{this.getSourceFileName(), sids.toString(), nodeName});
            } else {
                OLogger.info("OUI-67512", new Object[]{this.getSourceFileName(), sids.toString(), nodeName});
            }
            String cmd = opatchUtilCmd.toString() + connStr.toString();
            Rac.srvmRunRemoteCommand(nodeName, cmd);
            continue;
        }
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("hotpatchAction::conflictDetectable()  ");
        boolean tmpB = this.objectNames != null && this.objectNames.length > 0;
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        return this.objectNames;
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        String[] fileTouched = new String[2];
        for (int i2 = 0; i2 < this.objectNames.length; ++i2) {
            int endIndex = this.objectNames[i2].lastIndexOf(File.separator);
            String parentFile = this.objectNames[i2].substring(0, endIndex);
            parentFile = oracleHomePath + File.separator + parentFile;
            String childFile = this.objectNames[i2].substring(endIndex);
            fileTouched[0] = parentFile;
            fileTouched[1] = childFile;
            if (!hotpatchAction.isFileConflict(oracleHomePath, oneoffs, fileTouched)) continue;
            StringBuffer buff = new StringBuffer();
            for (int fileIter = 0; fileIter < fileTouched.length; ++fileIter) {
                buff.append(fileTouched[fileIter]);
                if (fileIter + 1 == fileTouched.length) continue;
                buff.append(":");
            }
            buff.append(",");
            return buff.toString();
        }
        return "";
    }

    private static boolean isFileConflict(String oracleHomePath, OneOffEntry[] ohOneOffs, String[] filesPath) {
        OneOffEntry[] fileConflictList = new OneOffEntry[]{};
        StringBuffer tmpS = new StringBuffer();
        StringBuffer buff = null;
        if (ohOneOffs != null && ohOneOffs.length > 0) {
            ArrayList<OneOffEntry> conflictList = new ArrayList<OneOffEntry>();
            for (int i2 = 0; i2 < ohOneOffs.length; ++i2) {
                buff = new StringBuffer();
                String f_patchID = ohOneOffs[i2].getID();
                PatchAction[] piActions = ohOneOffs[i2].getPatchActions();
                if (piActions.length == 0) {
                    RuntimeException e2 = new RuntimeException("No actions defined for patch: " + f_patchID);
                    throw e2;
                }
                boolean flag = false;
                for (int j2 = 0; j2 < piActions.length; ++j2) {
                    RuntimeException re;
                    ConflictDetectable cdi;
                    tmpS = new StringBuffer("hotpatchAction:isFileConflict: Action in inventory ");
                    tmpS.append(piActions[j2].toString());
                    OLogger.debug(tmpS);
                    if (piActions[j2] instanceof hotpatchAction) {
                        try {
                            cdi = (ConflictDetectable)((Object)piActions[j2]);
                            String[] filesList = cdi.filesTouched(oracleHomePath);
                            String[][] filesjList = hotpatchAction.processObjectName(oracleHomePath, filesList);
                            for (int newj = 0; newj < filesjList.length; ++newj) {
                                int s;
                                String[] filesj = filesjList[newj];
                                tmpS = new StringBuffer("hotpatchAction:isFileConflict: Files to be compared ");
                                tmpS.append(" Files touched by hotpatch: (");
                                for (s = 0; s < filesj.length; ++s) {
                                    tmpS.append(" ");
                                    tmpS.append(filesj[s]);
                                }
                                tmpS.append(") Files to be touched by the patch to be applied: (");
                                for (s = 0; s < filesPath.length; ++s) {
                                    tmpS.append(" ");
                                    tmpS.append(filesPath[s]);
                                }
                                tmpS.append(")");
                                OLogger.debug(tmpS);
                                if (!ConflictHandler.compareFilesForConflict(filesj, filesPath)) continue;
                                tmpS = new StringBuffer("hotpatchAction:isFileConflict: There is FILE CONFLICT");
                                OLogger.debug(tmpS);
                                flag = true;
                                for (int fileIter = 0; fileIter < filesj.length; ++fileIter) {
                                    buff.append(filesj[fileIter]);
                                    if (fileIter + 1 == filesj.length) continue;
                                    buff.append(":");
                                }
                                buff.append(",");
                            }
                            continue;
                        }
                        catch (Throwable t) {
                            re = new RuntimeException(t.getMessage());
                            re.setStackTrace(t.getStackTrace());
                            throw re;
                        }
                    }
                    if (!(piActions[j2] instanceof ConflictDetectable)) continue;
                    try {
                        int s;
                        cdi = (ConflictDetectable)((Object)piActions[j2]);
                        String[] filesj = cdi.filesTouched(oracleHomePath);
                        tmpS = new StringBuffer("hotpatchAction:isFileConflict: Files to be compared ");
                        tmpS.append(" Files touched in inventory: (");
                        for (s = 0; s < filesj.length; ++s) {
                            tmpS.append(" ");
                            tmpS.append(filesj[s]);
                        }
                        tmpS.append(") Files to be touched by the patch to be applied: (");
                        for (s = 0; s < filesPath.length; ++s) {
                            tmpS.append(" ");
                            tmpS.append(filesPath[s]);
                        }
                        tmpS.append(")");
                        OLogger.debug(tmpS);
                        if (!ConflictHandler.compareFilesForConflict(filesj, filesPath)) continue;
                        tmpS = new StringBuffer("hotpatchAction:isFileConflict: There is FILE CONFLICT");
                        OLogger.debug(tmpS);
                        flag = true;
                        for (int fileIter = 0; fileIter < filesj.length; ++fileIter) {
                            buff.append(filesj[fileIter]);
                            if (fileIter + 1 == filesj.length) continue;
                            buff.append(":");
                        }
                        buff.append(",");
                        continue;
                    }
                    catch (Throwable t) {
                        re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                }
                if (!flag) continue;
                conflictList.add(ohOneOffs[i2]);
            }
            if (conflictList.size() > 0) {
                fileConflictList = new OneOffEntry[conflictList.size()];
                conflictList.toArray(fileConflictList);
            }
        }
        tmpS = new StringBuffer("hotpatchAction::isFileConflict: conflict list ");
        for (int i3 = 0; i3 < fileConflictList.length; ++i3) {
            tmpS.append(" ");
            tmpS.append(fileConflictList[i3].getID());
        }
        OLogger.debug(tmpS);
        return fileConflictList.length > 0;
    }

    public static String[][] processObjectName(String oracleHomePath, String[] files) {
        String[][] filesReturn = new String[files.length][];
        for (int i2 = 0; i2 < files.length; ++i2) {
            String[] fileTouched = new String[2];
            int endIndex = files[i2].lastIndexOf(File.separator);
            String parentFile = files[i2].substring(0, endIndex);
            parentFile = oracleHomePath + File.separator + parentFile;
            String childFile = files[i2].substring(endIndex);
            fileTouched[0] = parentFile;
            fileTouched[1] = childFile;
            filesReturn[i2] = fileTouched;
        }
        return filesReturn;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof hotpatchAction) {
            String myHotName = this.getHotPatchName();
            String myPath = this.getPath();
            String myMKPatchParam = this.getMKPatchParams();
            hotpatchAction it = (hotpatchAction)o2;
            String itHotName = it.getHotPatchName();
            String itPath = it.getPath();
            String itMKPatchParam = it.getMKPatchParams();
            if (myHotName.equals(itHotName) && myPath.equals(itPath) && myMKPatchParam.equals(itMKPatchParam)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.hotPatchName.length();
        result = 37 * result + this.path.length();
        if (this.mkpatchParams != null) {
            result = 37 * result + this.mkpatchParams.length();
        }
        return result;
    }

    public String getActionName() {
        return "hotpatchAction";
    }

    public String getActionDesc() {
        return "Patch the bits in memory dynamically.";
    }

    public String getApplyDescription(String oracleHomePath) {
        return "The patch will be installed on active database instances.";
    }

    public String getChildPath() {
        return this.getSourceFileName();
    }

    public String getRollbackDescription(String oracleHomePath) {
        return "The patch will be removed from database instances.";
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 0;
    }

    public void checkMemory(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("hotpatchAction::checkMemory()");
        String pchFilePath = this.getSourceFile(patchLocation);
        File pchFile = new File(pchFilePath);
        if (!pchFile.exists()) {
            buff = new StringBuffer("hotpatchAction::checkMemory()");
            buff.append(": the pch file is not there.  This should not happen because ");
            buff.append("caller has certified that this hotpatchAction is applicable. pchFilePath = ");
            buff.append(pchFilePath);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswds = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        Boolean[] dbStatus = OPatchEnv.getSIDStatus();
        String localNode = OPatchEnv.getLocalNode();
        String dbSid = null;
        String dbUser = null;
        String dbPasswd = null;
        if (dbSids != null) {
            for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
                if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode)) continue;
                dbUser = dbUsers[sidIter];
                dbPasswd = dbPasswds[sidIter];
                dbSid = dbSids[sidIter];
            }
        }
        SystemCall.ExecReturn ret = null;
        boolean ok = false;
        ret = SQLUtilities.runMemoryReqs(oracleHomePath, pchFilePath, dbUser, dbPasswd, dbSid);
        ok = ret.isOK();
        if (!ok) {
            OLogger.warn("OUI-67508", new Object[]{this.getSourceFileName(), dbSid, ret.getErrorMessage()});
        } else {
            OLogger.println(ret.getNormalMessage());
        }
    }
}

