/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ops;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.PatchingModel;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInfo {
    private int modelCode = 1;
    private String execMode = "CLI";

    public int getModelCode() {
        return PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
    }

    public String getExecMode() {
        if (OPatchEnv.isOPatchSDKMode()) {
            return "SDK";
        }
        return "CLI";
    }

    public String getOUIVersion() {
        String ouiVersion = OPatchSDK.getOUIVersion();
        String[] ouiVerParts = ouiVersion.split("\\.");
        String tempOuiVer = ouiVerParts[0] + "." + ouiVerParts[1];
        return tempOuiVer;
    }

    public boolean isOUIExists() {
        StringBuffer ouiLocation = null;
        String oracleHomePath = OPatchEnv.getOracleHome();
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        OLogger.debug("isOUIBased: Path to oui location: " + ouiLocation.toString());
        File f2 = new File(ouiLocation.toString());
        return f2.exists();
    }

    public ArrayList<File> getCasJars() {
        ArrayList<File> casJars = new ArrayList<File>();
        try {
            File pathToClass = this.locateClass("oracle.opatch.ops.OPS", this.getClass().getClassLoader());
            if (pathToClass != null && pathToClass.exists()) {
                File[] files;
                File classDir = pathToClass.isDirectory() ? pathToClass : new File(pathToClass.getParent());
                for (File casJar : files = classDir.listFiles()) {
                    if (!casJar.toString().contains("com.oracle.glcm.patch.content-store")) continue;
                    casJars.add(casJar);
                }
            }
        }
        catch (RuntimeException e2) {
            OLogger.println("OPatch cannot locate CAS jar.");
        }
        return casJars;
    }

    public boolean isCASJarExists() {
        boolean isExist = false;
        try {
            File pathToClass = this.locateClass("oracle.opatch.ops.OPS", this.getClass().getClassLoader());
            if (pathToClass != null && pathToClass.exists()) {
                File classDir = pathToClass.isDirectory() ? pathToClass : new File(pathToClass.getParent());
                File casJar = new File(classDir + File.separator + "com.oracle.glcm.patch.content-store_12.2.0.3.2.jar");
                if (casJar.exists()) {
                    isExist = true;
                }
                OLogger.debug("isCASJarExists: Path to CAS jar: " + classDir);
                OLogger.debug("isCASJarExists: Is CAS jar exists: " + isExist);
            }
        }
        catch (RuntimeException re) {
            OLogger.println("OPatch cannot locate CAS jar.");
        }
        return isExist;
    }

    private File locateClass(String className, ClassLoader classloader) throws RuntimeException {
        if (className != null && classloader != null) {
            try {
                URL classResource = classloader.getResource(className.endsWith(".class") ? className : className.replace('.', '/') + ".class");
                if (classResource != null) {
                    String fileComponent = classResource.getFile();
                    if (classResource.getProtocol().equals("file")) {
                        int classFileIndex = fileComponent.lastIndexOf(className);
                        if (classFileIndex != -1) {
                            fileComponent = fileComponent.substring(0, classFileIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        return new File(URLDecoder.decode(fileComponent, "UTF-8"));
                    }
                    if (classResource.getProtocol().equals("jar")) {
                        int classSeparatorIndex = fileComponent.lastIndexOf("!");
                        if (classSeparatorIndex != -1) {
                            fileComponent = fileComponent.substring(0, classSeparatorIndex);
                        }
                        fileComponent = fileComponent.replaceAll("\\+", "%2B");
                        URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                        return new File(u.getFile());
                    }
                } else {
                    OLogger.println("Unable to locate class " + className);
                }
            }
            catch (UnsupportedEncodingException e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            catch (MalformedURLException e3) {
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
        }
        return null;
    }
}

