/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ops;

import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchException;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.ISupport;

public class Support
implements ISupport {
    private boolean fileBusyPatching = false;
    private Boolean fileBusyPatchingCache = null;

    public boolean isSupport(Feature feature) {
        boolean isSupport = false;
        if (feature.equals((Object)Feature.SYMBOL)) {
            isSupport = this.isOUISymbolSupported();
        }
        if (feature.equals((Object)Feature.FILE_BUSY_PATCHING)) {
            return this.isFileBusyPatchingEnabled();
        }
        if (feature.equals((Object)Feature.CAS)) {
            isSupport = this.isCASEnabled(new EnvInfo());
        }
        if (feature.equals((Object)Feature.FA_TWO_PHASE)) {
            isSupport = this.isFATwoPhaseEnabled(new EnvInfo());
        }
        if (feature.equals((Object)Feature.OUI_BASED)) {
            isSupport = this.isOUIBased(new EnvInfo());
        }
        return isSupport;
    }

    public boolean isOUISymbolSupported() {
        boolean isOUISymbolSupported = true;
        try {
            Class<?> clazz = Class.forName("com.oracle.cie.gdr.external.InventoryUtil");
        }
        catch (ClassNotFoundException ex) {
            isOUISymbolSupported = false;
        }
        return isOUISymbolSupported;
    }

    public boolean isInHouseTestingPatchWithUPI(PatchObject po) {
        String upi;
        boolean houseTestingWithUPI = false;
        PatchInventory pInv = po.getPatchInventory();
        if (pInv.isInHouseTestingPatch() && Integer.parseInt(upi = po.getPatchUniqID()) > 0) {
            houseTestingWithUPI = true;
        }
        return houseTestingWithUPI;
    }

    public boolean isFileBusyPatchingEnabled() {
        if (!this.fileBusyPatching) {
            return false;
        }
        if (this.fileBusyPatchingCache == null) {
            int patchingModel = PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
            this.fileBusyPatchingCache = patchingModel == 1 && !OPatchEnv.isWindows();
        }
        return this.fileBusyPatchingCache;
    }

    public void setFileBusyPatching(boolean fileBusyPatch) throws OPatchException {
        int patchingModel = PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
        if (patchingModel == 2 || OPatchEnv.isWindows()) {
            throw new OPatchException("Please check the patching model and platform, OPatch does not support file busy patching when snowball patching model or windows platform. ");
        }
        this.fileBusyPatching = fileBusyPatch;
    }

    public boolean isCASEnabled(EnvInfo env) {
        boolean isCASEnabled = false;
        if (env.isCASJarExists()) {
            isCASEnabled = true;
        }
        return isCASEnabled;
    }

    public boolean isFATwoPhaseEnabled(EnvInfo env) {
        boolean isFATwoPhaseEnabled = false;
        if (env.getModelCode() == 2 && env.getExecMode().equals("SDK")) {
            isFATwoPhaseEnabled = true;
        }
        return isFATwoPhaseEnabled;
    }

    public boolean isOUIBased(EnvInfo env) {
        boolean isOUIBased = false;
        if (env.isOUIExists()) {
            isOUIBased = true;
        }
        return isOUIBased;
    }
}

