/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.ZipStringResource;
import oracle.opatch.patchsdk.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.patchmodel.EngineeredSystemPatch;
import oracle.opatch.patchsdk.patchmodel.GenericPatch;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;

public class OPatchEngineeredSystemPatchValidatorAndGenerator
extends EngineeredSystemPatchValidatorAndGenerator {
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        return super.isPatchValid(patchLocation);
    }

    public boolean isPatchValid(Map map) throws PatchPackageException {
        return super.isPatchValid(map);
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        PatchPackage patch = super.generate(patchLocation);
        if (patch == null || !(patch instanceof EngineeredSystemPatch)) {
            throw new PatchPackageException("Location \"" + patchLocation + "\" is not a valid System Patch location.");
        }
        EngineeredSystemPatch eSysPatch = (EngineeredSystemPatch)patch;
        OPatchEngineeredSystemPatch oESysPatch = new OPatchEngineeredSystemPatch();
        oESysPatch.setPatchID(eSysPatch.getPatchID());
        oESysPatch.setPatchLocation(eSysPatch.getPatchLocation());
        oESysPatch.setBundleXmlLoc(eSysPatch.getBundleXmlLoc());
        oESysPatch.setBundleXml(eSysPatch.getBundleXml());
        oESysPatch.setAutomationXmlLocation(eSysPatch.getAutomationXmlLocation());
        oESysPatch.setAutoXmls(eSysPatch.getAutoXmls());
        List<GenericPatch> subPatchList = eSysPatch.getSubPatches();
        oESysPatch.setSubPatches(subPatchList);
        File messageProp = new File(patchLocation + File.separator + "automation" + File.separator + "messages.properties");
        if (messageProp.exists() && messageProp.isFile()) {
            try {
                oESysPatch.setResourceBundle(this.getContent(new FileInputStream(messageProp)).toString());
            }
            catch (IOException ex) {
                throw new PatchPackageException("Couldn't get the string content of the messages.properties", ex);
            }
        } else {
            oESysPatch.setResourceBundle(null);
        }
        this.constructESysPatchAutomationMetadata(oESysPatch);
        return oESysPatch;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        PatchPackage patch = super.generate(map);
        if (patch == null || !(patch instanceof EngineeredSystemPatch)) {
            throw new PatchPackageException("The given zip file is not a valid System Patch.");
        }
        Object[] bundleXMLArray = (Object[])map.get(ZipStringResource.BUNDLE);
        EngineeredSystemPatch eSysPatch = (EngineeredSystemPatch)patch;
        OPatchEngineeredSystemPatch oESysPatch = new OPatchEngineeredSystemPatch();
        oESysPatch.setPatchID(eSysPatch.getPatchID());
        oESysPatch.setPatchLocation((String)map.get(OPatchZipStringResource.TOPDIRNAME));
        oESysPatch.setBundleXmlLoc((String)bundleXMLArray[0]);
        oESysPatch.setBundleXml(eSysPatch.getBundleXml());
        oESysPatch.setAutomationXmlLocation((String)map.get(OPatchZipStringResource.TOPDIRNAME) + File.separator + "automation");
        oESysPatch.setAutoXmls(eSysPatch.getAutoXmls());
        List<GenericPatch> subPatchList = eSysPatch.getSubPatches();
        Map oppsmap = OPatchPatch.getPatches((Map)map);
        for (Map.Entry entry : oppsmap.entrySet()) {
            String patchloc = (String)entry.getKey();
            OPatchPatch opp = (OPatchPatch)entry.getValue();
            OPatchSingletonPatch subpatch = new OPatchSingletonPatch(opp);
            subpatch.setPatchID(opp.getPatchId());
            subpatch.setPatchLocation(patchloc);
            subPatchList.add(subpatch);
        }
        oESysPatch.setSubPatches(subPatchList);
        Object[] messageArray = (Object[])map.get(OPatchZipStringResource.MESSAGE);
        if (messageArray.length == 2) {
            ByteArrayInputStream messageStream = new ByteArrayInputStream((byte[])messageArray[1]);
            try {
                oESysPatch.setResourceBundle(this.getContent(messageStream).toString());
            }
            catch (IOException ex) {
                throw new PatchPackageException("Couldn't get the string content of the messages.properties", ex);
            }
        } else {
            oESysPatch.setResourceBundle(null);
        }
        this.constructESysPatchAutomationMetadata(oESysPatch, map);
        return oESysPatch;
    }

    public String getPatchTool() {
        return "OPATCH";
    }

    private void constructESysPatchAutomationMetadata(OPatchEngineeredSystemPatch patch) {
        boolean isAuto = true;
        try {
            if (patch.getAutomationXmlLocation() == null || patch.getAutomationXmlLocation().equals("")) {
                isAuto = false;
            }
            if (isAuto) {
                StringBuffer applyAutomationXMLLoc = new StringBuffer(patch.getAutomationXmlLocation());
                applyAutomationXMLLoc.append(File.separator);
                applyAutomationXMLLoc.append("apply_automation.xml");
                File applyAutomationXML = new File(applyAutomationXMLLoc.toString());
                if (applyAutomationXML.exists()) {
                    patch.setApplyAutomationXMLLoc(applyAutomationXML.getAbsolutePath());
                } else {
                    isAuto = false;
                }
                StringBuffer rollbackAutomationXMLLoc = new StringBuffer(patch.getAutomationXmlLocation());
                rollbackAutomationXMLLoc.append(File.separator);
                rollbackAutomationXMLLoc.append("rollback_automation.xml");
                File rollbackAutomationXML = new File(rollbackAutomationXMLLoc.toString());
                if (rollbackAutomationXML.exists()) {
                    patch.setRollbackAutomationXMLLoc(rollbackAutomationXML.getAbsolutePath());
                } else {
                    isAuto = false;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String msg = "Not able to get automation elements of the patch.";
            throw new RuntimeException(msg);
        }
        patch.setIsAuto(isAuto);
    }

    private void constructESysPatchAutomationMetadata(OPatchEngineeredSystemPatch patch, Map map) {
        boolean isAuto = false;
        try {
            Object[] applyAutoArray = (Object[])map.get(OPatchZipStringResource.APPLYAUTO);
            Object[] rollbackAutoArray = (Object[])map.get(OPatchZipStringResource.ROLLBACKAUTO);
            if (applyAutoArray.length == 0 && rollbackAutoArray.length == 0) {
                patch.setIsAuto(isAuto);
                return;
            }
            isAuto = true;
            patch.setApplyAutomationXMLLoc((String)applyAutoArray[0]);
            patch.setRollbackAutomationXMLLoc((String)rollbackAutoArray[0]);
            patch.setIsAuto(isAuto);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String msg = "Not able to get automation elements of the patch.";
            throw new RuntimeException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            sw.close();
            isr.close();
            throw throwable;
        }
        sw.close();
        isr.close();
        return sw.getBuffer();
    }
}

