/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.ipm.IIPMAuxServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.PhaseOneExecutor;
import oracle.opatch.twophase.PhaseTwoExecutor;
import oracle.opatch.twophase.TwoPhasePatchingHelper;

public class TwoPhasePatching {
    private boolean init = false;
    private String oh = OPatchEnv.getOracleHome();
    private OPatchCASOracleHome coh;

    private void initialize() {
        if (this.init) {
            return;
        }
        this.coh = new OPatchCASOracleHome(this.oh, ".cas");
        this.init = true;
    }

    public void prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch)");
        this.initialize();
        String soh = "";
        soh = this.casPrepare(this.oh, rollbackPatch, applyPatch);
        this.attachShadowHome(soh);
        PhaseOneExecutor exe = new PhaseOneExecutor();
        exe.execute(soh, applyPatch, rollbackPatch);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::prepare(PatchObject[] rollbackPatch, PatchObject[] applyPatch)");
        this.detachShadowHome(soh);
        SystemCall.deleteRecurse(new File(soh + File.separator + ".patch_storage"), false);
        OLogger.justlog(OLogger.INFO, "clean up shadow oh \"" + soh + "\" after phase one.");
    }

    public void commit() throws ExitTwoPhaseException, Exception {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::commit()");
        try {
            this.initialize();
            PhaseTwoExecutor exec = new PhaseTwoExecutor();
            exec.execute(this.coh);
        }
        catch (Exception e2) {
            if (e2 instanceof ExitTwoPhaseException) {
                throw (ExitTwoPhaseException)e2;
            }
            throw e2;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::commit()");
    }

    private String casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        CASFileServices cas = new CASFileServices();
        String branchKey = "";
        String sohPath = "";
        try {
            branchKey = OPatchEnv.getBranchKey();
            OLogger.justlog(OLogger.INFO, "casPrepare::enable CAS/buildCasStore.");
            try {
                cas.build();
            }
            catch (Throwable t) {
                OLogger.printlnOnLog("BuildCasStore has issue: " + t.getMessage());
                OLogger.printStackTrace(t);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            String soh = this.coh.getCASStoragePath() + File.separator + branchKey;
            sohPath = oh + File.separator + soh;
            OLogger.justlog(OLogger.INFO, "casPrepare::destroy previous shadow OH");
            cas.destroy();
            Map<Path, String> copy = TwoPhasePatchingHelper.getBaseCopy(oh);
            Map<Path, String> rCopies = TwoPhasePatchingHelper.getCopiedFiles(oh, rollbackPatches);
            Map<Path, String> aCopies = TwoPhasePatchingHelper.getCopiedFiles(oh, applyPatches);
            for (Map.Entry<Path, String> entry : rCopies.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Path, String> entry : aCopies.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            TwoPhasePatchingHelper.addCopiedFilesForPatchStorage(copy, oh, rollbackPatches);
            TwoPhasePatchingHelper.addCopiedFilesForSparceCopy(copy, oh, applyPatches);
            HashMap<Path, String> hardlink = new HashMap<Path, String>();
            OLogger.justlog(OLogger.INFO, "casPrepare::copy list to shadow OH is: " + copy);
            OLogger.justlog(OLogger.INFO, "casPrepare::hardlink list to shadow OH is: " + hardlink);
            OLogger.justlog(OLogger.INFO, "casPrepare::create shadow OH, relative path is " + soh);
            if (IPMUtil.isDBHome(oh)) {
                TwoPhasePatchingHelper.doTheCopy(copy, oh, sohPath);
            }
            cas.create(soh, copy, hardlink);
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::casPrepare(String oh, PatchObject[] rollbackPatches, PatchObject[] applyPatches)");
        return sohPath;
    }

    private void attachShadowHome(String soh) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::attachHome(String soh)");
        Properties props = System.getProperties();
        props.setProperty("oracle.installer.scratchPath", "/tmp");
        try {
            IIPMAuxServices aux = IPM.INSTANCE.getAuxServices();
            aux.attachHome(soh, "soh", "-force -nogenerateGUID");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        props.setProperty("oracle.installer.attachHome", "false");
        OLogger.justlog(OLogger.INFO, "attachHome::copy over comps.xml from origianl OH to Shadow OH after attachhome");
        File oComps = new File(IPMUtil.getCompsXMLLocation(this.oh));
        File sComps = new File(IPMUtil.getCompsXMLLocation(soh));
        SystemCall.copyFile(oComps, sComps);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::attachHome(String soh)");
    }

    private void detachShadowHome(String soh) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: TwoPhasePatching::detachHome(String soh)");
        Properties props = System.getProperties();
        props.setProperty("oracle.installer.scratchPath", "/tmp");
        try {
            IIPMAuxServices aux = IPM.INSTANCE.getAuxServices();
            aux.detachHome(soh, "soh", "-force");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        props.setProperty("oracle.installer.detachHome", "false");
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: TwoPhasePatching::detachHome(String soh)");
    }
}

