/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import oracle.opatch.CmdLineOptionsManager;
import oracle.opatch.opatchlogger.OLogger;

public class OPatchCmdLineParser {
    private CmdLineOptionsManager optManager = null;
    private String[] remainingArgs = null;
    private Hashtable options = new Hashtable(10);
    private Hashtable values = new Hashtable(10);

    public OPatchCmdLineParser() {
        this.optManager = new CmdLineOptionsManager();
    }

    public final Option addOption(Option opt) {
        this.options.put("-" + opt.shortForm().toLowerCase(), opt);
        this.options.put("--" + opt.longForm().toLowerCase(), opt);
        return opt;
    }

    public final Option addStringOption(String shortForm, String longForm) {
        Option.StringOption opt = new Option.StringOption(shortForm, longForm);
        this.addOption(opt);
        return opt;
    }

    public final Option addStringOption(String form) {
        Option.StringOption opt = new Option.StringOption(form, form);
        this.addOption(opt);
        return opt;
    }

    public final Option addRawStringOption(String shortForm, String longForm) {
        Option.RawStringOption opt = new Option.RawStringOption(shortForm, longForm);
        this.addOption(opt);
        return opt;
    }

    public final Option addRawStringOption(String form) {
        Option.RawStringOption opt = new Option.RawStringOption(form, form);
        this.addOption(opt);
        return opt;
    }

    public final Option addStringTegerOption(String form) {
        Option.StringTegerOption opt = new Option.StringTegerOption(form);
        this.addOption(opt);
        return opt;
    }

    public final Option addIntegerOption(String shortForm, String longForm) {
        Option.IntegerOption opt = new Option.IntegerOption(shortForm, longForm);
        this.addOption(opt);
        return opt;
    }

    public final Option addIntegerOption(String form) {
        Option.IntegerOption opt = new Option.IntegerOption(form, form);
        this.addOption(opt);
        return opt;
    }

    public final Option addDoubleOption(String shortForm, String longForm) {
        Option.DoubleOption opt = new Option.DoubleOption(shortForm, longForm);
        this.addOption(opt);
        return opt;
    }

    public final Option addDoubleOption(String form) {
        Option.DoubleOption opt = new Option.DoubleOption(form, form);
        this.addOption(opt);
        return opt;
    }

    public final Option addBooleanOption(String shortForm, String longForm) {
        Option.BooleanOption opt = new Option.BooleanOption(shortForm, longForm);
        this.addOption(opt);
        return opt;
    }

    public final Option addBooleanOption(String form) {
        Option.BooleanOption opt = new Option.BooleanOption(form, form);
        this.addOption(opt);
        return opt;
    }

    public final Object getOptionValue(Option o2) {
        String opt = o2.longForm();
        Object obj = this.values.get(o2.longForm());
        if (obj != null) {
            if (this.optManager.isValidOption(opt)) {
                return obj;
            }
            RuntimeException re = new RuntimeException("\"-" + opt + "\" option is not valid.");
            throw re;
        }
        return obj;
    }

    public final String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    public final void parse(String[] argv) throws IllegalOptionValueException, UnknownOptionException {
        this.parse(argv, Locale.getDefault());
    }

    public final void parse(String[] argv, Locale locale) throws IllegalOptionValueException, UnknownOptionException {
        Vector<String> otherArgs = new Vector<String>();
        int position = 0;
        this.values = new Hashtable(10);
        while (position < argv.length) {
            String curArg = argv[position];
            if (curArg.startsWith("-")) {
                StringBuffer tmpSb;
                Option opt;
                int equalsPos;
                if (curArg.equals("--")) {
                    ++position;
                    break;
                }
                String valueArg = null;
                if (curArg.startsWith("--") && (equalsPos = curArg.indexOf("=")) != -1) {
                    valueArg = curArg.substring(equalsPos + 1);
                    curArg = curArg.substring(0, equalsPos);
                }
                if ((opt = (Option)this.options.get(curArg.toLowerCase())) == null) {
                    throw new UnknownOptionException(curArg);
                }
                Object value = null;
                if (opt.wantsValue()) {
                    String sortOption;
                    if (curArg.substring(1).equalsIgnoreCase("pre")) {
                        tmpSb = new StringBuffer();
                        ++position;
                        while (position < argv.length) {
                            if (argv[position].substring(1).equalsIgnoreCase("opatch_pre_end")) {
                                --position;
                                break;
                            }
                            tmpSb.append(argv[position]);
                            tmpSb.append(" ");
                            ++position;
                        }
                        valueArg = tmpSb.toString();
                    } else if (curArg.substring(1).equalsIgnoreCase("post")) {
                        tmpSb = new StringBuffer();
                        ++position;
                        while (position < argv.length) {
                            if (argv[position].substring(1).equalsIgnoreCase("opatch_post_end")) {
                                --position;
                                break;
                            }
                            tmpSb.append(argv[position]);
                            tmpSb.append(" ");
                            ++position;
                        }
                        valueArg = tmpSb.toString();
                    } else if (curArg.substring(1).equalsIgnoreCase("init")) {
                        tmpSb = new StringBuffer();
                        ++position;
                        while (position < argv.length) {
                            if (argv[position].substring(1).equals("opatch_init_end")) {
                                --position;
                                break;
                            }
                            tmpSb.append(argv[position]);
                            tmpSb.append(" ");
                            ++position;
                        }
                        valueArg = tmpSb.toString();
                    } else if (curArg.substring(1).equalsIgnoreCase("patch")) {
                        if (++position < argv.length) {
                            sortOption = argv[position];
                            if (sortOption.compareToIgnoreCase("asc") == 0 || sortOption.compareToIgnoreCase("desc") == 0) {
                                valueArg = sortOption;
                            } else {
                                valueArg = "desc";
                                --position;
                            }
                        } else {
                            valueArg = "desc";
                        }
                    } else if (curArg.substring(1).equalsIgnoreCase("patch_id")) {
                        if (++position < argv.length) {
                            sortOption = argv[position];
                            if (sortOption.compareToIgnoreCase("asc") == 0 || sortOption.compareToIgnoreCase("desc") == 0) {
                                valueArg = sortOption;
                            } else {
                                valueArg = "asc";
                                --position;
                            }
                        } else {
                            valueArg = "asc";
                        }
                    } else if (curArg.substring(1).equalsIgnoreCase("bugs_fixed")) {
                        if (++position < argv.length) {
                            sortOption = argv[position];
                            if (sortOption.compareToIgnoreCase("asc") == 0 || sortOption.compareToIgnoreCase("desc") == 0) {
                                valueArg = sortOption;
                            } else {
                                valueArg = "asc";
                                --position;
                            }
                        } else {
                            valueArg = "asc";
                        }
                    }
                    if (valueArg == null) {
                        valueArg = null;
                        if (++position < argv.length) {
                            if ("-invPtrLoc".equals(argv[position])) {
                                valueArg = "";
                                --position;
                            } else {
                                valueArg = argv[position];
                            }
                        }
                    }
                    value = opt.getValue(valueArg, locale);
                } else if (opt.wantsValues()) {
                    tmpSb = new StringBuffer();
                    ++position;
                    String optLongEnd = opt.longForm() + "_end";
                    String optShortEnd = opt.shortForm() + "_end";
                    boolean inc = true;
                    while (position < argv.length) {
                        if (argv[position].substring(1).equals(optLongEnd) || argv[position].substring(1).equals(optShortEnd)) {
                            --position;
                            break;
                        }
                        String innerArg = argv[position].toLowerCase();
                        Option opt1 = (Option)this.options.get(innerArg);
                        if (opt1 != null) {
                            --position;
                            inc = false;
                            break;
                        }
                        tmpSb.append(argv[position]);
                        tmpSb.append(" ");
                        ++position;
                    }
                    if ((valueArg = tmpSb.toString()) == null) {
                        valueArg = null;
                        if (++position < argv.length) {
                            valueArg = argv[position];
                        }
                    }
                    value = opt.getValue(valueArg, locale);
                    if (inc) {
                        ++position;
                    }
                } else {
                    value = opt.getValue(null, locale);
                }
                this.values.put(opt.longForm(), value);
                ++position;
                continue;
            }
            otherArgs.addElement(argv[position]);
            ++position;
        }
        while (position < argv.length) {
            otherArgs.addElement(argv[position]);
            ++position;
        }
        this.remainingArgs = new String[otherArgs.size()];
        int i2 = 0;
        Enumeration e2 = otherArgs.elements();
        while (e2.hasMoreElements()) {
            this.remainingArgs[i2] = (String)e2.nextElement();
            ++i2;
        }
    }

    protected boolean validateTheOptions() {
        Set opts = this.values.keySet();
        String[] optsArray = new String[opts.size()];
        opts.toArray(optsArray);
        if (this.optManager.containsMutuallyExclusiveOptions(optsArray)) {
            return false;
        }
        return this.optManager.containsCombinationOptions(optsArray);
    }

    public static abstract class Option {
        private String shortForm = null;
        private String longForm = null;
        private boolean wantsValue = false;
        private boolean wantsValues = false;

        protected Option(String shortForm, String longForm, boolean wantsValue, boolean wantsValues) {
            if (longForm == null) {
                throw new IllegalArgumentException("null arg forms not allowed");
            }
            this.shortForm = new String(shortForm);
            this.longForm = longForm;
            this.wantsValue = wantsValue;
            this.wantsValues = wantsValues;
        }

        protected Option(String shortForm, String longForm, boolean wantsValue) {
            if (longForm == null) {
                throw new IllegalArgumentException("null arg forms not allowed");
            }
            this.shortForm = new String(shortForm);
            this.longForm = longForm;
            this.wantsValue = wantsValue;
        }

        public String toString() {
            if (this.longForm != null && !this.longForm.equals("")) {
                return this.longForm;
            }
            if (this.shortForm != null && !this.shortForm.equals("")) {
                return this.shortForm;
            }
            OLogger.log(OLogger.FINE, "Both short and long form are null for this 'unknown' option");
            return "";
        }

        public String shortForm() {
            return this.shortForm;
        }

        public String longForm() {
            return this.longForm;
        }

        public boolean wantsValue() {
            return this.wantsValue;
        }

        public boolean wantsValues() {
            return this.wantsValues;
        }

        public final Object getValue(String arg, Locale locale) throws IllegalOptionValueException {
            if (this.wantsValue) {
                if (arg == null) {
                    throw new IllegalOptionValueException(this, "");
                }
                return this.parseValue(arg, locale);
            }
            if (this.wantsValues) {
                if (arg == null) {
                    throw new IllegalOptionValueException(this, "");
                }
                return this.parseValue(arg, locale);
            }
            return Boolean.TRUE;
        }

        protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            return null;
        }

        public static class RawStringOption
        extends Option {
            public RawStringOption(String shortForm, String longForm) {
                super(shortForm, longForm, false, true);
            }

            protected Object parseValue(String arg, Locale locale) {
                return arg;
            }
        }

        public static class StringOption
        extends Option {
            public StringOption(String shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) {
                return arg;
            }
        }

        public static class DoubleOption
        extends Option {
            public DoubleOption(String shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    NumberFormat format = NumberFormat.getNumberInstance(locale);
                    Number num = format.parse(arg);
                    return new Double(num.doubleValue());
                }
                catch (ParseException e2) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class StringTegerOption
        extends Option {
            public StringTegerOption(String form) {
                super(form, form, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    Integer i2 = new Integer(arg);
                    return i2;
                }
                catch (NumberFormatException e2) {
                    return arg;
                }
            }
        }

        public static class IntegerOption
        extends Option {
            public IntegerOption(String shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    return new Integer(arg);
                }
                catch (NumberFormatException e2) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class BooleanOption
        extends Option {
            public BooleanOption(String shortForm, String longForm) {
                super(shortForm, longForm, false);
            }
        }
    }

    public static class IllegalOptionValueException
    extends OptionException {
        private Option option;
        private String value;

        public IllegalOptionValueException(Option opt, String value) {
            super("illegal value '" + value + "' for option -" + opt.shortForm() + "/--" + opt.longForm());
            this.option = opt;
            this.value = value;
        }

        public Option getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UnknownOptionException
    extends OptionException {
        private String optionName = null;

        UnknownOptionException(String optionName) {
            super("unknown option '" + optionName + "'");
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static abstract class OptionException
    extends Exception {
        OptionException(String msg) {
            super(msg);
        }
    }
}

