/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.Help;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchValidationException;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class UtilSession
extends OPatchSession
implements Help {
    protected UtilSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public static IIPMRWServices getRWServices(String oracleHomePath) throws Throwable {
        if (oracleHomePath == null || oracleHomePath.equals("")) {
            throw new NullPointerException("UtilSession::getReadServices() got a null oracleHomePath");
        }
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        if (!rwServices.isLocked() || !rwServices.getOracleHomePath().equals(oracleHomePath)) {
            rwServices.lock(oracleHomePath);
        }
        if (!rwServices.isInventoryLoaded()) {
            rwServices.loadInventory(oracleHomePath);
        }
        if (!rwServices.isInventoryLoaded()) {
            throw new NullPointerException("Inventory could not be created");
        }
        return rwServices;
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String utilOption = OPatchEnv.getUtilOption();
        String helpFile = "";
        String fmwHelpFile = "";
        helpFile = "opatchutil/util_help.txt";
        if (!utilOption.equals("")) {
            helpFile = "opatchutil/" + utilOption.toLowerCase() + "_help.txt";
            fmwHelpFile = "opatchfafmw/" + utilOption.toLowerCase() + "_help.txt";
        }
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            if (is == null) {
                is = this.getClass().getResourceAsStream(fmwHelpFile);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("/")) continue;
                helpM.append(thisLine);
                helpM.append("\n");
            }
            br.close();
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile + " or " + fmwHelpFile});
            OLogger.println(msg);
            throw new RuntimeException(msg, e2);
        }
    }

    private boolean checkIsSupportedOption(String option) {
        boolean isSupported = true;
        String[] optionsUnSupported = new String[]{"applysql", "checkminimumopatchversion", "checkcomponents", "verify", "napply", "nrollback"};
        for (int i2 = 0; i2 < optionsUnSupported.length; ++i2) {
            if (option.compareTo(optionsUnSupported[i2]) != 0) continue;
            isSupported = false;
        }
        return isSupported;
    }

    protected void process(String oracleHomePath, String utilOption) throws RuntimeException, Error {
        StringBuffer buff = new StringBuffer("UtilSession::process() ");
        buff.append(oracleHomePath);
        OLogger.debug(buff);
        String patchLoc = OUSession.getPatchLocation();
        boolean isEsysPatch = false;
        if (patchLoc != null) {
            isEsysPatch = OPatchSessionHelper.checkIsEsysPatch(patchLoc);
        }
        if (isEsysPatch) {
            OPatchEnv.setOpatchExitCode(21);
            throw new RuntimeException(OLogger.getString("OUI-68011"));
        }
        boolean skipInit = true;
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            skipInit = false;
        } else if (!utilOption.equals("napply") && !utilOption.equals("nrollback")) {
            skipInit = false;
        }
        if (skipInit) {
            if (!OPatchEnv.getPatchStorageWritePermission()) {
                throw new RuntimeException(OLogger.getString("OUI-68060", new Object[]{oracleHomePath}));
            }
        } else {
            try {
                if (!OPatchEnv.isSrvmUtil()) {
                    IIPMRWServices rwServices = UtilSession.getRWServices(oracleHomePath);
                    buff = new StringBuffer("Generic Inventory object is loaded properly for home ");
                    buff.append(oracleHomePath);
                    OLogger.debug(buff);
                }
            }
            catch (SecurityException e2) {
                throw e2;
            }
            catch (Throwable t) {
                OLogger.error("OUI-67064", new Object[]{oracleHomePath});
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        try {
            String className = "oracle.opatch.opatchutil.OUSession";
            String functionName = utilOption.toLowerCase();
            buff = new StringBuffer(" Checking on class ");
            buff.append(className);
            OLogger.debug(buff);
            Class<?> utilClass = Class.forName(className);
            buff = new StringBuffer(" Get list of methods implemented by the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method[] methods = utilClass.getMethods();
            String defaultMethodName = "defaultOption";
            Class[] parameterTypes = new Class[1];
            String stringTypeName = "java.lang.String";
            buff = new StringBuffer(" Get a class of type ");
            buff.append(stringTypeName);
            OLogger.debug(buff);
            parameterTypes[0] = Class.forName(stringTypeName);
            buff = new StringBuffer(" Get the default method of the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method defaultMethod = utilClass.getMethod(defaultMethodName, parameterTypes);
            Object obj = null;
            Object[] args = new Object[]{oracleHomePath};
            boolean invoked = false;
            buff = new StringBuffer(" Begin searching for method ");
            buff.append(utilOption);
            OLogger.debug(buff);
            for (int i2 = 0; i2 < methods.length && !invoked; ++i2) {
                Method method = methods[i2];
                String methodName = method.getName();
                if (!methodName.equals(functionName)) continue;
                if (!OUSession.checkMethod(functionName)) {
                    throw new RuntimeException("OPatch UtilSession does not support the method \"" + functionName + "\".");
                }
                if (!methodName.equals("napply") && !methodName.equals("nrollback")) {
                    OLogger.println("Invoking utility \"" + methodName + "\"");
                }
                if (methodName.equals("cleanup")) {
                    OPatchEnv.setCleanupCmdLine(true);
                }
                method.invoke(obj, args);
                invoked = true;
            }
            if (!invoked) {
                defaultMethod.invoke(obj, args);
            }
        }
        catch (ClassNotFoundException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            Throwable t = e4.getTargetException();
            if (t instanceof ExitOPatchException) {
                throw (ExitOPatchException)t;
            }
            if (t instanceof OnlinePatchException) {
                throw (OnlinePatchException)t;
            }
            if (t instanceof SymbolFailureException) {
                throw (SymbolFailureException)t;
            }
            if (t instanceof PatchValidationException) {
                throw (PatchValidationException)t;
            }
            if (t != null) {
                buff = new StringBuffer();
                buff.append(t.getMessage());
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            RuntimeException re = new RuntimeException("Unknown exception occured.");
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        catch (IllegalAccessException e5) {
            throw new RuntimeException(e5);
        }
        catch (NoSuchMethodException e6) {
            throw new RuntimeException(e6);
        }
    }

    public static OneOffEntry[] getAutoRollbackList() {
        return OPatchUtilHelper.getAutoRollbackOneOffsIfNotRead();
    }

    public static boolean isUtilOptionValid(String utilOption) {
        try {
            String className = "oracle.opatch.opatchutil.OUSession";
            String functionName = utilOption.toLowerCase();
            StringBuffer buff = new StringBuffer(" Checking on class ");
            buff.append(className);
            OLogger.debug(buff);
            Class<?> utilClass = Class.forName(className);
            buff = new StringBuffer(" Get list of methods implemented by the class ");
            buff.append(className);
            OLogger.debug(buff);
            Method[] methods = utilClass.getMethods();
            Class[] parameterTypes = new Class[1];
            String stringTypeName = "java.lang.String";
            buff = new StringBuffer(" Get a class of type ");
            buff.append(stringTypeName);
            OLogger.debug(buff);
            parameterTypes[0] = Class.forName(stringTypeName);
            buff = new StringBuffer(" Get the default method of the class ");
            buff.append(className);
            OLogger.debug(buff);
            buff = new StringBuffer(" Begin searching for method ");
            buff.append(utilOption);
            OLogger.debug(buff);
            for (int i2 = 0; i2 < methods.length; ++i2) {
                Method method = methods[i2];
                String methodName = method.getName();
                if (!methodName.equals(functionName)) continue;
                OLogger.debug(new StringBuffer("Found utility \"" + methodName + "\""));
                return true;
            }
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return false;
    }
}

