/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.glcm.opatch.content.api.ICASFileServices;
import oracle.glcm.opatch.content.api.ICasSDK;
import oracle.glcm.opatch.content.api.IView;
import oracle.glcm.opatch.content.api.IViewFilter;
import oracle.glcm.opatch.content.errors.CasApiNoOpException;
import oracle.glcm.opatch.content.lib.CASServices;
import oracle.glcm.opatch.content.sdk.CasPublic;
import oracle.glcm.opatch.content.sdk.CasSDK;
import oracle.opatch.OPatchEnv;
import oracle.opatch.cas.BranchInfo;
import oracle.opatch.cas.TagUIInfo;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASBranchServices {
    private String defaultTagviewRegex = "[^\u0000/]+";

    public void createBranch(String shadowDir, String branchKey, String tagKey) throws Throwable {
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - creating branch from a repository");
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        try {
            Path casPath = Paths.get(shadowDir, new String[0]).getParent();
            repoSDK = CasPublic.newOBRepoSDK((Path)casPath);
            repoSDK.buildCasStore(false);
            this.verifyBranch(shadowDir);
            this.verifyKey(branchKey);
            repoSDK.createView(branchKey, tagKey, Paths.get(shadowDir, new String[0]).normalize());
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - created branch from a repository");
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("createBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Create view \"{0}\" ERROR: {1}", branchKey, t.getMessage()));
            throw t;
        }
    }

    private String getTagViewRegex() {
        String customEnvRegex = System.getenv("ZDTTAGVIEW_REGEX");
        if (customEnvRegex != null && !customEnvRegex.equals("")) {
            OLogger.justlog(OLogger.INFO, "CASBranchServices env ZDTTAGVIEW_REGEX is set");
            this.defaultTagviewRegex = customEnvRegex;
        }
        return this.defaultTagviewRegex;
    }

    private void verifyBranch(String shadowDir) {
        File f2 = new File(shadowDir);
        boolean ok = true;
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            StringBuffer tBuff = new StringBuffer("Please specify a valid view directory. The given directory \"");
            tBuff.append(shadowDir);
            tBuff.append("\" does not exist and OPatch cannot create the view.");
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        if (f2.list().length != 0) {
            StringBuffer tBuff = new StringBuffer("Please specify an empty view directory. The given directory \"");
            tBuff.append(shadowDir);
            tBuff.append("\" is not empty.");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
    }

    private void verifyKey(String branchKey) {
        if (branchKey != null && !branchKey.isEmpty()) {
            if (branchKey.matches(this.getTagViewRegex())) {
                return;
            }
            StringBuffer tBuff = new StringBuffer("The given view id \"");
            tBuff.append(branchKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("Please specify view id containing only characters comply to regex: " + this.defaultTagviewRegex);
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("Please specify a valid view id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    private void verifyMaxMemKey(String maxMemKey) {
        if (maxMemKey != null && !maxMemKey.isEmpty()) {
            if (maxMemKey.matches("[0-9]+(.[0-9]+)?[m|M|g|G]")) {
                String unit = maxMemKey.substring(maxMemKey.length() - 1);
                String maxMemSize = maxMemKey.substring(0, maxMemKey.length() - 1);
                float memFloat = Float.parseFloat(maxMemSize);
                if (unit.equalsIgnoreCase("m") && memFloat >= 768.0f && memFloat <= 5120.0f) {
                    return;
                }
                if (unit.equalsIgnoreCase("G") && (double)memFloat >= 0.75 && memFloat <= 5.0f) {
                    return;
                }
                StringBuffer tBuff = new StringBuffer("The given max memory \"");
                tBuff.append(maxMemKey);
                tBuff.append("\" is invalid. ");
                tBuff.append("Please specify max memory between 768M to 5G.");
                OLogger.println(tBuff.toString());
                RuntimeException re = new RuntimeException(tBuff.toString());
                throw re;
            }
            StringBuffer tBuff = new StringBuffer("The given max memory \"");
            tBuff.append(maxMemKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("Please specify max memory with correct format.");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("Please specify a valid max memory.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    private void verifyTagKey(String tagKey, String branchKey, ICASFileServices casFileServices) throws Throwable {
        if (tagKey != null && !tagKey.isEmpty()) {
            if (tagKey.matches(this.getTagViewRegex())) {
                List tagList = casFileServices.listTagsFromBranch(branchKey, tagKey);
                if (tagList.size() > 0) {
                    StringBuffer tBuff = new StringBuffer("Tag \"");
                    tBuff.append(tagKey);
                    tBuff.append("\" already exist. ");
                    RuntimeException re = new RuntimeException(tBuff.toString());
                    throw re;
                }
                return;
            }
            StringBuffer tBuff = new StringBuffer("The given tag id \"");
            tBuff.append(tagKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("Please specify tag id containing only characters comply to regex: " + this.defaultTagviewRegex);
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("Please specify a valid tag id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    private void verifyTagKeyForCleanup(String tagKey, String branchKey, ICASFileServices casFileServices) throws Throwable {
        if (tagKey != null && !tagKey.isEmpty()) {
            if (tagKey.matches(this.getTagViewRegex())) {
                List tagList = casFileServices.listTagsFromBranch(branchKey, tagKey);
                if (tagList.size() == 0) {
                    StringBuffer tBuff = new StringBuffer("Tag \"");
                    tBuff.append(tagKey);
                    tBuff.append("\" doesn't exist. ");
                    RuntimeException re = new RuntimeException(tBuff.toString());
                    throw re;
                }
                return;
            }
            StringBuffer tBuff = new StringBuffer("The given tag id \"");
            tBuff.append(tagKey);
            tBuff.append("\" is invalid. ");
            tBuff.append("Please specify tag id containing only characters comply to regex: " + this.defaultTagviewRegex);
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
        StringBuffer tBuff = new StringBuffer("Please specify a valid tag id.");
        OLogger.println(tBuff.toString());
        RuntimeException re = new RuntimeException(tBuff.toString());
        throw re;
    }

    public void synchBranch(String branchKey, String tagKey) throws Throwable {
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - synching branch started");
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        String masterKey = "master";
        try {
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            repoSDK.synchView(branchKey, tagKey);
            repoSDK.restoreView(tagKey, null);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS synching branch completed");
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("synchBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Synch view \"{0}\" ERROR: {1}", branchKey, t.getMessage()));
            throw t;
        }
    }

    public void tagBranch(String tagId) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            ICasSDK.IRepoSDK repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            repoSDK.buildCasStore(false);
            String masterKey = "master";
            this.verifyTagKey(tagId, masterKey, casFileServices);
            repoSDK.tag(tagId);
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("tagBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Create tag \"{0}\" ERROR: {1}", tagId, t.getMessage()));
            throw t;
        }
    }

    public void cleanup(String tagId, boolean pruneSpace, String maxMem, boolean report) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        try {
            casFileServices = CASServices.getFileServices();
            String masterKey = "master";
            if (tagId != null) {
                this.verifyTagKeyForCleanup(tagId, masterKey, casFileServices);
            }
            this.verifyMaxMemKey(maxMem);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("cleanup error: " + t.getMessage());
            OLogger.println(MessageFormat.format("cleanup \"{0}\" ERROR: {1}", tagId, t.getMessage()));
            throw t;
        }
    }

    public void destroyBranch(String branchKey) throws Throwable {
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        try {
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - destroying branch");
            IViewFilter filter = null;
            List views = new ArrayList();
            views = repoSDK.lsViews(filter);
            IView view = null;
            for (int i2 = 0; i2 < views.size(); ++i2) {
                if (!branchKey.equals(((IView)views.get(i2)).getId())) continue;
                view = (IView)views.get(i2);
                break;
            }
            repoSDK.destroyView(view);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - branch destroyed");
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("destroyBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("Destroy view \"{0}\" ERROR: {1}", branchKey, t.getMessage()));
            throw t;
        }
    }

    public LinkedList<BranchInfo> listBranch(List<String> keys, List<Path> values) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        LinkedList<BranchInfo> bis = new LinkedList<BranchInfo>();
        try {
            casFileServices = CASServices.getFileServices();
            casFileServices.listBranch(keys, values);
            if (keys.size() == 0) {
                OLogger.printlnOnLog("No branch is created");
            }
            for (String key : keys) {
                LinkedList<String> mKeys = new LinkedList<String>();
                Path p2 = casFileServices.listBranchInfo(key, mKeys);
                List tags = casFileServices.listTagsFromBranch(key);
                String tagsKey = null;
                if (!key.equals("master")) {
                    tagsKey = tags.size() > 0 ? ((ICASFileServices.TagInfo)tags.get(tags.size() - 1)).getTagKey() : "";
                }
                LinkedHashMap<String, String> pidMap = new LinkedHashMap();
                pidMap = this.extractPatchInfo(mKeys);
                LinkedList<String> list = this.getPatchInfoList(pidMap);
                bis.add(new BranchInfo(key, p2, tagsKey, list));
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("listBranch error: " + t.getMessage());
            OLogger.println(MessageFormat.format("List views ERROR: {0}", t.getMessage()));
            throw t;
        }
        return bis;
    }

    public LinkedList<TagUIInfo> listTagsFromBranch(String branchKey) throws Throwable {
        this.validate();
        ICASFileServices casFileServices = null;
        List keys = new LinkedList();
        LinkedList<TagUIInfo> list = new LinkedList<TagUIInfo>();
        try {
            casFileServices = CASServices.getFileServices();
            keys = casFileServices.listTagsFromBranch(branchKey);
            if (keys.size() == 0) {
                OLogger.printlnOnLog("No tag is created");
            }
            LinkedHashSet<String> accumulativeMKeys = new LinkedHashSet<String>();
            for (ICASFileServices.TagInfo t : keys) {
                StringBuffer buff = new StringBuffer();
                buff.append("Tag name: " + t.getTagKey() + "\n");
                buff.append("Installed patches: \n");
                List pKeys = t.getDeltaPatches();
                LinkedList<String> mKeys = new LinkedList<String>();
                LinkedHashMap<String, String> pidMap = new LinkedHashMap();
                for (int i2 = pKeys.size() - 1; i2 >= 0; --i2) {
                    ICASFileServices.PatchKey pKey = (ICASFileServices.PatchKey)pKeys.get(i2);
                    if (pKey.isNullKey()) continue;
                    String mKey = pKey.getKey();
                    accumulativeMKeys.add(mKey);
                }
                for (String mKey : accumulativeMKeys) {
                    mKeys.add(mKey);
                }
                Collections.reverse(mKeys);
                pidMap = this.extractPatchInfo(mKeys);
                LinkedList<String> taginfoList = this.getPatchInfoList(pidMap);
                list.add(new TagUIInfo(t.getTagKey(), taginfoList));
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("listTagsFromBranch error: " + t.getMessage());
            throw t;
        }
        return list;
    }

    private Map<String, String> extractPatchInfo(LinkedList<String> keys) {
        LinkedHashMap<String, String> pidMap = new LinkedHashMap<String, String>();
        Collections.reverse(keys);
        for (String key : keys) {
            if (key.endsWith("noncasflow")) {
                String ts = key.substring(0, key.lastIndexOf("_"));
                OLogger.printlnOnLog(MessageFormat.format("No patch information listed for non-casflow sessions. Please refer to log file at \"{0}\" for more information.", ts));
                continue;
            }
            int first = key.indexOf("_");
            int second = key.indexOf("_", first + 1);
            int third = key.indexOf("_", second + 1);
            int last = key.lastIndexOf("_");
            String id = key.substring(0, third);
            String time = key.substring(third + 1, last);
            if (key.endsWith("napply")) {
                pidMap.put(id, time);
                continue;
            }
            if (!key.endsWith("nrollback")) continue;
            pidMap.remove(id);
        }
        return pidMap;
    }

    private LinkedList<String> getPatchInfoList(Map<String, String> map) {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] ids = entry.getKey().split("_");
            StringBuffer buff = new StringBuffer("Patch ");
            buff.append(ids[0]);
            buff.append(": applied on ");
            buff.append(entry.getValue());
            buff.append("\nUnique Patch ID: ");
            buff.append(ids[2]);
            buff.append("\nLanguage: ");
            buff.append(ids[1]);
            list.add(buff.toString());
        }
        Collections.reverse(list);
        return list;
    }

    public void detachMain() throws Throwable {
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        try {
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS -  detaching cas store");
            repoSDK.detach();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - cas store detached");
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            if (t instanceof CasApiNoOpException) {
                OLogger.printlnOnLog("detachMain info: " + t.getMessage());
            } else {
                OLogger.printlnOnLog("detachMain error: " + t.getMessage());
                OLogger.printStackTrace(t);
                OLogger.println(MessageFormat.format("Detach ERROR: {0}", t.getMessage()));
            }
            throw t;
        }
    }

    public void attachMain() throws Throwable {
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        try {
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - attaching cas store");
            repoSDK.attach();
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] CAS - cas store attached");
            ((CasSDK)repoSDK).cleanup();
        }
        catch (Throwable t) {
            if (t instanceof CasApiNoOpException) {
                OLogger.printlnOnLog("attachMain info: " + t.getMessage());
            } else {
                OLogger.printlnOnLog("attachMain error: " + t.getMessage());
                OLogger.printStackTrace(t);
                OLogger.println(MessageFormat.format("Attach ERROR: {0}", t.getMessage()));
            }
            throw t;
        }
    }

    public boolean isCasReposPresent() throws Throwable {
        this.validate();
        ICasSDK.IRepoSDK repoSDK = null;
        try {
            String ohPath = OPatchEnv.getOracleHome();
            Path casLoc = Paths.get(ohPath, ".cas").normalize();
            repoSDK = CasPublic.newOBRepoSDK((Path)casLoc);
            boolean isRepoPresent = repoSDK.isCasReposPresent();
            ((CasSDK)repoSDK).cleanup();
            return isRepoPresent;
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("isCasReposPresent error: " + t.getMessage());
            OLogger.printStackTrace(t);
            throw t;
        }
    }

    private void validate() {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            StringBuffer tBuff = new StringBuffer("OPatch doesn't support ZDT commands");
            tBuff.append(" in the environment that is not CAS-enabled. ");
            OLogger.println(tBuff.toString());
            RuntimeException re = new RuntimeException(tBuff.toString());
            throw re;
        }
    }
}

