/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SQLUtilities;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;

public class sqlprocAction
extends OrderedPatchAction
implements Restorable,
ConflictDetectable {
    private String sqlProcFileName = null;
    private String sqlProcedureFile = null;
    private String filePath = null;
    private String procSqlForRun = "";
    private String procSqlForRetrieve = "";
    private String nonApplicableDesc = "";
    private String nonRollbackableDesc = "";
    private String backupForRollbackFailureDesc = "";
    private String nonBackupForRestoreDesc = "";
    private boolean parseInfo = false;
    private static String currentCookedID = "";
    private static boolean isFileBackedUp = false;
    private String relativeProcedureSqlLocation = "";
    private ArrayList procInfo;
    private int RESTORE_MODE = 0;
    private int ROLLBACK_MODE = 1;
    private boolean isBackedUpForRestore = false;

    public sqlprocAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws RuntimeException, NullPointerException, Exception {
        super(pc, lineNumber);
        String patchFilesLocation = null;
        if (argNames == null || argValues == null) {
            throw new RuntimeException("Argument inputs are NULL for sqlprocAction");
        }
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Argument names and their values don't match numerically for sqlprocAction.");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String argName = (String)argNames.get(i2);
            String argValue = (String)argValues.get(i2);
            if (argName.equals("name")) {
                this.sqlProcFileName = argValue;
            }
            if (argName.equals("file_path")) {
                this.filePath = argValue;
            }
            if (argName.equals("proc_touched_list")) {
                this.sqlProcedureFile = argValue;
            }
            if (!argName.equals("PATCH_FILES_LOCATION_TAG")) continue;
            patchFilesLocation = argValue;
        }
        if (this.sqlProcFileName == null || this.filePath == null || this.sqlProcedureFile == null) {
            String errMsg = "The sql proc action is null";
            if (this.sqlProcFileName == null) {
                errMsg = errMsg + "The sql file name is null";
            }
            if (this.filePath == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (this.sqlProcedureFile == null) {
                errMsg = errMsg + "The sql procedure text file is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.setDelayExecution(true);
        this.sqlProcedureFile = this.sqlProcedureFile;
        this.filePath = PatchObjectUtil.getPlatformDependentPath(this.filePath);
        StringBuffer procedureFilePath = new StringBuffer(patchFilesLocation);
        procedureFilePath.append(File.separator);
        procedureFilePath.append(this.filePath);
        procedureFilePath.append(File.separator);
        StringBuffer procedureSqlPath = new StringBuffer(procedureFilePath.toString());
        procedureSqlPath.append(this.sqlProcFileName);
        procedureFilePath.append(this.sqlProcedureFile);
        this.parseInfo = this.parseProcedureFile(procedureFilePath.toString());
        if (!this.parseInfo) {
            throw new RuntimeException("Unable to parse the procedure text file \"" + procedureFilePath.toString() + "\"");
        }
        this.relativeProcedureSqlLocation = procedureSqlPath.toString();
    }

    private sqlprocAction() {
    }

    public boolean equals(Object o2) {
        StringBuffer buff = new StringBuffer("sqlProcAction::equals()");
        OLogger.debug(buff);
        if (o2 instanceof sqlprocAction) {
            String procFileName = this.sqlProcFileName;
            String procFilePath = this.filePath;
            String sqlProcedureFile = this.sqlProcedureFile;
            sqlprocAction sqlproc = (sqlprocAction)o2;
            String inputProcFileName = sqlproc.sqlProcFileName;
            String inputProcFilePath = sqlproc.filePath;
            String inputSqlProcedureFile = sqlproc.sqlProcedureFile;
            return procFileName.equals(inputProcFileName) && procFilePath.equals(inputProcFilePath) && sqlProcedureFile.equals(inputSqlProcedureFile);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.sqlProcFileName.length();
        result = 37 * result + this.sqlProcedureFile.length();
        result = 37 * result + this.filePath.length();
        return result;
    }

    public String toString() {
        String patchLoc = OPatchEnv.getPatchloc();
        StringBuffer buff = new StringBuffer("   Run Sql file ");
        buff.append("\"" + this.getSourceFile(patchLoc) + "\" for 'apply'");
        buff.append("\n   after backing up procedures corresponding to ");
        buff.append("\"" + this.getProcedureTextFile(patchLoc) + "\" for 'rollback'");
        return buff.toString();
    }

    private boolean parseProcedureFile(String procedureLocation) {
        String fileContents = "";
        OLogger.debug(new StringBuffer("sqlprocAction::parseProcedureFile() called"));
        File f2 = new File(procedureLocation);
        if (!f2.exists() || !f2.canRead()) {
            StringBuffer buff = new StringBuffer("File \"" + procedureLocation + "\" does not exists or is not readable");
            OLogger.debug(buff);
            return false;
        }
        try {
            fileContents = OPatchSessionHelper.readTextFile(procedureLocation);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return false;
        }
        this.parseInput(fileContents);
        ArrayList procList = this.getProcedureList();
        if (procList == null || procList.size() == 0) {
            StringBuffer buff = new StringBuffer("sqlprocAction::parseProcedurefile()--> Empty or null procedure List found for \"" + procedureLocation + "\"");
            OLogger.debug(buff);
            return false;
        }
        ArrayList<String> filteredProcList = new ArrayList<String>();
        for (int i2 = 0; i2 < procList.size(); ++i2) {
            String procName = (String)procList.get(i2);
            if (!filteredProcList.contains(procName)) {
                filteredProcList.add(procName);
                continue;
            }
            StringBuffer buff = new StringBuffer("sqlprocAction::parseProcedureFile()-->");
            buff.append("Duplicate element \"" + procName + "\" ");
            buff.append("found at index \"" + i2 + "\" in the procedure List. Filtered...");
            OLogger.debug(buff);
        }
        OLogger.debug(new StringBuffer("Procedural elements to be backed up:::"));
        OLogger.debug(new StringBuffer(filteredProcList.toString()));
        if (filteredProcList.size() != 0) {
            this.setProcedureList(filteredProcList);
        }
        return true;
    }

    private void parseInput(String input) {
        input = input.trim();
        StringTokenizer strTok = new StringTokenizer(input, "\n");
        this.procInfo = new ArrayList();
        while (strTok.hasMoreTokens()) {
            String temp = strTok.nextToken();
            if ((temp = temp.trim()) == null || temp.equals("")) continue;
            this.procInfo.add(temp);
        }
    }

    public void constructApplyRestoreRollbackBackupSQL(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer fileName = new StringBuffer("AR_BR_");
        fileName.append(this.getKeyFilePathRep(this.filePath, this.sqlProcFileName));
        fileName.append("_");
        fileName.append(OLogger.getFormatTimeStamp());
        fileName.append(".sql");
        boolean isOk = OPatchEnv.setupScriptStorage(oracleHomePath, cookedPatchID);
        if (!isOk) {
            throw new RuntimeException("Not able to successfully create 'dbScripts' directory under $ORACLE_HOME/.patch_storage");
        }
        String dbScriptPath = OPatchEnv.getPatchStorageScriptPath(oracleHomePath, cookedPatchID);
        StringBuffer sqlFilePath = new StringBuffer(dbScriptPath);
        sqlFilePath.append(File.separator);
        sqlFilePath.append(fileName);
        String sqlFile = sqlFilePath.toString();
        File f2 = new File(sqlFile);
        try {
            f2.createNewFile();
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("Not able to create file for doing Apply - Restore (or) Rollback backup : " + sqlFilePath);
            buff.append("\n");
            buff.append(e2.getMessage());
            throw new RuntimeException(buff.toString(), e2);
        }
        StringBuffer buff = new StringBuffer("Constructing ");
        buff.append(sqlFilePath);
        buff.append("....");
        buff.append("\n");
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(f2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        PrintWriter pw = new PrintWriter(fout, true);
        pw.println("SET HEADING OFF;");
        for (int i2 = 0; i2 < this.procInfo.size(); ++i2) {
            String procedureName = (String)this.procInfo.get(i2);
            if (procedureName.equals("")) continue;
            StringBuffer sqlString = new StringBuffer("SELECT TEXT FROM USER_SOURCE WHERE TYPE = 'PROCEDURE' AND NAME = ");
            sqlString.append("'");
            sqlString.append(procedureName);
            sqlString.append("';");
            pw.println(sqlString.toString());
            buff.append("Constructed -> ");
            buff.append(sqlString);
            buff.append("\n");
        }
        pw.println("EXIT;");
        try {
            fout.close();
        }
        catch (IOException e4) {
            throw new RuntimeException(e4);
        }
        OLogger.debug(buff);
        this.procSqlForRetrieve = sqlFile;
    }

    public String getChildPath() {
        return "";
    }

    public String getParentDirPath(String path) {
        return "";
    }

    public String getParentFilePath(String path) {
        return "";
    }

    public String getSourceFileName() {
        return this.sqlProcFileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getProcedureTextFileName() {
        return this.sqlProcedureFile;
    }

    public ArrayList getProcedureList() {
        return this.procInfo;
    }

    protected void setProcedureList(ArrayList procInfo) {
        this.procInfo = procInfo;
    }

    public String getSourceFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.filePath);
        buff.append(File.separator);
        buff.append(this.sqlProcFileName);
        return buff.toString();
    }

    public String getProcedureTextFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.filePath);
        buff.append(File.separator);
        buff.append(this.sqlProcedureFile);
        return buff.toString();
    }

    public String getActionName() {
        return "sqlProcAction";
    }

    public String getActionDesc() {
        return "Run the sql procedure scripts and patch the database instance.";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("sqlprocAction::applicable()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        if (!OPatchEnv.isRunSql()) {
            return true;
        }
        String src = this.getSourceFile(patchLocation);
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\n");
        buff.append("dst = not applicable");
        OLogger.debug(buff);
        File srcFile = new File(src);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("SqlProcedure Action: source file \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!this.parseInfo) {
            String procedureLocation = this.getProcedureTextFile(patchLocation);
            this.parseInfo = this.parseProcedureFile(procedureLocation);
            if (!this.parseInfo) {
                buff = new StringBuffer("SqlProcedure Action : Unable to parse input procedure file : " + procedureLocation);
                buff.append("\n");
                this.nonApplicableDesc = buff.toString();
                return false;
            }
        }
        return true;
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        String errorMsg = this.getApplyFailureDescription();
        StringBuffer buff = new StringBuffer("sqlProcAction::apply()");
        OLogger.debug(buff);
        if (!OPatchEnv.isRunSql()) {
            OLogger.println("   [skipped]");
            return;
        }
        String src = this.getSourceFile(patchLocation);
        if (Rules.SystemWrite_continue()) {
            this.procSqlForRun = src;
            File f2 = new File(this.procSqlForRun);
            if (!f2.exists() || !f2.canRead()) {
                buff = new StringBuffer();
                buff.append(errorMsg);
                buff.append("\n");
                buff.append("The Run file to apply the procedures does not exist or is not readable, ");
                buff.append("Run sql file = ");
                buff.append(this.procSqlForRun);
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            String[] dbSids = OPatchEnv.getDBSIDs();
            try {
                buff = new StringBuffer("");
                SystemCall.ExecReturn[] retObj = this.runSQL(oracleHomePath, this.procSqlForRun);
                for (int i2 = 0; i2 < retObj.length; ++i2) {
                    if (retObj[i2] == null || retObj[i2].isOK()) continue;
                    buff.append("Failure in running the sql file to apply procedures on SID \"" + dbSids[i2] + "\"");
                    buff.append("Message given is : " + retObj[i2].getNormalMessage());
                    buff.append("\n");
                    buff.append(retObj[i2].getErrorMessage());
                    buff.append("\n");
                }
            }
            catch (RuntimeException e2) {
                throw new RuntimeException(errorMsg, e2);
            }
            if (!buff.toString().equals("")) {
                buff.append("sql used to run the procedures is : " + this.procSqlForRun);
                throw new RuntimeException(errorMsg + "\n" + buff.toString());
            }
        }
    }

    public String getApplicableDesc(String oracleHomePath, String owningComponent) {
        String desc = OLogger.getString("OUI-67520", new Object[]{this.nonApplicableDesc, owningComponent, this.relativeProcedureSqlLocation});
        return desc;
    }

    public String getApplyDescription(String oracleHomePath) {
        return "Running the apply sql procedure script \"" + this.relativeProcedureSqlLocation + "\"";
    }

    private String getApplyFailureDescription() {
        StringBuffer failureMsg = new StringBuffer("OPatch failed to execute");
        failureMsg.append(" \"" + this.relativeProcedureSqlLocation + "\"");
        return failureMsg.toString();
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        int i2;
        boolean isApplied;
        String sqlResult;
        StringBuffer buff = new StringBuffer("Sql Proc Action::rollbackable()");
        OLogger.debug(buff);
        if (!OPatchEnv.isRunSql()) {
            return true;
        }
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        Properties sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        if (sqlProp != null && (sqlResult = sqlProp.getProperty("RUNSQL")) != null && !(isApplied = Boolean.valueOf(sqlResult).booleanValue())) {
            return true;
        }
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcedureFile);
        String dbScriptPath = OPatchEnv.getPatchStorageScriptPath(oracleHomePath, cookedPatchID);
        String sessionType = OPatchEnv.getSessionType();
        StringBuffer filePath = new StringBuffer(dbScriptPath);
        filePath.append(File.separator);
        filePath.append("SQLPROC_Rollback");
        String rollbackFile = filePath.toString();
        File f2 = new File(rollbackFile);
        if (!f2.exists() || !f2.canRead()) {
            buff = new StringBuffer("Mapping file for rollback \"" + rollbackFile + "\" does not exist or " + "is not readable");
            OLogger.debug(buff);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f2);
        }
        catch (Exception e2) {
            buff = new StringBuffer("Mapping file for rollback \"" + rollbackFile + "\" is not readable");
            OLogger.printStackTrace(e2);
            OLogger.debug(new StringBuffer(e2.getMessage()));
            OLogger.debug(buff);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        Properties mapping = null;
        try {
            if (mapping == null) {
                mapping = new Properties();
            }
            mapping.load(fin);
        }
        catch (Exception e3) {
            buff = new StringBuffer("Unable to load the mapping file \"" + rollbackFile + "\"for rollback information");
            OLogger.printStackTrace(e3);
            OLogger.debug(new StringBuffer(e3.getMessage()));
            OLogger.debug(buff);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        buff = new StringBuffer("");
        ArrayList<String> filesToCheck = new ArrayList<String>();
        for (i2 = 0; i2 < dbSids.length; ++i2) {
            if (!dbNodes[i2].equals(localNode) && !dbNodes[i2].equals("")) continue;
            StringBuffer keyBuff = new StringBuffer(dbSids[i2]);
            keyBuff.append("_");
            keyBuff.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
            String key = keyBuff.toString();
            StringBuffer rbKeyBuff = keyBuff.append("_RbStatus");
            String rbKey = rbKeyBuff.toString();
            String rbValue = mapping.getProperty(rbKey);
            if (rbValue == null || rbValue.trim().equals("")) {
                buff.append("The rollback status of action represented by the procedure text ");
                buff.append("file \"" + src.toString() + "\" is ");
                buff.append("not found in the mapping file \"" + rollbackFile + "\"");
                continue;
            }
            if (!rbValue.equals("false")) {
                buff.append("The action represented by procedure text file \"" + src.toString() + "\" has a ");
                buff.append("rollback status \"" + rbValue + "\". So, it cannot be rollbacked.");
                buff.append("\nPossible causes are \n1)sql procedure action already rollbacked\n2)");
                buff.append("sql procedure action skipped during apply");
                continue;
            }
            String value = mapping.getProperty(key);
            if (value == null || value.trim().equals("")) {
                buff.append("The rollback sql path of the procedure text file \"" + src.toString() + "\" is ");
                buff.append("not found in the mapping file \"" + rollbackFile + "\"");
                continue;
            }
            filesToCheck.add(value);
        }
        if (!buff.toString().equals("")) {
            OLogger.debug(buff);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("");
        for (i2 = 0; i2 < filesToCheck.size(); ++i2) {
            String fileLoc = (String)filesToCheck.get(i2);
            f2 = new File(fileLoc);
            if (f2.exists() && f2.canRead()) continue;
            buff = new StringBuffer("Actual sql file for rollback \"" + fileLoc + "\" does not exist or " + "is not readable");
            buff.append("\n");
        }
        if (!buff.toString().equals("")) {
            OLogger.debug(buff);
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        boolean isApplied;
        String sqlResult;
        boolean needRunSqlCheck;
        String errorMsg = this.getRollbackFailureDesc();
        StringBuffer buff = new StringBuffer("Sql Proc Action::rollback()");
        OLogger.debug(buff);
        Properties mapping = null;
        if (!OPatchEnv.isRunSql()) {
            OLogger.println("   [skipped]");
            return;
        }
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        Properties sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        String sessionType = OPatchEnv.getSessionType();
        boolean bl = needRunSqlCheck = sessionType.equals("rollback") || OPatchEnv.isNRollback() || sessionType.equals("apply") || OPatchEnv.isNApply();
        if (sqlProp != null && needRunSqlCheck && (sqlResult = sqlProp.getProperty("RUNSQL")) != null && !(isApplied = Boolean.valueOf(sqlResult).booleanValue())) {
            OLogger.println("   [skipped]");
            return;
        }
        String dbScriptPath = OPatchEnv.getPatchStorageScriptPath(oracleHomePath, cookedPatchID);
        StringBuffer filePath = new StringBuffer(dbScriptPath);
        filePath.append(File.separator);
        filePath.append("SQLPROC_Rollback");
        String rollbackFile = filePath.toString();
        buff = new StringBuffer("");
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswords = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(rollbackFile);
        }
        catch (Exception e2) {
            buff = new StringBuffer("Mapping file for rollback \"" + rollbackFile + "\" is not opening for " + "input stream");
            buff.append("\n");
            buff.append(e2.getMessage());
            buff.append(errorMsg);
            throw new RuntimeException(buff.toString(), e2);
        }
        if (mapping == null) {
            mapping = new Properties();
        }
        try {
            mapping.load(fin);
        }
        catch (Exception e3) {
            buff = new StringBuffer("Unable to load the mapping file \"" + rollbackFile + "\"for rollback ");
            buff.append("\n");
            buff.append(e3.getMessage());
            buff.append(errorMsg);
            throw new RuntimeException(buff.toString(), e3);
        }
        StringBuffer oraWarnMsg = new StringBuffer("");
        String rbValue = "unknown";
        String key = "";
        StringBuffer keyBuff = new StringBuffer("");
        String rollbackStatusKey = "";
        for (int i2 = 0; i2 < dbSids.length; ++i2) {
            Object var30_33;
            String value;
            if (dbNodes[i2] != null && !dbNodes[i2].equals("") && !dbNodes[i2].equals(localNode) && !dbNodes[i2].equals("")) continue;
            keyBuff = new StringBuffer();
            keyBuff.append(dbSids[i2]);
            keyBuff.append("_");
            keyBuff.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
            key = keyBuff.toString();
            OLogger.debug(new StringBuffer("KEY IS : "));
            OLogger.debug(keyBuff);
            rollbackStatusKey = keyBuff.append("_RbStatus").toString();
            String rbStatus = mapping.getProperty(rollbackStatusKey);
            if (rbStatus.equals("true") || (value = mapping.getProperty(key)) == null || value.equals("")) continue;
            try {
                try {
                    String oraString;
                    SystemCall.ExecReturn ret = null;
                    if (SQLUtilities.startupDB(oracleHomePath, OPatchEnv.isSqlMigrate(), dbUsers[i2], dbPasswords[i2], dbSids[i2])) {
                        ret = SQLUtilities.runSqlScript(oracleHomePath, value, dbUsers[i2], dbPasswords[i2], dbSids[i2]);
                    }
                    if (!ret.isOK()) {
                        buff = new StringBuffer();
                        buff.append("Error returned while executing the script \"" + value + "\" for rollback\n");
                        buff.append("Error Message is : " + ret.getErrorMessage());
                        buff.append("\n");
                        buff.append("Normal Message is : " + ret.getNormalMessage());
                        buff.append("\n");
                        OLogger.debug(buff);
                    }
                    if (!(oraString = SQLUtilities.detectOraError(ret.getNormalMessage())).equals("")) {
                        String resourceStr = OLogger.getString("OUI-67261", new Object[]{value, dbSids[i2]});
                        oraWarnMsg.append(resourceStr);
                        oraWarnMsg.append("\n");
                        oraWarnMsg.append("Error Information : ");
                        oraWarnMsg.append("\n");
                        oraWarnMsg.append(oraString);
                    }
                    if (ret.isOK() && oraString.equals("")) {
                        rbValue = "true";
                    }
                }
                catch (RuntimeException e4) {
                    throw new RuntimeException(e4.getMessage() + errorMsg, e4);
                }
                var30_33 = null;
                this.updateMappingFile(new File(rollbackFile), rollbackStatusKey, rbValue);
                continue;
            }
            catch (Throwable throwable) {
                var30_33 = null;
                this.updateMappingFile(new File(rollbackFile), rollbackStatusKey, rbValue);
                throw throwable;
            }
        }
        if (!buff.toString().equals("")) {
            buff.append(errorMsg);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (!oraWarnMsg.toString().equals("")) {
            oraWarnMsg.append(errorMsg);
            OLogger.debug(oraWarnMsg);
            throw new RuntimeException(oraWarnMsg.toString());
        }
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("sqlprocAction::backupForRollback()");
        OLogger.debug(buff);
        String patchLocation = OPatchEnv.getPatchloc();
        String srcFile = this.getSourceFile(patchLocation);
        File f1 = new File(srcFile);
        StringBuffer dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlProcFileName);
        String dstFile = dstPath.toString();
        File f2 = new File(dstFile);
        if (!srcFile.equals(dstFile)) {
            if (!f1.exists() || !f1.canRead()) {
                buff = new StringBuffer("sqlprocAction::Source procedure sql file \"");
                buff.append(srcFile);
                buff.append("\" does not exist or is not readable");
                OLogger.debug(buff);
                this.backupForRollbackFailureDesc = buff.toString();
                throw new RuntimeException(buff.toString());
            }
            try {
                buff = new StringBuffer("sqlProcAction::backupForRollback(): back up ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
                SystemCall.backupFile(f1, f2);
            }
            catch (RuntimeException e2) {
                this.backupForRollbackFailureDesc = e2.getMessage();
                throw e2;
            }
        }
        String procedureFile = this.getProcedureTextFile(patchLocation);
        f1 = new File(procedureFile);
        dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlProcedureFile);
        dstFile = dstPath.toString();
        f2 = new File(dstFile);
        if (!procedureFile.equals(dstFile)) {
            if (!f1.exists() || !f1.canRead()) {
                buff = new StringBuffer("sqlprocAction::Source procedure text file \"");
                buff.append(srcFile);
                buff.append("\" does not exist or is not readable");
                OLogger.debug(buff);
                this.backupForRollbackFailureDesc = buff.toString();
                throw new RuntimeException(buff.toString());
            }
            if (f2.exists()) {
                f2.delete();
            }
            try {
                buff = new StringBuffer("sqlProcAction::backupForRollback(): back up ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
                SystemCall.backupFile(f1, f2);
            }
            catch (RuntimeException e3) {
                this.backupForRollbackFailureDesc = OLogger.getString("OUI-67003", new Object[]{srcFile, dstFile, e3.getMessage()});
                OLogger.println(this.backupForRollbackFailureDesc);
                throw e3;
            }
        }
        if (!OPatchEnv.isRunSql()) {
            return;
        }
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        try {
            this.backupSqlProcedures(oracleHomePath, cookedPatchID, "SQLPROC_Rollback", "SQLPROC_BackupRollback", this.ROLLBACK_MODE);
        }
        catch (RuntimeException e4) {
            this.backupForRollbackFailureDesc = e4.getMessage();
            throw e4;
        }
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcedureFile);
        String desc = OLogger.getString("OUI-67521", new Object[]{this.nonRollbackableDesc, owningComponent, src.toString()});
        return desc;
    }

    public String getRollbackDescription(String oracleHomePath) {
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcedureFile);
        return "Running the rollback sql procedure script corresponding to backed up procedures \"" + src.toString() + "\"";
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) {
        return "";
    }

    private String getRollbackFailureDesc() {
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcFileName);
        String failMessage = "\nOPatch failed to rollback sql procedure scripts for \"" + src.toString() + "\"";
        return failMessage;
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        String procedureLocation = "";
        StringBuffer buff = new StringBuffer("sqlprocAction::restorable()");
        OLogger.debug(buff);
        if (!Rules.SystemWrite_continue()) {
            return true;
        }
        if (!OPatchEnv.isRunSql()) {
            return true;
        }
        String sessionType = OPatchEnv.getSessionType();
        boolean autoRollBack = OPatchEnv.isAutoRollbackBackup();
        if ((sessionType.equals("apply") || OPatchEnv.isNApply()) && autoRollBack && !OPatchEnv.getAutoRollbackCookedPatchID().equals("")) {
            cookedPatchID = OPatchEnv.getAutoRollbackCookedPatchID();
        }
        if (sessionType.equals("rollback") || OPatchEnv.isNRollback() || (sessionType.equals("apply") || OPatchEnv.isNApply()) && autoRollBack) {
            boolean isApplied;
            String sqlResult;
            Properties sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
            if (sqlProp != null && (sqlResult = sqlProp.getProperty("RUNSQL")) != null && !(isApplied = Boolean.valueOf(sqlResult).booleanValue())) {
                return true;
            }
            StringBuffer dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            dstPath.append(File.separator);
            dstPath.append(this.filePath);
            dstPath.append(File.separator);
            dstPath.append(this.sqlProcedureFile);
            procedureLocation = dstPath.toString();
        } else if ((sessionType.equals("apply") || OPatchEnv.isNApply()) && !autoRollBack) {
            procedureLocation = this.getProcedureTextFile(OPatchEnv.getPatchloc());
        }
        if (!this.parseInfo) {
            this.parseInfo = this.parseProcedureFile(procedureLocation);
            if (!this.parseInfo) {
                buff = new StringBuffer("\nSqlProcedure Action : Unable to parse input procedure file");
                OLogger.debug(buff);
                this.nonBackupForRestoreDesc = buff.toString();
                return false;
            }
        }
        try {
            this.constructApplyRestoreRollbackBackupSQL(oracleHomePath, cookedPatchID);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer("\nSqlProcedure Action : Unable to successfully create primary sql file for Apply Session to start backup for restore (or) backup for rollback");
            buff.append("\n");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            this.nonBackupForRestoreDesc = buff.toString();
            return false;
        }
        File f2 = new File(this.procSqlForRetrieve);
        if (!f2.exists() || !f2.canRead()) {
            buff = new StringBuffer("\nNot able to detect existence or readability of \"" + this.procSqlForRetrieve + "\"");
            buff.append("\n This sql should have been constructed for backup for restore");
            OLogger.debug(buff);
            this.nonBackupForRestoreDesc = buff.toString();
            return false;
        }
        return true;
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        this.backupSqlProcedures(oracleHomePath, cookedPatchID, "SQLPROC_ApplyBackupRestore", "", this.RESTORE_MODE);
        this.isBackedUpForRestore = true;
    }

    private void backupSqlProcedures(String oracleHomePath, String cookedPatchID, String mainFile, String backupFile, int mode) throws RuntimeException {
        String differ;
        String generalPath;
        File fGeneral;
        StringBuffer filePath1;
        String dbScriptPath;
        SystemCall.ExecReturn[] retObj;
        StringBuffer buff;
        Properties mapping;
        String modeStr;
        block45: {
            boolean isApplied;
            String sqlResult;
            Properties sqlProp;
            modeStr = "";
            mapping = null;
            buff = new StringBuffer("sqlprocAction::backupSqlProcedures()");
            OLogger.debug(buff);
            if (!OPatchEnv.isRunSql()) {
                return;
            }
            if (!Rules.SystemWrite_continue()) {
                return;
            }
            String sessionType = OPatchEnv.getSessionType();
            boolean autoRollBack = OPatchEnv.isAutoRollbackBackup();
            if ((sessionType.equals("rollback") || OPatchEnv.isNRollback() || autoRollBack) && (sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID)) != null && (sqlResult = sqlProp.getProperty("RUNSQL")) != null && !(isApplied = Boolean.valueOf(sqlResult).booleanValue())) {
                return;
            }
            if (mode == this.RESTORE_MODE) {
                modeStr = "restore";
            } else if (mode == this.ROLLBACK_MODE) {
                modeStr = "rollback";
            }
            retObj = null;
            if ((sessionType.equals("apply") || OPatchEnv.isNApply()) && autoRollBack && !OPatchEnv.getAutoRollbackCookedPatchID().equals("")) {
                cookedPatchID = OPatchEnv.getAutoRollbackCookedPatchID();
            }
            if (!currentCookedID.equals(cookedPatchID)) {
                currentCookedID = cookedPatchID;
                isFileBackedUp = false;
            }
            try {
                retObj = this.runSQL(oracleHomePath, this.procSqlForRetrieve);
            }
            catch (RuntimeException e2) {
                this.nonBackupForRestoreDesc = e2.getMessage();
                OLogger.debug(new StringBuffer(e2.getMessage()));
                OLogger.printStackTrace(e2);
                throw e2;
            }
            if (retObj == null || retObj.length == 0) {
                buff = new StringBuffer("\nBackup for " + modeStr + " Failed. Could not " + "retrieve any of the db contents");
                this.nonBackupForRestoreDesc = buff.toString();
                throw new RuntimeException(buff.toString());
            }
            boolean isOk = OPatchEnv.setupScriptStorage(oracleHomePath, cookedPatchID);
            if (!isOk) {
                buff = new StringBuffer("\nNot able to successfully create 'dbScripts' directory under $ORACLE_HOME/.patch_storage");
                this.nonBackupForRestoreDesc = buff.toString();
                throw new RuntimeException(buff.toString());
            }
            dbScriptPath = OPatchEnv.getPatchStorageScriptPath(oracleHomePath, cookedPatchID);
            boolean autoRollback = OPatchEnv.isAutoRollbackBackup();
            filePath1 = new StringBuffer(dbScriptPath);
            filePath1.append(File.separator);
            filePath1.append(mainFile);
            StringBuffer filePath2 = new StringBuffer(dbScriptPath);
            filePath2.append(File.separator);
            filePath2.append("SQLPROC_RollbackBackupRestore");
            StringBuffer fileBackup = null;
            if (!isFileBackedUp && mode == this.ROLLBACK_MODE) {
                fileBackup = new StringBuffer(dbScriptPath);
                fileBackup.append(File.separator);
                fileBackup.append(backupFile);
            }
            if (mapping == null) {
                mapping = new Properties();
            }
            File f1 = new File(filePath1.toString());
            File f2 = new File(filePath2.toString());
            fGeneral = null;
            generalPath = "";
            differ = "";
            if ((sessionType.equals("apply") || OPatchEnv.isNApply()) && !autoRollback) {
                fGeneral = f1;
                generalPath = filePath1.toString();
                if (mode == this.RESTORE_MODE) {
                    differ = "A";
                } else if (mode == this.ROLLBACK_MODE) {
                    differ = "RB";
                }
            } else if (sessionType.equals("rollback") || OPatchEnv.isNRollback() || autoRollback) {
                fGeneral = f2;
                generalPath = filePath2.toString();
                differ = "R";
            } else {
                fGeneral = f1;
                generalPath = filePath1.toString();
                differ = "RB";
            }
            try {
                if (!fGeneral.exists()) {
                    isOk = fGeneral.createNewFile();
                    if (!isOk) {
                        buff = new StringBuffer("\nUnable to create file : " + filePath1 + " for 'Backup for " + modeStr + "'");
                        buff.append("\n");
                        OLogger.debug(buff);
                        this.nonBackupForRestoreDesc = buff.toString();
                        throw new RuntimeException(buff.toString());
                    }
                    break block45;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(fGeneral);
                }
                catch (Exception e3) {
                    buff = new StringBuffer("Mapping file for backup for " + modeStr + " \"" + generalPath + "\" is not opening for " + "input stream");
                    buff.append("\n");
                    buff.append(e3.getMessage());
                    throw new RuntimeException(buff.toString(), e3);
                }
                try {
                    mapping.load(fin);
                }
                catch (Exception e4) {
                    buff = new StringBuffer("Unable to load the mapping file \"" + generalPath + "\"for backup for " + modeStr + " ");
                    buff.append("\n");
                    buff.append(e4.getMessage());
                    throw new RuntimeException(buff.toString(), e4);
                }
                if (isFileBackedUp || mode != this.ROLLBACK_MODE) break block45;
                File f3 = new File(fileBackup.toString());
                if (f3.exists()) {
                    f3.delete();
                }
                if (!(isOk = f3.createNewFile())) {
                    buff = new StringBuffer("\nUnable to back up the existing the file : " + filePath1 + " for " + "ensuring sanity of the script information for rollback");
                    buff.append("\n");
                    OLogger.debug(buff);
                    this.nonBackupForRestoreDesc = buff.toString();
                    throw new RuntimeException(buff.toString());
                }
                try {
                    SystemCall.backupFile(fGeneral, f3);
                    isFileBackedUp = true;
                }
                catch (Exception e5) {
                    buff = new StringBuffer("\nUnable to back up the existing file : " + filePath1 + " for " + "ensuring sanity of the script information for rollback");
                    buff.append("\n");
                    buff.append(e5.getMessage());
                    OLogger.debug(buff);
                    this.nonBackupForRestoreDesc = buff.toString();
                    throw new RuntimeException(buff.toString());
                }
            }
            catch (Exception e6) {
                buff = new StringBuffer("\nUnable to create file : " + filePath1 + " for 'Backup for " + modeStr + "'");
                buff.append("\n");
                buff.append(e6.getMessage());
                OLogger.debug(buff);
                this.nonBackupForRestoreDesc = buff.toString();
                RuntimeException re = new RuntimeException(buff.toString(), e6);
                throw re;
            }
        }
        FileOutputStream fout = null;
        FileOutputStream fTemp = null;
        try {
            fout = new FileOutputStream(fGeneral);
        }
        catch (IOException e7) {
            buff = new StringBuffer("\nUnable to open output stream for file : " + filePath1 + " for " + "Backup for " + modeStr + "'");
            buff.append("\n");
            buff.append(e7.getMessage());
            OLogger.debug(buff);
            this.nonBackupForRestoreDesc = buff.toString();
            RuntimeException re = new RuntimeException(buff.toString(), e7);
            throw re;
        }
        String[] refined = new String[retObj.length];
        String[] dbSids = OPatchEnv.getDBSIDs();
        String key = "";
        String value = "";
        StringBuffer sidBuff = new StringBuffer("");
        for (int i2 = 0; i2 < retObj.length; ++i2) {
            StringBuffer keyBuff;
            String msg;
            if (retObj[i2] == null || (msg = retObj[i2].getNormalMessage()) == null || msg.equals("")) continue;
            refined[i2] = this.constructSQLStringRepresentation(msg);
            StringBuffer tempSqlFile = new StringBuffer(dbScriptPath);
            tempSqlFile.append(File.separator);
            tempSqlFile.append(differ);
            tempSqlFile.append("_");
            tempSqlFile.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
            tempSqlFile.append("_");
            tempSqlFile.append(dbSids[i2]);
            tempSqlFile.append("_");
            tempSqlFile.append(OLogger.getFormatTimeStamp());
            tempSqlFile.append(".sql");
            File tempObj = new File(tempSqlFile.toString());
            try {
                tempObj.createNewFile();
                fTemp = new FileOutputStream(tempObj);
            }
            catch (Exception e8) {
                buff = new StringBuffer("\nUnable to create the sql file : " + tempSqlFile + " for 'Backup for " + modeStr + "'");
                buff.append("\n");
                buff.append("This sql file was attempted to be created for SID \"" + dbSids[i2] + "\"\n");
                buff.append(e8.getMessage());
                OLogger.debug(buff);
                this.nonBackupForRestoreDesc = buff.toString();
                if (mode == this.ROLLBACK_MODE) {
                    keyBuff = new StringBuffer(dbSids[i2]);
                    keyBuff.append("_");
                    keyBuff.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
                    keyBuff.append("_RbStatus");
                    mapping.setProperty(keyBuff.toString(), "unknown");
                }
                RuntimeException re = new RuntimeException(buff.toString(), e8);
                throw re;
            }
            PrintWriter pTemp = new PrintWriter(fTemp, true);
            pTemp.println(refined[i2]);
            keyBuff = new StringBuffer(dbSids[i2]);
            keyBuff.append("_");
            keyBuff.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
            key = keyBuff.toString();
            value = tempSqlFile.toString();
            mapping.setProperty(key, value);
            if (mode == this.ROLLBACK_MODE) {
                StringBuffer rbBuff = new StringBuffer(keyBuff.toString());
                rbBuff.append("_RbStatus");
                key = rbBuff.toString();
                value = "false";
                mapping.setProperty(key, value);
            }
            if (!sidBuff.toString().equals("")) {
                sidBuff.append(",");
            }
            sidBuff.append(dbSids[i2]);
        }
        mapping.setProperty("SID", sidBuff.toString());
        try {
            mapping.store(fout, null);
            fout.close();
        }
        catch (Exception e9) {
            buff = new StringBuffer("\nProblem with storing mapping information for 'Backup for " + modeStr + "' \n" + "in the file \"" + generalPath + "\"");
            buff.append("\n");
            buff.append(e9.getMessage());
            OLogger.debug(buff);
            this.nonBackupForRestoreDesc = buff.toString();
            RuntimeException re = new RuntimeException(buff.toString(), e9);
            throw re;
        }
    }

    private String getKeyFilePathRep(String filePath, String fileName) {
        StringBuffer buff = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(filePath, File.separator);
        while (strTok.hasMoreTokens()) {
            String temp = strTok.nextToken();
            if (temp == null || temp.equals("")) continue;
            buff.append(temp);
            buff.append("_");
        }
        buff.append(fileName);
        return buff.toString();
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        boolean applyMode = true;
        ArrayList<String> keys = new ArrayList<String>();
        StringBuffer buff = new StringBuffer("Sql Proc Action::restore()");
        OLogger.debug(buff);
        String errorMsg = this.getRestoreFailureDesc();
        String dbScriptPath = OPatchEnv.getPatchStorageScriptPath(oracleHomePath, cookedPatchID);
        buff = new StringBuffer("Calling restore() with Cooked ID " + cookedPatchID + " and ");
        buff.append("with (apply = " + apply + ", rollback = " + rollback + ")");
        OLogger.debug(buff);
        if (!OPatchEnv.isRunSql()) {
            return;
        }
        if (!Rules.SystemWrite_continue()) {
            return;
        }
        if (!this.isBackedUpForRestore) {
            buff = new StringBuffer("No restore due to backup boolean being false");
            OLogger.debug(buff);
            return;
        }
        if (!apply && !rollback) {
            buff = new StringBuffer();
            buff.append(errorMsg);
            buff.append("\n");
            buff.append("Not able to restore as restore() method was not able ");
            buff.append("to detect if it was an apply,rollback or auto-rollback");
            buff.append("\n");
            throw new RuntimeException(buff.toString());
        }
        applyMode = apply && !rollback;
        StringBuffer restoreFilePath = new StringBuffer(dbScriptPath);
        restoreFilePath.append(File.separator);
        if (applyMode) {
            restoreFilePath.append("SQLPROC_ApplyBackupRestore");
        } else {
            boolean isApplied;
            String sqlResult;
            Properties sqlProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
            if (sqlProp != null && (sqlResult = sqlProp.getProperty("RUNSQL")) != null && !(isApplied = Boolean.valueOf(sqlResult).booleanValue())) {
                return;
            }
            restoreFilePath.append("SQLPROC_RollbackBackupRestore");
        }
        String restoreFile = restoreFilePath.toString();
        buff = new StringBuffer("");
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswords = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(restoreFile);
        }
        catch (Exception e2) {
            buff = new StringBuffer();
            buff.append(errorMsg);
            buff.append("\n");
            buff.append("Mapping file for restore \"" + restoreFile + "\" is not opening for " + "input stream");
            buff.append("\n");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e2);
        }
        Properties p2 = new Properties();
        try {
            p2.load(fin);
        }
        catch (Exception e3) {
            buff = new StringBuffer();
            buff.append(errorMsg);
            buff.append("Unable to load the mapping file \"" + restoreFile + "\"for restore");
            buff.append("\n");
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e3);
        }
        StringBuffer oraMsg = new StringBuffer("");
        StringBuffer retMsg = new StringBuffer("");
        StringBuffer fileMsg = new StringBuffer("");
        boolean failRestore = false;
        for (int i2 = 0; i2 < dbSids.length; ++i2) {
            if (dbNodes[i2] != null && !dbNodes[i2].equals("") && !dbNodes[i2].equals(localNode) && !dbNodes[i2].equals("")) continue;
            StringBuffer keyBuff = new StringBuffer(dbSids[i2]);
            keyBuff.append("_");
            keyBuff.append(this.getKeyFilePathRep(this.filePath, this.sqlProcedureFile));
            String key = keyBuff.toString();
            keys.add(keyBuff.append("_RbStatus").toString());
            OLogger.debug(new StringBuffer("Key is : "));
            OLogger.debug(new StringBuffer(key));
            String value = p2.getProperty(key);
            OLogger.debug(new StringBuffer("Restore Sql to run is : "));
            OLogger.debug(new StringBuffer(value));
            if (value == null || value.equals("")) {
                buff = new StringBuffer();
                buff.append("No sql file for restore is found for the SID \"" + dbSids[i2] + "\"");
                buff.append("\n");
                OLogger.debug(buff);
                fileMsg.append(buff);
                failRestore = true;
                continue;
            }
            try {
                String oraString;
                SystemCall.ExecReturn ret = null;
                if (SQLUtilities.startupDB(oracleHomePath, OPatchEnv.isSqlMigrate(), dbUsers[i2], dbPasswords[i2], dbSids[i2])) {
                    ret = SQLUtilities.runSqlScript(oracleHomePath, value, dbUsers[i2], dbPasswords[i2], dbSids[i2]);
                }
                if (!ret.isOK()) {
                    buff = new StringBuffer();
                    buff.append("Error returned while executing the script \"" + value + "\" for restore\n");
                    buff.append("Error Message is : " + ret.getErrorMessage());
                    buff.append("\n");
                    buff.append("Normal Message is : " + ret.getNormalMessage());
                    buff.append("\n");
                    OLogger.debug(buff);
                    retMsg.append(buff);
                    failRestore = true;
                }
                if ((oraString = SQLUtilities.detectOraError(ret.getNormalMessage())).equals("")) continue;
                String resourceStr = OLogger.getString("OUI-67261", new Object[]{value, dbSids[i2]});
                oraMsg.append(errorMsg);
                oraMsg.append("\n");
                oraMsg.append(resourceStr);
                oraMsg.append("\n");
                oraMsg.append("Error Information : ");
                oraMsg.append("\n");
                oraMsg.append(oraString);
                oraMsg.append("\n");
                OLogger.debug(oraMsg);
                failRestore = true;
                continue;
            }
            catch (Exception e4) {
                buff = new StringBuffer();
                buff.append(errorMsg);
                buff.append("\n");
                buff.append(e4.getMessage());
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString(), e4);
            }
        }
        if (failRestore) {
            buff = new StringBuffer(errorMsg);
            buff.append("\n");
            buff.append(fileMsg);
            buff.append(retMsg);
            buff.append(oraMsg);
            throw new RuntimeException(buff.toString());
        }
        if (applyMode) {
            File fSql;
            String sqlPropertyFilePath = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, cookedPatchID);
            String backupSqlPropertyFilePath = OPatchEnv.getBackupSqlPropertyFilePath(oracleHomePath, cookedPatchID);
            File fBackupSql = new File(backupSqlPropertyFilePath);
            if (fBackupSql.exists()) {
                OLogger.debug(new StringBuffer("Re-copying backed up rollback file to its original location..."));
                fSql = new File(sqlPropertyFilePath);
                try {
                    SystemCall.backupFile(fBackupSql, fSql);
                }
                catch (RuntimeException e5) {
                    buff = new StringBuffer(errorMsg);
                    buff.append("\n");
                    buff.append(e5.getMessage());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString(), e5);
                }
            } else {
                boolean ok;
                OLogger.debug(new StringBuffer("Deleting the sqlproperties file..."));
                fSql = new File(sqlPropertyFilePath);
                if (fSql.exists() && !(ok = fSql.delete())) {
                    buff = new StringBuffer("Unable to delete the sqlproperties file created during apply");
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
            }
            StringBuffer backupRollbackFilePath = new StringBuffer(dbScriptPath);
            backupRollbackFilePath.append(File.separator);
            backupRollbackFilePath.append("SQLPROC_BackupRollback");
            File fBackupRollback = new File(backupRollbackFilePath.toString());
            if (fBackupRollback.exists()) {
                StringBuffer rollbackFilePath = new StringBuffer(dbScriptPath);
                rollbackFilePath.append(File.separator);
                rollbackFilePath.append("SQLPROC_Rollback");
                File fRollback = new File(rollbackFilePath.toString());
                try {
                    SystemCall.backupFile(fBackupRollback, fRollback);
                }
                catch (RuntimeException e6) {
                    buff = new StringBuffer(errorMsg);
                    buff.append("\n");
                    buff.append(e6.getMessage());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString(), e6);
                }
            }
        } else {
            StringBuffer updateRollbackFile = new StringBuffer(dbScriptPath);
            updateRollbackFile.append(File.separator);
            updateRollbackFile.append("SQLPROC_Rollback");
            File f2 = new File(updateRollbackFile.toString());
            FileInputStream fRollbackIn = null;
            Properties pRollback = null;
            if (f2.exists()) {
                OLogger.debug(new StringBuffer("Trying to switch rollback file statuses..."));
                try {
                    fRollbackIn = new FileInputStream(f2);
                }
                catch (Exception e7) {
                    buff = new StringBuffer(errorMsg);
                    buff.append("\n");
                    buff.append("Mapping file for rollback \"" + updateRollbackFile.toString() + "\" is not opening for " + "input stream");
                    buff.append("\n");
                    buff.append(e7.getMessage());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString(), e7);
                }
                try {
                    pRollback = new Properties();
                    pRollback.load(fRollbackIn);
                }
                catch (Exception e8) {
                    buff = new StringBuffer(errorMsg);
                    buff.append("\n");
                    buff.append("Unable to load the mapping file (rollback) \"" + updateRollbackFile.toString() + "\"");
                    buff.append("\n");
                    buff.append(e8.getMessage());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString(), e8);
                }
                for (int i3 = 0; i3 < keys.size(); ++i3) {
                    String key = (String)keys.get(i3);
                    String value = pRollback.getProperty(key);
                    if (value == null) continue;
                    pRollback.setProperty(key, "false");
                }
                try {
                    FileOutputStream fout = new FileOutputStream(f2);
                    pRollback.store(fout, null);
                }
                catch (Exception e9) {
                    buff = new StringBuffer(errorMsg);
                    buff.append("\n");
                    buff.append("Unable to restore the updated rollback information to rollback file");
                    buff.append(" \"" + updateRollbackFile.toString() + "\"");
                    buff.append("\n");
                    buff.append(e9.getMessage());
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
            }
        }
    }

    private String getRestoreFailureDesc() {
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcFileName);
        String failMessage = "\nRestore failed for \"" + src.toString() + "\"";
        return failMessage;
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer src = new StringBuffer();
        src.append(this.filePath);
        src.append(File.separator);
        src.append(this.sqlProcedureFile);
        StringBuffer buff = new StringBuffer("Unable to backup procedures corresponding to file \"" + src.toString() + "\"");
        buff.append(this.nonBackupForRestoreDesc);
        return buff.toString();
    }

    private SystemCall.ExecReturn[] runSQL(String oracleHomePath, String sqlFile) throws RuntimeException {
        SystemCall.ExecReturn[] retObj = null;
        StringBuffer oraWarnMsg = new StringBuffer("");
        StringBuffer buff = new StringBuffer("SQLProcAction::runSQL()");
        buff.append("\nNow, let's connect to DB and run the sql : " + sqlFile);
        OLogger.debug(buff);
        String localNode = OPatchEnv.getLocalNode();
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbUsers = OPatchEnv.getDBUsers();
        String[] dbPasswds = OPatchEnv.getDBPasswds();
        String[] dbNodes = OPatchEnv.getDBNodes();
        if (dbSids == null || dbSids.length < 1) {
            RuntimeException re = new RuntimeException("SqlProcAction : Database SIDs are not provided.");
            throw re;
        }
        retObj = new SystemCall.ExecReturn[dbSids.length];
        for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
            if (!(dbNodes[sidIter] == null || dbNodes[sidIter].equals("") || dbNodes[sidIter].equals(localNode) || dbNodes[sidIter].equals(""))) {
                retObj[sidIter] = null;
                continue;
            }
            SystemCall.ExecReturn ret = null;
            try {
                if (!SQLUtilities.startupDB(oracleHomePath, OPatchEnv.isSqlMigrate(), dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter])) {
                    OPatchEnv.setSqlDBError(true);
                    RuntimeException re = new RuntimeException("Unable to startup the DB \"" + dbSids[sidIter] + "\"");
                    throw re;
                }
                ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFile, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter]);
            }
            catch (Exception e2) {
                buff = new StringBuffer("sqlprocAction::runSQL()\n");
                buff.append("    " + e2.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException("SQL Script failed. " + e2.getMessage(), e2);
                throw re;
            }
            boolean ok = ret.isOK();
            buff = new StringBuffer(ret.toString());
            OLogger.debug(buff);
            if (!ok) {
                buff = new StringBuffer("Execution of SQL Script \"" + sqlFile + "\" results in " + "error code returned.");
                buff.append("\n");
                buff.append(ret.getErrorMessage());
                throw new RuntimeException(buff.toString());
            }
            String oraString = SQLUtilities.detectOraError(ret.getNormalMessage());
            if (!oraString.equals("")) {
                String resourceStr = OLogger.getString("OUI-67261", new Object[]{sqlFile, dbSids[sidIter]});
                oraWarnMsg.append(resourceStr);
                oraWarnMsg.append("\n");
                oraWarnMsg.append("Error Information : ");
                oraWarnMsg.append("\n");
                oraWarnMsg.append(oraString);
            }
            retObj[sidIter] = ret;
        }
        if (!oraWarnMsg.toString().equals("")) {
            OPatchEnv.setSqlDBError(true);
            throw new RuntimeException(oraWarnMsg.toString());
        }
        return retObj;
    }

    private String constructSQLStringRepresentation(String input) {
        String inProcess = "";
        String frontPortion = "";
        String middlePortion = "";
        String lastPortion = "";
        StringBuffer temp = new StringBuffer();
        if (input == null) {
            return "EXIT;";
        }
        inProcess = input.replaceAll("[\n]*[0-9]*[ ]*[r|R]ows [s|S]elected.[\n]*", "");
        inProcess = inProcess.replaceAll("[\n]*[n|N]o [r|R]ows [s|S]elected[\n]*", "");
        inProcess = inProcess.replaceAll("[\n]*[n|N]o [r|R]ows [s|S]elected.[\n]*", "");
        inProcess = inProcess.replaceAll("PROCEDURE ", "CREATE OR REPLACE PROCEDURE ");
        inProcess = inProcess.trim();
        int firstOccurrence = inProcess.indexOf("CREATE OR REPLACE PROCEDURE ");
        int lastOccurrence = inProcess.lastIndexOf("CREATE OR REPLACE PROCEDURE ");
        if (firstOccurrence != -1) {
            temp.append("\n");
            temp.append("/");
            temp.append("\n");
            int length = "CREATE OR REPLACE PROCEDURE ".length();
            frontPortion = inProcess.substring(0, firstOccurrence + length);
            if (firstOccurrence == lastOccurrence) {
                middlePortion = inProcess.substring(firstOccurrence + length);
                middlePortion = middlePortion.concat(temp.toString());
            } else {
                middlePortion = inProcess.substring(firstOccurrence + length, lastOccurrence + length);
                lastPortion = inProcess.substring(lastOccurrence + length);
                lastPortion = lastPortion.concat(temp.toString());
                middlePortion = middlePortion.replaceAll("CREATE OR REPLACE PROCEDURE ", temp.toString() + "CREATE OR REPLACE PROCEDURE ");
            }
        }
        inProcess = "";
        inProcess = frontPortion + middlePortion + lastPortion;
        StringBuffer finalStr = new StringBuffer();
        for (int i2 = 0; i2 < this.procInfo.size(); ++i2) {
            String procName = (String)this.procInfo.get(i2);
            String matchingPattern = "CREATE OR REPLACE PROCEDURE " + procName.trim();
            int indexValue = inProcess.indexOf(matchingPattern);
            if (indexValue != -1) continue;
            finalStr.append("DROP PROCEDURE ");
            finalStr.append(procName.trim());
            finalStr.append(";");
            finalStr.append("\n");
        }
        finalStr.append(inProcess);
        finalStr.append("\n");
        finalStr.append("EXIT;");
        return finalStr.toString();
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("sqlprocAction::conflictDetectable()");
        OLogger.debug(buff);
        return OPatchEnv.isRunSql();
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        ArrayList procList = this.getProcedureList();
        if (procList == null || procList.size() == 0) {
            throw new RuntimeException("Unable to get the procedure List for the sql proc action");
        }
        String[] proceduresTouched = new String[procList.size()];
        for (int i2 = 0; i2 < proceduresTouched.length; ++i2) {
            proceduresTouched[i2] = (String)procList.get(i2);
        }
        return proceduresTouched;
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        StringBuffer retBuff = new StringBuffer("");
        StringBuffer conflictProc = new StringBuffer("");
        StringBuffer buff = new StringBuffer("sqlprocAction::checkConflict()");
        OLogger.debug(buff);
        if (!OPatchEnv.isRunSql()) {
            return "";
        }
        String[] proceduresTouchedLocal = null;
        proceduresTouchedLocal = this.filesTouched(oracleHomePath);
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            PatchAction[] pas = oneoffs[i2].getPatchActions();
            StringBuffer collectProcedures = new StringBuffer("");
            if (pas == null || pas.length == 0) {
                throw new RuntimeException("The patch action array is null or empty for the one off \"" + oneoffs[i2].getID() + "\"");
            }
            for (int j2 = 0; j2 < pas.length; ++j2) {
                PatchAction cur = pas[j2];
                if (!(cur instanceof sqlprocAction)) continue;
                sqlprocAction procAction = (sqlprocAction)cur;
                String[] proceduresTouchedAction = null;
                proceduresTouchedAction = procAction.filesTouched("");
                String conflictProcedures = this.compareStringArray(proceduresTouchedLocal, proceduresTouchedAction);
                if (!conflictProc.toString().equals("") && !conflictProcedures.equals("")) {
                    conflictProc.append(",");
                    collectProcedures.append(",");
                }
                collectProcedures.append(conflictProcedures);
                conflictProc.append(conflictProcedures);
            }
            if (collectProcedures.toString().equals("")) continue;
            retBuff.append("Procedure conflict with " + oneoffs[i2].getID());
            retBuff.append("\n");
            retBuff.append("Conflicting procedures are \"" + collectProcedures.toString() + "\"");
            retBuff.append("\n");
            OLogger.debug(retBuff);
        }
        return conflictProc.toString();
    }

    private String compareStringArray(String[] a2, String[] b2) {
        StringBuffer retBuff = new StringBuffer("");
        if (a2 == null || b2 == null) {
            return retBuff.toString();
        }
        if (a2.length == 0 || b2.length == 0) {
            return retBuff.toString();
        }
        block0: for (int i2 = 0; i2 < a2.length; ++i2) {
            String x1 = a2[i2];
            for (int j2 = 0; j2 < b2.length; ++j2) {
                String y1 = b2[j2];
                if (!x1.equals(y1)) continue;
                if (!retBuff.toString().equals("")) {
                    retBuff.append(",");
                }
                retBuff.append(x1);
                continue block0;
            }
        }
        return retBuff.toString();
    }

    private boolean updateMappingFile(File mappingFile, String key, String value) {
        StringBuffer buff = new StringBuffer("sqlprocAction::updateMappingFile()");
        OLogger.debug(buff);
        Properties p2 = new Properties();
        if (mappingFile == null) {
            return false;
        }
        if (!(mappingFile.exists() && mappingFile.canWrite() && mappingFile.canRead())) {
            return false;
        }
        if (key == null || key.equals("")) {
            return false;
        }
        if (value == null) {
            return false;
        }
        try {
            p2.load(new FileInputStream(mappingFile));
            p2.setProperty(key, value);
            FileOutputStream fout = new FileOutputStream(mappingFile);
            p2.store(fout, null);
            fout.close();
        }
        catch (Exception e2) {
            buff = new StringBuffer("Unable to update the mapping file \"" + mappingFile.getAbsolutePath() + "\" ");
            buff.append("with key \"" + key + "\" and value \"" + value + "\"");
            OLogger.debug(buff);
            OLogger.debug(new StringBuffer(e2.getMessage()));
            OLogger.printStackTrace(e2);
            return false;
        }
        return true;
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        int fileNumber = 0;
        String patchLocation = OPatchEnv.getPatchloc();
        String srcFile = this.getSourceFile(patchLocation);
        File f1 = new File(srcFile);
        StringBuffer dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlProcFileName);
        String dstFile = dstPath.toString();
        File f2 = new File(dstFile);
        if (!srcFile.equals(dstFile) && f1.exists() && f1.canRead()) {
            ++fileNumber;
        }
        String procedureFile = this.getProcedureTextFile(patchLocation);
        f1 = new File(procedureFile);
        dstPath = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        dstPath.append(File.separator);
        dstPath.append(this.filePath);
        dstPath.append(File.separator);
        dstPath.append(this.sqlProcedureFile);
        dstFile = dstPath.toString();
        f2 = new File(dstFile);
        if (!procedureFile.equals(dstFile) && f1.exists() && f1.canRead()) {
            ++fileNumber;
        }
        return 0;
    }
}

