/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.HashSet;
import java.util.Set;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.TargetList;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;
import weblogic.management.configuration.ServerMBean;

final class CheckConfiguration
implements Operation {
    CheckConfiguration() {
    }

    public void run(FMWContext c2) {
        OPatchStepAdapter prereqStep = null;
        TargetList targetList = c2.getTargets();
        Set<String> targets = targetList.getTargets();
        Domain d2 = c2.getDomain();
        HashSet<String> eList = null;
        FMWContext.Type type = targetList.getType();
        switch (type) {
            case SERVER: 
            case CLUSTER: 
            case CONTAINER: {
                HashSet<String> sList = new HashSet<String>(5);
                for (String target : targets) {
                    ServerMBean[] servers = d2.getServers(target, type);
                    if (servers == null || servers.length == 0) {
                        if (eList == null) {
                            eList = new HashSet(5);
                        }
                        eList.add(target);
                        continue;
                    }
                    for (ServerMBean server : servers) {
                        sList.add(server.getName());
                    }
                }
                if (eList != null) break;
                targetList.set(FMWContext.Type.SERVER, sList);
                break;
            }
            case APPLICATION: {
                for (String target : targets) {
                    if (d2.getAppDeploymentMBean(target) != null) continue;
                    if (eList == null) {
                        eList = new HashSet<String>(5);
                    }
                    eList.add(target);
                }
                break;
            }
        }
        if (Logger.debug) {
            Logger.debug("Target Type [" + (Object)((Object)targetList.getType()) + "] Target List " + targetList.getTargets().toString());
        }
        if (eList != null) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SERVER_CONFIGURATION);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check for server configuration");
            prereqStep.setErrorMessage(Logger.getString(RB.Entry.TARGET_NOT_CONFIGURED, type.name().toLowerCase(), ((Object)eList).toString()));
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            Logger.error(RB.Entry.TARGET_NOT_CONFIGURED, type.name().toLowerCase(), ((Object)eList).toString());
        }
    }
}

