/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.repqueries;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class InstallSSLSocketFactoryImpl
extends SSLSocketFactory {
    private static SSLSocketFactory ossl;

    public InstallSSLSocketFactoryImpl() throws SSLException {
        this(System.getProperties());
    }

    public InstallSSLSocketFactoryImpl(Hashtable ht) throws SSLException {
        ossl = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public static SocketFactory getDefault() {
        try {
            InstallSSLSocketFactoryImpl installSSLSocketFactoryImpl = new InstallSSLSocketFactoryImpl();
            return installSSLSocketFactoryImpl;
        }
        catch (Exception e) {
            SocketFactory socketFactory = null;
            return socketFactory;
        }
    }

    public Socket createSocket(String s, int i) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s, i);
        return this.init(sock);
    }

    public Socket createSocket(InetAddress iaddr, int i) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(iaddr, i);
        return this.init(sock);
    }

    public Socket createSocket(String s, int i, InetAddress iaddr, int j) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s, i, iaddr, j);
        return this.init(sock);
    }

    public Socket createSocket(InetAddress iaddr1, int i, InetAddress iaddr2, int j) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(iaddr1, i, iaddr2, j);
        return this.init(sock);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sock = (SSLSocket)ossl.createSocket(s, host, port, autoClose);
        return this.init(sock);
    }

    private SSLSocket init(SSLSocket sock) throws IOException {
        sock.setUseClientMode(true);
        sock.setEnabledCipherSuites(ossl.getSupportedCipherSuites());
        sock.startHandshake();
        return sock;
    }

    public String[] getDefaultCipherSuites() {
        return ossl.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return ossl.getSupportedCipherSuites();
    }
}

