/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import oracle.i18n.text.OraDecimal;
import oracle.i18n.text.OraDecimalFormatPattern;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public class OraDecimalFormat
extends OraNumberFormat {
    private static final int JAVA_DOUBLE_INTEGER_DIGITS = 309;
    private static final int JAVA_DOUBLE_FRACTION_DIGITS = 340;
    private boolean useDefaultPattern;
    private OraDecimalFormatPattern oraDecPatPos;
    private OraDecimalFormatPattern oraDecPatNeg;
    private String ora_lang;
    private String ora_terr;
    private OraDecimalFormatSymbols symbols;
    private boolean decimalSeparatorShown = true;

    public OraDecimalFormat() {
        this.initialize(OraLocaleInfo.getDefault(), 0, false);
    }

    OraDecimalFormat(OraLocaleInfo oraLocaleInfo, int n, boolean bl) {
        this.initialize(oraLocaleInfo, n, bl);
    }

    public OraDecimalFormat(String string) throws ParseException {
        OraTerritory oraTerritory = OraLocaleInfo.getDefault().getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = OraLocaleInfo.getDefault().getOraLanguage().getName();
        this.symbols = new OraDecimalFormatSymbols(oraTerritory);
        this.applyPattern(string);
    }

    public OraDecimalFormat(String string, OraDecimalFormatSymbols oraDecimalFormatSymbols) throws ParseException {
        OraTerritory oraTerritory = OraLocaleInfo.getDefault().getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = OraLocaleInfo.getDefault().getOraLanguage().getName();
        this.symbols = (OraDecimalFormatSymbols)oraDecimalFormatSymbols.clone();
        this.applyPattern(string);
    }

    public void applyPattern(String string) throws ParseException {
        if (string != null && string.equals("")) {
            throw new ParseException(GDKMessage.getMessage(5087), -1);
        }
        if (string == null) {
            this.useDefaultPattern = true;
            OraTerritory oraTerritory = OraTerritory.getInstance(this.ora_lang, this.ora_terr);
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatNegative());
            this.SQLImplicit = true;
            this.setGroupingUsed(false);
        } else if (string.equals("DNF")) {
            this.useDefaultPattern = true;
            OraTerritory oraTerritory = OraTerritory.getInstance(this.ora_lang, this.ora_terr);
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatNegative());
        } else if (string.equals("DCF")) {
            this.useDefaultPattern = true;
            OraTerritory oraTerritory = OraTerritory.getInstance(this.ora_lang, this.ora_terr);
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatNegative());
        } else {
            ParsePosition parsePosition;
            String string2;
            String string3;
            int n = string.indexOf(59);
            if (n < 0) {
                string3 = string;
                string2 = null;
            } else {
                if (n == 0 || n + 1 == string.length()) {
                    ParsePosition parsePosition2 = new ParsePosition(0);
                    throw new ParseException(GDKMessage.getMessage(5088), n);
                }
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            if (this.oraDecPatPos == null || !this.oraDecPatPos.pattern.equals(string3)) {
                parsePosition = new ParsePosition(0);
                this.oraDecPatPos = new OraDecimalFormatPattern(string3, false, parsePosition);
                if (parsePosition.getErrorIndex() >= 0) {
                    throw new ParseException(GDKMessage.getMessage(5088), parsePosition.getErrorIndex());
                }
            }
            this.useDefaultPattern = false;
            if (n < 0) {
                this.oraDecPatNeg = (OraDecimalFormatPattern)this.oraDecPatPos.clone();
            } else if (this.oraDecPatNeg == null || !this.oraDecPatNeg.pattern.equals(string2)) {
                parsePosition = new ParsePosition(0);
                this.oraDecPatNeg = new OraDecimalFormatPattern(string2, false, parsePosition);
                if (parsePosition.getErrorIndex() >= 0) {
                    throw new ParseException(GDKMessage.getMessage(5088), parsePosition.getErrorIndex());
                }
            }
        }
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = bigDecimal.signum() < 0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, false, new OraDecimal(bigDecimal, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bigDecimal.signum() < 0, false, new OraDecimal(bigDecimal, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = bigInteger.signum() < 0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, true, new OraDecimal(bigInteger, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, true, new OraDecimal(bigInteger, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = d < 0.0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (bl) {
            d = -d;
        }
        if (Double.isNaN(d)) {
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            } else {
                fieldPosition.setBeginIndex(0);
            }
            stringBuffer.append(this.symbols.getNaN());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            } else {
                fieldPosition.setEndIndex(0);
            }
            return stringBuffer;
        }
        if (this.useDefaultPattern) {
            if (Double.isInfinite(d)) {
                return this.formatInfinity(stringBuffer, fieldPosition, bl, oraDecimalFormatPattern);
            }
            return this.formatDefault(stringBuffer, fieldPosition, bl, false, new OraDecimal(d, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        if (Double.isInfinite(d)) {
            return this.formatInfinity(stringBuffer, fieldPosition, bl, oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, false, new OraDecimal(d, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = l < 0L;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (bl) {
            l = -l;
        }
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, true, new OraDecimal(l, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, true, new OraDecimal(l, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = string.length();
        int n3 = parsePosition.getIndex();
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (n3 + 1 == n2 && string.charAt(n3) == this.symbols.getNaN()) {
            parsePosition.setIndex(n2);
            return new Double(Double.NaN);
        }
        if (this.useDefaultPattern) {
            n = this.parseDefault(stringBuffer, string, n3);
        } else {
            n = this.parse(stringBuffer, string, n3, this.oraDecPatPos, false);
            if (n >= 0) {
                stringBuffer.delete(0, stringBuffer.length());
                n = this.parse(stringBuffer, string, n3, this.oraDecPatNeg, true);
                if (n >= 0) {
                    parsePosition.setIndex(n3);
                    parsePosition.setErrorIndex(n);
                    throw new IllegalArgumentException(GDKMessage.getMessage(5089));
                }
            }
        }
        parsePosition.setIndex(n2);
        switch (n) {
            case -1: {
                BigInteger bigInteger = new BigInteger(stringBuffer.toString());
                long l = bigInteger.longValue();
                if ((long)bigInteger.signum() * l >= 0L && l <= Long.MAX_VALUE && l >= Long.MIN_VALUE) {
                    return new Long(l);
                }
                return bigInteger;
            }
            case -2: {
                return new BigDecimal(stringBuffer.toString());
            }
            case -21: {
                return this.toBigDecimal(stringBuffer);
            }
            case -3: {
                return new Long(0L);
            }
            case -5: {
                return new Double(Double.POSITIVE_INFINITY);
            }
            case -6: {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        parsePosition.setIndex(n3);
        parsePosition.setErrorIndex(n);
        throw new IllegalArgumentException(GDKMessage.getMessage(5089));
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorShown = bl;
    }

    public OraDecimalFormatSymbols getOraDecimalFormatSymbols() {
        return this.symbols;
    }

    public void setOraDecimalFormatSymbols(OraDecimalFormatSymbols oraDecimalFormatSymbols) {
        this.symbols = oraDecimalFormatSymbols;
    }

    public String toPattern() {
        StringBuffer stringBuffer = this.oraDecPatPos.equals(this.oraDecPatNeg) ? new StringBuffer(this.oraDecPatPos.pattern) : new StringBuffer(this.oraDecPatPos.pattern + ";" + this.oraDecPatNeg.pattern);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if ((this.decimalSeparatorShown || stringBuffer.charAt(i) != 'D' && stringBuffer.charAt(i) != '.') && (this.isGroupingUsed() || stringBuffer.charAt(i) != 'G' && stringBuffer.charAt(i) != ',')) continue;
            stringBuffer.deleteCharAt(i);
        }
        return stringBuffer.toString();
    }

    @Override
    protected void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    @Override
    protected void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    @Override
    protected void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    @Override
    protected void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    @Override
    public Object clone() {
        OraDecimalFormat oraDecimalFormat = (OraDecimalFormat)super.clone();
        oraDecimalFormat.oraDecPatPos = (OraDecimalFormatPattern)this.oraDecPatPos.clone();
        oraDecimalFormat.oraDecPatNeg = (OraDecimalFormatPattern)this.oraDecPatNeg.clone();
        oraDecimalFormat.symbols = (OraDecimalFormatSymbols)this.symbols.clone();
        return oraDecimalFormat;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDecimalFormat) || !super.equals(object)) {
            return false;
        }
        OraDecimalFormat oraDecimalFormat = (OraDecimalFormat)object;
        return this.decimalSeparatorShown == oraDecimalFormat.decimalSeparatorShown && this.oraDecPatPos.equals(oraDecimalFormat.oraDecPatPos) && this.oraDecPatNeg.equals(oraDecimalFormat.oraDecPatNeg) && this.ora_lang.equals(oraDecimalFormat.ora_lang) && this.ora_terr.equals(oraDecimalFormat.ora_terr) && this.symbols.equals(oraDecimalFormat.symbols) && this.useDefaultPattern == oraDecimalFormat.useDefaultPattern;
    }

    public int hashCode() {
        return this.oraDecPatNeg.pattern.hashCode();
    }

    private void initialize(OraLocaleInfo oraLocaleInfo, int n, boolean bl) {
        this.useDefaultPattern = true;
        OraTerritory oraTerritory = oraLocaleInfo.getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = oraLocaleInfo.getLanguage();
        if (n == 1) {
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatNegative());
        } else {
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatNegative());
        }
        this.SQLImplicit = bl;
        if (bl) {
            this.setGroupingUsed(false);
        } else {
            this.setGroupingUsed(true);
        }
        this.symbols = new OraDecimalFormatSymbols(oraTerritory);
    }

    private StringBuffer formatInfinity(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, OraDecimalFormatPattern oraDecimalFormatPattern) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = stringBuffer.length();
        String string = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        block8: for (int i = 1; i <= 4; ++i) {
            switch (oraDecimalFormatPattern.getNthComponent(i)) {
                case 1: {
                    n = stringBuffer.length();
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(n);
                    } else {
                        fieldPosition.setBeginIndex(0);
                    }
                    stringBuffer.append(this.symbols.getInfinity());
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                        continue block8;
                    }
                    fieldPosition.setEndIndex(0);
                    continue block8;
                }
                case 2: {
                    bl4 = true;
                    if (!bl) continue block8;
                    stringBuffer.append('-');
                    continue block8;
                }
                case 3: {
                    stringBuffer.append(' ');
                    continue block8;
                }
                case 4: {
                    if (oraDecimalFormatPattern.useDollar) {
                        stringBuffer.insert(n, string);
                        if (fieldPosition.getField() == -1 || fieldPosition.getEndIndex() == 0) continue block8;
                        fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + string.length());
                        fieldPosition.setEndIndex(fieldPosition.getEndIndex() + string.length());
                        continue block8;
                    }
                    stringBuffer.append(string);
                    continue block8;
                }
                case 5: {
                    if (bl) {
                        stringBuffer.append('(');
                        n = stringBuffer.length();
                    }
                    bl2 = true;
                    bl4 = true;
                    continue block8;
                }
                case 6: {
                    if (bl) {
                        stringBuffer.append('<');
                        n = stringBuffer.length();
                    }
                    bl3 = true;
                    bl4 = true;
                    continue block8;
                }
            }
        }
        if (bl) {
            if (!bl4) {
                stringBuffer.insert(n2, '-');
            } else if (bl2) {
                stringBuffer.append(')');
            } else if (bl3) {
                stringBuffer.append('>');
            }
        }
        return stringBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer formatDefault(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2, OraDecimal oraDecimal, OraDecimalFormatPattern oraDecimalFormatPattern) {
        int n = oraDecimalFormatPattern.internalFormat;
        int n2 = oraDecimalFormatPattern.numberOfDigitsRHS;
        String string = oraDecimalFormatPattern.groupingSizes;
        int n3 = oraDecimal.exponent;
        int n4 = oraDecimal.numberOfDigitsLHS;
        int n5 = oraDecimal.numberOfDigitsRHS;
        int n6 = oraDecimal.numberOfDigits;
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = stringBuffer.length();
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        block7: for (int i = 1; i <= 4; ++i) {
            switch (oraDecimalFormatPattern.getNthComponent(i)) {
                case 1: {
                    int n8;
                    int n9 = 0;
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    if (n4 > 0) {
                        int n10;
                        int n11;
                        int n12;
                        if (string.length() == 1) {
                            n8 = string.charAt(0) - 48;
                            n12 = n8 - n4 % n8;
                            n11 = n4 > n6 ? n6 : n4;
                            for (n9 = 0; n9 < n11; ++n9) {
                                stringBuffer.append(oraDecimal.digits[n9]);
                                if (++n12 % n8 != 0 || n9 + 1 >= n4 || !this.isGroupingUsed()) continue;
                                stringBuffer.append(this.symbols.getGroupingSeparator());
                            }
                            for (n10 = n9; n10 < n4; ++n10) {
                                stringBuffer.append('0');
                                if (++n12 % n8 != 0 || n10 + 1 >= n4 || !this.isGroupingUsed()) continue;
                                stringBuffer.append(this.symbols.getGroupingSeparator());
                            }
                        } else {
                            if (string.length() != 2) throw new IllegalArgumentException(GDKMessage.getMessage(5084));
                            n8 = string.charAt(0) - 48;
                            n12 = string.charAt(1) - 48;
                            n11 = n12 - (n4 - n8) % n12;
                            n10 = n4 > n6 ? n6 : n4;
                            for (n9 = 0; n9 < n4 - n8; ++n9) {
                                if (n9 < n10) {
                                    stringBuffer.append(oraDecimal.digits[n9]);
                                } else {
                                    stringBuffer.append('0');
                                }
                                if (++n11 % n12 != 0 || n9 + 1 >= n4 - n8 || !this.isGroupingUsed()) continue;
                                stringBuffer.append(this.symbols.getGroupingSeparator());
                            }
                            if (n4 > n8 && this.isGroupingUsed()) {
                                stringBuffer.append(this.symbols.getGroupingSeparator());
                            }
                            while (n9 < n4) {
                                if (n9 < n10) {
                                    stringBuffer.append(oraDecimal.digits[n9]);
                                } else {
                                    stringBuffer.append('0');
                                }
                                ++n9;
                            }
                            n9 = n10;
                        }
                    } else if (oraDecimalFormatPattern.numberOfLeadingZeros > 0) {
                        stringBuffer.append('0');
                    }
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (bl2) continue block7;
                    if (this.decimalSeparatorShown && !this.SQLImplicit) {
                        stringBuffer.append(this.symbols.getDecimalSeparator());
                    }
                    if (oraDecimalFormatPattern.numberOfTrailingZeros <= 0 && n5 <= 0) continue block7;
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    if (n4 < 0) {
                        for (n8 = 0; n8 < -n4; ++n8) {
                            stringBuffer.append('0');
                        }
                    }
                    while (n9 < n6) {
                        stringBuffer.append(oraDecimal.digits[n9]);
                        ++n9;
                    }
                    if (oraDecimalFormatPattern.numberOfTrailingZeros > 0) {
                        for (n9 = 0; n9 < oraDecimalFormatPattern.numberOfDigitsRHS - n5; ++n9) {
                            stringBuffer.append('0');
                        }
                    }
                    if (fieldPosition.getField() != 1) continue block7;
                    fieldPosition.setEndIndex(stringBuffer.length());
                    continue block7;
                }
                case 2: {
                    bl4 = true;
                    if (!bl) continue block7;
                    stringBuffer.append('-');
                    continue block7;
                }
                case 3: {
                    stringBuffer.append(' ');
                    continue block7;
                }
                case 4: {
                    stringBuffer.append(this.symbols.getCurrencySymbol());
                    continue block7;
                }
                case 5: {
                    stringBuffer.append('(');
                    bl3 = true;
                    bl4 = true;
                    continue block7;
                }
            }
        }
        if (!bl) return stringBuffer;
        if (!bl4) {
            stringBuffer.insert(n7, '-');
            if (fieldPosition.getField() == -1 || fieldPosition.getEndIndex() == 0) return stringBuffer;
            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + 1);
            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + 1);
            return stringBuffer;
        } else {
            if (!bl3) return stringBuffer;
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    private StringBuffer format(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2, OraDecimal oraDecimal, OraDecimalFormatPattern oraDecimalFormatPattern) {
        char c;
        char c2;
        char c3;
        char c4;
        char c5;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        char c6 = oraDecimalFormatPattern.usePeriod ? (char)'.' : (char)this.symbols.getDecimalSeparator();
        char c7 = c5 = oraDecimalFormatPattern.useComma ? (char)',' : (char)this.symbols.getGroupingSeparator();
        String string = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        int n5 = stringBuffer.length();
        if (bl) {
            c4 = '(';
            c3 = ')';
            c2 = '<';
            c = '>';
        } else {
            c = ' ';
            c2 = ' ';
            c3 = ' ';
            c4 = ' ';
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (!oraDecimalFormatPattern.isTmOn && !oraDecimalFormatPattern.useScientificNotation && oraDecimal.numberOfDigitsLHS > oraDecimalFormatPattern.numberOfDigitsLHS) {
            for (int i = 0; i < oraDecimalFormatPattern.outputStringSize; ++i) {
                stringBuffer.append('#');
            }
            return stringBuffer;
        }
        int n6 = oraDecimalFormatPattern.outputStringSize;
        if (!(oraDecimalFormatPattern.useScientificNotation || oraDecimalFormatPattern.isBOn && oraDecimal.isZero)) {
            if (oraDecimalFormatPattern.numberOfLeadingZeros > oraDecimal.numberOfDigitsLHS) {
                n2 = oraDecimalFormatPattern.numberOfLeadingZeros - (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
                n = oraDecimalFormatPattern.numberOfDigitsLHS - oraDecimalFormatPattern.numberOfLeadingZeros;
            } else {
                n = oraDecimalFormatPattern.numberOfDigitsLHS - (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
            }
            if (n3 < oraDecimalFormatPattern.numberOfGroups) {
                while (n3 < oraDecimalFormatPattern.numberOfGroups && oraDecimalFormatPattern.groupingSeparatorPositions[n3] <= n) {
                    ++n3;
                }
            }
        }
        block10: for (int i = 1; i <= 4; ++i) {
            switch (oraDecimalFormatPattern.getNthComponent(i)) {
                case 1: {
                    int n7;
                    int n8 = 0;
                    n4 = stringBuffer.length();
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(n4);
                    }
                    for (n7 = 0; n7 < n2; ++n7) {
                        stringBuffer.append('0');
                        if (n3 >= oraDecimalFormatPattern.numberOfGroups || ++n != oraDecimalFormatPattern.groupingSeparatorPositions[n3]) continue;
                        if (this.isGroupingUsed()) {
                            stringBuffer.append(c5);
                            --n6;
                        }
                        ++n3;
                    }
                    n6 -= n2;
                    if (oraDecimal.isZero) {
                        if (n2 == 0 && !oraDecimalFormatPattern.isBOn && (oraDecimalFormatPattern.isFmOn && oraDecimalFormatPattern.numberOfTrailingZeros == 0 || oraDecimalFormatPattern.isTmOn || oraDecimalFormatPattern.numberOfDigitsRHS == 0) || oraDecimalFormatPattern.numberOfDigitsLHS == 1 && oraDecimalFormatPattern.numberOfLeadingZeros == 1 && oraDecimalFormatPattern.useScientificNotation) {
                            stringBuffer.append('0');
                            --n6;
                        }
                    } else {
                        int n9 = oraDecimal.numberOfDigitsLHS > oraDecimal.numberOfDigits ? oraDecimal.numberOfDigits : (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
                        for (n8 = 0; n8 < n9; ++n8) {
                            stringBuffer.append(oraDecimal.digits[n8]);
                            if (oraDecimalFormatPattern.useScientificNotation || n3 >= oraDecimalFormatPattern.numberOfGroups || ++n != oraDecimalFormatPattern.groupingSeparatorPositions[n3]) continue;
                            if (this.isGroupingUsed()) {
                                stringBuffer.append(c5);
                                --n6;
                            }
                            ++n3;
                        }
                        for (n7 = n8; n7 < oraDecimal.numberOfDigitsLHS; ++n7) {
                            stringBuffer.append('0');
                            if (oraDecimalFormatPattern.useScientificNotation || n3 >= oraDecimalFormatPattern.numberOfGroups || ++n != oraDecimalFormatPattern.groupingSeparatorPositions[n3]) continue;
                            if (this.isGroupingUsed()) {
                                stringBuffer.append(c5);
                                --n6;
                            }
                            ++n3;
                        }
                        n6 -= n7;
                    }
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (!oraDecimalFormatPattern.isVOn && (oraDecimalFormatPattern.isDecimalSeparatorOn || oraDecimalFormatPattern.isTmOn && oraDecimal.numberOfDigitsRHS > 0) && this.decimalSeparatorShown) {
                        stringBuffer.append(c6);
                        --n6;
                    }
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    n = 0;
                    if (oraDecimal.numberOfDigitsRHS > 0) {
                        if (oraDecimal.numberOfDigitsLHS < 0) {
                            for (n = 0; n < -oraDecimal.numberOfDigitsLHS; ++n) {
                                stringBuffer.append('0');
                            }
                        }
                        while (n8 < oraDecimal.numberOfDigits) {
                            ++n;
                            stringBuffer.append(oraDecimal.digits[n8]);
                            ++n8;
                        }
                    }
                    while (n < oraDecimalFormatPattern.numberOfTrailingZeros) {
                        stringBuffer.append('0');
                        ++n;
                    }
                    if (!oraDecimalFormatPattern.isFmOn) {
                        while (n < oraDecimalFormatPattern.numberOfDigitsRHS) {
                            stringBuffer.append('0');
                            ++n;
                        }
                    }
                    n6 -= n;
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (!oraDecimalFormatPattern.useScientificNotation) continue block10;
                    n6 -= 4;
                    stringBuffer.append('E');
                    if (oraDecimal.exponent < 0) {
                        stringBuffer.append('-');
                        n7 = -oraDecimal.exponent;
                    } else {
                        stringBuffer.append('+');
                        n7 = oraDecimal.exponent;
                    }
                    if (n7 < 99) {
                        stringBuffer.append((char)(48 + n7 / 10));
                        stringBuffer.append((char)(48 + n7 % 10));
                        continue block10;
                    }
                    stringBuffer.append(new Integer(n7).toString());
                    --n6;
                    continue block10;
                }
                case 2: {
                    bl5 = true;
                    --n6;
                    if (bl) {
                        stringBuffer.append('-');
                        continue block10;
                    }
                    if (oraDecimalFormatPattern.isSignOn) {
                        stringBuffer.append('+');
                        continue block10;
                    }
                    if (!oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(' ');
                        continue block10;
                    }
                    ++n6;
                    continue block10;
                }
                case 3: {
                    stringBuffer.append(' ');
                    --n6;
                    continue block10;
                }
                case 4: {
                    if (oraDecimalFormatPattern.useDollar) {
                        stringBuffer.insert(n4, string);
                        if (fieldPosition.getField() != -1 && fieldPosition.getEndIndex() != 0) {
                            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + string.length());
                            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + string.length());
                        }
                    } else {
                        stringBuffer.append(string);
                    }
                    n6 -= string.length();
                    continue block10;
                }
                case 5: {
                    if (bl || !oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(c4);
                        n4 = stringBuffer.length();
                    }
                    n6 -= 2;
                    bl3 = true;
                    bl5 = true;
                    continue block10;
                }
                case 6: {
                    if (bl || !oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(c2);
                        n4 = stringBuffer.length();
                    }
                    n6 -= 2;
                    bl4 = true;
                    bl5 = true;
                    continue block10;
                }
            }
        }
        if (!(!bl || bl5 || oraDecimalFormatPattern.isBOn && oraDecimal.isZero)) {
            stringBuffer.insert(n5, '-');
            --n6;
        } else if (bl || !oraDecimalFormatPattern.isFmOn) {
            if (bl3) {
                stringBuffer.append(c3);
            } else if (bl4) {
                stringBuffer.append(c);
            }
        }
        if (!oraDecimalFormatPattern.isTmOn && n6 < 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5084));
        }
        if (!oraDecimalFormatPattern.isFmOn && !oraDecimalFormatPattern.isTmOn && n6 > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(n6);
            for (n = 0; n < n6; ++n) {
                stringBuffer2.append(' ');
            }
            stringBuffer.insert(n5, stringBuffer2);
            if (fieldPosition.getField() != -1 && fieldPosition.getEndIndex() != 0) {
                fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + n6);
                fieldPosition.setEndIndex(fieldPosition.getEndIndex() + n6);
            }
        }
        return stringBuffer;
    }

    /*
     * Unable to fully structure code
     */
    private int parseDefault(StringBuffer var1_1, String var2_2, int var3_3) {
        var4_4 = var2_2.length();
        var10_5 = false;
        var11_6 = false;
        var12_7 = false;
        var13_8 = 0;
        var14_9 = 2;
        var15_10 = new int[]{-1, -1};
        for (var5_11 = var3_3; var5_11 < var4_4 && Character.isWhitespace(var2_2.charAt(var5_11)); ++var5_11) {
        }
        if (var5_11 >= var4_4) {
            return 0;
        }
        var7_12 = var2_2.charAt(var5_11);
        if (var7_12 == '-' || var7_12 == '(') {
            ++var5_11;
            var10_5 = true;
            var12_7 = true;
            var13_8 = 1;
            if (var7_12 == '(') {
                var11_6 = true;
            }
        } else if (var7_12 == '+') {
            ++var5_11;
            var12_7 = true;
            var14_9 = 1;
        }
        var16_13 = var10_5 != false ? this.oraDecPatNeg : this.oraDecPatPos;
        var6_14 = var5_11;
        while (true) {
            block41: {
                var9_16 = false;
                var8_15 = false;
                block9: for (var17_17 = 1; var15_10[var13_8] < 0 && var17_17 <= 4; ++var17_17) {
                    switch (var16_13.getNthComponent(var17_17)) {
                        case 1: {
                            var18_18 = 0;
                            var19_19 = 0;
                            var20_20 = 0;
                            var21_21 = 0;
                            var22_22 = var16_13.groupingSizes;
                            if (var5_11 < var4_4 && var2_2.charAt(var5_11) == this.symbols.getInfinity()) {
                                var8_15 = true;
                                ++var5_11;
                                continue block9;
                            }
                            if (var22_22.length() == 1) {
                                var20_20 = var21_21 = var22_22.charAt(0) - 48;
                            } else if (var22_22.length() == 2) {
                                var20_20 = var22_22.charAt(0) - 48;
                                var21_21 = var22_22.charAt(1) - 48;
                            } else {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5084));
                            }
                            while (var5_11 < var4_4) {
                                var7_12 = var2_2.charAt(var5_11);
                                if (Character.isDigit(var7_12)) {
                                    if (var9_16 && var19_19 >= var16_13.numberOfDigitsRHS && !this.SQLImplicit) {
                                        var15_10[var13_8] = var5_11;
                                        continue block9;
                                    }
                                    ++var19_19;
                                    if (!this.isParseIntegerOnly() || !var9_16) {
                                        var1_1.append(Character.digit(var7_12, 10));
                                    }
                                } else if (var7_12 == this.symbols.getDecimalSeparator()) {
                                    if (this.isGroupingUsed() && (var9_16 || var18_18 > 0 && var19_19 - var18_18 != var20_20 || var18_18 == 0 && var19_19 > var20_20)) {
                                        var15_10[var13_8] = var5_11;
                                        continue block9;
                                    }
                                    var9_16 = true;
                                    var19_19 = 0;
                                    if (!this.isParseIntegerOnly()) {
                                        var1_1.append('.');
                                    }
                                } else {
                                    if (var7_12 != this.symbols.getGroupingSeparator()) continue block9;
                                    if (!this.isGroupingUsed()) {
                                        var15_10[var13_8] = var5_11;
                                        continue block9;
                                    }
                                    if (Character.isWhitespace(var7_12) && (var9_16 || var5_11 + 1 >= var4_4 || !Character.isDigit(var2_2.charAt(var5_11 + 1)))) continue block9;
                                    if (var9_16 || var18_18 > 0 && var19_19 - var18_18 != var21_21 || var18_18 == 0 && var19_19 > var21_21) {
                                        var15_10[var13_8] = var5_11;
                                        continue block9;
                                    }
                                    var18_18 = var19_19;
                                }
                                ++var5_11;
                            }
                            continue block9;
                        }
                        case 2: {
                            if (var12_7) {
                                if (var5_11 == var6_14) continue block9;
                                var15_10[var13_8] = var6_14 - 1;
                                continue block9;
                            }
                            if (var5_11 >= var4_4) continue block9;
                            if ((var7_12 = var2_2.charAt(var5_11++)) == '-') {
                                var10_5 = true;
                                continue block9;
                            }
                            if (var7_12 == '+') continue block9;
                            var15_10[var13_8] = var5_11;
                            continue block9;
                        }
                        case 3: {
                            if (var5_11 < var4_4 && Character.isWhitespace(var2_2.charAt(var5_11++))) continue block9;
                            var15_10[var13_8] = var5_11;
                            continue block9;
                        }
                        case 4: {
                            var23_23 = this.symbols.getCurrencySymbol();
                            var24_24 = var23_23.length();
                            if (var5_11 + var24_24 > var4_4 || !var2_2.regionMatches(true, var5_11, var23_23, 0, var24_24)) {
                                var15_10[var13_8] = var5_11;
                                continue block9;
                            }
                            var5_11 += var24_24;
                            continue block9;
                        }
                        case 5: {
                            if (var5_11 == var6_14 && var11_6) continue block9;
                            var15_10[var13_8] = var5_11;
                            continue block9;
                        }
                    }
                }
                if (var15_10[var13_8] >= 0) break block41;
                if (!var11_6) ** GOTO lbl118
                if (var5_11 >= var4_4 || var2_2.charAt(var5_11) != ')') {
                    var15_10[var13_8] = var5_11;
                } else {
                    ++var5_11;
lbl118:
                    // 2 sources

                    if (var5_11 < var4_4) {
                        var15_10[var13_8] = var5_11;
                    } else {
                        if (var8_15) {
                            return var10_5 != false ? -6 : -5;
                        }
                        if (var10_5) {
                            var1_1.insert(0, '-');
                        }
                        if (var9_16 && !this.isParseIntegerOnly()) {
                            return -2;
                        }
                        return -1;
                    }
                }
            }
            if (++var13_8 >= var14_9 || var16_13.equals(this.oraDecPatNeg)) break;
            var16_13 = this.oraDecPatNeg;
            var5_11 = var6_14;
            if (var1_1.length() <= 0) continue;
            var1_1.delete(0, var1_1.length());
        }
        return var10_5 != false ? var15_10[1] : var15_10[0];
    }

    private int parse(StringBuffer stringBuffer, String string, int n, OraDecimalFormatPattern oraDecimalFormatPattern, boolean bl) {
        int n2;
        char c;
        int n3 = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        char c2 = oraDecimalFormatPattern.usePeriod ? (char)'.' : (char)this.symbols.getDecimalSeparator();
        char c3 = c = oraDecimalFormatPattern.useComma ? (char)',' : (char)this.symbols.getGroupingSeparator();
        String string2 = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        for (n2 = n; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 == n3) {
            if (oraDecimalFormatPattern.isBOn) {
                stringBuffer.append('0');
                return -3;
            }
            return n2;
        }
        if (n2 > n3) {
            return n2;
        }
        char c4 = string.charAt(n2);
        if (c4 == '-') {
            if (!bl) {
                return n2;
            }
            ++n2;
            bl6 = true;
        } else if (c4 == '+') {
            ++n2;
            bl6 = true;
        }
        int n4 = n2;
        block9: for (int i = 1; i <= 4; ++i) {
            switch (oraDecimalFormatPattern.getNthComponent(i)) {
                case 1: {
                    int n5;
                    boolean bl8 = false;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    boolean bl9 = false;
                    int n9 = 0;
                    int n10 = 0;
                    if (n2 < n3 && string.charAt(n2) == this.symbols.getInfinity()) {
                        bl2 = true;
                        ++n2;
                        continue block9;
                    }
                    while (n2 < n3) {
                        c4 = string.charAt(n2);
                        if (Character.isDigit(c4)) {
                            ++n9;
                            if (!this.isParseIntegerOnly() || !bl3 && !bl7) {
                                stringBuffer.append(Character.digit(c4, 10));
                            }
                        } else if (c4 == c2) {
                            if (bl3 || !this.decimalSeparatorShown) {
                                return n2;
                            }
                            bl3 = true;
                            n7 = n9;
                            n9 = 0;
                            if (!this.isParseIntegerOnly()) {
                                stringBuffer.append('.');
                            }
                        } else if (c4 == c) {
                            if (bl3 || bl7 || !this.isGroupingUsed()) {
                                if (Character.isWhitespace(c4)) break;
                                return n2;
                            }
                            if (Character.isWhitespace(c4) && (n2 + 1 >= n3 || !Character.isDigit(string.charAt(n2 + 1)))) break;
                            n10 = n9;
                            while (n6 < oraDecimalFormatPattern.numberOfGroups && oraDecimalFormatPattern.groupingSeparatorPositions[n6++] <= n9) {
                            }
                        } else if (c4 == 'E' || c4 == 'e') {
                            if (bl7) {
                                return n2;
                            }
                            bl7 = true;
                            if (bl3) {
                                n8 = n9;
                            } else {
                                n7 = n9;
                            }
                            n9 = 0;
                            if (!this.isParseIntegerOnly()) {
                                stringBuffer.append('E');
                            }
                        } else {
                            if (c4 != '-' && c4 != '+' || !bl7) break;
                            if (n9 > 0) {
                                return n2;
                            }
                            stringBuffer.append(c4);
                        }
                        ++n2;
                    }
                    if (!bl7) {
                        if (!bl3) {
                            n7 = n9;
                        } else {
                            n8 = n9;
                        }
                    }
                    int n11 = n5 = oraDecimalFormatPattern.numberOfGroups > 0 ? oraDecimalFormatPattern.numberOfDigitsLHS - oraDecimalFormatPattern.groupingSeparatorPositions[oraDecimalFormatPattern.numberOfGroups - 1] : oraDecimalFormatPattern.numberOfDigitsLHS;
                    if (oraDecimalFormatPattern.numberOfDigitsLHS >= n7 && oraDecimalFormatPattern.numberOfDigitsRHS >= n8 && (n10 <= 0 || n5 == n7 - n10) && (n10 != 0 || n5 >= n7)) continue block9;
                    return n2;
                }
                case 2: {
                    if (bl6) {
                        if (n2 == n4) continue block9;
                        return n4 - 1;
                    }
                    if (n2 >= n3 || !((c4 = string.charAt(n2++)) == '-' ? !bl : c4 != '+')) continue block9;
                    return n2;
                }
                case 3: {
                    if (n2 < n3 && Character.isWhitespace(string.charAt(n2++))) continue block9;
                    return n2;
                }
                case 4: {
                    int n12 = string2.length();
                    if (n2 + n12 > n3 || !string.regionMatches(true, n2, string2, 0, n12)) {
                        return n2;
                    }
                    n2 += n12;
                    continue block9;
                }
                case 5: {
                    if (n2 >= n3 || string.charAt(n2++) != '(') {
                        return n2;
                    }
                    bl4 = true;
                    continue block9;
                }
                case 6: {
                    if (n2 >= n3 || string.charAt(n2++) != '<') {
                        return n2;
                    }
                    bl5 = true;
                    continue block9;
                }
            }
        }
        if (bl4 && (n2 >= n3 || string.charAt(n2) != ')') || bl5 && (n2 >= n3 || string.charAt(n2) != '>')) {
            return n2;
        }
        if (bl4 || bl5) {
            bl = true;
            ++n2;
        }
        if (n2 < n3) {
            return n2;
        }
        if (bl2) {
            return bl ? -6 : -5;
        }
        if (bl) {
            stringBuffer.insert(0, '-');
        }
        if ((bl3 || bl7) && !this.isParseIntegerOnly()) {
            if (bl7) {
                return -21;
            }
            return -2;
        }
        return -1;
    }

    private BigDecimal toBigDecimal(StringBuffer stringBuffer) {
        int n;
        String string = stringBuffer.toString();
        int n2 = string.charAt((n = string.indexOf(69)) + 1) == '+' ? new Integer(string.substring(n + 2, string.length())).intValue() : new Integer(string.substring(n + 1, string.length())).intValue();
        stringBuffer.delete(n, string.length());
        if (n2 == 0) {
            return new BigDecimal(stringBuffer.toString());
        }
        int n3 = string.indexOf(46);
        if (n3 >= 0) {
            stringBuffer.deleteCharAt(n3);
            n2 -= n - n3 - 1;
        }
        if (n2 <= 0) {
            return new BigDecimal(new BigInteger(stringBuffer.toString()), -n2);
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        return new BigDecimal(new BigInteger(stringBuffer.toString()), 0);
    }
}

