/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;
import oracle.ops.verification.framework.engine.task.Task;

public class PrereqCheckerJob
extends Job
implements Callable<VerificationResultSet> {
    public static final String PROPERTY_FIXABLE = "PrereqCheckerJob.fixable";
    private static Logger logger = Logger.getLogger(PrereqCheckerJob.class.getName());
    private VerificationTask verificationTask;
    private VerificationResultSet verificationResultSet;
    private boolean fixable;

    public PrereqCheckerJob(VerificationTask verificationTask) {
        super(verificationTask.getElementName(), verificationTask.getElementName(), 1.0f);
        this.verificationTask = verificationTask;
        logger.log(Level.INFO, "Creating PrereqChecker Job for leaf task " + verificationTask.getElementName());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public VerificationResultSet getVerificationResultSet() {
        return this.verificationResultSet;
    }

    public void setVerificationResultSet(VerificationResultSet verificationResultSet) {
        this.verificationResultSet = verificationResultSet;
    }

    public VerificationTask getVerificationTask() {
        return this.verificationTask;
    }

    public boolean isFixable() {
        boolean fixable;
        block1: {
            String failedNode;
            List failedNodeList;
            fixable = false;
            Status status = this.getStatus();
            if (status != Status.SUCCEEDED_PARTIALLY && status != Status.FAILED && status != Status.WARNING && status != Status.IGNORED || (fixable = PrereqChecker.getInstance().isFixable(this)) || this.verificationResultSet == null || (failedNodeList = this.verificationResultSet.getFailedNodes()) == null || failedNodeList.isEmpty()) break block1;
            Iterator iterator = failedNodeList.iterator();
            while (iterator.hasNext() && !(fixable = this.isFixable(failedNode = (String)iterator.next()))) {
            }
        }
        return fixable;
    }

    public void setFixable(boolean fixable) {
        if (this.fixable != fixable) {
            boolean oldValue = this.fixable;
            this.fixable = fixable;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_FIXABLE, oldValue, fixable);
        }
    }

    private void buildJobTree(CompositePrereqCheckerJob parentJob, VerificationTask verificationTask, boolean isConverted, PrereqCheckerJob oldParentJob) {
        CompositePrereqCheckerJob job = null;
        boolean addLeafJobToParent = false;
        if (verificationTask.hasSubtasks()) {
            try {
                List subtasks = verificationTask.getSubtasks();
                if (subtasks != null && subtasks.size() > 0) {
                    job = new CompositePrereqCheckerJob(verificationTask);
                    job.setConverted(isConverted);
                    job.setActualWeightage(0.0f);
                    parentJob.add(job);
                    if (oldParentJob != null && oldParentJob.getStatus() != Status.SUCCEEDED) {
                        job.add(oldParentJob, true);
                    }
                    for (VerificationTask subtask : subtasks) {
                        this.buildJobTree(job, subtask, false, null);
                    }
                }
            }
            catch (SubtasksUnavailableException e) {
                logger.log(Level.WARNING, "Could not get the subtasks of the task: " + verificationTask.getDescription());
                addLeafJobToParent = true;
            }
        }
        if (verificationTask.hasCreatedTasks()) {
            List createdtasks = verificationTask.getCreatedTasks();
            if (createdtasks != null && createdtasks.size() > 0) {
                if (job == null) {
                    addLeafJobToParent = false;
                    job = new CompositePrereqCheckerJob(verificationTask);
                    job.setConverted(isConverted);
                    job.setActualWeightage(0.0f);
                    parentJob.add(job);
                    if (oldParentJob != null && oldParentJob.getStatus() != Status.SUCCEEDED) {
                        job.add(oldParentJob, true);
                    }
                }
                for (VerificationTask createdtask : createdtasks) {
                    PrereqCheckerJob prereqCheckerJob = new PrereqCheckerJob(createdtask);
                    if (createdtask instanceof Task) {
                        Task task = (Task)createdtask;
                        prereqCheckerJob.setVerificationResultSet((VerificationResultSet)task.getResultSet());
                        this.processStatusAndSeverity(prereqCheckerJob, task);
                    } else {
                        prereqCheckerJob = null;
                    }
                    this.buildJobTree(job, createdtask, false, prereqCheckerJob);
                }
            } else {
                addLeafJobToParent = true;
            }
        } else {
            addLeafJobToParent = true;
        }
        if (addLeafJobToParent) {
            PrereqCheckerJob prereqJob = new PrereqCheckerJob(verificationTask);
            prereqJob.setActualWeightage(0.0f);
            Task task = null;
            if (verificationTask instanceof Task) {
                task = (Task)verificationTask;
                prereqJob.setVerificationResultSet((VerificationResultSet)task.getResultSet());
                this.processStatusAndSeverity(prereqJob, task);
                parentJob.add(prereqJob);
            }
        }
    }

    private void processStatusAndSeverity(PrereqCheckerJob prereqJob, Task task) {
        SeverityType severity = task.getSeverity();
        OverallStatus overallStatus = task.getResultSet().getOverallStatus();
        Status status = Status.SUCCEEDED;
        Severity failureSeverity = null;
        if (overallStatus != null) {
            switch (overallStatus) {
                case SUCCESSFUL: {
                    status = Status.SUCCEEDED;
                    break;
                }
                case WARNING: {
                    status = Status.WARNING;
                    failureSeverity = Severity.WARNING;
                    break;
                }
                default: {
                    if (severity == SeverityType.IGNORABLE) {
                        status = Status.WARNING;
                        failureSeverity = Severity.WARNING;
                        break;
                    }
                    if (severity == SeverityType.FATAL) {
                        status = Status.FAILED;
                        failureSeverity = Severity.FATAL_NOT_IGNORABLE;
                        break;
                    }
                    status = Status.FAILED;
                    failureSeverity = Severity.FATAL;
                }
            }
        }
        prereqJob.setStatus(status);
        if (status != Status.SUCCEEDED) {
            prereqJob.setFailureSeverity(failureSeverity);
        }
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerificationResultSet call() throws Exception {
        if (this.getStatus() != Status.SUCCEEDED) {
            Severity failureSeverity;
            Status status;
            block31: {
                this.setStatus(Status.INPROGRESS);
                status = Status.FAILED;
                failureSeverity = null;
                try {
                    this.verificationResultSet = this.verificationTask.verify(true);
                    if (this.verificationResultSet == null) break block31;
                    SeverityType severity = this.verificationTask.getSeverity();
                    OverallStatus overallStatus = this.verificationResultSet.getOverallStatus();
                    if (overallStatus != null) {
                        switch (overallStatus) {
                            case SUCCESSFUL: {
                                status = Status.SUCCEEDED;
                                break;
                            }
                            case OPERATION_FAILED: {
                                if (severity == SeverityType.IGNORABLE) {
                                    status = Status.WARNING;
                                    break;
                                }
                                if (severity == SeverityType.FATAL) {
                                    status = Status.FAILED;
                                    failureSeverity = Severity.FATAL_NOT_IGNORABLE;
                                    break;
                                }
                                status = Status.FAILED;
                                break;
                            }
                            case WARNING: {
                                status = Status.WARNING;
                                break;
                            }
                            default: {
                                if (severity == SeverityType.IGNORABLE) {
                                    status = Status.WARNING;
                                    break;
                                }
                                if (severity == SeverityType.FATAL) {
                                    status = Status.FAILED;
                                    failureSeverity = Severity.FATAL_NOT_IGNORABLE;
                                    break;
                                }
                                status = Status.FAILED;
                            }
                        }
                    }
                    this.logResults();
                    if (!this.verificationTask.hasCreatedTasks()) break block31;
                    CompositeJob parent = this.getParent();
                    this.setStatus(status);
                    if (status != Status.SUCCEEDED) {
                        this.setFailureSeverity(failureSeverity);
                        this.setProgress(1.0f);
                    }
                    parent.remove(this);
                    if (!(parent instanceof CompositePrereqCheckerJob)) break block31;
                    this.buildJobTree((CompositePrereqCheckerJob)parent, this.verificationTask, true, this);
                }
                catch (Throwable t) {
                    try {
                        logger.log(Level.WARNING, String.format("Unexpected error while performing check: %s", this.getDescription()), t);
                    }
                    catch (Throwable throwable) {
                        this.setStatus(status);
                        if (status != Status.SUCCEEDED) {
                            this.setProgress(1.0f);
                        }
                        if (failureSeverity == null) {
                            if (status == Status.FAILED) {
                                failureSeverity = Severity.FATAL;
                            } else if (status == Status.WARNING) {
                                failureSeverity = Severity.WARNING;
                            }
                        }
                        this.setFailureSeverity(failureSeverity);
                        throw throwable;
                    }
                    this.setStatus(status);
                    if (status != Status.SUCCEEDED) {
                        this.setProgress(1.0f);
                    }
                    if (failureSeverity == null) {
                        if (status == Status.FAILED) {
                            failureSeverity = Severity.FATAL;
                        } else if (status == Status.WARNING) {
                            failureSeverity = Severity.WARNING;
                        }
                    }
                    this.setFailureSeverity(failureSeverity);
                }
            }
            this.setStatus(status);
            if (status != Status.SUCCEEDED) {
                this.setProgress(1.0f);
            }
            if (failureSeverity == null) {
                if (status == Status.FAILED) {
                    failureSeverity = Severity.FATAL;
                } else if (status == Status.WARNING) {
                    failureSeverity = Severity.WARNING;
                }
            }
            this.setFailureSeverity(failureSeverity);
        }
        return this.verificationResultSet;
    }

    public Status getStatus(String node) {
        List successfulNodes;
        Status status = super.getStatus();
        if (this.verificationResultSet != null && (successfulNodes = this.verificationResultSet.getSuccessfulNodes()) != null && successfulNodes.contains(node)) {
            status = Status.SUCCEEDED;
        }
        return status;
    }

    public boolean isFixable(String node) {
        List failedNodes;
        boolean fixable = false;
        Status status = this.getStatus();
        if ((status == Status.SUCCEEDED_PARTIALLY || status == Status.FAILED || status == Status.WARNING) && !(fixable = PrereqChecker.getInstance().isFixable(this)) && this.verificationResultSet != null && (failedNodes = this.verificationResultSet.getFailedNodes()) != null && failedNodes.contains(node)) {
            try {
                VerificationResult result = this.verificationResultSet.getNodeResult(node);
                if (result != null) {
                    fixable = result.isFixupAvailable();
                }
            }
            catch (NodeResultsUnavailableException e) {
                logger.log(Level.INFO, "Node result unavailable for node " + node);
            }
        }
        return fixable;
    }

    private void logResults() {
        List errors;
        this.logTaskOverallResult();
        try {
            List nodeResults = this.verificationResultSet.getNodeResults();
            if (nodeResults != null) {
                for (VerificationResult result : nodeResults) {
                    logger.info("-----------------------------------------------");
                    logger.info("Verification Result for Node:" + result.getNode());
                    logger.info("Expected Value:" + result.getExpectedValue());
                    logger.info("Actual Value:" + result.getActualValue());
                    List errors2 = result.getErrors();
                    if (errors2 != null) {
                        for (VerificationError error : errors2) {
                            logger.info("Error Message:" + error.getErrorMessage());
                            logger.info("Cause:" + error.getCause());
                            logger.info("Action:" + error.getAction());
                        }
                    }
                    logger.info("-----------------------------------------------");
                }
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        if (this.verificationResultSet.getOverallStatus() != OverallStatus.SUCCESSFUL && (errors = this.verificationResultSet.getErrors()) != null) {
            for (VerificationError error : errors) {
                logger.info("Error Message:" + error.getErrorMessage());
                logger.info("Cause:" + error.getCause());
                logger.info("Action:" + error.getAction());
            }
        }
    }

    public void logTaskOverallResult() {
        logger.info("*********************************************");
        logger.info(this.verificationTask.getElementName() + ": " + this.verificationTask.getDescription());
        logger.info("Severity:" + this.verificationTask.getSeverity());
        if (this.verificationResultSet != null) {
            logger.info("OverallStatus:" + this.verificationResultSet.getOverallStatus());
        } else {
            logger.info("verificationResultSet is null hence over all status is not printed");
        }
    }
}

