/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.BeanValidator;
import oracle.install.commons.flow.validation.annotation.BeanValidatorDef;

public class BeanValidatorRegistry {
    private static Logger logger = Logger.getLogger(BeanValidatorRegistry.class.getName());
    private static Map<Class, BeanValidator> cache = new HashMap<Class, BeanValidator>();

    public static BeanValidator getValidator(Class beanType) {
        BeanValidatorDef validatorDef = beanType.getAnnotation(BeanValidatorDef.class);
        Class<? extends BeanValidator> validatorType = validatorDef.value();
        BeanValidator validator = cache.get(validatorType);
        if (validator == null) {
            try {
                validator = validatorType.newInstance();
                cache.put(validatorType, validator);
            }
            catch (Exception iae) {
                logger.warning("Validator not for beanType - " + beanType);
            }
        }
        return validator;
    }
}

