/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.net.support;

import oracle.install.commons.net.support.DefaultSSHSupportManager;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.net.support.SSHConnectivitySetupInfo;
import oracle.install.commons.net.support.SSHSetupPolicy;
import oracle.install.commons.net.support.SSHSupportManagerConstants;
import oracle.install.commons.net.support.SSHSupportManagerException;
import oracle.install.commons.net.support.SSHSupportManagerSysProps;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.SystemProperties;

public abstract class SSHSupportManager
implements SSHSupportManagerConstants,
SSHSupportManagerSysProps {
    private static SSHSupportManager instance = null;
    private short threadPoolSize;
    private boolean setupEnabled;
    private SSHSetupPolicy setupPolicy;
    private long setupTimeout;
    private boolean setupCheckEnabled;
    private SSHSetupPolicy setupCheckPolicy;
    private long setupCheckTimeout;
    private int sshdMaxStartups;
    private boolean sshdLockRequired;

    public static SSHSupportManager getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (proxyFactory = ProxyFactory.getInstance()).createProxy(SSHSupportManager.class)) == null) {
            instance = new DefaultSSHSupportManager();
        }
        return instance;
    }

    protected SSHSupportManager() {
        SystemProperties systemProperties = SystemProperties.getInstance();
        this.threadPoolSize = systemProperties.getValue(Short.class, "oracle.install.ssh.threadPoolSize", Short.valueOf((short)5));
        this.setupEnabled = systemProperties.getBoolean("oracle.install.ssh.setupEnabled", true);
        this.setupTimeout = systemProperties.getValue(Integer.class, "oracle.install.ssh.setupTimeout", Integer.valueOf(0)).intValue();
        this.setupPolicy = SSHSetupPolicy.getSSHSetupPolicy("oracle.install.ssh.setupPolicy", DEFAULT_SETUP_POLICY);
        this.setupCheckEnabled = systemProperties.getBoolean("oracle.install.ssh.setupCheckEnabled", true);
        this.setupCheckTimeout = systemProperties.getValue(Integer.class, "oracle.install.ssh.setupCheckTimeout", Integer.valueOf(300000)).intValue();
        this.setupCheckPolicy = SSHSetupPolicy.getSSHSetupPolicy("oracle.install.ssh.setupCheckPolicy", DEFAULT_SETUP_CHECK_POLICY);
        this.sshdMaxStartups = systemProperties.getValue(Integer.class, "oracle.install.ssh.maxStartups", Integer.valueOf(10));
    }

    public short getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(short threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public boolean isSetupEnabled() {
        return this.setupEnabled;
    }

    public void setSetupEnabled(boolean setupEnabled) {
        this.setupEnabled = setupEnabled;
    }

    public SSHSetupPolicy getSetupPolicy() {
        return this.setupPolicy;
    }

    public void setSetupPolicy(SSHSetupPolicy setupPolicy) {
        this.setupPolicy = setupPolicy;
    }

    public long getSetupTimeout() {
        return this.setupTimeout;
    }

    public void setSetupTimeout(long setupTimeout) {
        this.setupTimeout = setupTimeout;
    }

    public boolean isSetupCheckEnabled() {
        return this.setupCheckEnabled;
    }

    public void setSetupCheckEnabled(boolean setupCheckEnabled) {
        this.setupCheckEnabled = setupCheckEnabled;
    }

    public SSHSetupPolicy getSetupCheckPolicy() {
        return this.setupCheckPolicy;
    }

    public void setSetupCheckPolicy(SSHSetupPolicy setupCheckPolicy) {
        this.setupCheckPolicy = setupCheckPolicy;
    }

    public long getSetupCheckTimeout() {
        return this.setupCheckTimeout;
    }

    public void setSetupCheckTimeout(long setupCheckTimeout) {
        this.setupCheckTimeout = setupCheckTimeout;
    }

    public void setSshdMaxStartups(int maxStartups) {
        this.sshdMaxStartups = maxStartups;
    }

    public int getSshdMaxStartups() {
        return this.sshdMaxStartups;
    }

    public void setSshdLockRequired(boolean lockRequired) {
        this.sshdLockRequired = lockRequired;
    }

    public boolean isSshdLockRequired() {
        return this.sshdLockRequired;
    }

    public int getAvailableSshdLocks() {
        return this.sshdMaxStartups - 1;
    }

    public boolean isSSHConnectivityExist(String[] nodes, String sharedUserName, char[] passphrase) throws SSHSupportManagerException {
        SSHConnectivityDetails details = this.getSSHConnectivityDetails(nodes, sharedUserName, passphrase);
        return details.isConfigurationComplete();
    }

    public boolean isSSHConnectivityExist(String[] nodes) throws SSHSupportManagerException {
        return this.isSSHConnectivityExist(nodes, null, null);
    }

    public boolean isSSHConnectivityExist(String[] nodes, String shareUserName) throws SSHSupportManagerException {
        return this.isSSHConnectivityExist(nodes, shareUserName, null);
    }

    public SSHConnectivityDetails getSSHConnectivityDetails(String[] nodes) throws SSHSupportManagerException {
        boolean nxnCheck = true;
        return this.getSSHConnectivityDetails(nodes, nxnCheck);
    }

    public SSHConnectivityDetails getSSHConnectivityDetails(String[] nodes, boolean nxnCheck) throws SSHSupportManagerException {
        return this.getSSHConnectivityDetails(nodes, null, null, nxnCheck);
    }

    public SSHConnectivityDetails getSSHConnectivityDetails(String[] nodes, String sharedUsername) throws SSHSupportManagerException {
        return this.getSSHConnectivityDetails(nodes, sharedUsername, null);
    }

    public abstract SSHConnectivityDetails establishSSHConnectivity(SSHConnectivitySetupInfo var1) throws SSHSupportManagerException;

    public abstract SSHConnectivityDetails getSSHConnectivityDetails(String[] var1, String var2, char[] var3, boolean var4) throws SSHSupportManagerException;

    public abstract SSHConnectivityDetails getSSHConnectivityDetails(String[] var1, String var2, char[] var3) throws SSHSupportManagerException;
}

