/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.util.XmlSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlTag {
    private XPath xpathEngine;
    private Document document;
    private Node node;

    public XmlTag(Node node) {
        this.node = node;
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        this.xpathEngine = XPathFactory.newInstance().newXPath();
    }

    public static XmlTag getInstance(String rootTagName, File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return XmlTag.getInstance(rootTagName, xmlFile, null);
    }

    public static XmlTag getInstance(String rootTagName, File xmlFile, EntityResolver entityResolver) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        if (entityResolver != null) {
            docBuilder.setEntityResolver(entityResolver);
        }
        Document document = docBuilder.parse(xmlFile);
        return XmlTag.getInstance(rootTagName, document);
    }

    public static XmlTag getInstance(String rootTagName, Document document) {
        XmlTag tag = new XmlTag(document);
        return tag.getXmlTag(rootTagName);
    }

    public static XmlTag createInstance(String rootTagName) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        return XmlTag.createInstance(rootTagName, document);
    }

    public static XmlTag createInstance(String rootTagName, Document document) {
        XmlTag tag = new XmlTag(document);
        return tag.createXmlTag(rootTagName);
    }

    public void addComment(String comment) {
        Comment commentNode = this.document.createComment(comment);
        this.node.appendChild(commentNode);
    }

    public String getName() {
        return this.node != null ? this.node.getNodeName() : null;
    }

    public Node getNode() {
        return this.node;
    }

    public Document getDocument() {
        return this.document;
    }

    public XmlTag setText(String xpath, String text) {
        XmlTag tag = null;
        if (xpath != null && text != null && (tag = this.getXmlTag(xpath, true)) != null) {
            tag.setText(text);
        }
        return tag;
    }

    public void setText(String text) {
        this.node.setTextContent(text);
    }

    public String getText(String xpath) {
        XmlTag tag;
        String text = null;
        if (xpath != null && (tag = this.getXmlTag(xpath, false)) != null) {
            text = tag.getText();
        }
        return text;
    }

    public String getText() {
        return this.node.getTextContent();
    }

    public String getAttribute(String xpath, String name) {
        String value = null;
        XmlTag tag = this.getXmlTag(xpath, false);
        if (tag != null) {
            value = tag.getAttribute(name);
        }
        return value;
    }

    public XmlTag setAttribute(String xpath, String name, String value) {
        XmlTag tag = this.getXmlTag(xpath, true);
        if (tag != null) {
            tag.setAttribute(name, value);
        }
        return tag;
    }

    public void setAttribute(String name, String value) {
        if (name != null) {
            try {
                Node targetNode = (Node)this.xpathEngine.evaluate("@" + name, this.node, XPathConstants.NODE);
                if (targetNode == null) {
                    Attr attr = this.document.createAttribute(name);
                    this.node.getAttributes().setNamedItem(attr);
                    targetNode = attr;
                }
                targetNode.setNodeValue(value);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
    }

    public String getAttribute(String name) {
        String value = null;
        if (name != null) {
            try {
                Node targetNode = (Node)this.xpathEngine.evaluate("@" + name, this.node, XPathConstants.NODE);
                if (targetNode != null) {
                    value = targetNode.getNodeValue();
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return value;
    }

    public XmlTag createXmlTag(String xpath) {
        XmlTag tag = null;
        if (xpath != null) {
            String tagName = null;
            String rest = null;
            String attrName = null;
            String attrValue = null;
            int slashIndex = xpath.indexOf("/");
            if (slashIndex != -1) {
                String part = xpath.substring(0, slashIndex);
                if (slashIndex < xpath.length()) {
                    rest = xpath.substring(slashIndex + 1);
                }
                if ((tag = this.getXmlTag(part, false)) == null) {
                    if (part.contains("[") && part.endsWith("]")) {
                        int attrIndex = part.indexOf("[@");
                        tagName = part.substring(0, attrIndex);
                        String attr = part.substring(attrIndex + 2, part.length() - 1);
                        String[] attrParts = attr.split("=");
                        attrName = attrParts[0];
                        attrValue = attrParts[1].substring(1, attrParts[1].length() - 1);
                    } else {
                        tagName = part;
                    }
                }
            } else {
                tagName = xpath;
            }
            if (tag == null) {
                tagName = tagName.trim();
                Element element = this.document.createElement(tagName);
                this.node.appendChild(element);
                tag = new XmlTag(element);
                if (attrName != null && attrValue != null) {
                    tag.setAttribute(attrName, attrValue);
                }
            }
            if (rest != null) {
                tag = tag.createXmlTag(rest);
            }
        }
        return tag;
    }

    public XmlTag getXmlTag(String xpath) {
        return this.getXmlTag(xpath, false, null);
    }

    public XmlTag getXmlTag(String xpath, boolean create) {
        return this.getXmlTag(xpath, create, null);
    }

    public <A extends XmlTag> A getXmlTag(String xpath, Class<A> type) {
        return this.getXmlTag(xpath, false, type);
    }

    public <A extends XmlTag> A getXmlTag(String xpath, boolean create, Class<A> type) {
        XmlTag tag;
        block9: {
            tag = null;
            if (xpath != null) {
                if (type == null) {
                    type = XmlTag.class;
                }
                try {
                    Node targetNode = (Node)this.xpathEngine.evaluate(xpath, this.node, XPathConstants.NODE);
                    XmlTag xmlTag = null;
                    if (targetNode != null) {
                        xmlTag = new XmlTag(targetNode);
                    } else if (create) {
                        xmlTag = this.createXmlTag(xpath);
                    }
                    if (xmlTag == null) break block9;
                    try {
                        Constructor<Object> constructor = type.getConstructor(Node.class);
                        tag = (XmlTag)constructor.newInstance(xmlTag.getNode());
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
        }
        return (A)tag;
    }

    public List<XmlTag> getXmlTags(String xpath) {
        return this.getXmlTags(xpath, null);
    }

    public <A extends XmlTag> List<A> getXmlTags(String xpath, Class<A> type) {
        ArrayList<XmlTag> tags = null;
        if (xpath != null) {
            if (type == null) {
                type = XmlTag.class;
            }
            Constructor<Object> constructor = null;
            try {
                constructor = type.getConstructor(Node.class);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            NodeList targetNodes = null;
            try {
                targetNodes = (NodeList)this.xpathEngine.evaluate(xpath, this.node, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            if (targetNodes != null) {
                int n = targetNodes.getLength();
                if (n > 0) {
                    tags = new ArrayList<XmlTag>();
                }
                try {
                    for (int i = 0; i < n; ++i) {
                        XmlTag tag = (XmlTag)constructor.newInstance(targetNodes.item(i));
                        tags.add(tag);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return tags;
    }

    public void release() {
        this.document = null;
        this.node = null;
        this.xpathEngine = null;
    }

    public void store(File file) throws Exception {
        FileOutputStream fout = new FileOutputStream(file);
        this.transform(null, new StreamResult(fout));
        fout.close();
    }

    public void transform(Source xslt, Result result) throws Exception {
        XmlSupport.transform(new DOMSource(this.getDocument()), result, xslt);
    }
}

