/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import oracle.install.commons.util.exception.BaseException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;

public class CheckedException
extends Exception
implements BaseException {
    private ErrorCode errorCode;
    private Severity severity;
    private String hint;
    private String errorId;
    private String helpId;
    private String message;
    private ErrorInfo errorInfo;

    public CheckedException(ErrorInfo errorInfo) {
        this(null, errorInfo);
    }

    public CheckedException(Throwable cause, ErrorInfo errorInfo) {
        super(cause);
        this.init(errorInfo, null);
    }

    public CheckedException() {
        this(null, null, CommonErrorCode.UNKNOWN_ERROR, Severity.FATAL);
    }

    public CheckedException(String message, Throwable cause) {
        this(message, cause, CommonErrorCode.UNKNOWN_ERROR, Severity.FATAL);
    }

    public CheckedException(String message) {
        this(message, null);
    }

    public CheckedException(Throwable cause) {
        this(null, cause);
    }

    public CheckedException(String message, ErrorCode errorCode, Severity severity) {
        this(message, null, errorCode, severity);
    }

    public CheckedException(String message, Throwable cause, ErrorCode errorCode, Severity severity) {
        this(cause, errorCode, severity, new Object[0]);
        if (message != null && message.trim().length() > 0) {
            this.message = message;
        }
    }

    public CheckedException(ErrorCode errorCode, Severity severity, String helpId) {
        this(null, errorCode, severity);
        if (helpId != null && helpId.trim().length() > 0) {
            this.helpId = helpId;
        }
    }

    public CheckedException(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        this(cause, errorCode, null, messageArgs);
    }

    public CheckedException(ErrorCode errorCode, Object ... messageArgs) {
        this(null, errorCode, null, messageArgs);
    }

    public CheckedException(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        this(null, errorCode, severity, messageArgs);
    }

    public CheckedException(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause);
        if (errorCode != null) {
            this.errorInfo = ErrorInfo.getInstance(errorCode, messageArgs);
            this.init(this.errorInfo, severity);
        } else {
            this.severity = severity;
        }
    }

    private void init(ErrorInfo errorInfo, Severity severity) {
        this.errorInfo = errorInfo;
        if (this.errorInfo != null) {
            this.errorCode = errorInfo.getErrorCode();
            this.severity = severity == null ? errorInfo.getSeverity() : severity;
            this.helpId = errorInfo.getHelpId();
            this.message = errorInfo.getMessage();
            this.hint = errorInfo.getHint();
            this.errorId = errorInfo.getErrorFQN();
        }
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getErrorId() {
        return this.errorId;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }
}

