/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.MessageOption;
import oracle.install.commons.util.Option;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;

public class DefaultAlertHandler
implements OiifmAlertHandler {
    private String title;
    private Component owner;

    public DefaultAlertHandler() {
        this(null, null);
    }

    public DefaultAlertHandler(Component owner) {
        this(owner, null);
    }

    public DefaultAlertHandler(Component owner, String title) {
        this.owner = owner;
        this.title = title;
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity, boolean selectable) {
        Level level;
        switch (severity) {
            case 10: {
                level = Level.WARNING;
                break;
            }
            case 20: {
                level = Level.SEVERE;
                break;
            }
            default: {
                level = Level.INFO;
            }
        }
        switch (alertType) {
            case 30: {
                level = Level.WARNING;
                break;
            }
            case 40: 
            case 60: {
                level = Level.WARNING;
                break;
            }
            case 50: {
                level = Level.SEVERE;
            }
        }
        ArrayList<MessageOption> options = new ArrayList<MessageOption>();
        if ((userChoices & 1) == 1) {
            options.add(MessageOption.YES);
        }
        if ((userChoices & 2) == 2) {
            options.add(MessageOption.NO);
        }
        if ((userChoices & 4) == 4) {
            options.add(MessageOption.CANCEL);
        }
        MessageOption defaultOption = MessageOption.OK;
        if (options.size() <= 1) {
            options.clear();
            options.add(MessageOption.OK);
        } else {
            switch (defaultChoice) {
                case 1: {
                    defaultOption = MessageOption.YES;
                    break;
                }
                case 2: {
                    defaultOption = MessageOption.NO;
                    break;
                }
                case 4: {
                    defaultOption = MessageOption.CANCEL;
                    break;
                }
                default: {
                    defaultOption = MessageOption.NO;
                }
            }
        }
        DefaultStatusMessage message = new DefaultStatusMessage(level, msg);
        MessageOption option = (MessageOption)StandardDialog.showMessage(this.owner, title == null ? this.title : title, message, defaultOption, options.toArray(new Option[0]));
        if (option == MessageOption.OK) {
            option = MessageOption.YES;
        }
        int returnCode = 0;
        switch (option) {
            case OK: 
            case YES: {
                returnCode = 1;
                break;
            }
            case NO: {
                returnCode = 2;
                break;
            }
            default: {
                returnCode = 4;
            }
        }
        return returnCode;
    }

    public int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity) {
        return this.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, false);
    }
}

