/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationHelper;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.util.RemoteOperationHelper;

public class RemoteOperationException
extends CheckedException {
    private Logger logger = Logger.getLogger(RemoteOperationException.class.getName());
    private List<String> failedNodes = null;

    public RemoteOperationException(List<String> failedNodes) {
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.init(severity);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, ErrorCode errorCode, Severity severity, String helpId) {
        super(errorCode, severity, helpId);
        this.init(severity);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, ErrorInfo errorInfo) {
        super(errorInfo);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, String message, ErrorCode errorCode, Severity severity) {
        super(message, errorCode, severity);
        this.init(severity);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, String message, Throwable cause, ErrorCode errorCode, Severity severity) {
        super(message, cause, errorCode, severity);
        this.init(severity);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, String message, Throwable cause) {
        super(message, cause);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, String message) {
        super(message);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.init(severity);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, Throwable cause, ErrorInfo errorInfo) {
        super(cause, errorInfo);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    public RemoteOperationException(List<String> failedNodes, Throwable cause) {
        super(cause);
        this.init(null);
        this.failedNodes = failedNodes;
        this.updateExtraDetails();
    }

    protected void init(Severity severity) {
        if (severity == null) {
            Severity newSeverity = ValidationHelper.getActionableValidationSeverity();
            if (newSeverity != null) {
                this.setSeverity(newSeverity);
            } else {
                this.logger.log(Level.INFO, "Property: actionable.validation.advisor.severity is not specified. So using default severity.");
            }
        }
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        RemoteOperationHelper helper = RemoteOperationHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }

    public List<String> getFailedNodes() {
        return this.failedNodes;
    }
}

