/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class GetVersionedObjectTask
extends Task {
    private Object consumer;
    private DomainFile domainFile;
    private int versionNumber;
    private DomainObject versionedObj;

    public GetVersionedObjectTask(Object consumer, DomainFile domainFile, int versionNumber) {
        this(consumer, domainFile, versionNumber, true);
    }

    public GetVersionedObjectTask(Object consumer, DomainFile domainFile, int versionNumber, boolean readOnly) {
        super("Get Versioned Domain Object", true, false, true);
        this.consumer = consumer;
        this.domainFile = domainFile;
        this.versionNumber = versionNumber;
    }

    public void run(TaskMonitor monitor) {
        try {
            monitor.setMessage("Getting Version " + this.versionNumber + " for " + this.domainFile.getName());
            this.versionedObj = this.domainFile.getReadOnlyDomainObject(this.consumer, this.versionNumber, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            if (this.domainFile.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)AppInfo.getActiveProject().getRepository(), (Exception)e, (String)"Get Versioned Object", null);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Error Getting Versioned Object", (Object)("Could not get version " + this.versionNumber + " for " + this.domainFile.getName() + ": " + e), (Throwable)e);
            }
        }
        catch (VersionException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Getting Versioned Object", (Object)("Could not get version " + this.versionNumber + " for " + this.domainFile.getName() + ": " + e));
        }
    }

    public DomainObject getVersionedObject() {
        return this.versionedObj;
    }
}

