/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.EmptyBorderToggleButton;
import docking.widgets.HyperlinkComponent;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.PluginInstallerDialog;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginPackageState;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import resources.ResourceManager;

public class PluginManagerComponent
extends JPanel
implements ChangeListener,
Scrollable {
    private final PluginTool tool;
    private PluginConfigurationModel model;
    private List<PluginPackageComponent> packageComponentList = new ArrayList<PluginPackageComponent>();

    PluginManagerComponent(PluginTool tool) {
        super((LayoutManager)new VerticalLayout(2));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(Color.WHITE);
        this.tool = tool;
        this.model = new PluginConfigurationModel(tool, this);
        List<PluginPackage> pluginPackages = this.model.getPluginPackages();
        for (PluginPackage pluginPackage : pluginPackages) {
            PluginPackageComponent comp = new PluginPackageComponent(pluginPackage);
            this.packageComponentList.add(comp);
            this.add(comp);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (PluginPackageComponent comp : this.packageComponentList) {
            comp.updateCheckBoxState();
        }
    }

    void managePlugins(PluginPackage pluginPackage) {
        PluginInstallerDialog pluginInstallerDialog = new PluginInstallerDialog("Configure " + pluginPackage.getName() + " Plugins", this.tool, this.model.getPluginDescriptions(pluginPackage));
        this.tool.showDialog(pluginInstallerDialog);
    }

    void manageAllPlugins() {
        PluginInstallerDialog pluginTableDialog = new PluginInstallerDialog("Configure All Plugins", this.tool, this.model.getAllPluginDescriptions());
        this.tool.showDialog(pluginTableDialog);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    static class MyToggleButton
    extends EmptyBorderToggleButton {
        public MyToggleButton(Icon icon) {
            super(icon);
        }

        public void setIcon(Icon newIcon) {
            ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)newIcon, (int)32, (int)32, (int)32);
            this.doSetIcon(scaledIcon);
        }
    }

    class PluginPackageComponent
    extends JPanel {
        private Color BG;
        private final PluginPackage pluginPackage;
        private JCheckBox jCheckBox;

        PluginPackageComponent(PluginPackage pluginPackage) {
            super(new BorderLayout());
            this.BG = Color.white;
            this.setBackground(this.BG);
            this.pluginPackage = pluginPackage;
            JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(0));
            panel.setBackground(this.BG);
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.addActionListener(e -> this.checkBoxClicked());
            if (!pluginPackage.isfullyAddable()) {
                this.jCheckBox.setEnabled(false);
            }
            panel.add(Box.createHorizontalStrut(10));
            this.jCheckBox.setBackground(this.BG);
            panel.add(this.jCheckBox);
            panel.add(Box.createHorizontalStrut(10));
            JLabel label = new JLabel(ResourceManager.getScaledIcon((Icon)pluginPackage.getIcon(), (int)32, (int)32, (int)32));
            label.setBackground(this.BG);
            panel.add(label);
            panel.add(Box.createHorizontalStrut(10));
            this.add((Component)panel, "West");
            JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(3));
            labelPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            labelPanel.setBackground(this.BG);
            label = new JLabel(pluginPackage.getName());
            label.setFont(label.getFont().deriveFont(18.0f));
            label.setForeground(Color.BLACK);
            labelPanel.add(label);
            HyperlinkComponent hyper = new HyperlinkComponent("<html> <a href=\"Configure\">Configure</a>");
            hyper.addHyperlinkListener("Configure", e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PluginManagerComponent.this.managePlugins(this.pluginPackage);
                }
            });
            hyper.setBackground(this.BG);
            labelPanel.add((Component)hyper);
            labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
            this.add(labelPanel);
            String htmlDescription = this.getHTMLDescription();
            JLabel descriptionlabel = new JLabel(htmlDescription);
            descriptionlabel.setForeground(Color.GRAY);
            descriptionlabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            descriptionlabel.setVerticalAlignment(1);
            descriptionlabel.setPreferredSize(new Dimension(300, 60));
            descriptionlabel.setToolTipText(HTMLUtilities.toWrappedHTML((String)pluginPackage.getDescription(), (int)80));
            this.add((Component)descriptionlabel, "East");
            this.setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.updateCheckBoxState();
        }

        private String getHTMLDescription() {
            String description = this.pluginPackage.getDescription();
            return HTMLUtilities.toHTML((String)description);
        }

        protected void checkBoxClicked() {
            boolean isSelected = this.jCheckBox.isSelected();
            if (isSelected) {
                PluginManagerComponent.this.model.addAllPlugins(this.pluginPackage);
            } else {
                PluginManagerComponent.this.model.removeAllPlugins(this.pluginPackage);
            }
        }

        void updateCheckBoxState() {
            this.jCheckBox.setSelected(PluginManagerComponent.this.model.getPackageState(this.pluginPackage) != PluginPackageState.NO_PLUGINS_LOADED);
        }
    }
}

