/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.GTable;
import docking.widgets.textfield.IntegerTextField;
import ghidra.bitpatterns.gui.ContextRegisterFilterablePanelBuilder;
import ghidra.bitpatterns.info.FileBitPatternInfoReader;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AlignmentPanelBuilder
extends ContextRegisterFilterablePanelBuilder {
    private static final int DEFAULT_MODULUS = 16;
    private static final String[] alignmentTableColumnNames = new String[]{"Modulus", "Number of Functions", "Percentage"};
    private static final String MODULUS_FIELD_TEXT = " Alignment Modulus ";
    private static final String RECOMPUTE_BUTTON_TEXT = "Compute Alignment Info";
    private GTable alignmentTable;
    private IntegerTextField modulusField;
    private JScrollPane scrollPane;
    private int savedNumFuncs;
    private List<Long> savedStartingAddresses = null;
    private FileBitPatternInfoReader fsReader;
    private int modulus;

    public JPanel buildAlignmentPanel() {
        this.alignmentTable = this.createAlignmentTable(null, 0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.alignmentTable.setColumnHeaderPopupEnabled(true);
        this.scrollPane = new JScrollPane((Component)this.alignmentTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        JPanel modulusPanel = new JPanel();
        PairLayout modulusLayout = new PairLayout();
        modulusPanel.setLayout((LayoutManager)modulusLayout);
        modulusPanel.add(new JLabel(MODULUS_FIELD_TEXT));
        this.modulusField = new IntegerTextField();
        this.modulusField.setValue(16);
        modulusPanel.add(this.modulusField.getComponent());
        JButton recomputeButton = new JButton(RECOMPUTE_BUTTON_TEXT);
        recomputeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentPanelBuilder.this.updateAlignmentPanel();
            }
        });
        this.getButtonPanel().add(recomputeButton);
        this.mainPanel.add((Component)modulusPanel, "North");
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        return this.mainPanel;
    }

    public void updateAlignmentPanel() {
        this.modulus = this.modulusField.getValue().intValue();
        if (this.modulus < 1) {
            this.modulus = 16;
            this.modulusField.setValue(16);
        }
        this.mainPanel.remove(this.scrollPane);
        this.alignmentTable = this.createAlignmentTable(this.savedStartingAddresses, this.savedNumFuncs);
        this.alignmentTable.setColumnHeaderPopupEnabled(true);
        this.scrollPane = new JScrollPane((Component)this.alignmentTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.mainPanel.updateUI();
    }

    private GTable createAlignmentTable(List<Long> startingAddresses, int numFuncs) {
        Object[][] modulusInfo = new String[this.modulus][3];
        if (startingAddresses != null) {
            for (int i = 0; i < this.modulus; ++i) {
                modulusInfo[i][0] = Long.toString(i);
            }
            long[] countsAsLongs = new long[this.modulus];
            for (Long currentAddress : startingAddresses) {
                countsAsLongs[(int)Long.remainderUnsigned((long)currentAddress.longValue(), (long)((long)this.modulus))] = countsAsLongs[(int)Long.remainderUnsigned(currentAddress, this.modulus)] + 1L;
            }
            for (int i = 0; i < this.modulus; ++i) {
                double percent = 100.0 * (double)countsAsLongs[i] / (double)numFuncs;
                modulusInfo[i][2] = Double.toString(Math.round(percent));
                modulusInfo[i][1] = Long.toString(countsAsLongs[i]);
            }
        }
        GTable table = new GTable(modulusInfo, (Object[])alignmentTableColumnNames);
        return table;
    }

    public void resetModulus() {
        this.modulus = 16;
    }

    public void setFsReader(FileBitPatternInfoReader fsReader) {
        this.fsReader = fsReader;
        this.savedStartingAddresses = fsReader.getStartingAddresses();
        this.savedNumFuncs = fsReader.getNumFuncs();
    }

    @Override
    public void applyFilterAction() {
        this.savedStartingAddresses = this.fsReader.getFilteredAddresses(this.getContextRegisterFilter());
        this.savedNumFuncs = this.savedStartingAddresses.size();
        this.updateAlignmentPanel();
    }

    @Override
    public void clearFilterAction() {
        this.savedStartingAddresses = this.fsReader.getStartingAddresses();
        this.savedNumFuncs = this.fsReader.getNumFuncs();
        this.updateAlignmentPanel();
    }
}

